/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "frontendInlayModelAdapter", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;)V", "attach", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getInlayInfo", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/InlayInfo;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendInlayDocumentWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendInlayDocumentWatcher.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n774#2:68\n865#2,2:69\n1869#2,2:71\n774#2:73\n865#2,2:74\n1869#2,2:76\n1869#2,2:78\n*S KotlinDebug\n*F\n+ 1 FrontendInlayDocumentWatcher.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher\n*L\n26#1:68\n26#1:69,2\n26#1:71,2\n29#1:73\n29#1:74,2\n29#1:76,2\n55#1:78,2\n*E\n"})
public final class FrontendInlayDocumentWatcher
implements DocumentListener {
    @NotNull
    private final Editor editor;
    @NotNull
    private final FrontendInlayModelAdapter frontendInlayModelAdapter;

    public FrontendInlayDocumentWatcher(@NotNull Editor editor, @NotNull FrontendInlayModelAdapter frontendInlayModelAdapter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frontendInlayModelAdapter, (String)"frontendInlayModelAdapter");
        this.editor = editor;
        this.frontendInlayModelAdapter = frontendInlayModelAdapter;
    }

    public final void attach(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.editor.getDocument().addDocumentListener((DocumentListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Object it;
        block18: {
            block17: {
                Object element$iv$iv;
                Iterator $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getDocument().isInBulkUpdate()) {
                    return;
                }
                VisualPosition visualPosition = this.editor.offsetToVisualPosition(event.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
                VisualPosition position = visualPosition;
                List list2 = this.editor.getInlayModel().getBlockElementsForVisualLine(position.line, true);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBlockElementsForVisualLine(...)");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    it = (Inlay)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getRenderer() instanceof FrontendInlayRenderer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Inlay it2 = (Inlay)element$iv;
                    boolean bl = false;
                    it2.update();
                }
                List list3 = this.editor.getInlayModel().getBlockElementsForVisualLine(position.line, false);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getBlockElementsForVisualLine(...)");
                $this$filter$iv = list3;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                Iterator bl = $this$filterTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    element$iv$iv = bl.next();
                    it = (Inlay)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getRenderer() instanceof FrontendInlayRenderer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Inlay it3 = (Inlay)element$iv;
                    boolean bl3 = false;
                    it3.update();
                }
                CharSequence charSequence = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                if (charSequence.length() == 0) break block17;
                CharSequence charSequence2 = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
                if (StringsKt.isBlank((CharSequence)charSequence2)) break block18;
            }
            return;
        }
        int oldOffset = event.getOffset();
        int newOffset = event.getOffset() + event.getNewFragment().length();
        VisualPosition visualPosition = this.editor.offsetToVisualPosition(oldOffset);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition visualPositionBefore = visualPosition;
        Inlay inlay = this.editor.getInlayModel().getInlineElementAt(visualPositionBefore);
        if (inlay != null) {
            Inlay inlay2 = inlay;
            boolean bl = false;
            InlayInfo inlayInfo = this.getInlayInfo(inlay2);
            if (inlayInfo != null) {
                it = inlayInfo;
                boolean bl4 = false;
                if (!((InlayInfo)it).getRelatesToPrecedingText()) {
                    this.frontendInlayModelAdapter.moveInlay(inlay2, (InlayInfo)it, newOffset);
                }
            }
        }
        VisualPosition visualPosition2 = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)this.editor, (int)newOffset);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"inlayAwareOffsetToVisualPosition(...)");
        VisualPosition visualPositionAfter = visualPosition2;
        Inlay inlay3 = this.editor.getInlayModel().getInlineElementAt(visualPositionAfter);
        if (inlay3 != null) {
            Inlay inlay4 = inlay3;
            boolean bl = false;
            InlayInfo inlayInfo = this.getInlayInfo(inlay4);
            if (inlayInfo != null) {
                InlayInfo it4 = inlayInfo;
                boolean bl5 = false;
                if (it4.getRelatesToPrecedingText()) {
                    this.frontendInlayModelAdapter.moveInlay(inlay4, it4, oldOffset);
                }
            }
        }
        List list4 = this.editor.getInlayModel().getAfterLineEndElementsInRange(newOffset, newOffset, FrontendInlayRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getAfterLineEndElementsInRange(...)");
        Iterable $this$forEach$iv = list4;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlayInfo it5;
            Inlay inlay5 = (Inlay)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)inlay5);
            if (this.getInlayInfo(inlay5) == null) continue;
            boolean bl6 = false;
            this.frontendInlayModelAdapter.moveInlay(inlay5, it5, oldOffset);
        }
    }

    private final InlayInfo getInlayInfo(Inlay<?> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        FrontendInlayRenderer frontendInlayRenderer = editorCustomElementRenderer instanceof FrontendInlayRenderer ? (FrontendInlayRenderer)editorCustomElementRenderer : null;
        if (frontendInlayRenderer == null) {
            return null;
        }
        FrontendInlayRenderer renderer = frontendInlayRenderer;
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getInstance().findMarkupContributor(this.editor);
        if (frontendMarkupContributor == null) {
            return null;
        }
        FrontendMarkupContributor markupContributor = frontendMarkupContributor;
        RangeHighlighterEx rangeHighlighterEx = markupContributor.getStorage().getAll().get(renderer.getId());
        return rangeHighlighterEx != null ? FrontendHintInlayModelSupportKt.getInlayInfo((RangeHighlighter)rangeHighlighterEx) : null;
    }
}

