/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.suppressors;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogShrinkingSuppressor;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterIdList;
import com.jetbrains.rd.ide.model.HighlighterList;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.daemon.suppressors.HighlighterElementSuppressor;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModelKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u0014\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J\u0016\u0010\u0016\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0002JD\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u00050\"\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0\u00052\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020&0%H\u0002J\u001a\u0010'\u001a\u00020&*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010(\u001a\u00020\fH\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "", "protocolMarkup", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "supressors", "", "Lcom/jetbrains/rdclient/daemon/suppressors/HighlighterElementSuppressor;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdMarkupModel;Ljava/util/List;)V", "pendingAddHighlighters", "", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "pendingUpdateHighlighters", "", "pendingRemoveHighlighters", "highlightersAdded", "Lcom/jetbrains/rd/util/reactive/ISignal;", "getHighlightersAdded", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "highlightersUpdated", "getHighlightersUpdated", "highlightersRemoved", "getHighlightersRemoved", "highlightersCleared", "", "getHighlightersCleared", "bind", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "elements", "idsToRemove", "flush", "splitBySuppressors", "Lkotlin/Pair;", "T", "predicate", "Lkotlin/Function1;", "", "isSuppressed", "element", "getActiveSuppressors", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolSuppressableMarkupModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolSuppressableMarkupModel.kt\ncom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n1869#2,2:115\n3301#2,10:129\n1761#2,3:139\n67#3,4:117\n67#3,4:121\n67#3,4:125\n*S KotlinDebug\n*F\n+ 1 ProtocolSuppressableMarkupModel.kt\ncom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel\n*L\n42#1:115,2\n108#1:129,10\n110#1:139,3\n51#1:117,4\n60#1:121,4\n73#1:125,4\n*E\n"})
public final class ProtocolSuppressableMarkupModel {
    @NotNull
    private final RdMarkupModel protocolMarkup;
    @NotNull
    private final List<HighlighterElementSuppressor> supressors;
    @NotNull
    private final Map<Long, HighlighterElement> pendingAddHighlighters;
    @NotNull
    private final List<HighlighterElement> pendingUpdateHighlighters;
    @NotNull
    private final List<Long> pendingRemoveHighlighters;
    @NotNull
    private final ISignal<List<HighlighterElement>> highlightersAdded;
    @NotNull
    private final ISignal<List<HighlighterElement>> highlightersUpdated;
    @NotNull
    private final ISignal<List<Long>> highlightersRemoved;
    @NotNull
    private final ISignal<Unit> highlightersCleared;

    public ProtocolSuppressableMarkupModel(@NotNull RdMarkupModel protocolMarkup, @NotNull List<? extends HighlighterElementSuppressor> supressors) {
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        Intrinsics.checkNotNullParameter(supressors, (String)"supressors");
        this.protocolMarkup = protocolMarkup;
        this.supressors = supressors;
        this.pendingAddHighlighters = new LinkedHashMap();
        this.pendingUpdateHighlighters = new ArrayList();
        this.pendingRemoveHighlighters = new ArrayList();
        this.highlightersAdded = (ISignal)new Signal();
        this.highlightersUpdated = (ISignal)new Signal();
        this.highlightersRemoved = (ISignal)new Signal();
        this.highlightersCleared = (ISignal)new Signal();
    }

    @NotNull
    public final ISignal<List<HighlighterElement>> getHighlightersAdded() {
        return this.highlightersAdded;
    }

    @NotNull
    public final ISignal<List<HighlighterElement>> getHighlightersUpdated() {
        return this.highlightersUpdated;
    }

    @NotNull
    public final ISignal<List<Long>> getHighlightersRemoved() {
        return this.highlightersRemoved;
    }

    @NotNull
    public final ISignal<Unit> getHighlightersCleared() {
        return this.highlightersCleared;
    }

    public final void bind(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.protocolMarkup.getHighlightersRemoved().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$0(this, arg_0));
        this.protocolMarkup.getHighlightersAdded().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$1(this, arg_0));
        this.protocolMarkup.getHighlightersUpdated().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$2(this, arg_0));
        this.protocolMarkup.getHighlightersCleared().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$3(this, arg_0));
        DocumentLog.Companion.registerSuppressor(lifetime, new DocumentLogShrinkingSuppressor(this){
            final /* synthetic */ ProtocolSuppressableMarkupModel this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean canShrink(RdDocumentVersion documentVersion) {
                Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
                return ProtocolSuppressableMarkupModel.access$getPendingAddHighlighters$p(this.this$0).isEmpty() && ProtocolSuppressableMarkupModel.access$getPendingUpdateHighlighters$p(this.this$0).isEmpty() && ProtocolSuppressableMarkupModel.access$getPendingRemoveHighlighters$p(this.this$0).isEmpty();
            }
        });
        Iterable $this$forEach$iv = this.supressors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HighlighterElementSuppressor it = (HighlighterElementSuppressor)element$iv;
            boolean bl = false;
            it.getFlush().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$4$0(this, arg_0));
        }
    }

    private final void highlightersUpdated(List<HighlighterElement> elements) {
        if (elements.isEmpty()) {
            return;
        }
        Pair<List<HighlighterElement>, List<HighlighterElement>> pair = this.splitBySuppressors(elements, arg_0 -> ProtocolSuppressableMarkupModel.highlightersUpdated$lambda$0(this, arg_0));
        List suppressed = (List)pair.component1();
        List toUpdate = (List)pair.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersUpdated: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toUpdate).size() + " toUpdate");
        }
        this.pendingUpdateHighlighters.addAll(suppressed);
        this.highlightersUpdated.fire((Object)toUpdate);
    }

    private final void highlightersAdded(List<HighlighterElement> elements) {
        if (elements.isEmpty()) {
            return;
        }
        Pair<List<HighlighterElement>, List<HighlighterElement>> pair = this.splitBySuppressors(elements, arg_0 -> ProtocolSuppressableMarkupModel.highlightersAdded$lambda$0(this, arg_0));
        List suppressed = (List)pair.component1();
        List toAdd = (List)pair.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersAdded: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toAdd).size() + " toAdd");
        }
        for (HighlighterElement it : suppressed) {
            this.pendingAddHighlighters.put(it.getHighlighter().getId(), it);
        }
        if (!toAdd.isEmpty()) {
            this.highlightersAdded.fire((Object)toAdd);
        }
    }

    private final void highlightersRemoved(List<Long> idsToRemove) {
        if (idsToRemove.isEmpty()) {
            return;
        }
        Pair<List<Long>, List<Long>> pair = this.splitBySuppressors(idsToRemove, arg_0 -> ProtocolSuppressableMarkupModel.highlightersRemoved$lambda$0(this, arg_0));
        List suppressed = (List)pair.component1();
        List toRemove = (List)pair.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersRemoved: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toRemove).size() + " toRemove");
        }
        this.pendingRemoveHighlighters.addAll(suppressed);
        this.highlightersRemoved.fire((Object)toRemove);
    }

    private final void highlightersCleared() {
        ProtocolSuppressableMarkupModelKt.access$getLogger$p().trace("highlightersCleared");
        this.pendingAddHighlighters.clear();
        this.pendingUpdateHighlighters.clear();
        this.pendingRemoveHighlighters.clear();
        InterfacesKt.fire(this.highlightersCleared);
    }

    private final void flush() {
        if (!this.pendingAddHighlighters.isEmpty()) {
            List pendingAddList = CollectionsKt.toList((Iterable)this.pendingAddHighlighters.values());
            this.pendingAddHighlighters.clear();
            this.highlightersAdded(pendingAddList);
        }
        if (!((Collection)this.pendingUpdateHighlighters).isEmpty()) {
            List pendingUpdateList = CollectionsKt.toList((Iterable)this.pendingUpdateHighlighters);
            this.pendingUpdateHighlighters.clear();
            this.highlightersUpdated(pendingUpdateList);
        }
        if (!((Collection)this.pendingRemoveHighlighters).isEmpty()) {
            List pendingRemoveList = CollectionsKt.toList((Iterable)this.pendingRemoveHighlighters);
            this.pendingRemoveHighlighters.clear();
            this.highlightersRemoved(pendingRemoveList);
        }
    }

    private final <T> Pair<List<T>, List<T>> splitBySuppressors(List<? extends T> $this$splitBySuppressors, Function1<? super T, Boolean> predicate) {
        if (this.supressors.isEmpty()) {
            return new Pair((Object)CollectionsKt.emptyList(), $this$splitBySuppressors);
        }
        Iterable $this$partition$iv = $this$splitBySuppressors;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl = (Boolean)predicate.invoke(element$iv) != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        return new Pair(first$iv, second$iv);
    }

    private final boolean isSuppressed(List<? extends HighlighterElementSuppressor> $this$isSuppressed, HighlighterElement element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isSuppressed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HighlighterElementSuppressor it = (HighlighterElementSuppressor)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldSuppress(element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @TestOnly
    @NotNull
    public final List<HighlighterElementSuppressor> getActiveSuppressors() {
        return this.supressors;
    }

    private static final Unit bind$lambda$0(ProtocolSuppressableMarkupModel this$0, HighlighterIdList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersRemoved(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(ProtocolSuppressableMarkupModel this$0, HighlighterList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersAdded(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(ProtocolSuppressableMarkupModel this$0, HighlighterList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersUpdated(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(ProtocolSuppressableMarkupModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersCleared();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4$0(ProtocolSuppressableMarkupModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.flush();
        return Unit.INSTANCE;
    }

    private static final boolean highlightersUpdated$lambda$0(ProtocolSuppressableMarkupModel this$0, HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.isSuppressed(this$0.supressors, element);
    }

    private static final boolean highlightersAdded$lambda$0(ProtocolSuppressableMarkupModel this$0, HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.isSuppressed(this$0.supressors, element);
    }

    private static final boolean highlightersRemoved$lambda$0(ProtocolSuppressableMarkupModel this$0, long elementId) {
        return this$0.pendingAddHighlighters.containsKey(elementId);
    }

    public static final /* synthetic */ Map access$getPendingAddHighlighters$p(ProtocolSuppressableMarkupModel $this) {
        return $this.pendingAddHighlighters;
    }

    public static final /* synthetic */ List access$getPendingUpdateHighlighters$p(ProtocolSuppressableMarkupModel $this) {
        return $this.pendingUpdateHighlighters;
    }

    public static final /* synthetic */ List access$getPendingRemoveHighlighters$p(ProtocolSuppressableMarkupModel $this) {
        return $this.pendingRemoveHighlighters;
    }
}

