/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services.popups;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.ide.model.popups.IRdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdEmptyPopupMenuModel;
import com.jetbrains.ide.model.popups.RdExpandSubmenuRequest;
import com.jetbrains.ide.model.popups.RdPopupMenuItemKind;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItem;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItems;
import com.jetbrains.ide.model.popups.RdPopupSubmenuModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.services.popups.FrontendIntentionAction;
import com.jetbrains.rdclient.services.popups.FrontendIntentionMenuContributor;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0012H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "bindPopupModel", "", "popupLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "popupModel", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModel;", "intentions", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "convertSubstep", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "popupMenuModelItem", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModelItem;", "tryGetClientShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "isCurrent", "", "Lcom/jetbrains/ide/model/popups/IRdPopupMenuModel;", "currentThreadId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIntentionMenuContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIntentionMenuContributor.kt\ncom/jetbrains/rdclient/services/popups/FrontendIntentionMenuContributorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n67#2,4:317\n67#2,4:326\n13#2:335\n1573#3:321\n1604#3,4:322\n1573#3:330\n1604#3,4:331\n*S KotlinDebug\n*F\n+ 1 FrontendIntentionMenuContributor.kt\ncom/jetbrains/rdclient/services/popups/FrontendIntentionMenuContributorKt\n*L\n251#1:317,4\n282#1:326,4\n51#1:335\n280#1:321\n280#1:322,4\n287#1:330\n287#1:331,4\n*E\n"})
public final class FrontendIntentionMenuContributorKt {
    @NotNull
    private static final Logger LOG;

    private static final void bindPopupModel(Lifetime popupLifetime, Project project, IdeBackend backend, RdPopupMenuModel popupModel, ShowIntentionsPass.IntentionsInfo intentions) {
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)popupModel.getItems().getValueOrNull();
        if (rdPopupMenuModelItems == null) {
            return;
        }
        RdPopupMenuModelItems items = rdPopupMenuModelItems;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got intentions (count=" + items.getValue().size() + ")");
        }
        Iterator iterator2 = ((Iterable)items.getValue()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            RdPopupMenuModelItem popupMenuModelItem = (RdPopupMenuModelItem)iterator2.next();
            FrontendIntentionAction intentionAction = new FrontendIntentionAction(i, popupLifetime, popupModel, popupMenuModelItem);
            List<IntentionAction> intentionOptions = FrontendIntentionMenuContributorKt.convertSubstep(popupLifetime, popupModel, popupMenuModelItem);
            IconModel iconModel = popupMenuModelItem.getIcon();
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = new HighlightInfo.IntentionActionDescriptor((IntentionAction)intentionAction, intentionOptions, null, iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, null, null, null, null);
            switch (WhenMappings.$EnumSwitchMapping$0[popupMenuModelItem.getKind().ordinal()]) {
                case 1: {
                    boolean bl = intentions.errorFixesToShow.add(intentionActionDescriptor);
                    break;
                }
                case 2: {
                    boolean bl = intentions.inspectionFixesToShow.add(intentionActionDescriptor);
                    break;
                }
                case 3: {
                    boolean bl = intentions.guttersToShow.add(intentionAction.toAnAction(project));
                    break;
                }
                case 4: {
                    boolean bl = intentions.notificationActionsToShow.add(intentionActionDescriptor);
                    break;
                }
                default: {
                    boolean bl = intentions.intentionsToShow.add(intentionActionDescriptor);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IntentionAction> convertSubstep(Lifetime popupLifetime, RdPopupMenuModel popupModel, RdPopupMenuModelItem popupMenuModelItem) {
        void $this$mapIndexedTo$iv$iv;
        Object object;
        if (!popupMenuModelItem.getCanExpand()) {
            return CollectionsKt.emptyList();
        }
        List subItems = popupMenuModelItem.getSubItems();
        if (subItems != null) {
            void $this$mapIndexedTo$iv$iv2;
            Iterable $this$mapIndexed$iv = subItems;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                void item;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RdPopupMenuModelItem rdPopupMenuModelItem = (RdPopupMenuModelItem)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new FrontendIntentionAction((int)i, popupLifetime, popupModel, (RdPopupMenuModelItem)item));
            }
            return (List)destination$iv$iv;
        }
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            object.trace("Sending expand item request for item " + popupMenuModelItem.getItemId() + " in " + FrontendIntentionMenuContributorKt.currentThreadId());
        }
        RdExpandSubmenuRequest request = new RdExpandSubmenuRequest(popupMenuModelItem.getItemId());
        popupModel.getExpandSubmenu().set((Object)request);
        Object destination$iv$iv = request.getSubmenu().getValueOrNull();
        RdPopupSubmenuModel rdPopupSubmenuModel = destination$iv$iv instanceof RdPopupSubmenuModel ? (RdPopupSubmenuModel)destination$iv$iv : null;
        if (rdPopupSubmenuModel == null) {
            return CollectionsKt.emptyList();
        }
        RdPopupSubmenuModel submenuModel = rdPopupSubmenuModel;
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)submenuModel.getItems().getValueOrNull();
        if (rdPopupMenuModelItems == null) {
            return CollectionsKt.emptyList();
        }
        RdPopupMenuModelItems submenuModelItems = rdPopupMenuModelItems;
        Iterable $this$mapIndexed$iv = submenuModelItems.getValue();
        boolean $i$f$mapIndexed = false;
        Iterable index$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv2 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void item;
            void i;
            int n;
            if ((n = index$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RdPopupMenuModelItem rdPopupMenuModelItem = (RdPopupMenuModelItem)item$iv$iv;
            int n3 = n;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new FrontendIntentionAction((int)i, popupLifetime, popupModel, (RdPopupMenuModelItem)item));
        }
        return (List)destination$iv$iv2;
    }

    private static final ShortcutSet tryGetClientShortcut(RdPopupMenuModelItem $this$tryGetClientShortcut) {
        if ($this$tryGetClientShortcut.getActionId() != null) {
            KeymapManager manager = KeymapManager.getInstance();
            if (manager != null) {
                Shortcut[] shortcutArray = manager.getActiveKeymap().getShortcuts($this$tryGetClientShortcut.getActionId());
                return (ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutArray, shortcutArray.length));
            }
            return null;
        }
        RichAttributedTextModel optionalText = $this$tryGetClientShortcut.getOptionalText();
        if (optionalText == null) {
            return null;
        }
        String shortcutTextPresentation = RichTextHtmlUtils.INSTANCE.highlightAttributedParts(optionalText);
        if (StringsKt.isBlank((CharSequence)shortcutTextPresentation)) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(shortcutTextPresentation);
        return (ShortcutSet)new CustomShortcutSet(keyStroke);
    }

    public static final boolean isCurrent(@NotNull IRdPopupMenuModel $this$isCurrent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isCurrent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UiContextManager uiContextManager = UiContextManager.Companion.getInstance(project);
        IRdPopupMenuModel iRdPopupMenuModel = $this$isCurrent;
        return iRdPopupMenuModel instanceof RdEmptyPopupMenuModel ? uiContextManager.isActualValues(((RdEmptyPopupMenuModel)$this$isCurrent).getTimestamps()) : (iRdPopupMenuModel instanceof RdPopupMenuModel ? uiContextManager.isActualValues(((RdPopupMenuModel)$this$isCurrent).getTimestamps()) : false);
    }

    @NotNull
    public static final String currentThreadId() {
        return ApplicationManager.getApplication().isDispatchThread() ? "EDT" : String.valueOf(Thread.currentThread().getId());
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$bindPopupModel(Lifetime popupLifetime, Project project, IdeBackend backend, RdPopupMenuModel popupModel, ShowIntentionsPass.IntentionsInfo intentions) {
        FrontendIntentionMenuContributorKt.bindPopupModel(popupLifetime, project, backend, popupModel, intentions);
    }

    public static final /* synthetic */ ShortcutSet access$tryGetClientShortcut(RdPopupMenuModelItem $receiver) {
        return FrontendIntentionMenuContributorKt.tryGetClientShortcut($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendIntentionMenuContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdPopupMenuItemKind.values().length];
            try {
                nArray[RdPopupMenuItemKind.ErrorFix.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.InspectionFix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.Gutter.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.Notification.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

