/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.RdDocumentVersions;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentVersionHolderImpl;", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "initialVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdDocumentVersion;Lcom/jetbrains/rd/ide/model/RdDocumentId;)V", "value", "version", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "incrementVersion", "Lcom/jetbrains/rd/ide/document/RdDocumentVersions;", "offset", "", "moveOffset", "oldText", "", "newText", "oldDocumentLength", "text", "resetVersion", "", "v", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentVersionHolderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentVersionHolderImpl.kt\ncom/jetbrains/rd/ide/document/DocumentVersionHolderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,35:1\n67#2,4:36\n67#2,4:40\n67#2,4:44\n13#2:48\n*S KotlinDebug\n*F\n+ 1 DocumentVersionHolderImpl.kt\ncom/jetbrains/rd/ide/document/DocumentVersionHolderImpl\n*L\n20#1:36,4\n27#1:40,4\n33#1:44,4\n11#1:48\n*E\n"})
public final class DocumentVersionHolderImpl
implements DocumentVersionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private RdDocumentVersion version;
    @NotNull
    private static final Logger logger;

    public DocumentVersionHolderImpl(@NotNull RdDocumentVersion initialVersion, @NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)initialVersion, (String)"initialVersion");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        this.documentId = documentId;
        this.version = initialVersion;
    }

    @Override
    @NotNull
    public RdDocumentVersion getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public RdDocumentVersions incrementVersion(int offset, int moveOffset, @NotNull String oldText, @NotNull String newText, int oldDocumentLength) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        RdDocumentVersion previousVersion = this.getVersion();
        this.version = DocumentVersionsKt.nextVersion(this.getVersion(), offset, moveOffset, oldText, newText, oldDocumentLength);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Increment document version '" + this.documentId + "', version: " + this.getVersion() + " previousVersion: " + previousVersion);
        }
        return new RdDocumentVersions(previousVersion, this.getVersion());
    }

    @Override
    @NotNull
    public RdDocumentVersions incrementVersion(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        RdDocumentVersion previousVersion = this.getVersion();
        this.version = DocumentVersionsKt.nextVersion(this.getVersion(), text);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Increment document version '" + this.documentId + "', version: " + this.getVersion() + " previousVersion: " + previousVersion);
        }
        return new RdDocumentVersions(previousVersion, this.getVersion());
    }

    @Override
    public void resetVersion(@NotNull RdDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.version = v;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Reset document version '" + this.documentId + "', version: " + this.getVersion());
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DocumentVersionHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DocumentVersionHolderImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentVersionHolderImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

