/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdNonConflictingPatchItemId;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.model.RdTransparentEditorChange;
import com.jetbrains.rd.ide.model.RdTransparentItem;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u001e\u0010\u0013\u001a\u00020\u000f*\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0001\u001a$\u0010\u0014\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0002\u001a4\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u0016\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0002\u001a$\u0010\u001e\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007H\u0002\u001a$\u0010 \u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007H\u0002\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006!"}, d2={"isIntersecting", "", "Lcom/jetbrains/rd/ide/model/RdPatch;", "other", "intersectable", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemId;", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "updatingChange", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "oldVersion", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "newVersion", "isEqualOrEquivalent", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "(Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;)Z", "speculativelyEqualsEx", "allowEquivalentChanges", "speculativelyEquals", "areChangesEquivalent", "left", "right", "areDocumentChangesEqual", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "checkSubChange", "checkReplaceOrComplexChangeSplitIn2", "leftIterator", "", "rightIterator", "areCaretChangesEquivalent", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "areCaretChangesEquivalentPerEditorId", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nRdPatchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdPatchUtils.kt\ncom/jetbrains/rd/ide/requests/RdPatchUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,190:1\n1586#2:191\n1661#2,3:192\n873#2,2:195\n777#2:197\n873#2,2:198\n777#2:200\n873#2,2:201\n812#2,12:203\n812#2,12:215\n1512#2:227\n1538#2,3:228\n1541#2,3:238\n1512#2:241\n1538#2,3:242\n1541#2,3:252\n383#3,7:231\n383#3,7:245\n173#4,3:255\n57#5:258\n35#5,2:259\n*S KotlinDebug\n*F\n+ 1 RdPatchUtils.kt\ncom/jetbrains/rd/ide/requests/RdPatchUtilsKt\n*L\n20#1:191\n20#1:192,3\n20#1:195,2\n39#1:197\n39#1:198,2\n40#1:200\n40#1:201,2\n49#1:203,12\n50#1:215,12\n148#1:227\n148#1:228,3\n148#1:238,3\n149#1:241\n149#1:242,3\n149#1:252,3\n148#1:231,7\n149#1:245,7\n152#1:255,3\n168#1:258\n168#1:259,2\n*E\n"})
public final class RdPatchUtilsKt {
    public static final boolean isIntersecting(@NotNull RdPatch $this$isIntersecting, @NotNull RdPatch other) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntersecting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Set<RdPatchItemId> thisExpected = RdPatchUtilsKt.intersectable($this$isIntersecting.getExpectedItemVersions());
        Set<RdPatchItemId> thisUpdated = RdPatchUtilsKt.intersectable($this$isIntersecting.getUpdatedItemVersions());
        Set<RdPatchItemId> otherExpected = RdPatchUtilsKt.intersectable(other.getExpectedItemVersions());
        Set<RdPatchItemId> otherUpdated = RdPatchUtilsKt.intersectable(other.getUpdatedItemVersions());
        return !((Collection)CollectionsKt.intersect((Iterable)thisExpected, (Iterable)otherUpdated)).isEmpty() || !((Collection)CollectionsKt.intersect((Iterable)thisUpdated, (Iterable)otherExpected)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<RdPatchItemId> intersectable(@NotNull List<? extends RdPatchItemVersion> $this$intersectable) {
        void var2_3;
        void $this$filterTo$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$intersectable, (String)"<this>");
        Iterable $this$map$iv = $this$intersectable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdPatchItemVersion rdPatchItemVersion = (RdPatchItemVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            RdPatchItemId it = (RdPatchItemId)element$iv;
            boolean bl = false;
            if (!(!(it instanceof RdNonConflictingPatchItemId))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var2_3;
    }

    public static final boolean updatingChange(@NotNull RdPatchItem $this$updatingChange, @NotNull RdEditorVersion oldVersion, @NotNull RdEditorVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$updatingChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return !($this$updatingChange instanceof RdTransparentEditorChange) && !Intrinsics.areEqual((Object)oldVersion, (Object)newVersion);
    }

    public static final boolean isEqualOrEquivalent(@NotNull SpeculativelyEqualsResult $this$isEqualOrEquivalent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isEqualOrEquivalent), (String)"<this>");
        return $this$isEqualOrEquivalent != SpeculativelyEqualsResult.Different;
    }

    public static final boolean speculativelyEqualsEx(@Nullable RdPatch $this$speculativelyEqualsEx, @Nullable RdPatch other, boolean allowEquivalentChanges) {
        return RdPatchUtilsKt.speculativelyEquals($this$speculativelyEqualsEx, other, allowEquivalentChanges) != SpeculativelyEqualsResult.Different;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpeculativelyEqualsResult speculativelyEquals(@Nullable RdPatch $this$speculativelyEquals, @Nullable RdPatch other, boolean allowEquivalentChanges) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        if ($this$speculativelyEquals == other) {
            return SpeculativelyEqualsResult.Equals;
        }
        if ($this$speculativelyEquals == null || other == null) {
            return SpeculativelyEqualsResult.Different;
        }
        Iterable $this$filter$iv = $this$speculativelyEquals.getChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RdPatchItem it = (RdPatchItem)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof RdTransparentItem))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List a_ = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = other.getChanges();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RdPatchItem it = (RdPatchItem)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof RdTransparentItem))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List b_ = (List)destination$iv$iv2;
        if (Intrinsics.areEqual((Object)a_, (Object)b_)) {
            return SpeculativelyEqualsResult.Equals;
        }
        return allowEquivalentChanges && RdPatchUtilsKt.areChangesEquivalent(a_, b_) ? SpeculativelyEqualsResult.Equivalent : SpeculativelyEqualsResult.Different;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean areChangesEquivalent(List<? extends RdPatchItem> left, List<? extends RdPatchItem> right) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv = left;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof RdSelectionChangeBase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List leftCaretChanges = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = right;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RdSelectionChangeBase)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List rightCaretChanges = (List)destination$iv$iv2;
        if (RdPatchUtilsKt.areCaretChangesEquivalent(leftCaretChanges, rightCaretChanges)) {
            RdPatchItem rightChange;
            RdPatchItem leftChange;
            List leftChanges = CollectionsKt.minus((Iterable)left, (Iterable)leftCaretChanges);
            List rightChanges = CollectionsKt.minus((Iterable)right, (Iterable)rightCaretChanges);
            ListIterator leftIterator = leftChanges.listIterator();
            ListIterator rightIterator = rightChanges.listIterator();
            do {
                if (!leftIterator.hasNext()) {
                    return !rightIterator.hasNext();
                }
                if (rightIterator.hasNext()) continue;
                return !leftIterator.hasNext();
            } while (Intrinsics.areEqual((Object)(leftChange = (RdPatchItem)leftIterator.next()), (Object)(rightChange = (RdPatchItem)rightIterator.next())) || leftChange instanceof RdDocumentChange && rightChange instanceof RdDocumentChange && (RdPatchUtilsKt.areDocumentChangesEqual((RdDocumentChange)leftChange, (RdDocumentChange)rightChange) || RdPatchUtilsKt.checkReplaceOrComplexChangeSplitIn2((RdDocumentChange)leftChange, leftIterator, (RdDocumentChange)rightChange, rightIterator)));
            return false;
        }
        return false;
    }

    private static final boolean areDocumentChangesEqual(RdDocumentChange left, RdDocumentChange right) {
        if (Intrinsics.areEqual((Object)left.getDocumentId(), (Object)right.getDocumentId()) && left.getOffset() == right.getOffset() && left.getMoveOffset() == right.getMoveOffset() && Intrinsics.areEqual((Object)left.getNewText(), (Object)right.getNewText()) && Intrinsics.areEqual((Object)left.getOldText(), (Object)right.getOldText())) {
            return true;
        }
        if (left.getOldText().length() == right.getOldText().length()) {
            return false;
        }
        if (left.getOldText().length() > right.getOldText().length() && left.getNewText().length() > right.getNewText().length()) {
            return RdPatchUtilsKt.checkSubChange(left, right);
        }
        if (left.getOldText().length() < right.getOldText().length() && left.getNewText().length() < right.getNewText().length()) {
            return RdPatchUtilsKt.checkSubChange(right, left);
        }
        return false;
    }

    private static final boolean checkSubChange(RdDocumentChange left, RdDocumentChange right) {
        boolean bl;
        boolean bl2 = bl = left.getOldText().length() > right.getOldText().length() && left.getNewText().length() > right.getNewText().length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int start = right.getOffset() - left.getOffset();
        if (start < 0) {
            return false;
        }
        int oldLength = right.getOldText().length();
        int newLength = right.getNewText().length();
        return StringUtil.equals((CharSequence)StringsKt.take((String)left.getOldText(), (int)start), (CharSequence)StringsKt.take((String)left.getNewText(), (int)start)) && StringUtil.equals((CharSequence)StringsKt.drop((String)StringsKt.drop((String)left.getOldText(), (int)start), (int)oldLength), (CharSequence)StringsKt.drop((String)left.getNewText(), (int)(start + newLength))) && StringUtil.equals((CharSequence)StringsKt.take((String)StringsKt.drop((String)left.getOldText(), (int)start), (int)oldLength), (CharSequence)right.getOldText()) && StringUtil.equals((CharSequence)StringsKt.take((String)StringsKt.drop((String)left.getNewText(), (int)start), (int)newLength), (CharSequence)right.getNewText());
    }

    private static final boolean checkReplaceOrComplexChangeSplitIn2(RdDocumentChange left, ListIterator<? extends RdPatchItem> leftIterator, RdDocumentChange right, ListIterator<? extends RdPatchItem> rightIterator) {
        return RdPatchUtilsKt.checkReplaceOrComplexChangeSplitIn2$check(left, leftIterator, right) || RdPatchUtilsKt.checkReplaceOrComplexChangeSplitIn2$check(right, rightIterator, left);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean areCaretChangesEquivalent(List<? extends RdSelectionChangeBase> left, List<? extends RdSelectionChangeBase> right) {
        void $this$groupByTo$iv$iv;
        Object key$iv$iv$iv;
        void $this$groupByTo$iv$iv2;
        Iterable $this$groupBy$iv = left;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            RdSelectionChangeBase it = (RdSelectionChangeBase)element$iv$iv;
            boolean bl = false;
            TextControlId key$iv$iv = it.getEditorId();
            Object object2 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map leftEditorToChanges = destination$iv$iv;
        Iterable $this$groupBy$iv2 = right;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            RdSelectionChangeBase it = (RdSelectionChangeBase)element$iv$iv;
            boolean bl = false;
            TextControlId key$iv$iv = it.getEditorId();
            key$iv$iv$iv = destination$iv$iv2;
            TextControlId key$iv$iv$iv2 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv2);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv2, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map rightEditorToChanges = destination$iv$iv2;
        return RdPatchUtilsKt.areCaretChangesEquivalent$check(leftEditorToChanges, rightEditorToChanges) && RdPatchUtilsKt.areCaretChangesEquivalent$check(rightEditorToChanges, leftEditorToChanges);
    }

    private static final boolean areCaretChangesEquivalentPerEditorId(List<? extends RdSelectionChangeBase> left, List<? extends RdSelectionChangeBase> right) {
        List<RdCaret> leftInitialCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(left, true);
        List<RdCaret> rightInitialCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(right, true);
        List<RdCaret> leftFinalCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(left, false);
        List<RdCaret> rightFinalCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(right, false);
        if (leftInitialCarets == null || rightInitialCarets == null) {
            return Intrinsics.areEqual(leftInitialCarets, leftFinalCarets) && Intrinsics.areEqual(rightInitialCarets, rightFinalCarets);
        }
        return Intrinsics.areEqual(leftFinalCarets, rightFinalCarets);
    }

    private static final boolean checkReplaceOrComplexChangeSplitIn2$check(RdDocumentChange left, ListIterator<? extends RdPatchItem> leftIterator, RdDocumentChange right) {
        Object object;
        boolean unequalUniqueId;
        if (left.getOffset() != left.getMoveOffset() || !leftIterator.hasNext()) {
            return false;
        }
        RdPatchItem leftNext = leftIterator.next();
        leftIterator.previous();
        if (!(leftNext instanceof RdDocumentChange)) {
            return false;
        }
        boolean enabledUniqueIdFlag = Registry.Companion.is("rd.client.patch.engine.enable.unique.document.id", false);
        boolean bl = unequalUniqueId = enabledUniqueIdFlag && !Intrinsics.areEqual((Object)left.getUniqueId(), (Object)right.getUniqueId());
        if (!Intrinsics.areEqual((Object)left.getDocumentId(), (Object)((RdDocumentChange)leftNext).getDocumentId()) || ((RdDocumentChange)leftNext).getOffset() != ((RdDocumentChange)leftNext).getMoveOffset() || unequalUniqueId) {
            return false;
        }
        if (((RdDocumentChange)leftNext).getOffset() == left.getOffset() + left.getNewText().length()) {
            object = left.getNewText() + ((RdDocumentChange)leftNext).getNewText();
        } else if (left.getOffset() == ((RdDocumentChange)leftNext).getOffset() && Intrinsics.areEqual((Object)left.getNewText(), (Object)((RdDocumentChange)leftNext).getOldText())) {
            object = ((RdDocumentChange)leftNext).getNewText();
        } else {
            return false;
        }
        String newText = object;
        RdDocumentChange combinedChange = new RdDocumentChange(left.getOffset(), left.getMoveOffset(), newText, left.getOldText(), RdTextModificationKind.NotSpecified, left.getOldDocumentLength(), null, Boolean.valueOf(false), left.getDocumentId(), right.getNewVersion(), left.getOldVersion(), left.getUniqueId());
        boolean success = RdPatchUtilsKt.areDocumentChangesEqual(combinedChange, right);
        if (success) {
            leftIterator.next();
        }
        return success;
    }

    private static final boolean areCaretChangesEquivalent$check(Map<TextControlId, ? extends List<? extends RdSelectionChangeBase>> left, Map<TextControlId, ? extends List<? extends RdSelectionChangeBase>> right) {
        boolean bl;
        block4: {
            Map<TextControlId, ? extends List<? extends RdSelectionChangeBase>> $this$all$iv = left;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<TextControlId, ? extends List<? extends RdSelectionChangeBase>>> iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    List rightPerEditorChanges;
                    Map.Entry<TextControlId, ? extends List<? extends RdSelectionChangeBase>> element$iv;
                    Map.Entry<TextControlId, ? extends List<? extends RdSelectionChangeBase>> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    List list = right.get(it.getKey());
                    if (list == null) {
                        list = rightPerEditorChanges = CollectionsKt.emptyList();
                    }
                    if (RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId(it.getValue(), rightPerEditorChanges)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final List areCaretChangesEquivalentPerEditorId$getCarets$lambda$0(boolean $initial, RdSelectionChangeBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$tryGetCarets(it, $initial);
    }

    private static final List<RdCaret> areCaretChangesEquivalentPerEditorId$tryGetCarets(RdSelectionChangeBase $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets, boolean old) {
        List list;
        RdSelectionChangeBase rdSelectionChangeBase = $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            list = (old ? ((RdCaretStateChange)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getOldState() : ((RdCaretStateChange)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getNewState()).getCarets();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            list = ((RdCaretStateSnapshotBase)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getState().getCarets();
        } else {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown caret change: " + $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets);
            list = null;
        }
        return list;
    }

    private static final List<RdCaret> areCaretChangesEquivalentPerEditorId$getCarets(List<? extends RdSelectionChangeBase> $this$areCaretChangesEquivalentPerEditorId_u24getCarets, boolean initial) {
        List list = initial ? $this$areCaretChangesEquivalentPerEditorId_u24getCarets : CollectionsKt.asReversed($this$areCaretChangesEquivalentPerEditorId_u24getCarets);
        return (List)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets$lambda$0(initial, arg_0)));
    }
}

