// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: regexp-lexer.flex

/* This is automatically generated code. Do not modify it. */
package org.intellij.lang.regexp;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.IntArrayList;

import java.util.EnumSet;

import static java.lang.Boolean.FALSE;
import static java.lang.Boolean.TRUE;
import static org.intellij.lang.regexp.RegExpCapability.*;

class _RegExLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int QUOTED = 2;
  public static final int EMBRACED = 4;
  public static final int QUANTIFIER = 6;
  public static final int NON_QUANTIFIER = 8;
  public static final int NEGATED_CLASS = 10;
  public static final int QUOTED_CLASS = 12;
  public static final int CLASS1 = 14;
  public static final int OPTIONS = 16;
  public static final int COMMENT = 18;
  public static final int NAMED_GROUP = 20;
  public static final int QUOTED_NAMED_GROUP = 22;
  public static final int PY_NAMED_GROUP_REF = 24;
  public static final int PCRE_NUMBERED_GROUP = 26;
  public static final int BRACKET_EXPRESSION = 28;
  public static final int MYSQL_CHAR_EXPRESSION = 30;
  public static final int MYSQL_CHAR_EQ_EXPRESSION = 32;
  public static final int EMBRACED_HEX = 34;
  public static final int CONDITIONAL1 = 36;
  public static final int CONDITIONAL2 = 38;
  public static final int CLASS2 = 40;
  public static final int PROP = 42;
  public static final int NAMED = 44;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u1f00\1\u3500\1\u3600\1\u3700\1\u3800\1\u0100"+
    "\1\u3900\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u1f00"+
    "\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700"+
    "\1\u4800\1\u4900\1\u4a00\1\u4b00\1\u1f00\1\u4c00\1\u4d00\1\u4e00"+
    "\1\u1f00\3\u0100\1\u4f00\1\u5000\1\u5100\12\u1f00\4\u0100\1\u5200"+
    "\17\u1f00\2\u0100\1\u5300\41\u1f00\2\u0100\1\u5400\1\u5500\2\u1f00"+
    "\1\u5600\1\u5700\27\u0100\1\u5800\2\u0100\1\u5900\45\u1f00\1\u0100"+
    "\1\u5a00\1\u5b00\11\u1f00\1\u5c00\27\u1f00\1\u5d00\1\u5e00\1\u5f00"+
    "\1\u6000\11\u1f00\1\u6100\1\u6200\5\u1f00\1\u6300\1\u6400\4\u1f00"+
    "\1\u6500\21\u1f00\246\u0100\1\u6600\20\u0100\1\u6700\1\u6800\25\u0100"+
    "\1\u6900\34\u0100\1\u6a00\14\u1f00\2\u0100\1\u6b00\u0e05\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\10\0\2\1\1\2\1\0\1\1\1\2\22\0\1\3"+
    "\1\4\1\0\1\5\1\6\1\0\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\0\1\20"+
    "\3\21\4\22\2\23\1\24\1\0\1\25\1\26\1\27"+
    "\1\30\1\0\2\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\36\1\42\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\41\1\52\1\53\2\54"+
    "\1\41\1\55\1\56\1\57\1\60\1\61\1\62\1\0"+
    "\1\63\1\64\1\65\1\66\2\63\1\67\1\37\1\70"+
    "\1\41\1\71\1\52\1\41\1\72\1\41\1\73\1\41"+
    "\1\72\1\54\1\72\1\74\2\54\1\75\1\41\1\36"+
    "\1\76\1\77\1\100\54\0\1\101\12\0\1\101\4\0"+
    "\1\101\5\0\27\101\1\0\37\101\1\0\u01ca\101\4\0"+
    "\14\101\16\0\5\101\7\0\1\101\1\0\1\101\201\0"+
    "\5\101\1\0\2\101\2\0\4\101\1\0\1\101\6\0"+
    "\1\101\1\0\3\101\1\0\1\101\1\0\24\101\1\0"+
    "\123\101\1\0\213\101\10\0\246\101\1\0\46\101\2\0"+
    "\1\101\6\0\51\101\107\0\33\101\4\0\4\101\55\0"+
    "\53\101\25\0\12\102\4\0\2\101\1\0\143\101\1\0"+
    "\1\101\17\0\2\101\7\0\2\101\12\102\3\101\2\0"+
    "\1\101\20\0\1\101\1\0\36\101\35\0\131\101\13\0"+
    "\1\101\16\0\12\102\41\101\11\0\2\101\4\0\1\101"+
    "\5\0\26\101\4\0\1\101\11\0\1\101\3\0\1\101"+
    "\27\0\31\101\7\0\13\101\65\0\25\101\1\0\10\101"+
    "\106\0\66\101\3\0\1\101\22\0\1\101\7\0\12\101"+
    "\4\0\12\102\1\0\20\101\4\0\10\101\2\0\2\101"+
    "\2\0\26\101\1\0\7\101\1\0\1\101\3\0\4\101"+
    "\3\0\1\101\20\0\1\101\15\0\2\101\1\0\3\101"+
    "\4\0\12\102\2\101\12\0\1\101\10\0\6\101\4\0"+
    "\2\101\2\0\26\101\1\0\7\101\1\0\2\101\1\0"+
    "\2\101\1\0\2\101\37\0\4\101\1\0\1\101\7\0"+
    "\12\102\2\0\3\101\20\0\11\101\1\0\3\101\1\0"+
    "\26\101\1\0\7\101\1\0\2\101\1\0\5\101\3\0"+
    "\1\101\22\0\1\101\17\0\2\101\4\0\12\102\11\0"+
    "\1\101\13\0\10\101\2\0\2\101\2\0\26\101\1\0"+
    "\7\101\1\0\2\101\1\0\5\101\3\0\1\101\36\0"+
    "\2\101\1\0\3\101\4\0\12\102\1\0\1\101\21\0"+
    "\1\101\1\0\6\101\3\0\3\101\1\0\4\101\3\0"+
    "\2\101\1\0\1\101\1\0\2\101\3\0\2\101\3\0"+
    "\3\101\3\0\14\101\26\0\1\101\25\0\12\102\25\0"+
    "\10\101\1\0\3\101\1\0\27\101\1\0\20\101\3\0"+
    "\1\101\32\0\3\101\5\0\2\101\4\0\12\102\20\0"+
    "\1\101\4\0\10\101\1\0\3\101\1\0\27\101\1\0"+
    "\12\101\1\0\5\101\3\0\1\101\40\0\1\101\1\0"+
    "\2\101\4\0\12\102\1\0\2\101\22\0\10\101\1\0"+
    "\3\101\1\0\51\101\2\0\1\101\20\0\1\101\5\0"+
    "\3\101\10\0\3\101\4\0\12\102\12\0\6\101\5\0"+
    "\22\101\3\0\30\101\1\0\11\101\1\0\1\101\2\0"+
    "\7\101\37\0\12\102\21\0\60\101\1\0\2\101\14\0"+
    "\7\101\11\0\12\102\47\0\2\101\1\0\1\101\1\0"+
    "\5\101\1\0\30\101\1\0\1\101\1\0\12\101\1\0"+
    "\2\101\11\0\1\101\2\0\5\101\1\0\1\101\11\0"+
    "\12\102\2\0\4\101\40\0\1\101\37\0\12\102\26\0"+
    "\10\101\1\0\44\101\33\0\5\101\163\0\53\101\24\0"+
    "\1\101\12\102\6\0\6\101\4\0\4\101\3\0\1\101"+
    "\3\0\2\101\7\0\3\101\4\0\15\101\14\0\1\101"+
    "\1\0\12\102\6\0\46\101\1\0\1\101\5\0\1\101"+
    "\2\0\53\101\1\0\115\101\1\0\4\101\2\0\7\101"+
    "\1\0\1\101\1\0\4\101\2\0\51\101\1\0\4\101"+
    "\2\0\41\101\1\0\4\101\2\0\7\101\1\0\1\101"+
    "\1\0\4\101\2\0\17\101\1\0\71\101\1\0\4\101"+
    "\2\0\103\101\45\0\20\101\20\0\126\101\2\0\6\101"+
    "\3\0\u016c\101\2\0\21\101\1\0\32\101\5\0\113\101"+
    "\6\0\10\101\7\0\15\101\1\0\4\101\16\0\22\101"+
    "\16\0\22\101\16\0\15\101\1\0\3\101\17\0\64\101"+
    "\43\0\1\101\4\0\1\101\3\0\12\102\46\0\12\102"+
    "\6\0\131\101\7\0\5\101\2\0\42\101\1\0\1\101"+
    "\5\0\106\101\12\0\37\101\47\0\12\102\36\101\2\0"+
    "\5\101\13\0\54\101\4\0\32\101\6\0\12\102\46\0"+
    "\27\101\11\0\65\101\53\0\12\102\6\0\12\102\15\0"+
    "\1\101\135\0\57\101\21\0\7\101\4\0\12\102\51\0"+
    "\36\101\15\0\2\101\12\102\54\101\32\0\44\101\34\0"+
    "\12\102\3\0\3\101\12\102\44\101\2\0\11\101\7\0"+
    "\53\101\2\0\3\101\51\0\4\101\1\0\6\101\1\0"+
    "\2\101\3\0\1\101\5\0\300\101\100\0\26\101\2\0"+
    "\6\101\2\0\46\101\2\0\6\101\2\0\10\101\1\0"+
    "\1\101\1\0\1\101\1\0\1\101\1\0\37\101\2\0"+
    "\65\101\1\0\7\101\1\0\1\101\3\0\3\101\1\0"+
    "\7\101\3\0\4\101\2\0\6\101\4\0\15\101\5\0"+
    "\3\101\1\0\7\101\164\0\1\101\15\0\1\101\20\0"+
    "\15\101\145\0\1\101\4\0\1\101\2\0\12\101\1\0"+
    "\1\101\3\0\5\101\6\0\1\101\1\0\1\101\1\0"+
    "\1\101\1\0\4\101\1\0\13\101\2\0\4\101\5\0"+
    "\5\101\4\0\1\101\64\0\2\101\u017b\0\57\101\1\0"+
    "\57\101\1\0\205\101\6\0\4\101\3\0\2\101\14\0"+
    "\46\101\1\0\1\101\5\0\1\101\2\0\70\101\7\0"+
    "\1\101\20\0\27\101\11\0\7\101\1\0\7\101\1\0"+
    "\7\101\1\0\7\101\1\0\7\101\1\0\7\101\1\0"+
    "\7\101\1\0\7\101\120\0\1\101\325\0\2\101\52\0"+
    "\5\101\5\0\2\101\4\0\126\101\6\0\3\101\1\0"+
    "\132\101\1\0\4\101\5\0\53\101\1\0\136\101\21\0"+
    "\33\101\65\0\306\101\112\0\360\101\20\0\215\101\103\0"+
    "\56\101\2\0\15\101\3\0\20\101\12\102\2\101\24\0"+
    "\57\101\20\0\37\101\2\0\106\101\61\0\11\101\2\0"+
    "\147\101\2\0\65\101\2\0\5\101\60\0\13\101\1\0"+
    "\3\101\1\0\4\101\1\0\27\101\35\0\64\101\16\0"+
    "\62\101\34\0\12\102\30\0\6\101\3\0\1\101\1\0"+
    "\2\101\1\0\12\102\34\101\12\0\27\101\31\0\35\101"+
    "\7\0\57\101\34\0\1\101\12\102\6\0\5\101\1\0"+
    "\12\101\12\102\5\101\1\0\51\101\27\0\3\101\1\0"+
    "\10\101\4\0\12\102\6\0\27\101\3\0\1\101\3\0"+
    "\62\101\1\0\1\101\3\0\2\101\2\0\5\101\2\0"+
    "\1\101\1\0\1\101\30\0\3\101\2\0\13\101\7\0"+
    "\3\101\14\0\6\101\2\0\6\101\2\0\6\101\11\0"+
    "\7\101\1\0\7\101\1\0\53\101\1\0\14\101\10\0"+
    "\163\101\15\0\12\102\6\0\244\101\14\0\27\101\4\0"+
    "\61\101\4\0\156\101\2\0\152\101\46\0\7\101\14\0"+
    "\5\101\5\0\1\101\1\0\12\101\1\0\15\101\1\0"+
    "\5\101\1\0\1\101\1\0\2\101\1\0\2\101\1\0"+
    "\154\101\41\0\153\101\22\0\100\101\2\0\66\101\50\0"+
    "\14\101\164\0\5\101\1\0\207\101\23\0\12\102\7\0"+
    "\32\101\6\0\32\101\13\0\131\101\3\0\6\101\2\0"+
    "\6\101\2\0\6\101\2\0\3\101\43\0\14\101\1\0"+
    "\32\101\1\0\23\101\1\0\2\101\1\0\17\101\2\0"+
    "\16\101\42\0\173\101\205\0\35\101\3\0\61\101\57\0"+
    "\40\101\15\0\24\101\1\0\10\101\6\0\46\101\12\0"+
    "\36\101\2\0\44\101\4\0\10\101\60\0\236\101\2\0"+
    "\12\102\6\0\44\101\4\0\44\101\4\0\50\101\10\0"+
    "\64\101\234\0\67\101\11\0\26\101\12\0\10\101\230\0"+
    "\6\101\2\0\1\101\1\0\54\101\1\0\2\101\3\0"+
    "\1\101\2\0\27\101\12\0\27\101\11\0\37\101\101\0"+
    "\23\101\1\0\2\101\12\0\26\101\12\0\32\101\106\0"+
    "\70\101\6\0\2\101\100\0\1\101\17\0\4\101\1\0"+
    "\3\101\1\0\35\101\52\0\35\101\3\0\35\101\43\0"+
    "\10\101\1\0\34\101\33\0\66\101\12\0\26\101\12\0"+
    "\23\101\15\0\22\101\156\0\111\101\67\0\63\101\15\0"+
    "\63\101\15\0\44\101\14\0\12\102\306\0\35\101\12\0"+
    "\1\101\10\0\26\101\232\0\27\101\14\0\65\101\56\0"+
    "\12\102\23\0\55\101\40\0\31\101\7\0\12\102\11\0"+
    "\44\101\17\0\12\102\4\0\1\101\13\0\43\101\3\0"+
    "\1\101\14\0\60\101\16\0\4\101\13\0\12\102\1\101"+
    "\1\0\1\101\43\0\22\101\1\0\31\101\124\0\7\101"+
    "\1\0\1\101\1\0\4\101\1\0\17\101\1\0\12\101"+
    "\7\0\57\101\21\0\12\102\13\0\10\101\2\0\2\101"+
    "\2\0\26\101\1\0\7\101\1\0\2\101\1\0\5\101"+
    "\3\0\1\101\22\0\1\101\14\0\5\101\236\0\65\101"+
    "\22\0\4\101\5\0\12\102\5\0\1\101\40\0\60\101"+
    "\24\0\2\101\1\0\1\101\10\0\12\102\246\0\57\101"+
    "\51\0\4\101\44\0\60\101\24\0\1\101\13\0\12\102"+
    "\46\0\53\101\15\0\1\101\7\0\12\102\66\0\33\101"+
    "\25\0\12\102\306\0\54\101\164\0\100\101\12\102\25\0"+
    "\1\101\240\0\10\101\2\0\47\101\20\0\1\101\1\0"+
    "\1\101\34\0\1\101\12\0\50\101\7\0\1\101\25\0"+
    "\1\101\13\0\56\101\23\0\1\101\42\0\71\101\7\0"+
    "\11\101\1\0\45\101\21\0\1\101\17\0\12\102\30\0"+
    "\36\101\160\0\7\101\1\0\2\101\1\0\46\101\25\0"+
    "\1\101\11\0\12\102\6\0\6\101\1\0\2\101\1\0"+
    "\40\101\16\0\1\101\7\0\12\102\u0136\0\23\101\15\0"+
    "\232\101\346\0\304\101\274\0\57\101\321\0\107\101\271\0"+
    "\71\101\7\0\37\101\1\0\12\102\146\0\36\101\22\0"+
    "\60\101\20\0\4\101\14\0\12\102\11\0\25\101\5\0"+
    "\23\101\260\0\100\101\200\0\113\101\5\0\1\101\102\0"+
    "\15\101\100\0\2\101\1\0\1\101\34\0\370\101\10\0"+
    "\363\101\15\0\37\101\61\0\3\101\21\0\4\101\10\0"+
    "\u018c\101\4\0\153\101\5\0\15\101\3\0\11\101\7\0"+
    "\12\101\146\0\125\101\1\0\107\101\1\0\2\101\2\0"+
    "\1\101\2\0\2\101\2\0\4\101\1\0\14\101\1\0"+
    "\1\101\1\0\7\101\1\0\101\101\1\0\4\101\2\0"+
    "\10\101\1\0\7\101\1\0\34\101\1\0\4\101\1\0"+
    "\5\101\1\0\1\101\3\0\7\101\1\0\u0154\101\2\0"+
    "\31\101\1\0\31\101\1\0\37\101\1\0\31\101\1\0"+
    "\37\101\1\0\31\101\1\0\37\101\1\0\31\101\1\0"+
    "\37\101\1\0\31\101\1\0\10\101\2\0\62\102\55\101"+
    "\12\0\7\101\2\0\12\102\4\0\1\101\u0171\0\54\101"+
    "\4\0\12\102\6\0\305\101\73\0\104\101\7\0\1\101"+
    "\4\0\12\102\246\0\4\101\1\0\33\101\1\0\2\101"+
    "\1\0\1\101\2\0\1\101\1\0\12\101\1\0\4\101"+
    "\1\0\1\101\1\0\1\101\6\0\1\101\4\0\1\101"+
    "\1\0\1\101\1\0\1\101\1\0\3\101\1\0\2\101"+
    "\1\0\1\101\2\0\1\101\1\0\1\101\1\0\1\101"+
    "\1\0\1\101\1\0\1\101\1\0\2\101\1\0\1\101"+
    "\2\0\4\101\1\0\7\101\1\0\4\101\1\0\4\101"+
    "\1\0\1\101\1\0\12\101\1\0\21\101\5\0\3\101"+
    "\1\0\5\101\1\0\21\101\104\0\327\101\51\0\65\101"+
    "\13\0\336\101\2\0\u0182\101\16\0\u0131\101\37\0\36\101"+
    "\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27648];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\11\0\1\1\15\0\1\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\2\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\0\1\32\2\33\1\34"+
    "\1\35\1\36\1\34\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\26\1\45\1\46\2\47\1\50\2\47\1\26"+
    "\2\47\1\26\1\51\1\52\1\16\2\40\2\26\1\16"+
    "\1\53\1\54\1\55\1\2\1\56\1\57\1\16\1\60"+
    "\1\61\1\24\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\75\1\76\1\77"+
    "\1\16\1\100\1\101\1\102\1\103\1\104\1\105\1\74"+
    "\1\75\2\16\1\106\1\107\1\110\3\0\1\111\1\112"+
    "\1\113\1\114\1\115\1\116\1\117\1\120\1\121\1\0"+
    "\1\122\2\26\1\123\2\51\1\124\1\125\1\0\1\16"+
    "\1\126\1\127\2\26\1\65\1\71\1\72\1\73\1\16"+
    "\1\75\1\76\1\77\1\100\1\101\1\102\1\103\1\70"+
    "\1\105\1\75\1\16\1\106\1\107\1\130\1\131\1\132"+
    "\1\133\1\134\1\0\1\135\1\136\1\137\2\0\1\140"+
    "\1\141\1\142\1\143\1\0\1\144\2\145\1\73\1\0"+
    "\1\146\1\147\1\150\1\151\1\0\1\152\1\153\1\154"+
    "\1\155\1\156\1\157\4\0\1\160\2\0\1\161\1\162"+
    "\1\163\1\164\1\165\1\0\1\166\2\26\2\145\1\73"+
    "\1\146\1\150\1\154\1\156\1\0\1\167\1\0\1\170"+
    "\1\171\1\172\1\173\2\145\1\73\1\0\1\150\2\0"+
    "\1\154\1\174\1\0\1\175\1\0\1\176\1\0\1\177"+
    "\1\200\1\201\1\202\1\203\2\26\2\145\1\73\1\150"+
    "\1\154\1\174\1\204\1\0\1\205\1\150\1\0\1\154"+
    "\1\206\1\207\2\26\1\205\1\150\1\154\1\0\1\210"+
    "\1\211\1\26\1\210\1\26\1\212\1\0\3\212";

  private static int [] zzUnpackAction() {
    int [] result = new int[278];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605"+
    "\0\u0605\0\u0605\0\u0605\0\u0605\0\u0648\0\u0605\0\u0605\0\u0605"+
    "\0\u0605\0\u0605\0\u068b\0\u06ce\0\u0605\0\u0605\0\u0711\0\u0605"+
    "\0\u0605\0\u0754\0\u0605\0\u0605\0\u0797\0\u0605\0\u0605\0\u07da"+
    "\0\u081d\0\u0605\0\u0605\0\u0754\0\u0605\0\u0605\0\u0860\0\u08a3"+
    "\0\u0605\0\u0605\0\u0605\0\u08e6\0\u0605\0\u0929\0\u096c\0\u0605"+
    "\0\u0605\0\u0605\0\u09af\0\u0605\0\u09f2\0\u0a35\0\u0a78\0\u0abb"+
    "\0\u0afe\0\u0b41\0\u0b84\0\u0bc7\0\u0c0a\0\u0c4d\0\u0c90\0\u0cd3"+
    "\0\u0d16\0\u0d59\0\u0605\0\u0605\0\u0605\0\u0d9c\0\u0605\0\u0ddf"+
    "\0\u0e22\0\u0605\0\u0605\0\u0c0a\0\u0605\0\u0e65\0\u0605\0\u0605"+
    "\0\u0605\0\u0605\0\u0605\0\u0605\0\u0ea8\0\u0eeb\0\u0605\0\u0605"+
    "\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605"+
    "\0\u0605\0\u0f2e\0\u0f71\0\u0fb4\0\u0ff7\0\u103a\0\u107d\0\u10c0"+
    "\0\u1103\0\u1146\0\u1189\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605"+
    "\0\u0605\0\u0605\0\u0605\0\u0605\0\u11cc\0\u0605\0\u120f\0\u0605"+
    "\0\u0605\0\u1252\0\u0605\0\u0605\0\u0605\0\u1295\0\u12d8\0\u0605"+
    "\0\u0605\0\u131b\0\u135e\0\u096c\0\u096c\0\u13a1\0\u13e4\0\u096c"+
    "\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c"+
    "\0\u096c\0\u1427\0\u146a\0\u14ad\0\u14f0\0\u0605\0\u0605\0\u0605"+
    "\0\u0605\0\u0605\0\u1533\0\u0605\0\u0605\0\u0605\0\u1576\0\u15b9"+
    "\0\u0605\0\u15fc\0\u0605\0\u0605\0\u163f\0\u0605\0\u1682\0\u16c5"+
    "\0\u1708\0\u174b\0\u0605\0\u0605\0\u178e\0\u0605\0\u17d1\0\u0605"+
    "\0\u0605\0\u1814\0\u0605\0\u1857\0\u0605\0\u189a\0\u18dd\0\u1920"+
    "\0\u1963\0\u0605\0\u19a6\0\u19e9\0\u0605\0\u0605\0\u0605\0\u0605"+
    "\0\u0605\0\u1a2c\0\u0605\0\u1a6f\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b"+
    "\0\u096c\0\u1bbe\0\u1c01\0\u1c44\0\u1c87\0\u0605\0\u1cca\0\u0605"+
    "\0\u0605\0\u0605\0\u0605\0\u1d0d\0\u0605\0\u0605\0\u1d50\0\u1d93"+
    "\0\u1dd6\0\u1e19\0\u1e5c\0\u0605\0\u1e9f\0\u0605\0\u1ee2\0\u0605"+
    "\0\u1f25\0\u0605\0\u0605\0\u0605\0\u0605\0\u0605\0\u1f68\0\u1fab"+
    "\0\u1fee\0\u096c\0\u096c\0\u2031\0\u2074\0\u096c\0\u0605\0\u20b7"+
    "\0\u0605\0\u0605\0\u20fa\0\u213d\0\u0605\0\u0605\0\u2180\0\u21c3"+
    "\0\u096c\0\u096c\0\u2206\0\u2249\0\u0605\0\u096c\0\u228c\0\u096c"+
    "\0\u22cf\0\u2312\0\u2355\0\u2398\0\u23db\0\u0605";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[278];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\30\2\31\1\32\1\30\1\33\1\34\2\30\1\35"+
    "\1\36\1\37\1\40\2\30\1\41\10\30\1\42\25\30"+
    "\1\43\1\44\1\45\1\46\14\30\1\47\1\50\1\51"+
    "\61\30\1\52\23\30\26\53\1\54\2\53\25\55\3\53"+
    "\1\46\1\53\13\55\2\53\1\56\1\55\16\53\1\57"+
    "\2\53\4\60\54\53\1\56\1\53\1\60\15\0\1\30"+
    "\2\0\4\30\33\0\1\61\22\0\1\30\61\0\1\62"+
    "\21\0\57\63\1\64\23\63\1\65\3\66\52\65\1\67"+
    "\1\70\1\71\22\65\12\72\1\73\3\72\1\74\5\72"+
    "\1\75\4\72\25\76\5\72\13\76\3\72\1\76\1\72"+
    "\2\12\1\0\100\12\6\72\1\77\20\72\1\100\1\72"+
    "\25\77\1\72\1\77\2\72\14\77\3\72\1\77\7\72"+
    "\1\77\1\72\1\101\20\72\25\77\1\72\1\77\2\72"+
    "\14\77\3\72\1\77\7\72\1\77\3\72\1\73\16\72"+
    "\25\77\1\72\1\77\2\72\14\77\3\72\1\77\21\72"+
    "\4\60\56\72\1\60\24\102\1\103\1\104\1\102\1\104"+
    "\1\102\25\55\3\102\1\46\1\102\13\55\3\102\1\55"+
    "\1\102\17\105\1\106\11\105\25\107\5\105\13\107\3\105"+
    "\1\107\1\105\26\110\1\111\2\110\25\112\5\110\13\112"+
    "\3\110\1\112\1\110\76\0\1\113\4\0\1\30\2\31"+
    "\1\32\1\30\1\33\3\30\1\114\45\30\1\115\1\30"+
    "\1\46\21\30\6\72\1\77\1\72\1\116\1\72\1\73"+
    "\5\72\4\60\3\72\1\117\1\72\2\77\1\120\17\77"+
    "\1\121\2\77\1\72\1\122\2\72\14\77\3\72\1\77"+
    "\1\60\1\30\2\123\1\124\1\30\1\125\1\30\1\126"+
    "\6\30\1\127\37\30\1\130\1\131\1\132\22\30\32\53"+
    "\1\133\7\53\3\133\1\53\1\133\2\53\1\133\3\53"+
    "\1\133\1\53\1\134\16\53\1\135\63\53\1\134\16\53"+
    "\1\135\4\53\133\0\1\136\133\0\1\137\21\0\1\140"+
    "\3\141\1\140\1\142\1\143\2\140\4\143\1\140\1\144"+
    "\1\143\1\145\3\146\4\140\1\143\1\147\1\150\1\151"+
    "\1\152\1\153\1\147\1\154\1\150\1\153\1\152\1\153"+
    "\1\155\1\153\1\156\1\157\2\151\1\152\2\151\1\147"+
    "\2\143\1\160\1\143\1\140\1\161\1\162\1\163\1\151"+
    "\1\164\1\150\1\165\1\161\1\156\1\166\1\167\1\170"+
    "\1\143\1\160\2\140\15\0\1\171\2\0\4\172\33\0"+
    "\1\173\22\0\1\172\34\0\1\174\51\0\1\55\5\0"+
    "\2\55\3\0\1\55\1\0\4\55\5\0\25\55\4\0"+
    "\14\55\3\0\2\55\20\0\4\60\56\0\1\60\100\0"+
    "\1\175\21\0\1\176\4\0\1\177\1\0\1\176\32\0"+
    "\1\200\70\0\1\201\10\0\1\202\1\203\52\0\25\74"+
    "\5\0\13\74\3\0\1\74\32\0\25\76\5\0\13\76"+
    "\3\0\1\76\4\0\1\77\2\0\1\77\7\0\1\77"+
    "\1\0\4\77\5\0\25\77\1\0\1\77\2\0\14\77"+
    "\3\0\2\77\60\0\1\204\41\0\1\205\102\0\1\205"+
    "\40\0\1\206\40\0\1\207\1\205\4\210\5\0\25\207"+
    "\5\0\13\207\3\0\1\207\1\210\26\0\1\205\102\0"+
    "\1\205\31\0\1\211\25\0\1\55\5\0\2\55\3\0"+
    "\1\55\1\0\4\55\2\0\1\205\2\0\25\55\4\0"+
    "\14\55\3\0\2\55\20\0\4\212\5\0\5\212\25\0"+
    "\4\212\11\0\1\213\12\0\1\214\14\0\1\215\2\0"+
    "\1\216\52\0\5\140\1\142\10\140\1\144\1\140\1\145"+
    "\3\146\5\140\1\153\1\150\1\151\1\152\2\153\1\154"+
    "\1\150\1\153\1\152\1\153\1\155\1\153\1\156\1\157"+
    "\1\153\1\151\1\152\2\151\1\153\2\143\3\140\1\161"+
    "\1\153\1\163\1\151\1\217\1\150\1\153\1\161\1\156"+
    "\1\166\1\167\5\140\12\0\1\220\102\0\1\221\73\0"+
    "\1\77\2\0\1\77\7\0\1\77\1\0\4\77\5\0"+
    "\3\77\1\222\21\77\1\0\1\77\2\0\14\77\3\0"+
    "\2\77\3\0\1\77\2\0\1\77\7\0\1\77\1\0"+
    "\4\77\5\0\3\77\1\223\21\77\1\0\1\77\2\0"+
    "\14\77\3\0\2\77\3\140\1\224\1\140\1\142\1\224"+
    "\7\140\1\225\1\140\1\226\3\227\5\140\1\230\1\231"+
    "\1\232\1\233\2\230\1\234\1\231\1\230\1\233\1\230"+
    "\1\235\1\230\1\236\1\237\1\230\1\232\1\233\2\232"+
    "\1\230\1\143\1\240\2\140\1\224\1\241\1\230\1\242"+
    "\1\232\1\243\1\231\1\230\1\241\1\236\1\244\1\245"+
    "\3\140\2\224\7\0\1\246\112\0\1\247\4\0\1\247"+
    "\1\0\1\247\32\0\1\250\21\0\1\140\3\251\1\140"+
    "\1\142\10\140\1\144\1\140\1\145\3\146\5\140\1\153"+
    "\1\150\1\151\1\152\2\153\1\154\1\150\1\153\1\152"+
    "\1\153\1\155\1\153\1\156\1\157\1\153\1\151\1\152"+
    "\2\151\1\153\3\143\2\140\2\161\1\163\1\151\1\217"+
    "\1\150\1\153\1\161\1\156\1\166\1\167\5\140\4\0"+
    "\1\252\1\253\1\0\1\254\1\255\1\256\2\0\1\257"+
    "\1\0\1\257\2\0\3\260\1\261\1\262\1\263\1\264"+
    "\16\0\1\265\30\0\1\266\23\0\2\267\1\270\100\0"+
    "\4\271\155\0\1\272\4\0\103\273\10\0\1\274\10\0"+
    "\3\275\1\0\1\276\50\0\1\277\14\0\1\300\14\0"+
    "\1\301\75\0\4\302\5\0\5\302\25\0\4\302\7\0"+
    "\1\303\24\0\4\304\5\0\5\304\25\0\4\304\7\0"+
    "\1\305\21\0\1\306\2\0\4\307\56\0\1\307\20\0"+
    "\4\310\33\0\1\311\20\0\1\312\1\0\1\310\15\0"+
    "\1\313\2\0\4\172\33\0\1\314\20\0\1\315\1\0"+
    "\1\172\100\0\1\316\62\0\1\317\40\0\1\207\1\0"+
    "\4\210\5\0\25\207\5\0\13\207\3\0\1\207\1\210"+
    "\20\0\4\212\5\0\5\212\25\0\4\212\11\0\1\320"+
    "\6\0\1\321\20\0\1\322\1\323\75\0\3\275\52\0"+
    "\1\277\7\0\1\77\2\0\1\77\7\0\1\77\1\0"+
    "\4\77\5\0\4\77\1\324\20\77\1\0\1\77\2\0"+
    "\14\77\3\0\2\77\3\0\1\77\2\0\1\77\7\0"+
    "\1\77\1\0\4\77\5\0\17\77\1\325\5\77\1\0"+
    "\1\77\2\0\14\77\3\0\2\77\3\0\1\77\2\0"+
    "\1\77\7\0\1\77\1\0\2\326\1\327\1\77\5\0"+
    "\25\77\1\0\1\77\2\0\14\77\3\0\2\77\3\0"+
    "\1\77\2\0\1\77\7\0\1\77\1\0\4\330\5\0"+
    "\25\77\1\0\1\77\2\0\14\77\3\0\2\77\3\273"+
    "\1\331\2\273\1\331\7\273\1\331\1\273\4\331\5\273"+
    "\25\331\1\273\1\331\2\273\14\331\3\273\2\331\3\0"+
    "\1\77\2\0\1\77\7\0\1\77\1\0\1\77\3\332"+
    "\5\0\25\77\1\0\1\77\2\0\14\77\1\277\2\0"+
    "\2\77\3\0\1\77\2\0\1\77\7\0\1\77\1\0"+
    "\4\333\5\0\5\333\20\77\1\0\1\77\2\0\1\77"+
    "\4\333\7\77\1\303\2\0\2\77\3\0\1\77\2\0"+
    "\1\77\7\0\1\77\1\0\4\334\5\0\5\334\20\77"+
    "\1\0\1\77\2\0\1\77\4\334\7\77\1\305\2\0"+
    "\2\77\12\335\1\0\70\335\21\0\3\260\71\0\1\336"+
    "\5\0\4\337\63\0\1\340\21\0\1\341\101\0\1\342"+
    "\1\343\1\254\73\0\3\344\100\0\3\345\100\0\4\346"+
    "\146\0\1\347\33\0\4\350\75\0\1\351\2\0\3\352"+
    "\77\0\4\353\5\0\5\353\25\0\4\353\34\0\4\354"+
    "\5\0\5\354\25\0\4\354\34\0\4\355\54\0\1\356"+
    "\1\0\1\355\15\0\1\357\2\0\4\307\54\0\1\360"+
    "\1\0\1\307\20\0\4\310\33\0\1\361\20\0\1\362"+
    "\1\0\1\310\100\0\1\363\22\0\4\313\33\0\1\314"+
    "\20\0\1\315\1\0\1\313\100\0\1\364\6\0\1\365"+
    "\21\0\1\366\57\0\1\77\2\0\1\77\7\0\1\77"+
    "\1\0\4\77\5\0\7\77\1\367\15\77\1\0\1\77"+
    "\2\0\14\77\3\0\2\77\3\0\1\77\2\0\1\77"+
    "\7\0\1\77\1\0\4\77\5\0\20\77\1\370\4\77"+
    "\1\0\1\77\2\0\14\77\3\0\2\77\3\0\1\77"+
    "\2\0\1\77\7\0\1\77\1\0\3\371\1\77\5\0"+
    "\25\77\1\0\1\77\2\0\14\77\3\0\2\77\3\0"+
    "\1\77\2\0\1\77\7\0\1\77\1\0\3\372\1\77"+
    "\5\0\25\77\1\0\1\77\2\0\14\77\3\0\2\77"+
    "\3\0\1\77\2\0\1\77\7\0\1\77\1\0\4\373"+
    "\5\0\25\77\1\0\1\77\2\0\14\77\3\0\2\77"+
    "\3\0\1\77\2\0\1\77\7\0\1\77\1\0\4\374"+
    "\5\0\25\77\1\0\1\77\2\0\14\77\3\0\2\77"+
    "\3\0\1\77\2\0\1\77\7\0\1\77\1\0\4\375"+
    "\5\0\5\375\20\77\1\0\1\77\2\0\1\77\4\375"+
    "\7\77\3\0\2\77\3\0\1\77\2\0\1\77\7\0"+
    "\1\77\1\0\4\376\5\0\5\376\20\77\1\0\1\77"+
    "\2\0\1\77\4\376\7\77\3\0\2\77\12\335\1\377"+
    "\70\335\12\0\1\336\5\0\4\u0100\77\0\3\u0101\160\0"+
    "\1\147\22\0\4\u0102\100\0\3\352\77\0\4\u0103\54\0"+
    "\1\u0102\22\0\4\u0104\5\0\5\u0104\25\0\4\u0104\34\0"+
    "\4\355\54\0\1\u0105\1\0\1\355\20\0\4\357\54\0"+
    "\1\360\1\0\1\357\100\0\1\u0106\5\0\1\77\2\0"+
    "\1\77\7\0\1\77\1\0\4\77\5\0\13\77\1\u0107"+
    "\11\77\1\0\1\77\2\0\14\77\3\0\2\77\3\0"+
    "\1\77\2\0\1\77\7\0\1\77\1\0\4\77\5\0"+
    "\7\77\1\u0108\15\77\1\0\1\77\2\0\14\77\3\0"+
    "\2\77\3\0\1\77\2\0\1\77\7\0\1\77\1\0"+
    "\3\u0109\1\77\5\0\25\77\1\0\1\77\2\0\14\77"+
    "\3\0\2\77\3\0\1\77\2\0\1\77\7\0\1\77"+
    "\1\0\4\u010a\5\0\25\77\1\0\1\77\2\0\14\77"+
    "\3\0\2\77\3\0\1\77\2\0\1\77\7\0\1\77"+
    "\1\0\4\u010b\5\0\5\u010b\20\77\1\0\1\77\2\0"+
    "\1\77\4\u010b\7\77\3\0\2\77\12\0\1\336\110\0"+
    "\4\u010c\54\0\1\u0102\22\0\4\u010d\5\0\5\u010d\25\0"+
    "\4\u010d\17\0\1\77\2\0\1\77\7\0\1\77\1\0"+
    "\4\77\5\0\3\77\1\u010e\21\77\1\0\1\77\2\0"+
    "\14\77\3\0\2\77\3\0\1\77\2\0\1\77\7\0"+
    "\1\77\1\0\4\77\5\0\14\77\1\u010f\10\77\1\0"+
    "\1\77\2\0\14\77\3\0\2\77\3\0\1\77\2\0"+
    "\1\77\7\0\1\77\1\0\4\u0110\5\0\5\u0110\20\77"+
    "\1\0\1\77\2\0\1\77\4\u0110\7\77\3\0\2\77"+
    "\100\0\1\u0102\5\0\1\77\2\0\1\77\7\0\1\77"+
    "\1\0\4\77\5\0\13\77\1\u0111\11\77\1\0\1\77"+
    "\2\0\14\77\3\0\2\77\3\0\1\77\2\0\1\77"+
    "\7\0\1\77\1\0\4\77\2\0\1\u0112\1\u0113\1\0"+
    "\25\77\1\0\1\77\2\0\14\77\3\0\2\77\17\0"+
    "\1\u0114\4\u0112\56\0\1\u0112\26\0\1\u0112\74\0\4\u0115"+
    "\56\0\1\u0115\20\0\4\u0116\56\0\1\u0116";

  private static int [] zzUnpacktrans() {
    int [] result = new int[9246];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\11\0\1\1\15\0\5\11\1\1\5\11\2\1\2\11"+
    "\1\1\2\11\1\1\2\11\1\1\2\11\1\1\1\0"+
    "\2\11\1\1\2\11\2\1\3\11\1\1\1\11\2\1"+
    "\3\11\1\1\1\11\16\1\3\11\1\1\1\11\2\1"+
    "\2\11\1\1\1\11\1\1\6\11\2\1\13\11\7\1"+
    "\3\0\11\11\1\0\1\11\1\1\2\11\1\1\3\11"+
    "\1\0\1\1\2\11\24\1\5\11\1\0\3\11\2\0"+
    "\1\11\1\1\2\11\1\0\1\11\3\1\1\0\2\11"+
    "\1\1\1\11\1\0\2\11\1\1\1\11\1\1\1\11"+
    "\4\0\1\11\2\0\5\11\1\0\1\11\11\1\1\0"+
    "\1\11\1\0\4\11\1\1\2\11\1\0\1\1\2\0"+
    "\1\1\1\11\1\0\1\11\1\0\1\11\1\0\5\11"+
    "\10\1\1\11\1\0\2\11\1\0\1\1\2\11\5\1"+
    "\1\0\1\11\5\1\1\0\2\1\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[278];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
    // This adds support for nested states. I'm no JFlex pro, so maybe this is overkill, but it works quite well.
    final IntArrayList states = new IntArrayList();

    // This was an idea to use the regex implementation for XML schema regexes (which use a slightly different syntax)
    // as well, but is currently unfinished as it requires to tweak more places than just the lexer.
    private boolean xmlSchemaMode;

    int capturingGroupCount = 0;

    private Boolean allowDanglingMetacharacters;
    private boolean allowOmitNumbersInQuantifiers;
    private boolean allowOmitBothNumbersInQuantifiers;
    private boolean allowNestedCharacterClasses;
    private boolean allowOctalNoLeadingZero;
    private boolean allowHexDigitClass;
    private boolean allowEmptyCharacterClass;
    private boolean allowHorizontalWhitespaceClass;
    private boolean allowPosixBracketExpressions;
    private boolean allowTransformationEscapes;
    private boolean allowExtendedUnicodeCharacter;
    private boolean allowOneHexCharEscape;
    private boolean allowMysqlBracketExpressions;
    private boolean allowPcreBackReferences;
    private boolean allowPcreConditions;
    private boolean allowPcreNumberedGroupRef;
    private int maxOctal = 0777;
    private int minOctalDigits = 1;
    private boolean whitespaceInClass;

    _RegExLexer(EnumSet<RegExpCapability> capabilities) {
      this((java.io.Reader)null);
      this.xmlSchemaMode = capabilities.contains(XML_SCHEMA_MODE);
      if (capabilities.contains(DANGLING_METACHARACTERS)) this.allowDanglingMetacharacters = TRUE;
      if (capabilities.contains(NO_DANGLING_METACHARACTERS)) this.allowDanglingMetacharacters = FALSE;
      this.allowOmitNumbersInQuantifiers = capabilities.contains(OMIT_NUMBERS_IN_QUANTIFIERS);
      this.allowOmitBothNumbersInQuantifiers = capabilities.contains(OMIT_BOTH_NUMBERS_IN_QUANTIFIERS);
      this.allowNestedCharacterClasses = capabilities.contains(NESTED_CHARACTER_CLASSES);
      this.allowOctalNoLeadingZero = capabilities.contains(OCTAL_NO_LEADING_ZERO);
      this.commentMode = capabilities.contains(COMMENT_MODE);
      this.allowHexDigitClass = capabilities.contains(ALLOW_HEX_DIGIT_CLASS);
      this.allowHorizontalWhitespaceClass = capabilities.contains(ALLOW_HORIZONTAL_WHITESPACE_CLASS);
      this.allowEmptyCharacterClass = capabilities.contains(ALLOW_EMPTY_CHARACTER_CLASS);
      this.allowPosixBracketExpressions = capabilities.contains(POSIX_BRACKET_EXPRESSIONS);
      this.allowTransformationEscapes = capabilities.contains(TRANSFORMATION_ESCAPES);
      this.allowMysqlBracketExpressions = capabilities.contains(MYSQL_BRACKET_EXPRESSIONS);
      this.allowPcreBackReferences = capabilities.contains(PCRE_BACK_REFERENCES);
      this.allowPcreNumberedGroupRef = capabilities.contains(PCRE_NUMBERED_GROUP_REF);
      this.allowPcreConditions = capabilities.contains(PCRE_CONDITIONS);
      if (capabilities.contains(MAX_OCTAL_177)) {
        maxOctal = 0177;
      }
      else if (capabilities.contains(MAX_OCTAL_377)) {
        maxOctal = 0377;
      }
      if (capabilities.contains(MIN_OCTAL_2_DIGITS)) {
        minOctalDigits = 2;
      }
      else if (capabilities.contains(MIN_OCTAL_3_DIGITS)) {
        minOctalDigits = 3;
      }
      this.allowExtendedUnicodeCharacter = capabilities.contains(EXTENDED_UNICODE_CHARACTER);
      this.allowOneHexCharEscape = capabilities.contains(ONE_HEX_CHAR_ESCAPE);
      this.whitespaceInClass = capabilities.contains(WHITESPACE_IN_CLASS);
    }

    private void yypushstate(int state) {
        states.add(yystate());
        yybegin(state);
    }

    private void yypopstate() {
        final int state = states.remove(states.size() - 1);
        yybegin(state);
    }

    private void handleOptions() {
      final String o = yytext().toString();
      if (o.contains("x")) {
        commentMode = !o.startsWith("-");
      }
    }

    // tracks whether the lexer is in comment mode, i.e. whether whitespace is not significant and whether to ignore
    // text after '#' till EOL
    boolean commentMode = false;


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _RegExLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { yypopstate(); return RegExpTT.COMMENT;
            }
          // fall through
          case 139: break;
          case 2:
            { return RegExpTT.CHARACTER;
            }
          // fall through
          case 140: break;
          case 3:
            { return commentMode ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CTRL_CHARACTER;
            }
          // fall through
          case 141: break;
          case 4:
            { return commentMode ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CHARACTER;
            }
          // fall through
          case 142: break;
          case 5:
            { if (commentMode) { yypushstate(COMMENT); } else return RegExpTT.CHARACTER;
            }
          // fall through
          case 143: break;
          case 6:
            { return RegExpTT.DOLLAR;
            }
          // fall through
          case 144: break;
          case 7:
            { capturingGroupCount++; return RegExpTT.GROUP_BEGIN;
            }
          // fall through
          case 145: break;
          case 8:
            { return RegExpTT.GROUP_END;
            }
          // fall through
          case 146: break;
          case 9:
            { return RegExpTT.STAR;
            }
          // fall through
          case 147: break;
          case 10:
            { return RegExpTT.PLUS;
            }
          // fall through
          case 148: break;
          case 11:
            { return RegExpTT.DOT;
            }
          // fall through
          case 149: break;
          case 12:
            { return RegExpTT.QUEST;
            }
          // fall through
          case 150: break;
          case 13:
            { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN;
            }
          // fall through
          case 151: break;
          case 14:
            { return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          // fall through
          case 152: break;
          case 15:
            { return allowDanglingMetacharacters == FALSE ? RegExpTT.CLASS_END : RegExpTT.CHARACTER;
            }
          // fall through
          case 153: break;
          case 16:
            { return RegExpTT.CARET;
            }
          // fall through
          case 154: break;
          case 17:
            { if (allowDanglingMetacharacters != TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } return RegExpTT.CHARACTER;
            }
          // fall through
          case 155: break;
          case 18:
            { return RegExpTT.UNION;
            }
          // fall through
          case 156: break;
          case 19:
            { return (allowDanglingMetacharacters != FALSE) ? RegExpTT.CHARACTER : RegExpTT.RBRACE;
            }
          // fall through
          case 157: break;
          case 20:
            { yypopstate(); yypushback(1);
            }
          // fall through
          case 158: break;
          case 21:
            { return RegExpTT.EQ;
            }
          // fall through
          case 159: break;
          case 22:
            { return RegExpTT.NAME;
            }
          // fall through
          case 160: break;
          case 23:
            { yypopstate(); return RegExpTT.RBRACE;
            }
          // fall through
          case 161: break;
          case 24:
            { return RegExpTT.COMMA;
            }
          // fall through
          case 162: break;
          case 25:
            { return RegExpTT.NUMBER;
            }
          // fall through
          case 163: break;
          case 26:
            { yybegin(CLASS1); return RegExpTT.CARET;
            }
          // fall through
          case 164: break;
          case 27:
            { states.set(states.size() - 1, CLASS2); return RegExpTT.CHARACTER;
            }
          // fall through
          case 165: break;
          case 28:
            { yypushback(1); yybegin(CLASS2);
            }
          // fall through
          case 166: break;
          case 29:
            { if (commentMode && whitespaceInClass) return com.intellij.psi.TokenType.WHITE_SPACE; yypushback(1); yybegin(CLASS2);
            }
          // fall through
          case 167: break;
          case 30:
            { yybegin(CLASS2); if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          // fall through
          case 168: break;
          case 31:
            { if (allowEmptyCharacterClass) { yypopstate(); return RegExpTT.CLASS_END; } yybegin(CLASS2); return RegExpTT.CHARACTER;
            }
          // fall through
          case 169: break;
          case 32:
            { yybegin(YYINITIAL); yypushback(1);
            }
          // fall through
          case 170: break;
          case 33:
            { yybegin(YYINITIAL); return RegExpTT.GROUP_END;
            }
          // fall through
          case 171: break;
          case 34:
            { handleOptions(); return RegExpTT.OPTIONS_OFF;
            }
          // fall through
          case 172: break;
          case 35:
            { yybegin(YYINITIAL); return RegExpTT.COLON;
            }
          // fall through
          case 173: break;
          case 36:
            { handleOptions(); return RegExpTT.OPTIONS_ON;
            }
          // fall through
          case 174: break;
          case 37:
            { yybegin(YYINITIAL); return RegExpTT.GT;
            }
          // fall through
          case 175: break;
          case 38:
            { yybegin(YYINITIAL); return RegExpTT.QUOTE;
            }
          // fall through
          case 176: break;
          case 39:
            { return RegExpTT.BAD_CHARACTER;
            }
          // fall through
          case 177: break;
          case 40:
            { return allowMysqlBracketExpressions ? RegExpTT.NAME : RegExpTT.BAD_CHARACTER;
            }
          // fall through
          case 178: break;
          case 41:
            { yypopstate(); return (yycharat(-1) == 'u') ? StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN : RegExpTT.BAD_HEX_VALUE;
            }
          // fall through
          case 179: break;
          case 42:
            { yybegin(CONDITIONAL2); return RegExpTT.GROUP_BEGIN;
            }
          // fall through
          case 180: break;
          case 43:
            { return (commentMode && whitespaceInClass) ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CTRL_CHARACTER;
            }
          // fall through
          case 181: break;
          case 44:
            { return (commentMode && whitespaceInClass) ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CHARACTER;
            }
          // fall through
          case 182: break;
          case 45:
            { if (commentMode && whitespaceInClass) yypushstate(COMMENT); else return RegExpTT.CHARACTER;
            }
          // fall through
          case 183: break;
          case 46:
            { return RegExpTT.MINUS;
            }
          // fall through
          case 184: break;
          case 47:
            { if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          // fall through
          case 185: break;
          case 48:
            { yypopstate(); return RegExpTT.CLASS_END;
            }
          // fall through
          case 186: break;
          case 49:
            { yypopstate(); return RegExpTT.CATEGORY_SHORT_HAND;
            }
          // fall through
          case 187: break;
          case 50:
            { yypopstate(); yypushstate(EMBRACED); return RegExpTT.LBRACE;
            }
          // fall through
          case 188: break;
          case 51:
            { yybegin(OPTIONS); return RegExpTT.SET_OPTIONS;
            }
          // fall through
          case 189: break;
          case 52:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN;
            }
          // fall through
          case 190: break;
          case 53:
            { return RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 191: break;
          case 54:
            { return commentMode ? RegExpTT.ESC_CTRL_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 192: break;
          case 55:
            { return commentMode ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 193: break;
          case 56:
            { return RegExpTT.ESC_CHARACTER;
            }
          // fall through
          case 194: break;
          case 57:
            { return (yystate() == CLASS2) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 195: break;
          case 58:
            { return (allowOctalNoLeadingZero ? RegExpTT.OCT_CHAR : RegExpTT.BAD_OCT_VALUE);
            }
          // fall through
          case 196: break;
          case 59:
            { String text = yytext().toString().substring(1);
                                if (allowOctalNoLeadingZero) {
                                  if (Integer.parseInt(text) <= capturingGroupCount && yystate() != CLASS2) return RegExpTT.BACKREF;
                                  int i = 0;
                                  int value = 0;
                                  for (; i < text.length(); i++) {
                                    char c = text.charAt(i);
                                    if (c > '7') break;
                                    value = value * 8 + (c - '0');
                                  }
                                  if (i > 0) {
                                    yypushback(text.length() - i);
                                    if (value > maxOctal) {
                                      yypushback(1);
                                      return RegExpTT.BAD_OCT_VALUE;
                                    }
                                    if (minOctalDigits > i && yystate() != CLASS2) {
                                      return RegExpTT.BAD_OCT_VALUE;
                                    }
                                    return RegExpTT.OCT_CHAR;
                                  }
                                  return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                                }
                                else {
                                  if (yystate() == CLASS2) {
                                    yypushback(yylength() - 2);
                                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                                  }
                                  /* java.util.regex.Pattern says about backrefs:
                                      "In this class, \1 through \9 are always interpreted as back references,
                                      and a larger number is accepted as a back reference if at least that many
                                      subexpressions exist at that point in the regular expression, otherwise the
                                      parser will drop digits until the number is smaller or equal to the existing
                                      number of groups or it is one digit."
                                  */
                                  while (yylength() > 2 && Integer.parseInt(yytext().toString().substring(1)) > capturingGroupCount) {
                                    yypushback(1);
                                  }
                                  return RegExpTT.BACKREF;
                                }
            }
          // fall through
          case 197: break;
          case 60:
            { return RegExpTT.BOUNDARY;
            }
          // fall through
          case 198: break;
          case 61:
            { if (xmlSchemaMode) return RegExpTT.CHAR_CLASS; else return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          // fall through
          case 199: break;
          case 62:
            { return RegExpTT.CHAR_CLASS;
            }
          // fall through
          case 200: break;
          case 63:
            { return allowTransformationEscapes ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          // fall through
          case 201: break;
          case 64:
            { return (allowHexDigitClass || allowHorizontalWhitespaceClass ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN);
            }
          // fall through
          case 202: break;
          case 65:
            { yypushstate(NAMED); return RegExpTT.NAMED_CHARACTER;
            }
          // fall through
          case 203: break;
          case 66:
            { yypushstate(PROP); return RegExpTT.PROPERTY;
            }
          // fall through
          case 204: break;
          case 67:
            { yypushstate(QUOTED); return RegExpTT.QUOTE_BEGIN;
            }
          // fall through
          case 205: break;
          case 68:
            { return (allowDanglingMetacharacters == FALSE) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 206: break;
          case 69:
            { return RegExpTT.ESC_CTRL_CHARACTER;
            }
          // fall through
          case 207: break;
          case 70:
            { return allowTransformationEscapes ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          // fall through
          case 208: break;
          case 71:
            { return RegExpTT.BAD_HEX_VALUE;
            }
          // fall through
          case 209: break;
          case 72:
            { return (allowDanglingMetacharacters != TRUE) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 210: break;
          case 73:
            { yypopstate(); return RegExpTT.QUOTE_END;
            }
          // fall through
          case 211: break;
          case 74:
            { yypopstate(); return RegExpTT.ESC_CHARACTER;
            }
          // fall through
          case 212: break;
          case 75:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { yybegin(CLASS2); if (allowMysqlBracketExpressions) { yypushback(1); } else if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } else { return RegExpTT.CHARACTER; }
            }
          // fall through
          case 213: break;
          case 76:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { yybegin(CLASS2); if (allowPosixBracketExpressions) { yypushback(1); } else if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } else { return RegExpTT.CHARACTER; }
            }
          // fall through
          case 214: break;
          case 77:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { yybegin(CLASS2); if (allowNestedCharacterClasses) { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          // fall through
          case 215: break;
          case 78:
            { yypushstate(QUOTED_CLASS); return RegExpTT.QUOTE_BEGIN;
            }
          // fall through
          case 216: break;
          case 79:
            { yybegin(CLASS2); return allowEmptyCharacterClass ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 217: break;
          case 80:
            { yybegin(CLASS2); return RegExpTT.ESC_CHARACTER;
            }
          // fall through
          case 218: break;
          case 81:
            { yybegin(CLASS2); return RegExpTT.BRACKET_EXPRESSION_END;
            }
          // fall through
          case 219: break;
          case 82:
            { yybegin(CLASS2); return RegExpTT.MYSQL_CHAR_END;
            }
          // fall through
          case 220: break;
          case 83:
            { yybegin(CLASS2); return RegExpTT.MYSQL_CHAR_EQ_END;
            }
          // fall through
          case 221: break;
          case 84:
            { yybegin(CONDITIONAL2); return RegExpTT.QUOTED_CONDITION_BEGIN;
            }
          // fall through
          case 222: break;
          case 85:
            { yybegin(CONDITIONAL2); return RegExpTT.ANGLE_BRACKET_CONDITION_BEGIN;
            }
          // fall through
          case 223: break;
          case 86:
            { yybegin(YYINITIAL); return RegExpTT.QUOTED_CONDITION_END;
            }
          // fall through
          case 224: break;
          case 87:
            { yybegin(YYINITIAL); return RegExpTT.ANGLE_BRACKET_CONDITION_END;
            }
          // fall through
          case 225: break;
          case 88:
            { if (allowNestedCharacterClasses) return RegExpTT.ANDAND; else yypushback(1); return RegExpTT.CHARACTER;
            }
          // fall through
          case 226: break;
          case 89:
            { char c = yycharat(1);
                          if (allowPosixBracketExpressions && c == ':') {
                            yybegin(BRACKET_EXPRESSION);
                            return RegExpTT.BRACKET_EXPRESSION_BEGIN;
                          } else if (allowMysqlBracketExpressions && c == '=') {
                            yybegin(MYSQL_CHAR_EQ_EXPRESSION);
                            return RegExpTT.MYSQL_CHAR_EQ_BEGIN;
                          } else if (allowMysqlBracketExpressions && c == '.') {
                            yybegin(MYSQL_CHAR_EXPRESSION);
                            return RegExpTT.MYSQL_CHAR_BEGIN;
                          } else {
                            yypushback(1);
                            if (allowNestedCharacterClasses) {
                              yypushstate(CLASS1);
                              return RegExpTT.CLASS_BEGIN;
                            } else {
                              return RegExpTT.CHARACTER;
                            }
                          }
            }
          // fall through
          case 227: break;
          case 90:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowNestedCharacterClasses) { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          // fall through
          case 228: break;
          case 91:
            { return (commentMode && whitespaceInClass) ? RegExpTT.ESC_CTRL_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 229: break;
          case 92:
            { return RegExpTT.NEG_LOOKAHEAD;
            }
          // fall through
          case 230: break;
          case 93:
            { yybegin(NAMED_GROUP); return RegExpTT.PCRE_RECURSIVE_NAMED_GROUP_REF;
            }
          // fall through
          case 231: break;
          case 94:
            { yybegin(QUOTED_NAMED_GROUP); capturingGroupCount++; return RegExpTT.RUBY_QUOTED_NAMED_GROUP;
            }
          // fall through
          case 232: break;
          case 95:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { yybegin(CONDITIONAL1); return RegExpTT.CONDITIONAL;
            }
          // fall through
          case 233: break;
          case 96:
            { return RegExpTT.NON_CAPT_GROUP;
            }
          // fall through
          case 234: break;
          case 97:
            { yybegin(NAMED_GROUP); capturingGroupCount++; return RegExpTT.RUBY_NAMED_GROUP;
            }
          // fall through
          case 235: break;
          case 98:
            { return RegExpTT.POS_LOOKAHEAD;
            }
          // fall through
          case 236: break;
          case 99:
            { return RegExpTT.ATOMIC_GROUP;
            }
          // fall through
          case 237: break;
          case 100:
            { return RegExpTT.PCRE_BRANCH_RESET;
            }
          // fall through
          case 238: break;
          case 101:
            { return RegExpTT.OCT_CHAR;
            }
          // fall through
          case 239: break;
          case 102:
            { if (xmlSchemaMode) { yypushback(1); return RegExpTT.CHAR_CLASS; } else return RegExpTT.CTRL;
            }
          // fall through
          case 240: break;
          case 103:
            { yybegin(QUOTED_NAMED_GROUP); return RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL;
            }
          // fall through
          case 241: break;
          case 104:
            { return allowPcreBackReferences ? RegExpTT.BACKREF : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          // fall through
          case 242: break;
          case 105:
            { yybegin(NAMED_GROUP); return RegExpTT.RUBY_NAMED_GROUP_CALL;
            }
          // fall through
          case 243: break;
          case 106:
            { yybegin(QUOTED_NAMED_GROUP); return RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF;
            }
          // fall through
          case 244: break;
          case 107:
            { yybegin(NAMED_GROUP); return RegExpTT.RUBY_NAMED_GROUP_REF;
            }
          // fall through
          case 245: break;
          case 108:
            { yypushback(yylength() - 2); return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          // fall through
          case 246: break;
          case 109:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { if (allowExtendedUnicodeCharacter) yypushstate(EMBRACED_HEX); else return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          // fall through
          case 247: break;
          case 110:
            { if (allowOneHexCharEscape) { return RegExpTT.HEX_CHAR; } else { yypushback(1); return RegExpTT.BAD_HEX_VALUE; }
            }
          // fall through
          case 248: break;
          case 111:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { if (allowExtendedUnicodeCharacter) yypushstate(EMBRACED_HEX); else return RegExpTT.BAD_HEX_VALUE;
            }
          // fall through
          case 249: break;
          case 112:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowOmitBothNumbersInQuantifiers || allowDanglingMetacharacters != TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else return RegExpTT.CHARACTER;
            }
          // fall through
          case 250: break;
          case 113:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { yypushstate(QUANTIFIER); return RegExpTT.LBRACE;
            }
          // fall through
          case 251: break;
          case 114:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { return (allowDanglingMetacharacters != TRUE) ? RegExpTT.LBRACE : RegExpTT.CHARACTER;
            }
          // fall through
          case 252: break;
          case 115:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { return RegExpTT.CHARACTER;
            }
          // fall through
          case 253: break;
          case 116:
            { yypopstate(); return (yycharat(-1) == 'u') ? RegExpTT.UNICODE_CHAR : RegExpTT.HEX_CHAR;
            }
          // fall through
          case 254: break;
          case 117:
            { yybegin(YYINITIAL); return RegExpTT.NEG_LOOKAHEAD;
            }
          // fall through
          case 255: break;
          case 118:
            { yybegin(YYINITIAL); return RegExpTT.POS_LOOKAHEAD;
            }
          // fall through
          case 256: break;
          case 119:
            { if (allowPcreNumberedGroupRef) {
                                          yybegin(PCRE_NUMBERED_GROUP);
                                          return RegExpTT.PCRE_NUMBERED_GROUP_REF;
                                        }
                                        else { yypushback(yylength() - 2); yybegin(OPTIONS); return RegExpTT.SET_OPTIONS; }
            }
          // fall through
          case 257: break;
          case 120:
            { return RegExpTT.NEG_LOOKBEHIND;
            }
          // fall through
          case 258: break;
          case 121:
            { return RegExpTT.POS_LOOKBEHIND;
            }
          // fall through
          case 259: break;
          case 122:
            { yybegin(NAMED_GROUP); capturingGroupCount++; return RegExpTT.PYTHON_NAMED_GROUP;
            }
          // fall through
          case 260: break;
          case 123:
            { yybegin(PY_NAMED_GROUP_REF); return RegExpTT.PYTHON_NAMED_GROUP_REF;
            }
          // fall through
          case 261: break;
          case 124:
            { return RegExpTT.HEX_CHAR;
            }
          // fall through
          case 262: break;
          case 125:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { return allowOmitBothNumbersInQuantifiers ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 263: break;
          case 126:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { return RegExpTT.ESC_CHARACTER;
            }
          // fall through
          case 264: break;
          case 127:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowOmitNumbersInQuantifiers || allowDanglingMetacharacters != TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else return RegExpTT.CHARACTER;
            }
          // fall through
          case 265: break;
          case 128:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowDanglingMetacharacters == TRUE) { if (allowOmitBothNumbersInQuantifiers) yypushstate(NON_QUANTIFIER); return RegExpTT.CHARACTER; } else { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; }
            }
          // fall through
          case 266: break;
          case 129:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowDanglingMetacharacters != TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else { yypushstate(NON_QUANTIFIER); return RegExpTT.CHARACTER; }
            }
          // fall through
          case 267: break;
          case 130:
            { yybegin(YYINITIAL); return RegExpTT.NEG_LOOKBEHIND;
            }
          // fall through
          case 268: break;
          case 131:
            { yybegin(YYINITIAL); return RegExpTT.POS_LOOKBEHIND;
            }
          // fall through
          case 269: break;
          case 132:
            { return RegExpTT.COMMENT;
            }
          // fall through
          case 270: break;
          case 133:
            { if (allowOctalNoLeadingZero) yypushback(1); return RegExpTT.OCT_CHAR;
            }
          // fall through
          case 271: break;
          case 134:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 2);
            { return allowOmitNumbersInQuantifiers ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          // fall through
          case 272: break;
          case 135:
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, 1);
            { if (allowDanglingMetacharacters != TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else if (allowOmitNumbersInQuantifiers) yypushstate(NON_QUANTIFIER); return RegExpTT.CHARACTER;
            }
          // fall through
          case 273: break;
          case 136:
            { return RegExpTT.UNICODE_CHAR;
            }
          // fall through
          case 274: break;
          case 137:
            { return allowPcreConditions ? RegExpTT.PCRE_DEFINE : RegExpTT.NAME;
            }
          // fall through
          case 275: break;
          case 138:
            { return allowPcreConditions ? RegExpTT.PCRE_VERSION : RegExpTT.NAME;
            }
          // fall through
          case 276: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
