/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Winsvc;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/remoteDev/util/WindowsServiceUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "serviceExists", "", "serviceName", "", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nWindowsServiceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsServiceUtil.kt\ncom/intellij/remoteDev/util/WindowsServiceUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,43:1\n67#2,4:44\n23#2:48\n*S KotlinDebug\n*F\n+ 1 WindowsServiceUtil.kt\ncom/intellij/remoteDev/util/WindowsServiceUtil\n*L\n24#1:44,4\n14#1:48\n*E\n"})
public final class WindowsServiceUtil {
    @NotNull
    public static final WindowsServiceUtil INSTANCE;
    @NotNull
    private static final Logger logger;

    private WindowsServiceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean serviceExists(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        logger.info("Checking if Windows service '" + serviceName + "' exists");
        Winsvc.SC_HANDLE svcManager = Advapi32.INSTANCE.OpenSCManager(null, null, 1);
        try {
            Winsvc.SC_HANDLE svcHandle = Advapi32.INSTANCE.OpenService(svcManager, serviceName, 1);
            if (svcHandle == null) {
                int error = Kernel32.INSTANCE.GetLastError();
                String errorString = "0x" + Integer.toHexString(Kernel32.INSTANCE.GetLastError());
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("OpenServiceW returned null with error: " + errorString);
                }
                if (error == 1060) {
                    boolean bl = false;
                    return bl;
                }
                throw new IllegalStateException(("Failed to get Windows service. Error: " + errorString).toString());
            }
            try {
            }
            finally {
                Advapi32.INSTANCE.CloseServiceHandle(svcHandle);
            }
        }
        finally {
            Advapi32.INSTANCE.CloseServiceHandle(svcManager);
        }
        return true;
    }

    static {
        WindowsServiceUtil $this$thisLogger$iv = INSTANCE = new WindowsServiceUtil();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WindowsServiceUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WindowsServiceUtil.logger = logger;
    }
}

