/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.downloader.EmbeddedClientErrorReporter;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/remoteDev/downloader/NotificationBasedEmbeddedClientErrorReporter;", "Lcom/intellij/remoteDev/downloader/EmbeddedClientErrorReporter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "startupFailed", "", "exitCode", "", "output", "", "", "intellij.remoteDev.util"})
@SourceDebugExtension(value={"SMAP\nNotificationBasedEmbeddedClientErrorReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationBasedEmbeddedClientErrorReporter.kt\ncom/intellij/remoteDev/downloader/NotificationBasedEmbeddedClientErrorReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,31:1\n23#2:32\n*S KotlinDebug\n*F\n+ 1 NotificationBasedEmbeddedClientErrorReporter.kt\ncom/intellij/remoteDev/downloader/NotificationBasedEmbeddedClientErrorReporter\n*L\n15#1:32\n*E\n"})
public final class NotificationBasedEmbeddedClientErrorReporter
implements EmbeddedClientErrorReporter {
    @Nullable
    private final Project project;

    public NotificationBasedEmbeddedClientErrorReporter(@Nullable Project project) {
        this.project = project;
    }

    @Override
    public void startupFailed(int exitCode, @NotNull List<String> output) {
        Intrinsics.checkNotNullParameter(output, (String)"output");
        String outputString = CollectionsKt.joinToString$default((Iterable)output, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        NotificationBasedEmbeddedClientErrorReporter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NotificationBasedEmbeddedClientErrorReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Embedded client failed to start with exit code " + exitCode + ":\n" + outputString);
        Object[] objectArray = new Object[]{exitCode};
        Notification notification = new Notification("IDE-errors", RemoteDevUtilBundle.INSTANCE.message("notification.title.failed.to.start.client", new Object[0]), RemoteDevUtilBundle.INSTANCE.message("notification.content.process.finished.with.exit.code.0", objectArray), NotificationType.ERROR);
        if (this.project != null) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)RemoteDevUtilBundle.INSTANCE.message("action.notification.view.output", new Object[0]), () -> NotificationBasedEmbeddedClientErrorReporter.startupFailed$lambda$0(this, outputString)));
        }
        notification.notify(this.project);
    }

    private static final void startupFailed$lambda$0(NotificationBasedEmbeddedClientErrorReporter this$0, String $outputString) {
        FileEditorManager.getInstance((Project)this$0.project).openFile((VirtualFile)new LightVirtualFile("output.txt", (CharSequence)$outputString), true);
    }
}

