/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.remoteDev.downloader.EmbeddedClientLauncher;
import com.intellij.remoteDev.downloader.FrontendConfigPaths;
import com.intellij.remoteDev.util.ClientVersionUtil;
import com.intellij.remoteDev.util.ProductInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/intellij/remoteDev/downloader/FrontendConfigPaths;", "", "pluginPath", "Ljava/nio/file/Path;", "vmOptionsPath", "configPath", "logPath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getPluginPath", "()Ljava/nio/file/Path;", "getVmOptionsPath", "getConfigPath", "getLogPath", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.remoteDev.util"})
public final class FrontendConfigPaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path pluginPath;
    @NotNull
    private final Path vmOptionsPath;
    @NotNull
    private final Path configPath;
    @NotNull
    private final Path logPath;

    public FrontendConfigPaths(@NotNull Path pluginPath2, @NotNull Path vmOptionsPath, @NotNull Path configPath2, @NotNull Path logPath2) {
        Intrinsics.checkNotNullParameter((Object)pluginPath2, (String)"pluginPath");
        Intrinsics.checkNotNullParameter((Object)vmOptionsPath, (String)"vmOptionsPath");
        Intrinsics.checkNotNullParameter((Object)configPath2, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)logPath2, (String)"logPath");
        this.pluginPath = pluginPath2;
        this.vmOptionsPath = vmOptionsPath;
        this.configPath = configPath2;
        this.logPath = logPath2;
    }

    @NotNull
    public final Path getPluginPath() {
        return this.pluginPath;
    }

    @NotNull
    public final Path getVmOptionsPath() {
        return this.vmOptionsPath;
    }

    @NotNull
    public final Path getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public final Path getLogPath() {
        return this.logPath;
    }

    @NotNull
    public final Path component1() {
        return this.pluginPath;
    }

    @NotNull
    public final Path component2() {
        return this.vmOptionsPath;
    }

    @NotNull
    public final Path component3() {
        return this.configPath;
    }

    @NotNull
    public final Path component4() {
        return this.logPath;
    }

    @NotNull
    public final FrontendConfigPaths copy(@NotNull Path pluginPath2, @NotNull Path vmOptionsPath, @NotNull Path configPath2, @NotNull Path logPath2) {
        Intrinsics.checkNotNullParameter((Object)pluginPath2, (String)"pluginPath");
        Intrinsics.checkNotNullParameter((Object)vmOptionsPath, (String)"vmOptionsPath");
        Intrinsics.checkNotNullParameter((Object)configPath2, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)logPath2, (String)"logPath");
        return new FrontendConfigPaths(pluginPath2, vmOptionsPath, configPath2, logPath2);
    }

    public static /* synthetic */ FrontendConfigPaths copy$default(FrontendConfigPaths frontendConfigPaths, Path path, Path path2, Path path3, Path path4, int n, Object object) {
        if ((n & 1) != 0) {
            path = frontendConfigPaths.pluginPath;
        }
        if ((n & 2) != 0) {
            path2 = frontendConfigPaths.vmOptionsPath;
        }
        if ((n & 4) != 0) {
            path3 = frontendConfigPaths.configPath;
        }
        if ((n & 8) != 0) {
            path4 = frontendConfigPaths.logPath;
        }
        return frontendConfigPaths.copy(path, path2, path3, path4);
    }

    @NotNull
    public String toString() {
        return "FrontendConfigPaths(pluginPath=" + this.pluginPath + ", vmOptionsPath=" + this.vmOptionsPath + ", configPath=" + this.configPath + ", logPath=" + this.logPath + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.pluginPath).hashCode();
        result2 = result2 * 31 + ((Object)this.vmOptionsPath).hashCode();
        result2 = result2 * 31 + ((Object)this.configPath).hashCode();
        result2 = result2 * 31 + ((Object)this.logPath).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FrontendConfigPaths)) {
            return false;
        }
        FrontendConfigPaths frontendConfigPaths = (FrontendConfigPaths)other;
        if (!Intrinsics.areEqual((Object)this.pluginPath, (Object)frontendConfigPaths.pluginPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vmOptionsPath, (Object)frontendConfigPaths.vmOptionsPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configPath, (Object)frontendConfigPaths.configPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.logPath, (Object)frontendConfigPaths.logPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/remoteDev/downloader/FrontendConfigPaths$Companion;", "", "<init>", "()V", "fromProductInfo", "Lcom/intellij/remoteDev/downloader/FrontendConfigPaths;", "productInfo", "Lcom/intellij/remoteDev/util/ProductInfo;", "getDefaultClientPathFor", "Ljava/nio/file/Path;", "dataDirName", "", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getDefaultPathFor", "Lkotlin/Function1;", "useFrontendSuffixSince242", "", "intellij.remoteDev.util"})
    @SourceDebugExtension(value={"SMAP\nConfigureClientHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureClientHook.kt\ncom/intellij/remoteDev/downloader/FrontendConfigPaths$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n296#2,2:73\n1#3:75\n*S KotlinDebug\n*F\n+ 1 ConfigureClientHook.kt\ncom/intellij/remoteDev/downloader/FrontendConfigPaths$Companion\n*L\n40#1:73,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendConfigPaths fromProductInfo(@NotNull ProductInfo productInfo) {
            Object vmOptionsFile;
            Object object;
            String dataDirName;
            BuildNumber buildNumber;
            block8: {
                Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
                BuildNumber buildNumber2 = BuildNumber.fromString((String)productInfo.getBuildNumber());
                if (buildNumber2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                buildNumber = buildNumber2;
                dataDirName = productInfo.getDataDirectoryName();
                for (Object launchData : (Iterable)productInfo.getLaunch()) {
                    ProductInfo.CustomCommandLaunchData customCommand;
                    Object object2;
                    ProductInfo.CustomCommandLaunchData customCommandLaunchData;
                    boolean bl = false;
                    List<ProductInfo.CustomCommandLaunchData> list = ((ProductInfo.LaunchData)launchData).getCustomCommands();
                    if (list != null) {
                        Object v2;
                        block7: {
                            Iterable $this$firstOrNull$iv = list;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ProductInfo.CustomCommandLaunchData it = (ProductInfo.CustomCommandLaunchData)element$iv;
                                boolean bl2 = false;
                                if (!EmbeddedClientLauncher.Companion.isThinClientCustomCommand(it)) continue;
                                v2 = element$iv;
                                break block7;
                            }
                            v2 = null;
                        }
                        customCommandLaunchData = v2;
                    } else {
                        customCommandLaunchData = null;
                    }
                    if ((object2 = (customCommand = customCommandLaunchData)) == null || (object2 = ((ProductInfo.CustomCommandLaunchData)object2).getVmOptionsFilePath()) == null) {
                        object2 = ((ProductInfo.LaunchData)launchData).getVmOptionsFilePath();
                    }
                    if ((launchData = object2) == null) continue;
                    object = launchData;
                    break block8;
                }
                object = null;
            }
            if ((vmOptionsFile = object) == null) {
                boolean $i$a$-checkNotNull-FrontendConfigPaths$Companion$fromProductInfo$22 = false;
                String $i$a$-checkNotNull-FrontendConfigPaths$Companion$fromProductInfo$22 = "product_info doesn't contain vmOptionsFilePath";
                throw new IllegalStateException($i$a$-checkNotNull-FrontendConfigPaths$Companion$fromProductInfo$22.toString());
            }
            String vmOptionsFileName = StringsKt.substringAfterLast$default(vmOptionsFile, (String)"/", null, (int)2, null);
            Path pluginPath2 = this.getDefaultClientPathFor(dataDirName, buildNumber, (Function1<? super String, String>)((Function1)fromProductInfo.pluginPath.1.INSTANCE), true);
            Path configPath2 = this.getDefaultClientPathFor(dataDirName, buildNumber, (Function1<? super String, String>)((Function1)fromProductInfo.configPath.1.INSTANCE), false);
            Path vmOptionsPath = configPath2.resolve(vmOptionsFileName);
            Path logPath2 = this.getDefaultClientPathFor(dataDirName, buildNumber, (Function1<? super String, String>)((Function1)fromProductInfo.logPath.1.INSTANCE), true);
            Intrinsics.checkNotNull((Object)vmOptionsPath);
            return new FrontendConfigPaths(pluginPath2, vmOptionsPath, configPath2, logPath2);
        }

        @NotNull
        public final Path getDefaultClientPathFor(@NotNull String dataDirName, @NotNull BuildNumber buildNumber, @NotNull Function1<? super String, String> getDefaultPathFor, boolean useFrontendSuffixSince242) {
            Intrinsics.checkNotNullParameter((Object)dataDirName, (String)"dataDirName");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            Intrinsics.checkNotNullParameter(getDefaultPathFor, (String)"getDefaultPathFor");
            String string = buildNumber.asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCode(...)");
            if (ClientVersionUtil.INSTANCE.isClientUsesTheSamePathsAsLocalIde(string) && !StringsKt.startsWith$default((String)dataDirName, (String)"JetBrainsClient", (boolean)false, (int)2, null)) {
                Path path = Paths.get((String)getDefaultPathFor.invoke((Object)dataDirName), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path result2 = path;
                if (useFrontendSuffixSince242) {
                    Path path2 = result2.resolve("frontend");
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    result2 = path2;
                }
                return result2;
            }
            Path path = Paths.get((String)getDefaultPathFor.invoke((Object)dataDirName), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

