/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.ui;

import com.intellij.remoteDev.ui.TextComponentHint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b*\u0002\u0017\u001a\b\u0007\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0006\u0010#\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010%\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/remoteDev/ui/TextComponentHint;", "Ljavax/swing/JLabel;", "component", "Ljavax/swing/text/JTextComponent;", "text", "", "state", "Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "<init>", "(Ljavax/swing/text/JTextComponent;Ljava/lang/String;Lcom/intellij/remoteDev/ui/TextComponentHint$State;)V", "getComponent", "()Ljavax/swing/text/JTextComponent;", "getState", "()Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "setState", "(Lcom/intellij/remoteDev/ui/TextComponentHint$State;)V", "document", "Ljavax/swing/text/Document;", "showHintOnce", "", "focusLost", "", "documentListener", "com/intellij/remoteDev/ui/TextComponentHint$documentListener$1", "Lcom/intellij/remoteDev/ui/TextComponentHint$documentListener$1;", "focusListener", "com/intellij/remoteDev/ui/TextComponentHint$focusListener$1", "Lcom/intellij/remoteDev/ui/TextComponentHint$focusListener$1;", "setAlpha", "", "alpha", "", "value", "setStyle", "style", "getShowHintOnce", "setShowHintOnce", "checkForHint", "State", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class TextComponentHint
extends JLabel {
    @NotNull
    private final JTextComponent component;
    @NotNull
    private State state;
    @NotNull
    private final Document document;
    private boolean showHintOnce;
    private int focusLost;
    @NotNull
    private final documentListener.1 documentListener;
    @NotNull
    private final focusListener.1 focusListener;

    public TextComponentHint(@NotNull JTextComponent component, @Nls @NotNull String text, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super(text);
        this.component = component;
        this.state = state;
        Document document = this.component.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        this.documentListener = new DocumentListener(this){
            final /* synthetic */ TextComponentHint this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void removeUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        this.focusListener = new FocusListener(this){
            final /* synthetic */ TextComponentHint this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int n = TextComponentHint.access$getFocusLost$p(this.this$0);
                TextComponentHint.access$setFocusLost$p(this.this$0, n + 1);
                TextComponentHint.access$checkForHint(this.this$0);
            }
        };
        this.setFont(this.component.getFont());
        this.setForeground(this.component.getForeground());
        this.setBorder(new EmptyBorder(this.component.getInsets()));
        this.setHorizontalAlignment(10);
        this.setAlpha(0.5f);
        this.setStyle(2);
        this.component.addFocusListener(this.focusListener);
        this.document.addDocumentListener(this.documentListener);
        this.component.setLayout(new BorderLayout());
        this.component.add(this);
        this.checkForHint();
    }

    public /* synthetic */ TextComponentHint(JTextComponent jTextComponent, String string, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            state = State.FOCUS_LOST;
        }
        this(jTextComponent, string, state);
    }

    @NotNull
    public final JTextComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    private final void setAlpha(float alpha) {
        this.setAlpha((int)(alpha * (float)255));
    }

    private final void setAlpha(int value) {
        int alpha = value;
        alpha = alpha > 255 ? 255 : (alpha < 0 ? 0 : alpha);
        Color foreground = this.getForeground();
        int red = foreground.getRed();
        int green = foreground.getGreen();
        int blue = foreground.getBlue();
        Color withAlpha = new Color(red, green, blue, alpha);
        super.setForeground(withAlpha);
    }

    private final void setStyle(int style) {
        this.setFont(this.getFont().deriveFont(style));
    }

    public final boolean getShowHintOnce() {
        return this.showHintOnce;
    }

    public final void setShowHintOnce(boolean showHintOnce) {
        this.showHintOnce = showHintOnce;
    }

    private final void checkForHint() {
        if (this.document.getLength() > 0) {
            this.setVisible(false);
            return;
        }
        if (this.showHintOnce && this.focusLost > 0) {
            this.setVisible(false);
            return;
        }
        this.setVisible(this.component.hasFocus() ? this.state == State.ALWAYS || this.state == State.FOCUS_GAINED : this.state == State.ALWAYS || this.state == State.FOCUS_LOST);
    }

    public static final /* synthetic */ void access$checkForHint(TextComponentHint $this) {
        $this.checkForHint();
    }

    public static final /* synthetic */ int access$getFocusLost$p(TextComponentHint $this) {
        return $this.focusLost;
    }

    public static final /* synthetic */ void access$setFocusLost$p(TextComponentHint $this, int n) {
        $this.focusLost = n;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "", "<init>", "(Ljava/lang/String;I)V", "ALWAYS", "FOCUS_GAINED", "FOCUS_LOST", "intellij.remoteDev.util"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State ALWAYS = new State();
        public static final /* enum */ State FOCUS_GAINED = new State();
        public static final /* enum */ State FOCUS_LOST = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.ALWAYS, State.FOCUS_GAINED, State.FOCUS_LOST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

