/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.remoteDev.RemoteDevSystemSettings;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.connection.JetBrainsClientDownloadInfo;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.ConfigureClientHook;
import com.intellij.remoteDev.downloader.EmbeddedClientLauncher;
import com.intellij.remoteDev.downloader.EmbeddedFrontendInstallation;
import com.intellij.remoteDev.downloader.ExtractedJetBrainsClientData;
import com.intellij.remoteDev.downloader.FrontendConfigPaths;
import com.intellij.remoteDev.downloader.FrontendInstallation;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.downloader.JetBrainsClientLauncherData;
import com.intellij.remoteDev.downloader.NotificationBasedEmbeddedClientErrorReporter;
import com.intellij.remoteDev.downloader.RemoteDevStatisticsCollector;
import com.intellij.remoteDev.downloader.StandaloneFrontendInstallation;
import com.intellij.remoteDev.util.ClientVersionUtil;
import com.intellij.remoteDev.util.FileManifestUtil;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.remoteDev.util.ProductInfo;
import com.intellij.remoteDev.util.SubProgressIndicatorBase;
import com.intellij.remoteDev.util.SubProgressIndicatorKt;
import com.intellij.remoteDev.util.UrlUtilKt;
import com.intellij.remoteDev.util.WindowsFileUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import com.jetbrains.infra.pgpVerifier.JetBrainsPgpConstants;
import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifier;
import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifierLogger;
import com.jetbrains.infra.pgpVerifier.Sha256ChecksumSignatureVerifier;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002qrB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u0012J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0007J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0007J \u0010/\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020,J\u000e\u00100\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010/\u001a\u00020.2\u0006\u00103\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u00104J\u0016\u0010/\u001a\u00020.2\u0006\u00103\u001a\u00020 2\u0006\u0010+\u001a\u00020,J \u0010/\u001a\u00020.2\u0006\u00103\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\u0006\u00105\u001a\u00020\u0012H\u0007J \u00106\u001a\u00020.2\u0006\u00103\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\u0006\u00105\u001a\u00020\u0012H\u0002J\u0017\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b:J\u0017\u0010;\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b<J\u0010\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020?H\u0002J \u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u001e\u0010G\u001a\u00020H2\u0006\u0010F\u001a\u00020\u000f2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070JH\u0002J\u001e\u0010K\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000f2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0JH\u0002J\u0010\u0010M\u001a\u00020H2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u0015\u0010N\u001a\u00020H2\u0006\u0010O\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bPJ\u000e\u0010Q\u001a\u00020A2\u0006\u0010R\u001a\u00020.J(\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010R\u001a\u00020.2\b\b\u0002\u0010V\u001a\u00020\u0012J5\u0010W\u001a\u00020T2\u0006\u0010X\u001a\u00020H2\u0006\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010U\u001a\u00020TH\u0000\u00a2\u0006\u0002\b[JC\u0010W\u001a\u00020T2\u0006\u0010X\u001a\u00020H2\u0006\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u00072\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00070J2\u0006\u0010U\u001a\u00020TH\u0000\u00a2\u0006\u0002\b[J\u0016\u0010]\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010^\u001a\u00020\u000fJ\u0018\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020\u000f2\u0006\u0010a\u001a\u00020\u000fH\u0002J\u0010\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020\u000fH\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010e\u001a\u00020\u000fH\u0002J\u0012\u0010f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010c\u001a\u00020\u000fH\u0002J\u0016\u0010g\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010h\u001a\u00020\u001bJ\u001c\u0010i\u001a\n j*\u0004\u0018\u00010\u000f0\u000f*\u00020\u000f2\u0006\u0010k\u001a\u00020\u0007H\u0002J\u000e\u0010p\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010n\u001a\u00020oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "extractDirSuffix", "", "config", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "getConfig", "()Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "parseProductInfo", "Lcom/intellij/remoteDev/util/ProductInfo;", "productInfoPath", "Ljava/nio/file/Path;", "parseProductInfo$intellij_remoteDev_util", "isJbrSymlink", "", "file", "isSymlink", "cwmJbrManifestFilter", "Lkotlin/Function1;", "getCwmJbrManifestFilter", "()Lkotlin/jvm/functions/Function1;", "getJetBrainsClientManifestFilter", "clientBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "minimumClientBuildWithBundledJre", "isClientWithBundledJre", "getClientDistributionName", "createSessionInfo", "Lcom/intellij/remoteDev/connection/JetBrainsClientDownloadInfo;", "hostBuildNumber", "jreBuild", "unattendedMode", "getLatestBuild", "currentlyDownloading", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CompletableFuture;", "downloadClientAndJdk", "Lcom/intellij/remoteDev/downloader/ExtractedJetBrainsClientData;", "clientBuildVersion", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadFrontend", "Lcom/intellij/remoteDev/downloader/FrontendInstallation;", "downloadFrontendAndJdk", "isClientDownloaded", "extractedClientData", "Lcom/intellij/remoteDev/downloader/StandaloneFrontendInstallation;", "sessionInfoResponse", "(Lcom/intellij/remoteDev/connection/JetBrainsClientDownloadInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "useEmbeddedClientIfAvailable", "downloadFrontendAndJdkImpl", "createEmbeddedClientLauncherIfAvailable", "Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;", "expectedClientBuildNumber", "createEmbeddedClientLauncherIfAvailable$intellij_remoteDev_util", "createCustomFrontendSnapshotInstallation", "createCustomFrontendSnapshotInstallation$intellij_remoteDev_util", "isAlreadyDownloaded", "fileData", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData;", "downloadWithRetries", "", "url", "Ljava/net/URI;", "path", "findCwmGuestHome", "guestRoot", "findLauncher", "Lcom/intellij/remoteDev/downloader/JetBrainsClientLauncherData;", "launcherNames", "", "findInInstallation", "relativePathsToFind", "findLauncherUnderCwmGuestRoot", "createLauncherDataForMacOs", "app", "createLauncherDataForMacOs$intellij_remoteDev_util", "processBeforeRunHooks", "frontendInstallation", "runFrontendProcess", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime", "enableBeforeRunHooks", "runJetBrainsClientProcess", "launcherData", "workingDirectory", "clientBuild", "runJetBrainsClientProcess$intellij_remoteDev_util", "extraArguments", "createSymlinkToJdkFromGuest", "jdkRoot", "createSymlink", "link", "target", "getJbrDirectory", "root", "tryGetJdkRoot", "jdkDownload", "tryGetMacOsJbrDirectory", "versionsMatch", "localBuildNumber", "addSuffix", "kotlin.jvm.PlatformType", "suffix", "SHA256_SUFFIX", "SHA256_ASC_SUFFIX", "urlAllowedChars", "Lkotlin/text/Regex;", "isValidDownloadUrl", "DownloadableFileData", "MultipleSubProgressIndicator", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCodeWithMeClientDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeClientDownloader.kt\ncom/intellij/remoteDev/downloader/CodeWithMeClientDownloader\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1078:1\n42#2,3:1079\n42#2,3:1091\n1#3:1082\n1563#4:1083\n1634#4,3:1084\n1869#4,2:1087\n1869#4,2:1089\n774#4:1101\n865#4,2:1102\n774#4:1104\n865#4,2:1105\n1321#5,2:1094\n60#6,5:1096\n13#6:1107\n*S KotlinDebug\n*F\n+ 1 CodeWithMeClientDownloader.kt\ncom/intellij/remoteDev/downloader/CodeWithMeClientDownloader\n*L\n78#1:1079,3\n830#1:1091,3\n699#1:1083\n699#1:1084,3\n757#1:1087,2\n790#1:1089,2\n431#1:1101\n431#1:1102,2\n432#1:1104\n432#1:1105,2\n1001#1:1094,2\n1017#1:1096,5\n74#1:1107\n*E\n"})
public final class CodeWithMeClientDownloader {
    @NotNull
    public static final CodeWithMeClientDownloader INSTANCE = new CodeWithMeClientDownloader();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String extractDirSuffix = ".ide.d";
    @NotNull
    private static final Function1<Path, Boolean> cwmJbrManifestFilter;
    @NotNull
    private static final BuildNumber minimumClientBuildWithBundledJre;
    @NotNull
    private static final ConcurrentHashMap<Path, CompletableFuture<Boolean>> currentlyDownloading;
    @NotNull
    private static final String SHA256_SUFFIX = ".sha256";
    @NotNull
    private static final String SHA256_ASC_SUFFIX = ".sha256.asc";
    @NotNull
    private static final Regex urlAllowedChars;

    private CodeWithMeClientDownloader() {
    }

    private final JetBrainsClientDownloaderConfigurationProvider getConfig() {
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (JetBrainsClientDownloaderConfigurationProvider)object;
    }

    @Nullable
    public final ProductInfo parseProductInfo$intellij_remoteDev_util(@NotNull Path productInfoPath) {
        Intrinsics.checkNotNullParameter((Object)productInfoPath, (String)"productInfoPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(productInfoPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn(productInfoPath + " does not exist");
            return null;
        }
        try {
            return ProductInfo.Companion.fromJson(PathsKt.readText$default((Path)productInfoPath, null, (int)1, null));
        }
        catch (IOException e) {
            LOG.warn("Failed to parse " + productInfoPath + ": " + e, (Throwable)e);
            return null;
        }
    }

    private final boolean isJbrSymlink(Path file) {
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"jbr") && this.isSymlink(file);
    }

    private final boolean isSymlink(Path file) {
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)file.toFile());
        return fileAttributes != null ? fileAttributes.isSymLink() : false;
    }

    @NotNull
    public final Function1<Path, Boolean> getCwmJbrManifestFilter() {
        return cwmJbrManifestFilter;
    }

    @NotNull
    public final Function1<Path, Boolean> getJetBrainsClientManifestFilter(@NotNull BuildNumber clientBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        Function1 universalFilter = this.isClientWithBundledJre(clientBuildNumber) ? CodeWithMeClientDownloader::getJetBrainsClientManifestFilter$lambda$0 : CodeWithMeClientDownloader::getJetBrainsClientManifestFilter$lambda$1;
        if (SystemInfoRt.isMac) {
            return arg_0 -> CodeWithMeClientDownloader.getJetBrainsClientManifestFilter$lambda$2(universalFilter, arg_0);
        }
        if (SystemInfoRt.isWindows) {
            return arg_0 -> CodeWithMeClientDownloader.getJetBrainsClientManifestFilter$lambda$3(universalFilter, arg_0);
        }
        return universalFilter;
    }

    public final boolean isClientWithBundledJre(@NotNull BuildNumber clientBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        return clientBuildNumber.isSnapshot() || clientBuildNumber.compareTo(minimumClientBuildWithBundledJre) > 0;
    }

    private final String getClientDistributionName(BuildNumber clientBuildNumber) {
        return clientBuildNumber.isSnapshot() ? "JetBrainsClient" : (clientBuildNumber.compareTo(new BuildNumber("", 211, 6167)) < 0 ? "IntelliJClient" : (clientBuildNumber.compareTo(new BuildNumber("", 213, 5318)) < 0 ? "CodeWithMeGuest" : "JetBrainsClient"));
    }

    @NotNull
    public final JetBrainsClientDownloadInfo createSessionInfo(@NotNull BuildNumber hostBuildNumber, @Nullable String jreBuild, boolean unattendedMode) {
        String string;
        String string2;
        String string3;
        boolean bundledJre;
        Intrinsics.checkNotNullParameter((Object)hostBuildNumber, (String)"hostBuildNumber");
        boolean isSnapshot = hostBuildNumber.isSnapshot();
        if (isSnapshot) {
            LOG.warn("Thin client download from sources may result in failure due to different sources on host and client, don't forget to update your locally built archive");
        }
        if (bundledJre = this.isClientWithBundledJre(hostBuildNumber)) {
            string3 = null;
        } else {
            string3 = jreBuild;
            if (string3 == null) {
                throw new IllegalStateException(("JRE build number must be passed for client build number < " + hostBuildNumber.asStringWithoutProductCode()).toString());
            }
        }
        String jreBuildToDownload = string3;
        if (jreBuildToDownload != null) {
            string2 = SystemInfo.isLinux && CpuArch.isIntel64() ? "-no-jbr.tar.gz" : (SystemInfo.isLinux && CpuArch.isArm64() ? "-no-jbr-aarch64.tar.gz" : (SystemInfo.isWindows && CpuArch.isIntel64() ? ".win.zip" : (SystemInfo.isWindows && CpuArch.isArm64() ? "-aarch64.win.zip" : (SystemInfo.isMac && CpuArch.isIntel64() ? "-no-jdk.sit" : (SystemInfo.isMac && CpuArch.isArm64() ? "-no-jdk-aarch64.sit" : null)))));
        } else if ((SystemInfo.isLinux && CpuArch.isIntel64() ? ".tar.gz" : (SystemInfo.isLinux && CpuArch.isArm64() ? "-aarch64.tar.gz" : (SystemInfo.isWindows && CpuArch.isIntel64() ? ".jbr.win.zip" : (SystemInfo.isWindows && CpuArch.isArm64() ? "-aarch64.jbr.win.zip" : (SystemInfo.isMac && CpuArch.isIntel64() ? ".sit" : (string2 = SystemInfo.isMac && CpuArch.isArm64() ? "-aarch64.sit" : null)))))) == null) {
            throw new IllegalStateException(("Current platform is not supported: OS " + SystemInfo.OS_NAME + " ARCH " + SystemInfo.OS_ARCH).toString());
        }
        String platformSuffix = string2;
        String clientDistributionName = this.getClientDistributionName(hostBuildNumber);
        BuildNumber clientBuildNumber = isSnapshot && this.getConfig().getDownloadLatestBuildFromCDNForSnapshotHost() ? this.getLatestBuild(hostBuildNumber) : hostBuildNumber;
        String string4 = this.getConfig().getClientDownloadUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        char[] cArray = new char[]{'/'};
        String clientDownloadUrl = StringsKt.trimEnd((String)string4, (char[])cArray) + "/" + clientDistributionName + "-" + clientBuildNumber.asStringWithoutProductCode() + platformSuffix;
        if (jreBuildToDownload != null) {
            String jreDownloadUrl;
            String string5;
            if (SystemInfo.isLinux && CpuArch.isIntel64()) {
                string5 = "linux-x64";
            } else if (SystemInfo.isLinux && CpuArch.isArm64()) {
                string5 = "linux-aarch64";
            } else if (SystemInfo.isWindows && CpuArch.isIntel64()) {
                string5 = "windows-x64";
            } else if (SystemInfo.isWindows && CpuArch.isArm64()) {
                string5 = "windows-aarch64";
            } else if (SystemInfo.isMac && CpuArch.isIntel64()) {
                string5 = "osx-x64";
            } else if (SystemInfo.isMac && CpuArch.isArm64()) {
                string5 = "osx-aarch64";
            } else {
                throw new IllegalStateException("Current platform is not supported".toString());
            }
            String platformString = string5;
            Object object = new String[]{"b"};
            List jreBuildParts = StringsKt.split$default((CharSequence)jreBuildToDownload, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (!(jreBuildParts.size() == 2)) {
                boolean $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$42 = false;
                String $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$42 = "jreBuild format should be like 12_3_45b6789.0: " + jreBuildToDownload;
                throw new IllegalArgumentException($i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$42.toString());
            }
            object = (CharSequence)jreBuildParts.get(0);
            if (!new Regex("^[0-9_.]+$").matches((CharSequence)object)) {
                boolean $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$52 = false;
                String $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$52 = "jreBuild format should be like 12_3_45b6789.0: " + jreBuildToDownload;
                throw new IllegalArgumentException($i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$52.toString());
            }
            object = (CharSequence)jreBuildParts.get(1);
            if (!new Regex("^[0-9.]+$").matches((CharSequence)object)) {
                boolean $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$62 = false;
                String $i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$62 = "jreBuild format should be like 12_3_45b6789.0: " + jreBuildToDownload;
                throw new IllegalArgumentException($i$a$-require-CodeWithMeClientDownloader$createSessionInfo$jreDownloadUrl$62.toString());
            }
            String jdkVersion = StringsKt.replace$default((String)((String)jreBuildParts.get(0)), (String)".", (String)"_", (boolean)false, (int)4, null);
            String jdkBuild = (String)jreBuildParts.get(1);
            String string6 = this.getConfig().getJreDownloadUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            char[] cArray2 = new char[]{'/'};
            string = jreDownloadUrl = StringsKt.trimEnd((String)string6, (char[])cArray2) + "/jbr_jcef-" + jdkVersion + "-" + platformString + "-b" + jdkBuild + ".tar.gz";
        } else {
            string = null;
        }
        String jreDownloadUrl = string;
        String pgpPublicKeyUrl = unattendedMode ? RemoteDevSystemSettings.INSTANCE.getPgpPublicKeyUrl().getValue() : null;
        JetBrainsClientDownloadInfo sessionInfo = new JetBrainsClientDownloadInfo(hostBuildNumber, clientBuildNumber, clientDownloadUrl, jreDownloadUrl, pgpPublicKeyUrl);
        LOG.info("Generated session info: " + sessionInfo);
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BuildNumber getLatestBuild(BuildNumber hostBuildNumber) {
        BuildNumber buildNumber;
        String latestBuildTxtFileName = hostBuildNumber.getBaselineVersion() + "-LAST-BUILD.txt";
        String string = this.getConfig().getClientDownloadUrl().toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
        char[] cArray = new char[]{'/'};
        URI latestBuildTxtUri = new URI(StringsKt.trimEnd((String)string, (char[])cArray) + "/" + latestBuildTxtFileName);
        Path tempFile = Files.createTempFile(latestBuildTxtFileName, "", new FileAttribute[0]);
        try {
            if (ApplicationKt.getApplication().isDispatchThread()) {
                ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
                Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
                TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)RemoteDevUtilBundle.INSTANCE.getMessage("launcher.get.client.info", new Object[0]), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(latestBuildTxtUri, tempFile, null){
                    int label;
                    final /* synthetic */ URI $latestBuildTxtUri;
                    final /* synthetic */ Path $tempFile;
                    {
                        this.$latestBuildTxtUri = $latestBuildTxtUri;
                        this.$tempFile = $tempFile;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> getLatestBuild.1.invokeSuspend$lambda$0(this.$latestBuildTxtUri, this.$tempFile, arg_0), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(URI $latestBuildTxtUri, Path $tempFile, ProgressIndicator it) {
                        Intrinsics.checkNotNull((Object)$tempFile);
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                        CodeWithMeClientDownloader.access$downloadWithRetries(CodeWithMeClientDownloader.INSTANCE, $latestBuildTxtUri, $tempFile, progressIndicator);
                        return Unit.INSTANCE;
                    }
                }), (int)4, null);
            } else {
                Intrinsics.checkNotNull((Object)tempFile);
                this.downloadWithRetries(latestBuildTxtUri, tempFile, (ProgressIndicator)new EmptyProgressIndicator());
            }
            Intrinsics.checkNotNull((Object)tempFile);
            String buildNumberString = ((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)tempFile, null, (int)1, null))).toString();
            BuildNumber buildNumber2 = BuildNumber.fromStringOrNull((String)buildNumberString);
            if (buildNumber2 == null) {
                throw new IllegalStateException(("Invalid build number: " + buildNumberString).toString());
            }
            buildNumber = buildNumber2;
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
        return buildNumber;
    }

    @Deprecated(message="Use downloadFrontend() instead")
    @Nullable
    public final ExtractedJetBrainsClientData downloadClientAndJdk(@NotNull String clientBuildVersion, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)clientBuildVersion, (String)"clientBuildVersion");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)clientBuildVersion);
        if (buildNumber == null) {
            return null;
        }
        BuildNumber clientBuildNumber = buildNumber;
        FrontendInstallation frontendInstallation = this.downloadFrontend(clientBuildNumber, progressIndicator);
        if (frontendInstallation == null) {
            return null;
        }
        FrontendInstallation installation = frontendInstallation;
        Path path = installation.getInstallationHome();
        StandaloneFrontendInstallation standaloneFrontendInstallation = installation instanceof StandaloneFrontendInstallation ? (StandaloneFrontendInstallation)installation : null;
        Path path2 = standaloneFrontendInstallation != null ? standaloneFrontendInstallation.getJreDir() : null;
        String string = installation.getBuildNumber().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCode(...)");
        return new ExtractedJetBrainsClientData(path, path2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    @Nullable
    public final FrontendInstallation downloadFrontend(@NotNull BuildNumber clientBuildNumber, @NotNull ProgressIndicator progressIndicator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        FrontendInstallation customSnapshotInstallation = this.createCustomFrontendSnapshotInstallation$intellij_remoteDev_util(clientBuildNumber);
        if (customSnapshotInstallation != null) {
            return customSnapshotInstallation;
        }
        ProgressIndicator jdkBuildProgressIndicator = SubProgressIndicatorKt.createSubProgress(progressIndicator, 0.1);
        if (this.isClientWithBundledJre(clientBuildNumber)) {
            jdkBuildProgressIndicator.setFraction(1.0);
            string = null;
        } else {
            String string2;
            LOG.info("Downloading Thin Client jdk-build.txt");
            jdkBuildProgressIndicator.setText(RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.checking", new Object[0]));
            String clientDistributionName = this.getClientDistributionName(clientBuildNumber);
            String clientJdkDownloadUrl = this.getConfig().getClientDownloadUrl() + clientDistributionName + "-" + clientBuildNumber.asStringWithoutProductCode() + "-jdk-build.txt";
            LOG.info("Downloading from " + clientJdkDownloadUrl);
            Path tempFile = Files.createTempFile("jdk-build", "txt", new FileAttribute[0]);
            try {
                URI uRI = new URI(clientJdkDownloadUrl);
                Intrinsics.checkNotNull((Object)tempFile);
                this.downloadWithRetries(uRI, tempFile, (ProgressIndicator)new EmptyProgressIndicator());
                Unit it = Unit.INSTANCE;
                boolean bl = false;
                string2 = PathsKt.readText$default((Path)tempFile, null, (int)1, null);
            }
            finally {
                Files.delete(tempFile);
            }
            string = string2;
        }
        String jdkBuild = string;
        JetBrainsClientDownloadInfo sessionInfo = this.createSessionInfo(clientBuildNumber, jdkBuild, true);
        return this.downloadFrontendAndJdk(sessionInfo, SubProgressIndicatorKt.createSubProgress(progressIndicator, 0.9));
    }

    @NotNull
    public final FrontendInstallation downloadFrontendAndJdk(@NotNull BuildNumber clientBuildNumber, @Nullable String jreBuild, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        JetBrainsClientDownloadInfo sessionInfo = this.createSessionInfo(clientBuildNumber, jreBuild, true);
        return this.downloadFrontendAndJdk(sessionInfo, progressIndicator);
    }

    public final boolean isClientDownloaded(@NotNull BuildNumber clientBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        String clientUrl = this.createSessionInfo(clientBuildNumber, null, true).getCompatibleClientUrl();
        Path tempDir = FileUtil.createTempDirectory((String)"jb-cwm-dl", null).toPath();
        URI uRI = URI.create(clientUrl);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        Intrinsics.checkNotNull((Object)tempDir);
        DownloadableFileData guestData = DownloadableFileData.Companion.build(uRI, tempDir, this.getConfig().getClientCachesDir(), this.getJetBrainsClientManifestFilter(clientBuildNumber));
        return this.isAlreadyDownloaded(guestData);
    }

    @Nullable
    public final StandaloneFrontendInstallation extractedClientData(@NotNull BuildNumber clientBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        if (!this.isClientDownloaded(clientBuildNumber)) {
            return null;
        }
        String clientUrl = this.createSessionInfo(clientBuildNumber, null, true).getCompatibleClientUrl();
        Path tempDir = FileUtil.createTempDirectory((String)"jb-cwm-dl", null).toPath();
        URI uRI = URI.create(clientUrl);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        Intrinsics.checkNotNull((Object)tempDir);
        DownloadableFileData guestData = DownloadableFileData.Companion.build(uRI, tempDir, this.getConfig().getClientCachesDir(), this.getJetBrainsClientManifestFilter(clientBuildNumber));
        Path path = guestData.getTargetPath();
        return new StandaloneFrontendInstallation(path, clientBuildNumber, null);
    }

    @Nullable
    public final Object downloadFrontendAndJdk(@NotNull JetBrainsClientDownloadInfo sessionInfoResponse, @NotNull Continuation<? super FrontendInstallation> $completion) {
        return StepsKt.withProgressText((String)RemoteDevUtilBundle.INSTANCE.message("launcher.get.client.info", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FrontendInstallation>, Object>(sessionInfoResponse, null){
            int label;
            final /* synthetic */ JetBrainsClientDownloadInfo $sessionInfoResponse;
            {
                this.$sessionInfoResponse = $sessionInfoResponse;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> downloadFrontendAndJdk.2.invokeSuspend$lambda$0(this.$sessionInfoResponse, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FrontendInstallation> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FrontendInstallation invokeSuspend$lambda$0(JetBrainsClientDownloadInfo $sessionInfoResponse, ProgressIndicator it) {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                return CodeWithMeClientDownloader.INSTANCE.downloadFrontendAndJdk($sessionInfoResponse, progressIndicator);
            }
        }), $completion);
    }

    @NotNull
    public final FrontendInstallation downloadFrontendAndJdk(@NotNull JetBrainsClientDownloadInfo sessionInfoResponse, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)sessionInfoResponse, (String)"sessionInfoResponse");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        return this.downloadFrontendAndJdkImpl(sessionInfoResponse, progressIndicator, true);
    }

    @TestOnly
    @NotNull
    public final FrontendInstallation downloadFrontendAndJdk(@NotNull JetBrainsClientDownloadInfo sessionInfoResponse, @NotNull ProgressIndicator progressIndicator, boolean useEmbeddedClientIfAvailable) {
        Intrinsics.checkNotNullParameter((Object)sessionInfoResponse, (String)"sessionInfoResponse");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        return this.downloadFrontendAndJdkImpl(sessionInfoResponse, progressIndicator, useEmbeddedClientIfAvailable);
    }

    private final FrontendInstallation downloadFrontendAndJdkImpl(JetBrainsClientDownloadInfo sessionInfoResponse, ProgressIndicator progressIndicator, boolean useEmbeddedClientIfAvailable) {
        BuildNumber future;
        URI uRI;
        Object[] it;
        EmbeddedClientLauncher embeddedClientLauncher;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (useEmbeddedClientIfAvailable && (embeddedClientLauncher = this.createEmbeddedClientLauncherIfAvailable$intellij_remoteDev_util(sessionInfoResponse.getClientBuildNumber())) != null) {
            return new EmbeddedFrontendInstallation(embeddedClientLauncher);
        }
        Path tempDir = FileUtil.createTempDirectory((String)"jb-cwm-dl", null).toPath();
        LOG.info("Downloading Thin Client in " + tempDir + "...");
        URI clientUrl = new URI(sessionInfoResponse.getCompatibleClientUrl());
        Intrinsics.checkNotNull((Object)tempDir);
        DownloadableFileData guestData = DownloadableFileData.Companion.build(clientUrl, tempDir, this.getConfig().getClientCachesDir(), this.getJetBrainsClientManifestFilter(sessionInfoResponse.getClientBuildNumber()));
        Object[] objectArray = sessionInfoResponse.getCompatibleJreUrl();
        if (objectArray != null) {
            it = objectArray;
            boolean bl = false;
            uRI = new URI((String)it);
        } else {
            uRI = null;
        }
        URI jdkUrl = uRI;
        DownloadableFileData jdkData = jdkUrl != null ? DownloadableFileData.Companion.build(jdkUrl, tempDir, this.getConfig().getClientCachesDir(), cwmJbrManifestFilter) : null;
        it = new DownloadableFileData[]{jdkData, guestData};
        List dataList = CollectionsKt.listOfNotNull((Object[])it);
        StructuredIdeActivity activity = dataList.isEmpty() ? null : RemoteDevStatisticsCollector.INSTANCE.onGuestDownloadStarted();
        CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$updateStateText(dataList, progressIndicator);
        List<MultipleSubProgressIndicator> dataProgressIndicators = MultipleSubProgressIndicator.Companion.create(progressIndicator, dataList.size());
        Iterator iterator = ((Iterable)dataList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            DownloadableFileData data = (DownloadableFileData)iterator.next();
            future = data.getDownloadFuture();
            MultipleSubProgressIndicator dataProgressIndicator = dataProgressIndicators.get(index);
            AppExecutorUtil.getAppScheduledExecutorService().execute(() -> CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5(data, dataProgressIndicator, future, tempDir, sessionInfoResponse, dataList, progressIndicator));
        }
        try {
            boolean jdkSucceeded;
            Boolean guestSucceeded = guestData.getDownloadFuture().get();
            Object object = jdkData;
            boolean bl = object != null && (object = ((DownloadableFileData)object).getDownloadFuture()) != null && (object = (Boolean)((CompletableFuture)object).get()) != null ? (Boolean)object : (jdkSucceeded = true);
            if (!guestSucceeded.booleanValue() || !jdkSucceeded) {
                throw new IllegalStateException("Guest or jdk was not downloaded".toString());
            }
            LOG.info("Download of guest and jdk succeeded");
            Path path = guestData.getTargetPath();
            DownloadableFileData downloadableFileData = jdkData;
            Path path2 = downloadableFileData != null ? downloadableFileData.getTargetPath() : null;
            future = sessionInfoResponse.getClientBuildNumber();
            return new StandaloneFrontendInstallation(path, future, path2);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Download was canceled");
            throw e;
        }
        catch (Throwable e) {
            Throwable throwable;
            RemoteDevStatisticsCollector.INSTANCE.onGuestDownloadFinished(activity, false);
            LOG.warn(e);
            if (e instanceof ExecutionException && (throwable = e.getCause()) != null) {
                Throwable it2 = throwable;
                boolean bl = false;
                throw it2;
            }
            throw e;
        }
    }

    @Nullable
    public final EmbeddedClientLauncher createEmbeddedClientLauncherIfAvailable$intellij_remoteDev_util(@NotNull BuildNumber expectedClientBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)expectedClientBuildNumber, (String)"expectedClientBuildNumber");
        if (Registry.Companion.is("rdct.use.embedded.client") || Registry.Companion.is("rdct.always.use.embedded.client")) {
            BuildNumber buildNumber = expectedClientBuildNumber.withoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"withoutProductCode(...)");
            BuildNumber hostBuildNumberString = buildNumber;
            BuildNumber buildNumber2 = ApplicationInfo.getInstance().getBuild().withoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"withoutProductCode(...)");
            BuildNumber currentIdeBuildNumber = buildNumber2;
            LOG.debug("Host build number: " + hostBuildNumberString + ", current IDE build number: " + currentIdeBuildNumber);
            if (Intrinsics.areEqual((Object)hostBuildNumberString, (Object)currentIdeBuildNumber) || Registry.Companion.is("rdct.always.use.embedded.client")) {
                EmbeddedClientLauncher embeddedClientLauncher = EmbeddedClientLauncher.Companion.create();
                if (embeddedClientLauncher != null) {
                    LOG.debug("Embedded client is available");
                    return embeddedClientLauncher;
                }
                LOG.debug("Embedded client isn't available in the current IDE installation");
            }
        }
        return null;
    }

    @Nullable
    public final FrontendInstallation createCustomFrontendSnapshotInstallation$intellij_remoteDev_util(@NotNull BuildNumber hostBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)hostBuildNumber, (String)"hostBuildNumber");
        if (!hostBuildNumber.isSnapshot()) {
            return null;
        }
        String path = ((Object)StringsKt.trim((CharSequence)Registry.Companion.stringValue("rdct.path.to.custom.snapshot.frontend.installation"))).toString();
        if (((CharSequence)path).length() == 0) {
            return null;
        }
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return new StandaloneFrontendInstallation(path2, hostBuildNumber, null);
    }

    private final boolean isAlreadyDownloaded(DownloadableFileData fileData) {
        FileManifestUtil.ExtractDirectory extractDirectory = FileManifestUtil.INSTANCE.getExtractDirectory(fileData.getTargetPath(), this.getConfig().getModifiedDateInManifestIncluded(), fileData.getIncludeInManifest());
        return extractDirectory.isUpToDate() && !StringsKt.contains$default((CharSequence)((Object)fileData.getTargetPath().getFileName()).toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void downloadWithRetries(URI url, Path path, ProgressIndicator progressIndicator) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MAX_ATTEMPTS = 5;
        delayMs = BACKOFF_INITIAL_DELAY_MS = 500L;
        i = 1;
        while (true) {
            try {
                block16: {
                    block15: {
                        CodeWithMeClientDownloader.LOG.info("Downloading from " + url + " to " + path.toAbsolutePath().toString() + ", attempt " + i + " of " + MAX_ATTEMPTS);
                        var10_9 = url.getScheme();
                        if (var10_9 == null) break block15;
                        switch (var10_9.hashCode()) {
                            case 3143036: {
                                if (var10_9.equals("file")) break;
                                ** break;
                            }
                            case 3213448: {
                                if (!var10_9.equals("http")) {
                                    ** break;
                                }
                                ** GOTO lbl21
                            }
                            case 99617003: {
                                if (!var10_9.equals("https")) ** break;
lbl21:
                                // 2 sources

                                HttpRequests.request((String)url.toString()).saveToFile(path, progressIndicator, true);
                                progressIndicator.setText2("");
                                break block16;
                            }
                        }
                        v0 = Paths.get(url);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                        source = v0;
                        v1 = new LinkOption[]{};
                        if (Files.isDirectory(source, Arrays.copyOf(v1, v1.length))) {
                            throw new IllegalStateException(("Downloading a directory is not supported. Source: " + url + ", destination: " + path.toAbsolutePath().toString()).toString());
                        }
                        var12_12 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(source, path, var12_12);
                        break block16;
                    }
                    throw new IllegalStateException(("scheme " + url.getScheme() + " is not supported").toString());
                }
                CodeWithMeClientDownloader.LOG.info("Download from " + url + " to " + path.toAbsolutePath().toString() + " succeeded on attempt " + i + " of " + MAX_ATTEMPTS);
                return;
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                if (e instanceof HttpRequests.HttpStatusException) {
                    var11_10 = ((HttpRequests.HttpStatusException)e).getStatusCode();
                    v2 = 400 <= var11_10 ? var11_10 < 500 : false;
                    if (v2) {
                        CodeWithMeClientDownloader.LOG.warn("Received " + ((HttpRequests.HttpStatusException)e).getStatusCode() + " with message " + e.getMessage() + ", will not retry");
                        throw e;
                    }
                }
                if (i >= MAX_ATTEMPTS) {
                    CodeWithMeClientDownloader.LOG.warn("Failed to download from " + url + " to " + path.toAbsolutePath().toString() + " in " + MAX_ATTEMPTS + " attempts", e);
                    throw e;
                }
                CodeWithMeClientDownloader.LOG.warn("Attempt " + i + " of " + MAX_ATTEMPTS + " to download from " + url + " to " + path.toAbsolutePath().toString() + " failed, retrying in " + delayMs + " ms", e);
                Thread.sleep(delayMs);
                delayMs = (long)((double)delayMs * 1.5);
                if (i != MAX_ATTEMPTS) {
                    ++i;
                    continue;
                }
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path findCwmGuestHome(Path guestRoot) {
        AutoCloseable autoCloseable = Files.walk(guestRoot, 2, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Path path;
                Path dir = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)dir.resolve("bin"), (String)"resolve(...)");
                LinkOption[] linkOptionArray = new LinkOption[0];
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Path path2 = dir.resolve("lib");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                path = path2;
                linkOptionArray = new LinkOption[0];
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Intrinsics.checkNotNull((Object)dir);
                Path path3 = dir;
                return path3;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        throw new IllegalStateException(("JetBrains Client home is not found under " + guestRoot).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final JetBrainsClientLauncherData findLauncher(Path guestRoot, List<String> launcherNames) {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = launcherNames;
        Path path = guestRoot;
        CodeWithMeClientDownloader codeWithMeClientDownloader = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{it};
            collection.add(Path.of("bin", stringArray));
        }
        collection = (List)destination$iv$iv;
        Path launcherPath = codeWithMeClientDownloader.findInInstallation(path, (List<? extends Path>)collection);
        return new JetBrainsClientLauncherData(launcherPath, CollectionsKt.listOf((Object)((Object)launcherPath).toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path findInInstallation(Path guestRoot, List<? extends Path> relativePathsToFind) {
        AutoCloseable autoCloseable = Files.walk(guestRoot, 2, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Path dir = (Path)iterator.next();
                for (Path path : relativePathsToFind) {
                    Path candidate = dir.resolve(path);
                    Intrinsics.checkNotNull((Object)candidate);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(candidate, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    Path path2 = candidate;
                    return path2;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        throw new IllegalStateException(("Could not find any of (" + CollectionsKt.joinToString$default((Iterable)relativePathsToFind, null, null, null, (int)0, null, CodeWithMeClientDownloader::findInInstallation$lambda$1, (int)31, null) + ") under " + guestRoot).toString());
    }

    private final JetBrainsClientLauncherData findLauncherUnderCwmGuestRoot(Path guestRoot) {
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[]{"intellij_client.bat", "jetbrains_client.bat"};
            List batchLaunchers = CollectionsKt.listOf((Object[])objectArray);
            Object[] objectArray2 = new String[]{"jetbrains_client64.exe", "cwm_guest64.exe", "intellij_client64.exe"};
            List exeLaunchers = CollectionsKt.listOf((Object[])objectArray2);
            List eligibleLaunchers = Registry.Companion.is("com.jetbrains.gateway.client.use.batch.launcher", false) ? batchLaunchers : CollectionsKt.plus((Collection)exeLaunchers, (Iterable)batchLaunchers);
            return this.findLauncher(guestRoot, eligibleLaunchers);
        }
        if (SystemInfo.isUnix) {
            if (SystemInfo.isMac) {
                Object[] objectArray = guestRoot.toFile().listFiles(CodeWithMeClientDownloader::findLauncherUnderCwmGuestRoot$lambda$0);
                Intrinsics.checkNotNull((Object)objectArray);
                File app = (File)ArraysKt.singleOrNull((Object[])objectArray);
                if (app != null) {
                    Path path = app.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    return this.createLauncherDataForMacOs$intellij_remoteDev_util(path);
                }
            }
            Object[] exeLaunchers = new String[]{"jetbrains_client.sh", "cwm_guest.sh", "intellij_client.sh"};
            List shLauncherNames = CollectionsKt.listOf((Object[])exeLaunchers);
            List eligibleLaunchers = Registry.Companion.is("rdct.use.native.client.launcher.on.linux") ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"jetbrains_client"), (Iterable)shLauncherNames) : shLauncherNames;
            return this.findLauncher(guestRoot, eligibleLaunchers);
        }
        throw new IllegalStateException(("Unsupported OS: " + SystemInfo.OS_NAME).toString());
    }

    @NotNull
    public final JetBrainsClientLauncherData createLauncherDataForMacOs$intellij_remoteDev_util(@NotNull Path app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Object[] objectArray = new String[]{"open", "-n", "-W", "-a", ((Object)app).toString(), "--args"};
        return new JetBrainsClientLauncherData(app, CollectionsKt.listOf((Object[])objectArray));
    }

    public final void processBeforeRunHooks(@NotNull FrontendInstallation frontendInstallation) {
        Intrinsics.checkNotNullParameter((Object)frontendInstallation, (String)"frontendInstallation");
        Object[] objectArray = new Path[]{Path.of("product-info.json", new String[0]), Path.of("Resources/product-info.json", new String[0])};
        List productInfoRelPath = CollectionsKt.listOf((Object[])objectArray);
        Path productInfoPath = this.findInInstallation(frontendInstallation.getInstallationHome(), productInfoRelPath);
        ProductInfo productInfo = this.parseProductInfo$intellij_remoteDev_util(productInfoPath);
        if (productInfo == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ProductInfo productInfo2 = productInfo;
        FrontendConfigPaths configPaths = FrontendConfigPaths.Companion.fromProductInfo(productInfo2);
        Iterable $this$forEach$iv = ConfigureClientHook.Companion.getEP().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigureClientHook e = (ConfigureClientHook)element$iv;
            boolean bl = false;
            e.beforeRun(frontendInstallation, productInfo2, configPaths);
        }
    }

    @NotNull
    public final Lifetime runFrontendProcess(@NotNull Lifetime lifetime, @NotNull String url, @NotNull FrontendInstallation frontendInstallation, boolean enableBeforeRunHooks) {
        FrontendInstallation frontendInstallation2;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)frontendInstallation, (String)"frontendInstallation");
        if (enableBeforeRunHooks) {
            try {
                this.processBeforeRunHooks(frontendInstallation);
            }
            catch (Throwable e) {
                LOG.error("Could not process hooks before launching client " + frontendInstallation, e);
            }
        }
        if ((frontendInstallation2 = frontendInstallation) instanceof EmbeddedFrontendInstallation) {
            return ((EmbeddedFrontendInstallation)frontendInstallation).getFrontendLauncher().launch(url, lifetime, new NotificationBasedEmbeddedClientErrorReporter(null));
        }
        if (frontendInstallation2 instanceof StandaloneFrontendInstallation) {
            JetBrainsClientLauncherData launcherData = this.findLauncherUnderCwmGuestRoot(((StandaloneFrontendInstallation)frontendInstallation).getInstallationHome());
            if (((StandaloneFrontendInstallation)frontendInstallation).getJreDir() != null) {
                this.createSymlinkToJdkFromGuest(((StandaloneFrontendInstallation)frontendInstallation).getInstallationHome(), ((StandaloneFrontendInstallation)frontendInstallation).getJreDir());
            }
            if (this.getConfig().getClientVersionManagementEnabled()) {
                Object[] objectArray = new Path[]{((StandaloneFrontendInstallation)frontendInstallation).getInstallationHome(), ((StandaloneFrontendInstallation)frontendInstallation).getJreDir()};
                Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path path = (Path)element$iv;
                    boolean bl = false;
                    Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
                }
            }
            return this.runJetBrainsClientProcess$intellij_remoteDev_util(launcherData, ((StandaloneFrontendInstallation)frontendInstallation).getInstallationHome(), ((StandaloneFrontendInstallation)frontendInstallation).getBuildNumber(), url, lifetime);
        }
        throw new NoWhenBranchMatchedException();
    }

    public static /* synthetic */ Lifetime runFrontendProcess$default(CodeWithMeClientDownloader codeWithMeClientDownloader, Lifetime lifetime, String string, FrontendInstallation frontendInstallation, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return codeWithMeClientDownloader.runFrontendProcess(lifetime, string, frontendInstallation, bl);
    }

    @NotNull
    public final Lifetime runJetBrainsClientProcess$intellij_remoteDev_util(@NotNull JetBrainsClientLauncherData launcherData, @NotNull Path workingDirectory, @NotNull BuildNumber clientBuild, @NotNull String url, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)launcherData, (String)"launcherData");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)clientBuild, (String)"clientBuild");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        return this.runJetBrainsClientProcess$intellij_remoteDev_util(launcherData, workingDirectory, clientBuild, url, CollectionsKt.emptyList(), lifetime);
    }

    @NotNull
    public final Lifetime runJetBrainsClientProcess$intellij_remoteDev_util(@NotNull JetBrainsClientLauncherData launcherData, @NotNull Path workingDirectory, @NotNull BuildNumber clientBuild, @NotNull String url, @NotNull List<String> extraArguments, @NotNull Lifetime lifetime) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)launcherData, (String)"launcherData");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)clientBuild, (String)"clientBuild");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(extraArguments, (String)"extraArguments");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Object[] objectArray = new String[]{"thinClient", url};
        List parameters = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)extraArguments);
        LifetimeDefinition processLifetimeDef = lifetime.createNested();
        if (SystemInfoRt.isMac) {
            String[] stringArray = new String[]{"jetbrains_client.vmoptions"};
            path = Paths.get(PathManager.getDefaultConfigPathFor((String)("JetBrainsClient" + clientBuild.asStringWithoutProductCode())), stringArray);
        } else {
            path = SystemInfoRt.isWindows ? launcherData.getExecutable().resolveSibling("jetbrains_client64.exe.vmoptions") : launcherData.getExecutable().resolveSibling("jetbrains_client64.vmoptions");
        }
        Path vmOptionsFile = path;
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        JetBrainsClientDownloaderConfigurationProvider jetBrainsClientDownloaderConfigurationProvider = (JetBrainsClientDownloaderConfigurationProvider)object;
        Intrinsics.checkNotNull((Object)vmOptionsFile);
        jetBrainsClientDownloaderConfigurationProvider.patchVmOptions(vmOptionsFile, new URI(url));
        Map clientEnvironment = new LinkedHashMap();
        String separateConfigOption = ClientVersionUtil.INSTANCE.computeSeparateConfigEnvVariableValue(clientBuild);
        if (separateConfigOption != null) {
            clientEnvironment.put("JBC_SEPARATE_CONFIG", separateConfigOption);
        }
        if (SystemInfo.isWindows) {
            WinNT.HANDLE hProcess = WindowsFileUtil.windowsCreateProcess$default(WindowsFileUtil.INSTANCE, launcherData.getExecutable(), workingDirectory, parameters, clientEnvironment, null, 16, null);
            int STILL_ACTIVE = 259;
            ApplicationKt.getApplication().executeOnPooledThread(() -> CodeWithMeClientDownloader.runJetBrainsClientProcess$lambda$0(STILL_ACTIVE, hProcess, processLifetimeDef));
            LifetimeExKt.onTerminationOrNow(lifetime, (Function0<Unit>)((Function0)() -> CodeWithMeClientDownloader.runJetBrainsClientProcess$lambda$1(hProcess, STILL_ACTIVE)));
        } else {
            Ref.IntRef attemptCount = new Ref.IntRef();
            attemptCount.element = SystemInfo.isMac ? 5 : 1;
            Ref.LongRef lastProcessStartTime = new Ref.LongRef();
            CodeWithMeClientDownloader.runJetBrainsClientProcess$doRunProcess(launcherData, parameters, clientEnvironment, attemptCount, lastProcessStartTime, lifetime, processLifetimeDef);
        }
        return processLifetimeDef.getLifetime();
    }

    @NotNull
    public final Path createSymlinkToJdkFromGuest(@NotNull Path guestRoot, @NotNull Path jdkRoot) {
        Intrinsics.checkNotNullParameter((Object)guestRoot, (String)"guestRoot");
        Intrinsics.checkNotNullParameter((Object)jdkRoot, (String)"jdkRoot");
        Path linkTarget = this.getJbrDirectory(jdkRoot);
        Path guestHome = this.findCwmGuestHome(guestRoot);
        Path path = guestHome.resolve("jbr");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path link = path;
        this.createSymlink(link, linkTarget);
        return link;
    }

    private final void createSymlink(Path link, Path target) {
        Path targetRealPath = target.toRealPath(new LinkOption[0]);
        boolean linkExists = true;
        Path path = link;
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        Path linkRealPath = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? link.toRealPath(new LinkOption[0]) : null;
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)link.toFile());
        boolean isSymlink = fileAttributes != null ? fileAttributes.isSymLink() : false;
        LOG.info(link + ": exists=" + linkExists + ", realPath=" + linkRealPath + ", isSymlink=" + isSymlink);
        if (isSymlink && Intrinsics.areEqual((Object)linkRealPath, (Object)targetRealPath)) {
            LOG.info("Symlink/junction '" + link + "' is UP-TO-DATE and points to '" + target + "'");
        } else {
            FileUtil.deleteWithRenamingIfExists((Path)link);
            LOG.info("Creating symlink/junction '" + link + "' -> '" + target + "'");
            try {
                if (SystemInfo.isWindows) {
                    Path path2 = target.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
                    WindowsFileUtil.INSTANCE.createJunction(link, path2);
                } else {
                    Path path3 = target.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
                    Files.createSymbolicLink(link, path3, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(link, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Intrinsics.areEqual((Object)link.toRealPath(new LinkOption[0]), (Object)targetRealPath)) {
                    LOG.warn("Creating symlink/junction to already existing target. '" + link + "' -> '" + target + "'");
                }
                throw e;
            }
            try {
                Path linkRealPath2 = link.toRealPath(new LinkOption[0]);
                if (!Intrinsics.areEqual((Object)linkRealPath2, (Object)targetRealPath)) {
                    LOG.error("Symlink/junction '" + link + "' should point to '" + targetRealPath + "', but points to '" + linkRealPath2 + "' instead");
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                throw e;
            }
        }
    }

    private final Path getJbrDirectory(Path root) {
        Path path = this.tryGetMacOsJbrDirectory(root);
        if (path == null && (path = this.tryGetJdkRoot(root)) == null) {
            throw new IllegalStateException(("Unable to detect jdk content directory in path: '" + root + "'").toString());
        }
        return path;
    }

    private final Path tryGetJdkRoot(Path jdkDownload) {
        File file = jdkDownload.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk((File)file, (FileWalkDirection)FileWalkDirection.TOP_DOWN);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            if (!new File(file2, "bin").isDirectory() || !new File(file2, "lib").isDirectory()) continue;
            return file2.toPath();
        }
        return null;
    }

    private final Path tryGetMacOsJbrDirectory(Path root) {
        Object v0;
        block3: {
            if (!SystemInfo.isMac) {
                return null;
            }
            Iterable iterable = PathsKt.listDirectoryEntries$default((Path)root, null, (int)1, null);
            for (Object t : iterable) {
                Path it = (Path)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)PathsKt.getNameWithoutExtension((Path)it), (String)"jbr", (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Path jbrDirectory = v0;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("JBR directory: " + jbrDirectory, t$iv);
        }
        return jbrDirectory;
    }

    public final boolean versionsMatch(@NotNull BuildNumber hostBuildNumber, @NotNull BuildNumber localBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)hostBuildNumber, (String)"hostBuildNumber");
        Intrinsics.checkNotNullParameter((Object)localBuildNumber, (String)"localBuildNumber");
        try {
            if ((localBuildNumber.isSnapshot() || hostBuildNumber.isSnapshot()) && hostBuildNumber.getBaselineVersion() == localBuildNumber.getBaselineVersion()) {
                return true;
            }
            return Intrinsics.areEqual((Object)hostBuildNumber.asStringWithoutProductCode(), (Object)localBuildNumber.asStringWithoutProductCode());
        }
        catch (Throwable t) {
            LOG.error("Error comparing versions " + hostBuildNumber + " and " + localBuildNumber + ": " + t.getMessage(), t);
            return false;
        }
    }

    private final Path addSuffix(Path $this$addSuffix, String suffix) {
        return $this$addSuffix.resolveSibling($this$addSuffix.getFileName() + suffix);
    }

    public final boolean isValidDownloadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return urlAllowedChars.matches((CharSequence)url) && !StringsKt.contains$default((CharSequence)url, (CharSequence)"..", (boolean)false, (int)2, null);
    }

    private static final boolean cwmJbrManifestFilter$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || INSTANCE.isSymlink(it);
    }

    private static final boolean getJetBrainsClientManifestFilter$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || INSTANCE.isSymlink(it);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getJetBrainsClientManifestFilter$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (INSTANCE.isJbrSymlink(it)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return true;
        if (!INSTANCE.isSymlink(it)) return false;
        return true;
    }

    private static final boolean getJetBrainsClientManifestFilter$lambda$2(Function1 $universalFilter, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)".DS_Store") && (Boolean)$universalFilter.invoke((Object)it) != false;
    }

    private static final boolean getJetBrainsClientManifestFilter$lambda$3(Function1 $universalFilter, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.equals((String)PathsKt.getName((Path)it), (String)"Thumbs.db", (boolean)true) && (Boolean)$universalFilter.invoke((Object)it) != false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void downloadFrontendAndJdkImpl$updateStateText(List<DownloadableFileData> dataList, ProgressIndicator $progressIndicator) {
        String string;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = dataList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DownloadableFileData it = (DownloadableFileData)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus().get() == DownloadableFileData.DownloadableFileState.Downloading)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String downloadList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, CodeWithMeClientDownloader::downloadFrontendAndJdkImpl$updateStateText$lambda$2, (int)30, null);
        Iterable $this$filter$iv2 = dataList;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DownloadableFileData it = (DownloadableFileData)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus().get() == DownloadableFileData.DownloadableFileState.Extracting)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String extractList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)", ", null, null, (int)0, null, CodeWithMeClientDownloader::downloadFrontendAndJdkImpl$updateStateText$lambda$4, (int)30, null);
        if (!StringsKt.isBlank((CharSequence)downloadList) && !StringsKt.isBlank((CharSequence)extractList)) {
            var4_4 = new Object[]{downloadList, extractList};
            string = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.downloading.and.extracting", var4_4);
        } else if (!StringsKt.isBlank((CharSequence)downloadList)) {
            var4_4 = new Object[]{downloadList};
            string = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.downloading", var4_4);
        } else if (!StringsKt.isBlank((CharSequence)extractList)) {
            var4_4 = new Object[]{extractList};
            string = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.extracting", var4_4);
        } else {
            string = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.ready", new Object[0]);
        }
        $progressIndicator.setText(string);
    }

    private static final CharSequence downloadFrontendAndJdkImpl$updateStateText$lambda$2(DownloadableFileData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFileCaption();
    }

    private static final CharSequence downloadFrontendAndJdkImpl$updateStateText$lambda$4(DownloadableFileData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFileCaption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadFrontendAndJdkImpl$lambda$5(DownloadableFileData $data, MultipleSubProgressIndicator $dataProgressIndicator, CompletableFuture $future, Path $tempDir, JetBrainsClientDownloadInfo $sessionInfoResponse, List $dataList, ProgressIndicator $progressIndicator) {
        ConcurrentHashMap<Path, CompletableFuture<Boolean>> concurrentHashMap;
        try {
            Object signaturePath;
            CompletableFuture<Boolean> $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$existingDownloadFuture$22;
            concurrentHashMap = currentlyDownloading;
            synchronized (concurrentHashMap) {
                CompletableFuture<Boolean> completableFuture;
                boolean $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$existingDownloadFuture$22 = false;
                CompletableFuture<Boolean> existingDownloadInnerFuture = currentlyDownloading.get($data.getTargetPath());
                if (existingDownloadInnerFuture != null) {
                    completableFuture = existingDownloadInnerFuture;
                } else {
                    ((Map)currentlyDownloading).put($data.getTargetPath(), $data.getDownloadFuture());
                    completableFuture = null;
                }
                $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$existingDownloadFuture$22 = completableFuture;
            }
            CompletableFuture<Boolean> existingDownloadFuture = $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$existingDownloadFuture$22;
            if (existingDownloadFuture != null) {
                LOG.warn("Already downloading and extracting to " + $data.getTargetPath() + ", will wait until download finished");
                existingDownloadFuture.whenComplete((arg_0, arg_1) -> CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$2((arg_0, arg_1) -> CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$1($future, arg_0, arg_1), arg_0, arg_1));
                return;
            }
            if (INSTANCE.isAlreadyDownloaded($data)) {
                LOG.info("Already downloaded and extracted " + $data.getFileCaption() + " to " + $data.getTargetPath());
                $data.getStatus().set(DownloadableFileData.DownloadableFileState.Done);
                $dataProgressIndicator.setFraction(1.0);
                CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$updateStateText($dataList, $progressIndicator);
                $future.complete(true);
                return;
            }
            ProgressIndicator downloadingDataProgressIndicator = SubProgressIndicatorKt.createSubProgress((ProgressIndicator)$dataProgressIndicator, 0.5);
            try {
                CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$download(downloadingDataProgressIndicator, $data.getUrl(), $data.getArchivePath());
                LOG.info("Signature verification is " + (INSTANCE.getConfig().getVerifySignature() ? "ON" : "OFF"));
                if (INSTANCE.getConfig().getVerifySignature()) {
                    Path pgpKeyRingFile = Files.createTempFile($tempDir, "KEYS", "", new FileAttribute[0]);
                    String string = $sessionInfoResponse.getDownloadPgpPublicKeyUrl();
                    if (string == null) {
                        string = "https://download.jetbrains.com/KEYS";
                    }
                    URI uRI = new URI(string);
                    Intrinsics.checkNotNull((Object)pgpKeyRingFile);
                    CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$download(downloadingDataProgressIndicator, uRI, pgpKeyRingFile);
                    Path checksumPath = INSTANCE.addSuffix($data.getArchivePath(), SHA256_SUFFIX);
                    signaturePath = INSTANCE.addSuffix($data.getArchivePath(), SHA256_ASC_SUFFIX);
                    URI uRI2 = UrlUtilKt.addPathSuffix($data.getUrl(), SHA256_SUFFIX);
                    Intrinsics.checkNotNull((Object)checksumPath);
                    CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$download(downloadingDataProgressIndicator, uRI2, checksumPath);
                    URI uRI3 = UrlUtilKt.addPathSuffix($data.getUrl(), SHA256_ASC_SUFFIX);
                    Intrinsics.checkNotNull((Object)signaturePath);
                    CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$lambda$5$download(downloadingDataProgressIndicator, uRI3, (Path)signaturePath);
                    PgpSignaturesVerifier pgpVerifier2 = new PgpSignaturesVerifier(new PgpSignaturesVerifierLogger($data){
                        final /* synthetic */ DownloadableFileData $data;
                        {
                            this.$data = $data;
                        }

                        public void info(String message) {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            CodeWithMeClientDownloader.access$getLOG$p().info("Verifying " + this.$data.getUrl() + " PGP signature: " + message);
                        }
                    });
                    LOG.info("Running checksum signature verifier for " + $data.getArchivePath());
                    Sha256ChecksumSignatureVerifier sha256ChecksumSignatureVerifier = new Sha256ChecksumSignatureVerifier(pgpVerifier2);
                    Path path = $data.getArchivePath();
                    String string2 = $data.getUrl().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    String string3 = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
                    InputStream inputStream = new ByteArrayInputStream(Files.readAllBytes(pgpKeyRingFile));
                    String string4 = JetBrainsPgpConstants.INSTANCE.getJETBRAINS_DOWNLOADS_PGP_MASTER_PUBLIC_KEY();
                    byte[] byArray = string4.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    sha256ChecksumSignatureVerifier.verifyChecksumAndSignature(path, (Path)signaturePath, checksumPath, string3, inputStream, (InputStream)new ByteArrayInputStream(byArray));
                    LOG.info("Signature verified for " + $data.getArchivePath());
                }
            }
            catch (IOException ex) {
                $future.completeExceptionally(ex);
                LOG.warn((Throwable)ex);
                signaturePath = currentlyDownloading;
                synchronized (signaturePath) {
                    boolean bl = false;
                    CompletableFuture<Boolean> completableFuture = currentlyDownloading.remove($data.getTargetPath());
                }
                return;
            }
            $dataProgressIndicator.setFraction(0.75);
            $data.getStatus().set(DownloadableFileData.DownloadableFileState.Extracting);
            CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$updateStateText($dataList, $progressIndicator);
            Path archivePath = $data.getArchivePath();
            LOG.info("Extracting " + archivePath + " to " + $data.getTargetPath() + "...");
            FileUtil.delete((Path)$data.getTargetPath());
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists($data.getTargetPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$42 = false;
                String $i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$42 = "Target path \"" + $data.getTargetPath() + "\" for " + archivePath + " already exists";
                throw new IllegalArgumentException($i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$42.toString());
            }
            FileManifestUtil.INSTANCE.decompressWithManifest(archivePath, $data.getTargetPath(), INSTANCE.getConfig().getModifiedDateInManifestIncluded(), $data.getIncludeInManifest(), SubProgressIndicatorKt.createSubProgress((ProgressIndicator)$dataProgressIndicator, 0.25));
            if (!FileManifestUtil.INSTANCE.isUpToDate($data.getTargetPath(), INSTANCE.getConfig().getModifiedDateInManifestIncluded(), $data.getIncludeInManifest())) {
                boolean $i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$52 = false;
                String $i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$52 = "Manifest verification failed for archive: " + archivePath + " -> " + $data.getTargetPath();
                throw new IllegalArgumentException($i$a$-require-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$52.toString());
            }
            $dataProgressIndicator.setFraction(1.0);
            $data.getStatus().set(DownloadableFileData.DownloadableFileState.Done);
            CodeWithMeClientDownloader.downloadFrontendAndJdkImpl$updateStateText($dataList, $progressIndicator);
            Files.delete(archivePath);
            $future.complete(true);
        }
        catch (Throwable e) {
            $future.completeExceptionally(e);
            LOG.warn(e);
        }
        finally {
            concurrentHashMap = currentlyDownloading;
            synchronized (concurrentHashMap) {
                boolean $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$52 = false;
                CompletableFuture<Boolean> $i$a$-synchronized-CodeWithMeClientDownloader$downloadFrontendAndJdkImpl$1$52 = currentlyDownloading.remove($data.getTargetPath());
            }
        }
    }

    private static final Unit downloadFrontendAndJdkImpl$lambda$5$1(CompletableFuture $future, Boolean res, Throwable ex) {
        boolean bl = ex != null ? $future.completeExceptionally(ex) : $future.complete(res);
        return Unit.INSTANCE;
    }

    private static final void downloadFrontendAndJdkImpl$lambda$5$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void downloadFrontendAndJdkImpl$lambda$5$download(ProgressIndicator downloadingDataProgressIndicator, URI url, Path path) {
        INSTANCE.downloadWithRetries(url, path, downloadingDataProgressIndicator);
    }

    private static final CharSequence findInInstallation$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final boolean findLauncherUnderCwmGuestRoot$lambda$0(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null) && file.isDirectory();
    }

    private static final void runJetBrainsClientProcess$lambda$0(int $STILL_ACTIVE, WinNT.HANDLE $hProcess, LifetimeDefinition $processLifetimeDef) {
        IntByReference exitCode = new IntByReference($STILL_ACTIVE);
        while (exitCode.getValue() == $STILL_ACTIVE) {
            Kernel32.INSTANCE.GetExitCodeProcess($hProcess, exitCode);
            Thread.sleep(1000L);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)$processLifetimeDef, (boolean)false, (int)1, null);
    }

    private static final Unit runJetBrainsClientProcess$lambda$1(WinNT.HANDLE $hProcess, int $STILL_ACTIVE) {
        IntByReference exitCode = new IntByReference(-1);
        Kernel32.INSTANCE.GetExitCodeProcess($hProcess, exitCode);
        if (exitCode.getValue() != $STILL_ACTIVE) {
            return Unit.INSTANCE;
        }
        LOG.info("Terminating cwm guest process");
        if (!Kernel32.INSTANCE.TerminateProcess($hProcess, 1)) {
            int error = Kernel32.INSTANCE.GetLastError();
            WinNT.HRESULT hResult = new WinNT.HRESULT(error);
            String string = "0x%x";
            Object[] objectArray = new Object[]{hResult};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            LOG.error("Failed to terminate cwm guest process, HRESULT=" + string2);
        }
        return Unit.INSTANCE;
    }

    private static final void runJetBrainsClientProcess$doRunProcess(JetBrainsClientLauncherData $launcherData, List<String> parameters, Map<String, String> clientEnvironment, Ref.IntRef attemptCount, Ref.LongRef lastProcessStartTime, Lifetime $lifetime, LifetimeDefinition processLifetimeDef) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)$launcherData.getCommandLine(), (Iterable)parameters)).withEnvironment(clientEnvironment);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        INSTANCE.getConfig().modifyClientCommandLine(commandLine);
        LOG.info("Starting JetBrains Client process (attempts left: " + attemptCount.element + "): " + commandLine);
        int n = attemptCount.element;
        attemptCount.element = n + -1;
        lastProcessStartTime.element = System.currentTimeMillis();
        OSProcessHandler processHandler2 = new OSProcessHandler(commandLine){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        ProcessListener listener2 = new ProcessListener(lastProcessStartTime, $lifetime, attemptCount, processLifetimeDef, $launcherData, parameters, clientEnvironment){
            final /* synthetic */ Ref.LongRef $lastProcessStartTime;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ Ref.IntRef $attemptCount;
            final /* synthetic */ LifetimeDefinition $processLifetimeDef;
            final /* synthetic */ JetBrainsClientLauncherData $launcherData;
            final /* synthetic */ List<String> $parameters;
            final /* synthetic */ Map<String, String> $clientEnvironment;
            {
                this.$lastProcessStartTime = $lastProcessStartTime;
                this.$lifetime = $lifetime;
                this.$attemptCount = $attemptCount;
                this.$processLifetimeDef = $processLifetimeDef;
                this.$launcherData = $launcherData;
                this.$parameters = $parameters;
                this.$clientEnvironment = $clientEnvironment;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                super.onTextAvailable(event, outputType);
                CodeWithMeClientDownloader.access$getLOG$p().info("GUEST OUTPUT: " + event.getText());
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.processTerminated(event);
                CodeWithMeClientDownloader.access$getLOG$p().info("Guest process terminated, exit code " + event.getExitCode());
                if (event.getExitCode() == 0) {
                    ApplicationKt.getApplication().invokeLater(() -> runJetBrainsClientProcess.doRunProcess.listener.1.processTerminated$lambda$0(this.$processLifetimeDef));
                } else if (System.currentTimeMillis() - this.$lastProcessStartTime.element < 10000L && RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                    if (this.$attemptCount.element > 0) {
                        CodeWithMeClientDownloader.access$getLOG$p().info("Previous attempt to start guest process failed, will try again in one second");
                        EdtScheduler edtScheduler = EdtScheduler.Companion.getInstance();
                        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        EdtScheduler.schedule-rnQQ1Ag$default((EdtScheduler)edtScheduler, (long)l, (ModalityState)modalityState, null, () -> runJetBrainsClientProcess.doRunProcess.listener.1.processTerminated$lambda$1(this.$launcherData, this.$parameters, this.$clientEnvironment, this.$attemptCount, this.$lastProcessStartTime, this.$lifetime, this.$processLifetimeDef), (int)4, null);
                    } else {
                        CodeWithMeClientDownloader.access$getLOG$p().warn("Running client process failed after specified number of attempts");
                        ApplicationKt.getApplication().invokeLater(() -> runJetBrainsClientProcess.doRunProcess.listener.1.processTerminated$lambda$2(this.$processLifetimeDef));
                    }
                }
            }

            private static final void processTerminated$lambda$0(LifetimeDefinition $processLifetimeDef) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)$processLifetimeDef, (boolean)false, (int)1, null);
            }

            private static final void processTerminated$lambda$1(JetBrainsClientLauncherData $launcherData, List $parameters, Map $clientEnvironment, Ref.IntRef $attemptCount, Ref.LongRef $lastProcessStartTime, Lifetime $lifetime, LifetimeDefinition $processLifetimeDef) {
                CodeWithMeClientDownloader.access$runJetBrainsClientProcess$doRunProcess($launcherData, $parameters, $clientEnvironment, $attemptCount, $lastProcessStartTime, $lifetime, $processLifetimeDef);
            }

            private static final void processTerminated$lambda$2(LifetimeDefinition $processLifetimeDef) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)$processLifetimeDef, (boolean)false, (int)1, null);
            }
        };
        processHandler2.addProcessListener(listener2);
        processHandler2.startNotify();
        InterfacesKt.fire((ISignal)((ISignal)INSTANCE.getConfig().getClientLaunched()));
        LifetimeExKt.onTerminationOrNow($lifetime, (Function0<Unit>)((Function0)() -> CodeWithMeClientDownloader.runJetBrainsClientProcess$doRunProcess$lambda$2(processHandler2)));
    }

    private static final Unit runJetBrainsClientProcess$doRunProcess$lambda$2(runJetBrainsClientProcess.doRunProcess.processHandler.1 $processHandler) {
        $processHandler.getProcess().children().forEach(arg_0 -> CodeWithMeClientDownloader.runJetBrainsClientProcess$doRunProcess$lambda$2$1(CodeWithMeClientDownloader::runJetBrainsClientProcess$doRunProcess$lambda$2$0, arg_0));
        $processHandler.getProcess().destroyForcibly();
        return Unit.INSTANCE;
    }

    private static final Unit runJetBrainsClientProcess$doRunProcess$lambda$2$0(ProcessHandle it) {
        it.destroyForcibly();
        return Unit.INSTANCE;
    }

    private static final void runJetBrainsClientProcess$doRunProcess$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$downloadWithRetries(CodeWithMeClientDownloader $this, URI url, Path path, ProgressIndicator progressIndicator) {
        $this.downloadWithRetries(url, path, progressIndicator);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$runJetBrainsClientProcess$doRunProcess(JetBrainsClientLauncherData $launcherData, List parameters, Map clientEnvironment, Ref.IntRef attemptCount, Ref.LongRef lastProcessStartTime, Lifetime $lifetime, LifetimeDefinition processLifetimeDef) {
        CodeWithMeClientDownloader.runJetBrainsClientProcess$doRunProcess($launcherData, parameters, clientEnvironment, attemptCount, lastProcessStartTime, $lifetime, processLifetimeDef);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeClientDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        cwmJbrManifestFilter = CodeWithMeClientDownloader::cwmJbrManifestFilter$lambda$0;
        minimumClientBuildWithBundledJre = new BuildNumber("", 223, 4374);
        currentlyDownloading = new ConcurrentHashMap();
        urlAllowedChars = new Regex("^[._\\-a-zA-Z0-9:/]+$");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002!\"B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData;", "", "fileCaption", "", "url", "Ljava/net/URI;", "archivePath", "Ljava/nio/file/Path;", "targetPath", "includeInManifest", "Lkotlin/Function1;", "", "downloadFuture", "Ljava/util/concurrent/CompletableFuture;", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData$DownloadableFileState;", "<init>", "(Ljava/lang/String;Ljava/net/URI;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicReference;)V", "getFileCaption", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URI;", "getArchivePath", "()Ljava/nio/file/Path;", "getTargetPath", "getIncludeInManifest", "()Lkotlin/jvm/functions/Function1;", "getDownloadFuture", "()Ljava/util/concurrent/CompletableFuture;", "getStatus", "()Ljava/util/concurrent/atomic/AtomicReference;", "toString", "Companion", "DownloadableFileState", "intellij.remoteDev.util"})
    @ApiStatus.Internal
    public static final class DownloadableFileData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String fileCaption;
        @NotNull
        private final URI url;
        @NotNull
        private final Path archivePath;
        @NotNull
        private final Path targetPath;
        @NotNull
        private final Function1<Path, Boolean> includeInManifest;
        @NotNull
        private final CompletableFuture<Boolean> downloadFuture;
        @NotNull
        private final AtomicReference<DownloadableFileState> status;
        @NotNull
        private static final Regex prohibitedFileNameChars = new Regex("[^._\\-a-zA-Z0-9]");

        public DownloadableFileData(@NotNull String fileCaption, @NotNull URI url, @NotNull Path archivePath, @NotNull Path targetPath, @NotNull Function1<? super Path, Boolean> includeInManifest, @NotNull CompletableFuture<Boolean> downloadFuture, @NotNull AtomicReference<DownloadableFileState> status) {
            Intrinsics.checkNotNullParameter((Object)fileCaption, (String)"fileCaption");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
            Intrinsics.checkNotNullParameter(downloadFuture, (String)"downloadFuture");
            Intrinsics.checkNotNullParameter(status, (String)"status");
            this.fileCaption = fileCaption;
            this.url = url;
            this.archivePath = archivePath;
            this.targetPath = targetPath;
            this.includeInManifest = includeInManifest;
            this.downloadFuture = downloadFuture;
            this.status = status;
        }

        public /* synthetic */ DownloadableFileData(String string, URI uRI, Path path, Path path2, Function1 function1, CompletableFuture completableFuture, AtomicReference atomicReference, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                completableFuture = new CompletableFuture<Boolean>();
            }
            if ((n & 0x40) != 0) {
                atomicReference = new AtomicReference<DownloadableFileState>(DownloadableFileState.Downloading);
            }
            this(string, uRI, path, path2, (Function1<? super Path, Boolean>)function1, completableFuture, atomicReference);
        }

        @NotNull
        public final String getFileCaption() {
            return this.fileCaption;
        }

        @NotNull
        public final URI getUrl() {
            return this.url;
        }

        @NotNull
        public final Path getArchivePath() {
            return this.archivePath;
        }

        @NotNull
        public final Path getTargetPath() {
            return this.targetPath;
        }

        @NotNull
        public final Function1<Path, Boolean> getIncludeInManifest() {
            return this.includeInManifest;
        }

        @NotNull
        public final CompletableFuture<Boolean> getDownloadFuture() {
            return this.downloadFuture;
        }

        @NotNull
        public final AtomicReference<DownloadableFileState> getStatus() {
            return this.status;
        }

        @NotNull
        public String toString() {
            return "DownloadableFileData(fileCaption='" + this.fileCaption + "', url=" + this.url + ", archivePath=" + this.archivePath + ", targetPath=" + this.targetPath + ")";
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData$Companion;", "", "<init>", "()V", "prohibitedFileNameChars", "Lkotlin/text/Regex;", "sanitizeFileName", "", "fileName", "build", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData;", "url", "Ljava/net/URI;", "tempDir", "Ljava/nio/file/Path;", "cachesDir", "includeInManifest", "Lkotlin/Function1;", "", "intellij.remoteDev.util"})
        public static final class Companion {
            private Companion() {
            }

            private final String sanitizeFileName(String fileName) {
                return prohibitedFileNameChars.replace((CharSequence)fileName, "_");
            }

            @NotNull
            public final DownloadableFileData build(@NotNull URI url, @NotNull Path tempDir, @NotNull Path cachesDir, @NotNull Function1<? super Path, Boolean> includeInManifest) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
                Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
                Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
                URI urlWithoutFragment = UriUtilKt.withFragment((URI)url, null);
                URI bareUrl = UriUtilKt.withQuery((URI)urlWithoutFragment, null);
                String fileNameFromUrl = this.sanitizeFileName(StringsKt.substringAfterLast$default((String)bareUrl.getPath().toString(), (char)'/', null, (int)2, null));
                String string = StringsKt.take((String)fileNameFromUrl, (int)100);
                String string2 = urlWithoutFragment.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = string2;
                byte[] byArray = string3.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                string3 = DigestUtil.sha256Hex((byte[])byArray);
                int n = 0;
                int n2 = 10;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String fileName = string + "-" + string4;
                Path path = tempDir.resolve(fileName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = cachesDir.resolve(fileName + CodeWithMeClientDownloader.extractDirSuffix);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                return new DownloadableFileData(fileNameFromUrl, url, path, path2, includeInManifest, null, null, 96, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData$DownloadableFileState;", "", "<init>", "(Ljava/lang/String;I)V", "Downloading", "Extracting", "Done", "intellij.remoteDev.util"})
        public static final class DownloadableFileState
        extends Enum<DownloadableFileState> {
            public static final /* enum */ DownloadableFileState Downloading = new DownloadableFileState();
            public static final /* enum */ DownloadableFileState Extracting = new DownloadableFileState();
            public static final /* enum */ DownloadableFileState Done = new DownloadableFileState();
            private static final /* synthetic */ DownloadableFileState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static DownloadableFileState[] values() {
                return (DownloadableFileState[])$VALUES.clone();
            }

            public static DownloadableFileState valueOf(String value) {
                return Enum.valueOf(DownloadableFileState.class, value);
            }

            @NotNull
            public static EnumEntries<DownloadableFileState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = downloadableFileStateArray = new DownloadableFileState[]{DownloadableFileState.Downloading, DownloadableFileState.Extracting, DownloadableFileState.Done};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator;", "Lcom/intellij/remoteDev/util/SubProgressIndicatorBase;", "parent", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFractionChange", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)V", "subFraction", "", "getFraction", "setFraction", "fraction", "Companion", "intellij.remoteDev.util"})
    private static final class MultipleSubProgressIndicator
    extends SubProgressIndicatorBase {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function0<Unit> onFractionChange;
        private double subFraction;

        public MultipleSubProgressIndicator(@NotNull ProgressIndicator parent, @NotNull Function0<Unit> onFractionChange) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(onFractionChange, (String)"onFractionChange");
            super(parent);
            this.onFractionChange = onFractionChange;
        }

        public double getFraction() {
            return this.subFraction;
        }

        public void setFraction(double fraction) {
            this.subFraction = fraction;
            this.onFractionChange.invoke();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator$Companion;", "", "<init>", "()V", "create", "", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator;", "parent", "Lcom/intellij/openapi/progress/ProgressIndicator;", "count", "", "intellij.remoteDev.util"})
        @SourceDebugExtension(value={"SMAP\nCodeWithMeClientDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeClientDownloader.kt\ncom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1078:1\n1#2:1079\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<MultipleSubProgressIndicator> create(@NotNull ProgressIndicator parent, int count) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                List result2 = new ArrayList();
                double parentBaseFraction = parent.getFraction();
                int i = 0;
                if (i <= count) {
                    while (true) {
                        MultipleSubProgressIndicator element = new MultipleSubProgressIndicator(parent, (Function0<Unit>)((Function0)() -> Companion.create$lambda$0(result2, parent, parentBaseFraction, count)));
                        result2.add(element);
                        if (i == count) break;
                        ++i;
                    }
                }
                return result2;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit create$lambda$0(List $result, ProgressIndicator $parent, double $parentBaseFraction, int $count) {
                Iterable iterable = $result;
                double d = 0.0;
                for (Object t : iterable) {
                    void it;
                    MultipleSubProgressIndicator multipleSubProgressIndicator = (MultipleSubProgressIndicator)((Object)t);
                    double d2 = d;
                    boolean bl = false;
                    double d3 = ((MultipleSubProgressIndicator)it).subFraction;
                    d = d2 + d3;
                }
                double subFraction = d;
                $parent.setFraction(Math.min($parentBaseFraction + subFraction * (1.0 / (double)$count), 1.0));
                return Unit.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

