/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.remoteDev.OsRegistryConfigProvider;
import com.intellij.remoteDev.RemoteDevSystemSettings;
import com.intellij.remoteDev.downloader.IntellijClientDownloaderSystemSettings;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.jetbrains.rd.util.reactive.Signal;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/remoteDev/downloader/RealJetBrainsClientDownloaderConfigurationProvider;", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "<init>", "()V", "modifyClientCommandLine", "", "clientCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "clientDownloadUrl", "Ljava/net/URI;", "getClientDownloadUrl", "()Ljava/net/URI;", "jreDownloadUrl", "getJreDownloadUrl", "clientCachesDir", "Ljava/nio/file/Path;", "getClientCachesDir", "()Ljava/nio/file/Path;", "clientVersionManagementEnabled", "", "getClientVersionManagementEnabled", "()Z", "modifiedDateInManifestIncluded", "getModifiedDateInManifestIncluded", "verifySignature", "getVerifySignature", "patchVmOptions", "vmOptionsFile", "connectionUri", "clientLaunched", "Lcom/jetbrains/rd/util/reactive/Signal;", "getClientLaunched", "()Lcom/jetbrains/rd/util/reactive/Signal;", "downloadLatestBuildFromCDNForSnapshotHost", "getDownloadLatestBuildFromCDNForSnapshotHost", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJetBrainsClientDownloaderConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsClientDownloaderConfigurationProvider.kt\ncom/intellij/remoteDev/downloader/RealJetBrainsClientDownloaderConfigurationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
public final class RealJetBrainsClientDownloaderConfigurationProvider
implements JetBrainsClientDownloaderConfigurationProvider {
    @NotNull
    private final Signal<Unit> clientLaunched = new Signal();

    @Override
    public void modifyClientCommandLine(@NotNull GeneralCommandLine clientCommandLine) {
        Intrinsics.checkNotNullParameter((Object)clientCommandLine, (String)"clientCommandLine");
    }

    @Override
    @NotNull
    public URI getClientDownloadUrl() {
        URI uRI;
        String envVar;
        String string = envVar = JetBrainsClientDownloaderConfigurationProvider.Companion.getThinClientDownloadUrlValue();
        if (string != null) {
            String it = string;
            boolean bl = false;
            uRI = new URI(it);
        } else {
            uRI = RemoteDevSystemSettings.INSTANCE.getClientDownloadUrl().getValue();
        }
        return uRI;
    }

    @Override
    @NotNull
    public URI getJreDownloadUrl() {
        return RemoteDevSystemSettings.INSTANCE.getJreDownloadUrl().getValue();
    }

    @Override
    @NotNull
    public Path getClientCachesDir() {
        String envVar = JetBrainsClientDownloaderConfigurationProvider.Companion.getThinClientClientCachesDirValue();
        if (envVar != null) {
            Path path = Paths.get(envVar, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting<String> downloadDestination = IntellijClientDownloaderSystemSettings.INSTANCE.getDownloadDestination();
        if (downloadDestination.getValue() != null) {
            Path path = Paths.get(downloadDestination.getValue(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = Path.of(PathManager.getDefaultSystemPathFor((String)"JetBrainsClientDist"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @Override
    public boolean getClientVersionManagementEnabled() {
        return IntellijClientDownloaderSystemSettings.INSTANCE.isVersionManagementEnabled();
    }

    @Override
    public boolean getModifiedDateInManifestIncluded() {
        return IntellijClientDownloaderSystemSettings.INSTANCE.isModifiedDateInManifestIncluded();
    }

    @Override
    public boolean getVerifySignature() {
        Boolean envVar;
        Boolean bl = envVar = JetBrainsClientDownloaderConfigurationProvider.Companion.getThinClientVerifySignatureValue();
        return bl != null ? bl : true;
    }

    @Override
    public void patchVmOptions(@NotNull Path vmOptionsFile, @NotNull URI connectionUri) {
        Intrinsics.checkNotNullParameter((Object)vmOptionsFile, (String)"vmOptionsFile");
        Intrinsics.checkNotNullParameter((Object)connectionUri, (String)"connectionUri");
    }

    @Override
    @NotNull
    public Signal<Unit> getClientLaunched() {
        return this.clientLaunched;
    }

    @Override
    public boolean getDownloadLatestBuildFromCDNForSnapshotHost() {
        Boolean envVar;
        Boolean bl = envVar = JetBrainsClientDownloaderConfigurationProvider.Companion.getThinClientDownloadLatestBuildFromCDNForSnapshotValue();
        return bl != null ? bl : true;
    }
}

