/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.tests.impl.utils;

import com.intellij.remoteDev.tests.LambdaIdeContext;
import com.intellij.remoteDev.tests.impl.utils.SuspendingSerializableConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0001J(\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/remoteDev/tests/impl/utils/SerializedLambdaLoader;", "", "<init>", "()V", "save", "", "name", "obj", "load", "Lcom/intellij/remoteDev/tests/impl/utils/SuspendingSerializableConsumer;", "T", "Lcom/intellij/remoteDev/tests/LambdaIdeContext;", "stringToDecode", "classLoader", "Ljava/lang/ClassLoader;", "loadObject", "Ljava/io/Serializable;", "ClassLoaderObjectInputStream", "intellij.remoteDev.util"})
@SourceDebugExtension(value={"SMAP\nSerializedLambdaHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializedLambdaHelper.kt\ncom/intellij/remoteDev/tests/impl/utils/SerializedLambdaLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class SerializedLambdaLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String save(@Nullable String name, @NotNull Object obj2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        try {
            Object it;
            AutoCloseable autoCloseable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                it = (ByteArrayOutputStream)autoCloseable;
                boolean bl = false;
                new ObjectOutputStream((OutputStream)it).writeObject(obj2);
                it = Base64.getEncoder().encodeToString(((ByteArrayOutputStream)it).toByteArray());
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            object = it;
            Intrinsics.checkNotNull((Object)object);
        }
        catch (Throwable t) {
            String string;
            String string2 = name;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = " '" + it + "'";
            } else {
                string = null;
            }
            Throwable throwable = t;
            String string3 = "Failed to save/load the lambda" + string + ". Most likely, the current lambda was more complex and so Kotlin compiler decided to generate a more complicated constructor for a wrapper class. Try to add java.io.Serializable, simplify the code, cleanup variables from the closure, copy parameters to the local scope. " + t.getMessage();
            throw new Error(string3, throwable);
        }
        return object;
    }

    @NotNull
    public final <T extends LambdaIdeContext> SuspendingSerializableConsumer<T> load(@NotNull String stringToDecode, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)stringToDecode, (String)"stringToDecode");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Serializable serializable = this.loadObject(stringToDecode, classLoader);
        SuspendingSerializableConsumer suspendingSerializableConsumer = serializable instanceof SuspendingSerializableConsumer ? (SuspendingSerializableConsumer)serializable : null;
        if (suspendingSerializableConsumer == null) {
            throw new IllegalStateException("Failed to load Consumer<T : LambdaIdeContext> from the lambda".toString());
        }
        return suspendingSerializableConsumer;
    }

    public static /* synthetic */ SuspendingSerializableConsumer load$default(SerializedLambdaLoader serializedLambdaLoader, String string, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = serializedLambdaLoader.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
            classLoader = classLoader2;
        }
        return serializedLambdaLoader.load(string, classLoader);
    }

    @NotNull
    public final Serializable loadObject(@NotNull String stringToDecode, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)stringToDecode, (String)"stringToDecode");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        byte[] byArray = Base64.getDecoder().decode(stringToDecode);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray2);
        Class<?> obj2 = new ClassLoaderObjectInputStream(inputStream, classLoader).readObject();
        Serializable serializable = obj2 instanceof Serializable ? (Serializable)obj2 : null;
        if (serializable == null) {
            Class<?> clazz = obj2;
            String string = "Failed to load Serializable object from Base64 payload; object type is " + (clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null);
            throw new IllegalStateException(string.toString());
        }
        return serializable;
    }

    public static /* synthetic */ Serializable loadObject$default(SerializedLambdaLoader serializedLambdaLoader, String string, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = serializedLambdaLoader.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
            classLoader = classLoader2;
        }
        return serializedLambdaLoader.loadObject(string, classLoader);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/remoteDev/tests/impl/utils/SerializedLambdaLoader$ClassLoaderObjectInputStream;", "Ljava/io/ObjectInputStream;", "inputStream", "Ljava/io/InputStream;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/io/InputStream;Ljava/lang/ClassLoader;)V", "resolveClass", "Ljava/lang/Class;", "desc", "Ljava/io/ObjectStreamClass;", "intellij.remoteDev.util"})
    public static final class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        @NotNull
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(@NotNull InputStream inputStream, @NotNull ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        @NotNull
        protected Class<?> resolveClass(@NotNull ObjectStreamClass desc) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Class<?> clazz = Class.forName(desc.getName(), false, this.classLoader);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            return clazz;
        }
    }
}

