/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.openapi.util.BuildNumber;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"getPathSelectorPrefixByProductCode", "", "productCode", "getPathSelectorByBuildNumber", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "PRODUCT_CODES_TO_PREFIXES", "", "intellij.remoteDev.util"})
public final class ProductPathsKt {
    @NotNull
    private static final Map<String, String> PRODUCT_CODES_TO_PREFIXES;

    @Nullable
    public static final String getPathSelectorPrefixByProductCode(@NotNull String productCode) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        return PRODUCT_CODES_TO_PREFIXES.get(productCode);
    }

    @Nullable
    public static final String getPathSelectorByBuildNumber(@NotNull BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        String string = PRODUCT_CODES_TO_PREFIXES.get(buildNumber.getProductCode());
        if (string == null) {
            return null;
        }
        String prefix = string;
        int baseline = buildNumber.getBaselineVersion();
        String majorVersionNumber = "20" + baseline / 10 + "." + baseline % 10;
        return prefix + majorVersionNumber;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IU", (Object)"IntelliJIdea"), TuplesKt.to((Object)"IC", (Object)"IdeaIC"), TuplesKt.to((Object)"IE", (Object)"IdeaIE"), TuplesKt.to((Object)"RM", (Object)"RubyMine"), TuplesKt.to((Object)"PY", (Object)"PyCharm"), TuplesKt.to((Object)"PC", (Object)"PyCharmCE"), TuplesKt.to((Object)"DS", (Object)"DataSpell"), TuplesKt.to((Object)"PE", (Object)"PyCharmEdu"), TuplesKt.to((Object)"PS", (Object)"PhpStorm"), TuplesKt.to((Object)"WS", (Object)"WebStorm"), TuplesKt.to((Object)"OC", (Object)"AppCode"), TuplesKt.to((Object)"CL", (Object)"CLion"), TuplesKt.to((Object)"DB", (Object)"DataGrip"), TuplesKt.to((Object)"RD", (Object)"Rider"), TuplesKt.to((Object)"GO", (Object)"GoLand"), TuplesKt.to((Object)"AI", (Object)"AndroidStudio"), TuplesKt.to((Object)"CWMG", (Object)"CodeWithMeGuest"), TuplesKt.to((Object)"JBC", (Object)"JetBrainsClient"), TuplesKt.to((Object)"RR", (Object)"RustRover")};
        PRODUCT_CODES_TO_PREFIXES = MapsKt.mapOf((Pair[])pairArray);
    }
}

