/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.rpc;

import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.platform.debugger.impl.rpc.XSourcePositionDto;
import com.jetbrains.rider.debugger.shared.rpc.DotNetDebuggerSessionApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=3, xi=48)
@ApiStatus.Internal
public final class DotNetDebuggerSessionApiClientStub
implements DotNetDebuggerSessionApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public DotNetDebuggerSessionApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object runToMethod(@NotNull XDebugSessionId sessionId, @NotNull String type, @NotNull String methodName, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, type, methodName};
        return this.invocationHandler.invoke((Object)"runToMethod", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object setNextStatement(@NotNull XDebugSessionId sessionId, @NotNull XSourcePositionDto position, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, position};
        return this.invocationHandler.invoke((Object)"setNextStatement", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object enableForceWindowActivation(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"enableForceWindowActivation", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object focusTab(@NotNull XDebugSessionId sessionId, @NotNull String tabId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, tabId};
        return this.invocationHandler.invoke((Object)"focusTab", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object selectThreadInParallelStacks(@NotNull XDebugSessionId sessionId, long threadId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, Boxing.boxLong((long)threadId)};
        return this.invocationHandler.invoke((Object)"selectThreadInParallelStacks", (Object)objectArray, $completion);
    }
}

