/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.rpc;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rider.debugger.shared.rpc.DotNetDebuggerSessionDto;
import com.jetbrains.rider.debugger.shared.rpc.DotNetDebuggerSessionState;
import com.jetbrains.rider.debugger.shared.rpc.SharedDotNetDebuggerManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/debugger/shared/rpc/SharedDotNetDebuggerSession;", "", "dto", "Lcom/jetbrains/rider/debugger/shared/rpc/DotNetDebuggerSessionDto;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetbrains/rider/debugger/shared/rpc/DotNetDebuggerSessionDto;Lkotlinx/coroutines/CoroutineScope;)V", "getDto", "()Lcom/jetbrains/rider/debugger/shared/rpc/DotNetDebuggerSessionDto;", "stateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/jetbrains/rider/debugger/shared/rpc/DotNetDebuggerSessionState;", "close", "", "canSetDataBreakpoints", "", "getCanSetDataBreakpoints", "()Z", "canSetNextStatement", "getCanSetNextStatement", "isInitialized", "Companion", "intellij.rider.debugger.shared"})
@ApiStatus.Internal
public final class SharedDotNetDebuggerSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DotNetDebuggerSessionDto dto;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final StateFlow<DotNetDebuggerSessionState> stateFlow;

    public SharedDotNetDebuggerSession(@NotNull DotNetDebuggerSessionDto dto, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.dto = dto;
        this.cs = cs;
        this.stateFlow = FlowKt.stateIn((Flow)this.dto.getStateFlow().toFlow(), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)this.dto.getInitialState());
    }

    @NotNull
    public final DotNetDebuggerSessionDto getDto() {
        return this.dto;
    }

    public final void close() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
    }

    public final boolean getCanSetDataBreakpoints() {
        return ((DotNetDebuggerSessionState)this.stateFlow.getValue()).getCanSetDataBreakpoints();
    }

    public final boolean getCanSetNextStatement() {
        return ((DotNetDebuggerSessionState)this.stateFlow.getValue()).getCanSetNextStatement();
    }

    public final boolean isInitialized() {
        return ((DotNetDebuggerSessionState)this.stateFlow.getValue()).isInitialized();
    }

    @JvmStatic
    @Nullable
    public static final SharedDotNetDebuggerSession findSession(@NotNull AnActionEvent e) {
        return Companion.findSession(e);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/shared/rpc/SharedDotNetDebuggerSession$Companion;", "", "<init>", "()V", "findSession", "Lcom/jetbrains/rider/debugger/shared/rpc/SharedDotNetDebuggerSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider.debugger.shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SharedDotNetDebuggerSession findSession(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            XDebugSessionProxy xDebugSessionProxy = DebuggerUIUtil.getSessionProxy((AnActionEvent)e);
            if (xDebugSessionProxy == null) {
                return null;
            }
            XDebugSessionProxy sessionProxy = xDebugSessionProxy;
            return SharedDotNetDebuggerManager.Companion.getInstance(project2).getDotNetSession(sessionProxy.getId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

