/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.actions.overrides;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.impl.actions.ResumeAction;
import com.jetbrains.rider.debugger.shared.statistics.RiderExceptionPaneStatisticsCollector;
import java.awt.event.KeyEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/debugger/shared/actions/overrides/RiderResumeAction;", "Lcom/intellij/xdebugger/impl/actions/ResumeAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.rider.debugger.shared"})
@SourceDebugExtension(value={"SMAP\nRiderResumeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderResumeAction.kt\ncom/jetbrains/rider/debugger/shared/actions/overrides/RiderResumeAction\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n13#2:62\n13#3:63\n*S KotlinDebug\n*F\n+ 1 RiderResumeAction.kt\ncom/jetbrains/rider/debugger/shared/actions/overrides/RiderResumeAction\n*L\n20#1:62\n20#1:63\n*E\n"})
public final class RiderResumeAction
extends ResumeAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        XDebugSessionProxy currentSessionProxy = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(project2);
        if (currentSessionProxy == null) {
            e.getPresentation().setEnabled(e.getInputEvent() instanceof KeyEvent);
            return;
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        XDebugSessionProxy currentSessionProxy;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"Rider.Debugger.Popup")) {
            RiderExceptionPaneStatisticsCollector.INSTANCE.resumeCalled();
        }
        if ((currentSessionProxy = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(project2)) == null) {
            RunnerAndConfigurationSettings selectedConfiguration;
            logger.info("Current debug session is null");
            List debugSessions = XDebugManagerProxy.Companion.getInstance().getSessions(project2);
            logger.info("List of all active debug sessions: [" + CollectionsKt.joinToString$default((Iterable)debugSessions, (CharSequence)", ", null, null, (int)0, null, RiderResumeAction::actionPerformed$lambda$0, (int)30, null) + "]");
            if (CollectionsKt.any((Iterable)debugSessions)) {
                logger.warn("Several debug sessions available, however, none of it is active");
            }
            if ((selectedConfiguration = RunManager.Companion.getInstance(project2).getSelectedConfiguration()) != null) {
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
                return;
            }
        }
        super.actionPerformed(e);
    }

    private static final CharSequence actionPerformed$lambda$0(XDebugSessionProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSessionName();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderResumeAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderResumeAction.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/debugger/shared/actions/overrides/RiderResumeAction$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.debugger.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

