/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.actions.overrides;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.actions.StepIntoAction;
import com.jetbrains.rider.debugger.shared.RiderDebuggerSharedBundle;
import com.jetbrains.rider.debugger.shared.actions.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.shared.actions.IRiderNoCurrentSessionActionEnabledChecker;
import com.jetbrains.rider.debugger.shared.startupActivities.BreakAtMethodPostStartupActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/shared/actions/overrides/RiderStepIntoAction;", "Lcom/intellij/xdebugger/impl/actions/StepIntoAction;", "Lcom/jetbrains/rider/debugger/shared/actions/IRiderActionEnabledChecker;", "Lcom/jetbrains/rider/debugger/shared/actions/IRiderNoCurrentSessionActionEnabledChecker;", "<init>", "()V", "isEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "", "update", "event", "intellij.rider.debugger.shared"})
public final class RiderStepIntoAction
extends StepIntoAction
implements IRiderActionEnabledChecker,
IRiderNoCurrentSessionActionEnabledChecker {
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.isEnabledAction(e) && super.isEnabled(e) || this.isEnabledActionWithPostStartupActivityCheck(e, BreakAtMethodPostStartupActivity.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.isSessionInProgress(project2)) {
            super.actionPerformed(e);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.runAndBreakAtEntryPoint(project2, dataContext);
    }

    public void update(@NotNull AnActionEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        String presentationText = RiderDebuggerSharedBundle.Companion.message("RiderStepIntoAction.action.step.into.text", new Object[0]);
        if (!this.isEnabled(event)) {
            event.getPresentation().setText(presentationText);
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        boolean hasSession = this.isSessionInProgress(project2);
        Presentation presentation = event.getPresentation();
        if (hasSession) {
            string = presentationText;
        } else {
            Object[] objectArray = new Object[]{presentationText};
            string = RiderDebuggerSharedBundle.Companion.message("action.start.debugging.and.0.text", objectArray);
        }
        presentation.setText(string);
    }
}

