/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.util;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeExecutionStackDescriptor;
import com.jetbrains.rider.debugger.shared.util.JumpToStatementUtilKt;
import com.jetbrains.rider.debugger.shared.values.DotNetExecutionStackDescriptor;
import com.jetbrains.rider.debugger.shared.values.DotNetExecutionStackState;
import com.jetbrains.rider.debugger.shared.values.MethodRange;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\tH\u0002J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/debugger/shared/util/JumpToStatementUtil;", "", "<init>", "()V", "canJumpToStatement", "", "line", "", "dotNetExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getTopFrameMethodRange", "Lcom/jetbrains/rider/debugger/shared/values/MethodRange;", "executeWithLineNumberForceOpenEditor", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "place", "", "executeWithLineNumber", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.debugger.shared"})
public final class JumpToStatementUtil {
    @NotNull
    public static final JumpToStatementUtil INSTANCE = new JumpToStatementUtil();

    private JumpToStatementUtil() {
    }

    public final boolean canJumpToStatement(int line, @NotNull XExecutionStack dotNetExecutionStack, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dotNetExecutionStack, (String)"dotNetExecutionStack");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MethodRange methodRange = this.getTopFrameMethodRange(dotNetExecutionStack);
        if (methodRange == null) {
            return false;
        }
        int backendLine = line + 1;
        MethodRange methodRange2 = methodRange;
        return backendLine >= methodRange2.getStartLine() && backendLine < methodRange2.getEndLine();
    }

    public final boolean canJumpToStatement(@NotNull XSourcePosition sourcePosition, @NotNull XExecutionStack dotNetExecutionStack, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkNotNullParameter((Object)dotNetExecutionStack, (String)"dotNetExecutionStack");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MethodRange methodRange = this.getTopFrameMethodRange(dotNetExecutionStack);
        if (methodRange == null) {
            return false;
        }
        MethodRange methodRange2 = methodRange;
        int backendLine = sourcePosition.getLine() + 1;
        XStackFrame xStackFrame = dotNetExecutionStack.getTopFrame();
        if (!Intrinsics.areEqual((Object)(xStackFrame != null && (xStackFrame = xStackFrame.getSourcePosition()) != null ? xStackFrame.getFile() : null), (Object)sourcePosition.getFile())) {
            return false;
        }
        return backendLine >= methodRange2.getStartLine() && backendLine <= methodRange2.getEndLine();
    }

    private final MethodRange getTopFrameMethodRange(XExecutionStack $this$getTopFrameMethodRange) {
        XDescriptor xDescriptor;
        Object object;
        CompletableFuture completableFuture = $this$getTopFrameMethodRange.getXExecutionStackDescriptorAsync();
        if (completableFuture == null || (completableFuture = (XDescriptor)completableFuture.getNow(null)) == null) {
            return null;
        }
        CompletableFuture descriptor = completableFuture;
        CompletableFuture completableFuture2 = descriptor;
        MethodRange methodRange = completableFuture2 instanceof DotNetExecutionStackDescriptor ? ((DotNetExecutionStackDescriptor)((Object)descriptor)).getInitialState().getTopFrameMethodRange() : (completableFuture2 instanceof XMixedModeExecutionStackDescriptor ? ((object = (xDescriptor = ((XMixedModeExecutionStackDescriptor)descriptor).getHighStackDescriptor()) instanceof DotNetExecutionStackDescriptor ? (DotNetExecutionStackDescriptor)xDescriptor : null) != null && (object = ((DotNetExecutionStackDescriptor)object).getInitialState()) != null ? ((DotNetExecutionStackState)object).getTopFrameMethodRange() : null) : null);
        return methodRange;
    }

    @VisibleForTesting
    public final boolean executeWithLineNumberForceOpenEditor(@NotNull VirtualFile file, @NotNull Project project, @NotNull String place, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = fileEditorManager.getSelectedEditor(file);
        if (fileEditor == null) {
            JumpToStatementUtilKt.access$getLogger$p().warn("Editor for file '" + file + "' was not opened");
            List list = fileEditorManager.openFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"openFile(...)");
            fileEditor = (FileEditor)CollectionsKt.firstOrNull((List)list);
        }
        return this.executeWithLineNumber(fileEditor, file, place, line);
    }

    public final boolean executeWithLineNumber(@NotNull VirtualFile file, @NotNull Project project, @NotNull String place, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        return this.executeWithLineNumber(fileEditor, file, place, line);
    }

    private final boolean executeWithLineNumber(FileEditor fileEditor, VirtualFile file, String place, int line) {
        if (fileEditor == null) {
            JumpToStatementUtilKt.access$getLogger$p().warn("Unable to get file editor for file '" + file + "'");
            return false;
        }
        if (!(fileEditor instanceof TextEditor)) {
            JumpToStatementUtilKt.access$getLogger$p().warn("File editor for file " + file + " is not a " + TextEditor.class.getSimpleName() + " (actual type is " + fileEditor.getClass().getSimpleName() + ")");
            return false;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        return this.executeWithLineNumber(editor, place, line);
    }

    public final boolean executeWithLineNumber(@NotNull Editor editor, @NotNull String place, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        AnAction action = ActionManager.getInstance().getAction("JumpToStatement");
        if (action == null) {
            JumpToStatementUtilKt.access$getLogger$p().error("Action JumpToStatement is not available");
        }
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)place, null, arg_0 -> JumpToStatementUtil.executeWithLineNumber$lambda$0(editor, line, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        action.update(anActionEvent2);
        if (!anActionEvent2.getPresentation().isEnabled()) {
            JumpToStatementUtilKt.access$getLogger$p().warn("Action JumpToStatement is not available");
            return false;
        }
        Intrinsics.checkNotNull((Object)action);
        ActionUtil.performAction((AnAction)action, (AnActionEvent)anActionEvent2);
        return true;
    }

    private static final Object executeWithLineNumber$lambda$0(Editor $editor, int $line, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (CommonDataKeys.PROJECT.is(it)) {
            return $editor.getProject();
        }
        if (CommonDataKeys.EDITOR.is(it)) {
            return $editor;
        }
        if (XDebuggerUtilImpl.LINE_NUMBER.is(it)) {
            return $line;
        }
        return null;
    }
}

