/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.shared.util;

import com.intellij.execution.runners.BackendExecutionEnvironmentProxy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rider.debugger.shared.rpc.SharedDotNetDebuggerSession;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\t"}, d2={"isDebuggerActionEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isWasmClientProfile", "getCurrentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getEnvironmentProxy", "Lcom/intellij/execution/runners/ExecutionEnvironmentProxy;", "intellij.rider.debugger.shared"})
public final class RiderDebuggerActionEnabledUtilsKt {
    public static final boolean isDebuggerActionEnabled(@Nullable AnActionEvent e) {
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null) {
            return true;
        }
        SharedDotNetDebuggerSession sharedDotNetDebuggerSession = SharedDotNetDebuggerSession.Companion.findSession(anActionEvent);
        if (sharedDotNetDebuggerSession == null) {
            return true;
        }
        SharedDotNetDebuggerSession dotNetDebuggerSession = sharedDotNetDebuggerSession;
        return dotNetDebuggerSession.isInitialized();
    }

    public static final boolean isWasmClientProfile(@Nullable AnActionEvent e) {
        if (e == null) {
            return false;
        }
        ExecutionEnvironmentProxy executionEnvironmentProxy = RiderDebuggerActionEnabledUtilsKt.getEnvironmentProxy(e);
        if (executionEnvironmentProxy == null) {
            return false;
        }
        ExecutionEnvironmentProxy environmentProxy = executionEnvironmentProxy;
        return Intrinsics.areEqual((Object)environmentProxy.getRunConfigurationTypeId(), (Object)"WasmClient");
    }

    @Nullable
    public static final XDebugSession getCurrentSession(@Nullable AnActionEvent e) {
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null || (anActionEvent = anActionEvent.getProject()) == null) {
            return null;
        }
        AnActionEvent project = anActionEvent;
        return XDebuggerManager.getInstance((Project)project).getCurrentSession();
    }

    private static final ExecutionEnvironmentProxy getEnvironmentProxy(AnActionEvent e) {
        RunContentManager runContentManager;
        Project project;
        ExecutionEnvironmentProxy proxyFromContext = (ExecutionEnvironmentProxy)e.getData(RunTab.EXECUTION_ENVIRONMENT_PROXY);
        if (proxyFromContext != null) {
            return proxyFromContext;
        }
        ExecutionEnvironment environmentFromContext = (ExecutionEnvironment)e.getData(ExecutionDataKeys.EXECUTION_ENVIRONMENT);
        if (environmentFromContext != null) {
            return (ExecutionEnvironmentProxy)new BackendExecutionEnvironmentProxy(environmentFromContext);
        }
        Project project2 = project = e.getProject();
        Object object = runContentManager = project2 == null ? null : RunContentManager.getInstanceIfCreated((Project)project2);
        if (runContentManager == null) {
            return null;
        }
        RunContentDescriptor contentDescriptor = runContentManager.getSelectedContent();
        if (contentDescriptor == null) {
            return null;
        }
        Component component = contentDescriptor.getComponent();
        if (component == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext componentDataContext = dataContext;
        ExecutionEnvironmentProxy proxyFromSelectedContent = (ExecutionEnvironmentProxy)RunTab.EXECUTION_ENVIRONMENT_PROXY.getData(componentDataContext);
        if (proxyFromSelectedContent != null) {
            return proxyFromSelectedContent;
        }
        ExecutionEnvironment environmentFromSelectedContent = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(componentDataContext);
        if (environmentFromSelectedContent != null) {
            return (ExecutionEnvironmentProxy)new BackendExecutionEnvironmentProxy(environmentFromSelectedContent);
        }
        return null;
    }
}

