/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientAppSessionImpl;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendClientAppSession;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendLauncherKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendManagerKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolHost;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.ReSharperBackendLauncher;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolHost;
import com.jetbrains.rider.protocol.ProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0005J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher;", "", "<init>", "()V", "createLightweightBackendWithSolution", "Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolHost;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "fullBackendProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "createOrGetLightweightBackend", "lightweightBackendEnabledLifetime", "projectSession", "initializeLightweightProtocolManagerIfNeeded", "", "getLightweightBackends", "", "numberOfRunningLightweightBackends", "", "forceShutdownAllLightweightBackends", "tryGetFreeLightweightBackend", "createLightweightBackend", "fullBackendAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "subscribeForSettings", "lightweightBackendProtocolHost", "initializeSolution", "protocolHost", "project", "Lcom/intellij/openapi/project/Project;", "releaseSolution", "isLightweightProtocolManagerCreated", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "application", "Lcom/intellij/openapi/application/Application;", "Companion", "RiderLightweightBackendProtocolManagerFactory", "intellij.rider.lightweightBackend"})
@SourceDebugExtension(value={"SMAP\nRiderLightweightBackendLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendLauncher.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n13#2:168\n13#2:169\n13#2:174\n1586#3:170\n1661#3,3:171\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendLauncher.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher\n*L\n41#1:168\n49#1:169\n153#1:174\n92#1:170\n92#1:171,3\n*E\n"})
public final class RiderLightweightBackendLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final RiderLightweightBackendProtocolManagerFactory lightweightBackendProtocolManagerFactory = new RiderLightweightBackendProtocolManagerFactory();

    @Nullable
    public final RiderLightweightBackendProtocolHost createLightweightBackendWithSolution(@NotNull Lifetime lifetime, @NotNull ClientProjectSession fullBackendProjectSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)fullBackendProjectSession, (String)"fullBackendProjectSession");
        if (!RiderLightweightBackendManagerKt.isLightweightBackendEnabled()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RiderLightweightBackendLauncher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Lightweight backend is not enabled, cannot launch");
            return null;
        }
        IProtocolHostWithBackend iProtocolHostWithBackend = RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).createAndAttach(fullBackendProjectSession.getProject(), lifetime);
        Intrinsics.checkNotNull((Object)iProtocolHostWithBackend, (String)"null cannot be cast to non-null type com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolHost");
        RiderLightweightBackendProtocolHost lightweightBackendProtocolHost = (RiderLightweightBackendProtocolHost)iProtocolHostWithBackend;
        RiderLightweightBackendLauncherKt.access$getLogger$p().info("Lightweight backend for '" + fullBackendProjectSession.getProject().getName() + "' was launched");
        ClientAppSessionImpl lightweightAppSession = lightweightBackendProtocolHost.getSession();
        if (!(lightweightAppSession instanceof RiderLightweightBackendClientAppSession)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RiderLightweightBackendLauncher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Lightweight session is not " + Reflection.getOrCreateKotlinClass(RiderLightweightBackendClientAppSession.class).getSimpleName());
            return null;
        }
        this.subscribeForSettings(lightweightBackendProtocolHost, fullBackendProjectSession.getAppSession(), lifetime);
        return lightweightBackendProtocolHost;
    }

    @NotNull
    public final RiderLightweightBackendProtocolHost createOrGetLightweightBackend(@NotNull Lifetime lightweightBackendEnabledLifetime, @NotNull ClientProjectSession projectSession) {
        RiderLightweightBackendProtocolHost riderLightweightBackendProtocolHost;
        Intrinsics.checkNotNullParameter((Object)lightweightBackendEnabledLifetime, (String)"lightweightBackendEnabledLifetime");
        Intrinsics.checkNotNullParameter((Object)projectSession, (String)"projectSession");
        RiderLightweightBackendProtocolHost freeLightweightBackend = this.tryGetFreeLightweightBackend();
        RiderLightweightBackendLauncherKt.access$getLogger$p().info("Trying to get free lightweight backend for project '" + projectSession.getProject().getName() + "'..");
        if (freeLightweightBackend != null) {
            RiderLightweightBackendLauncherKt.access$getLogger$p().info("Found free lightweight backend without solution. Initializing it for '" + projectSession.getProject().getName() + "' project..");
            this.initializeSolution(freeLightweightBackend, projectSession.getProject());
            riderLightweightBackendProtocolHost = freeLightweightBackend;
        } else {
            RiderLightweightBackendLauncherKt.access$getLogger$p().info("No free lightweight backend found for project '" + projectSession.getProject().getName() + "'. Creating new one..");
            RiderLightweightBackendProtocolHost riderLightweightBackendProtocolHost2 = this.createLightweightBackendWithSolution(lightweightBackendEnabledLifetime, projectSession);
            riderLightweightBackendProtocolHost = riderLightweightBackendProtocolHost2;
            Intrinsics.checkNotNull((Object)((Object)riderLightweightBackendProtocolHost2));
        }
        RiderLightweightBackendProtocolHost lightweightBackendHost = riderLightweightBackendProtocolHost;
        return lightweightBackendHost;
    }

    public final void initializeLightweightProtocolManagerIfNeeded() {
        if (this.isLightweightProtocolManagerCreated(ApplicationKt.getApplication()) != null) {
            RiderLightweightBackendLauncherKt.access$getLogger$p().info("Lightweight protocol manager is already created, skipping initialization");
            return;
        }
        RiderLightweightBackendLauncherKt.access$getLogger$p().info("Initializing lightweight protocol manager");
        ReSharperBackendLauncher reSharperBackendLauncher = new ReSharperBackendLauncher();
        Application application = ApplicationKt.getApplication();
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        reSharperBackendLauncher.launchReSharperBackend(application, path, new ReSharperBackendLauncher.ProtocolLauncherHelper(RiderLightweightBackendLauncherKt.access$getLightweightProtocolManagerKey$p(), (ReSharperBackendLauncher.ProtocolManagerFactory)lightweightBackendProtocolManagerFactory));
        RiderLightweightBackendLauncherKt.access$getLogger$p().info("Finished initializing lightweight protocol manager");
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<RiderLightweightBackendProtocolHost> getLightweightBackends() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).getProtocolHosts()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IProtocolHostWithBackend iProtocolHostWithBackend = (IProtocolHostWithBackend)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolHost");
            collection.add((RiderLightweightBackendProtocolHost)it);
        }
        return (List)destination$iv$iv;
    }

    public final int numberOfRunningLightweightBackends() {
        return RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).getProtocolHosts().size();
    }

    public final void forceShutdownAllLightweightBackends() {
        RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).forceShutdown();
        RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).getProtocolHosts().clear();
    }

    @Nullable
    public final RiderLightweightBackendProtocolHost tryGetFreeLightweightBackend() {
        IProtocolHost iProtocolHost = RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).getFreeProtocolHost();
        return iProtocolHost instanceof RiderLightweightBackendProtocolHost ? (RiderLightweightBackendProtocolHost)iProtocolHost : null;
    }

    @NotNull
    public final RiderLightweightBackendProtocolHost createLightweightBackend(@NotNull Lifetime lifetime, @NotNull ClientAppSession fullBackendAppSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)fullBackendAppSession, (String)"fullBackendAppSession");
        ProtocolHost protocolHost = RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).create(lifetime);
        Intrinsics.checkNotNull((Object)protocolHost, (String)"null cannot be cast to non-null type com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolHost");
        RiderLightweightBackendProtocolHost lightweightBackendProtocolHost = (RiderLightweightBackendProtocolHost)protocolHost;
        this.subscribeForSettings(lightweightBackendProtocolHost, fullBackendAppSession, lifetime);
        return lightweightBackendProtocolHost;
    }

    private final void subscribeForSettings(RiderLightweightBackendProtocolHost lightweightBackendProtocolHost, ClientAppSession fullBackendAppSession, Lifetime lifetime) {
    }

    public final void initializeSolution(@NotNull RiderLightweightBackendProtocolHost protocolHost, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocolHost), (String)"protocolHost");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project currentLightweightBackendProject = (Project)protocolHost.getProject().getValue();
        if (currentLightweightBackendProject != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RiderLightweightBackendLauncher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Lightweight backend already has '" + currentLightweightBackendProject + "' attached project, cannot initialize solution");
            return;
        }
        RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).attachProjectToProtocolHost((ProtocolHostWithBackend)protocolHost, project);
    }

    public final void releaseSolution(@NotNull RiderLightweightBackendProtocolHost protocolHost) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocolHost), (String)"protocolHost");
        RiderLightweightBackendLauncherKt.access$getLightweightProtocolManager(ApplicationKt.getApplication()).release((IProtocolHostWithBackend)protocolHost);
    }

    private final ProtocolManager isLightweightProtocolManagerCreated(Application application) {
        return (ProtocolManager)application.getUserData(RiderLightweightBackendLauncherKt.access$getLightweightProtocolManagerKey$p());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher;", "lightweightBackendProtocolManagerFactory", "Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher$RiderLightweightBackendProtocolManagerFactory;", "intellij.rider.lightweightBackend"})
    @SourceDebugExtension(value={"SMAP\nRiderLightweightBackendLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendLauncher.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,167:1\n16#2,2:168\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendLauncher.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher$Companion\n*L\n35#1:168,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderLightweightBackendLauncher getInstance() {
            ComponentManager $this$getService$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(RiderLightweightBackendLauncher.class);
            if (object == null) {
                throw new IllegalStateException("Service " + RiderLightweightBackendLauncher.class + " not found in container " + $this$getService$iv);
            }
            return (RiderLightweightBackendLauncher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendLauncher$RiderLightweightBackendProtocolManagerFactory;", "Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;", "<init>", "()V", "createProtocolManager", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "application", "Lcom/intellij/openapi/application/Application;", "componentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.lightweightBackend"})
    public static class RiderLightweightBackendProtocolManagerFactory
    extends ReSharperBackendLauncher.ProtocolManagerFactory {
        @NotNull
        public ProtocolManager createProtocolManager(@NotNull Application application, @NotNull Lifetime componentLifetime) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)componentLifetime, (String)"componentLifetime");
            return new RiderLightweightBackendProtocolManager(application, componentLifetime);
        }
    }
}

