/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendLauncher;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolHost;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendSolutionInitializerKt;
import com.jetbrains.rd.ide.model.RdOpenSolution;
import com.jetbrains.rd.ide.model.RdSolutionDescription;
import com.jetbrains.rd.ide.model.RdSolutionOpenStrategy;
import com.jetbrains.rd.ide.model.RdVirtualSolution;
import com.jetbrains.rd.ide.model.RiderLightweightBackendSolutionExtension;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SolutionModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.ijent.extensions.PathExtKt;
import com.jetbrains.rider.projectView.SolutionDescriptionFactory;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.SolutionInitializerService;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializer;", "", "<init>", "()V", "initializeSolutionModel", "Lkotlin/Pair;", "Lcom/jetbrains/rd/ide/model/Solution;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "fullBackendProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "lightweightBackend", "Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolHost;", "lightweightSolutionModel", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "Companion", "intellij.rider.lightweightBackend"})
public final class RiderLightweightBackendSolutionInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AtomicInteger idFactory = new AtomicInteger(0);
    @NotNull
    private static final Key<SolutionInitializerService.SolutionKey> lightweightSolutionKey = new Key("LightweightSolutionKey");

    @NotNull
    public final Pair<Solution, Lifetime> initializeSolutionModel(@NotNull ClientProjectSession fullBackendProjectSession, @NotNull RiderLightweightBackendProtocolHost lightweightBackend, @NotNull SolutionModel lightweightSolutionModel) {
        Intrinsics.checkNotNullParameter((Object)fullBackendProjectSession, (String)"fullBackendProjectSession");
        Intrinsics.checkNotNullParameter((Object)((Object)lightweightBackend), (String)"lightweightBackend");
        Intrinsics.checkNotNullParameter((Object)lightweightSolutionModel, (String)"lightweightSolutionModel");
        try {
            RiderLightweightBackendSolutionExtension riderLightweightBackendSolutionExtension;
            RiderLightweightBackendSolutionInitializerKt.access$getLogger$p().info("Initializing lightweight solution model...");
            int count = ((Map)lightweightSolutionModel.getSolutions()).size();
            if (count > 0) {
                RiderLightweightBackendSolutionInitializerKt.access$getLogger$p().info("Lightweight backend has '" + count + "' solutions in its solution model, but expected to have none. Removing them from model..");
                lightweightSolutionModel.getSolutions().clear();
            }
            RdVirtualSolution lightweightFakeSolutionDescription = SolutionDescriptionFactory.INSTANCE.virtual("", CollectionsKt.emptyList());
            RdOpenSolution lightweightBackendStrategy = new RdOpenSolution((RdSolutionDescription)lightweightFakeSolutionDescription, true);
            Project project = fullBackendProjectSession.getProject();
            File solutionDirectory = SolutionHostExtensionsKt.getSolutionDirectory((Project)project);
            File solutionFile = SolutionHostExtensionsKt.getSolutionFile((Project)project);
            RiderLightweightBackendSolutionExtension it = riderLightweightBackendSolutionExtension = new RiderLightweightBackendSolutionExtension();
            boolean bl = false;
            it.getFullBackendSolutionDirectory().set((Object)PathExtKt.toRd((File)solutionDirectory));
            it.getFullBackendSolutionFileLocation().set((Object)PathExtKt.toRd((File)solutionFile));
            RiderLightweightBackendSolutionExtension extension = riderLightweightBackendSolutionExtension;
            Solution solution = new Solution(ProjectUtilKt.getOrCreateRdProjectId((Project)project), (RdSolutionOpenStrategy)lightweightBackendStrategy, CollectionsKt.listOf((Object)extension));
            LifetimeDefinition lightweightSolutionLifetime = RLifetimeKt.defineIntersection((Lifetime)lightweightBackend.getLifetime(), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)fullBackendProjectSession)));
            CollectionExKt.put((Map)((Map)lightweightSolutionModel.getSolutions()), (Lifetime)((Lifetime)lightweightSolutionLifetime), (Object)idFactory.incrementAndGet(), (Object)solution);
            UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)fullBackendProjectSession)).onTermination(() -> RiderLightweightBackendSolutionInitializer.initializeSolutionModel$lambda$1(lightweightBackend));
            RiderLightweightBackendSolutionInitializerKt.access$getLogger$p().info("Finished initializing lightweight solution model..");
            return new Pair((Object)solution, (Object)lightweightSolutionLifetime);
        }
        catch (Exception ex) {
            RiderLightweightBackendSolutionInitializerKt.access$getLogger$p().error((Throwable)ex);
            if (lightweightBackend.isProjectAttached()) {
                RiderLightweightBackendLauncher.Companion.getInstance().releaseSolution(lightweightBackend);
            }
            fullBackendProjectSession.getProject().putUserData(lightweightSolutionKey, (Object)new SolutionInitializerService.SolutionKey(null));
            throw ex;
        }
    }

    private static final Unit initializeSolutionModel$lambda$1(RiderLightweightBackendProtocolHost $lightweightBackend) {
        RiderLightweightBackendLauncher.Companion.getInstance().releaseSolution($lightweightBackend);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializer$Companion;", "", "<init>", "()V", "idFactory", "Ljava/util/concurrent/atomic/AtomicInteger;", "lightweightSolutionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/projectView/SolutionInitializerService$SolutionKey;", "getLightweightSolutionKey", "()Lcom/intellij/openapi/util/Key;", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<SolutionInitializerService.SolutionKey> getLightweightSolutionKey() {
            return lightweightSolutionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

