/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.remote.RemoteFile;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfoKt;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0003H\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/PathInfo;", "", "path", "", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/CPUKind;)V", "getPath", "()Ljava/lang/String;", "getCpuKind", "()Lcom/jetbrains/rider/CPUKind;", "sftpPath", "getSftpPath", "appendPath", "folders", "", "([Ljava/lang/String;)Lcom/jetbrains/rider/PathInfo;", "transformPathToSftp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
public final class PathInfo {
    @NotNull
    private final String path;
    @NotNull
    private final CPUKind cpuKind;
    @NotNull
    private final String sftpPath;

    public PathInfo(@NotNull String path, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        this.path = path;
        this.cpuKind = cpuKind;
        this.sftpPath = this.transformPathToSftp();
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final CPUKind getCpuKind() {
        return this.cpuKind;
    }

    @NotNull
    public final String getSftpPath() {
        return this.sftpPath;
    }

    @NotNull
    public final PathInfo appendPath(String ... folders) {
        Intrinsics.checkNotNullParameter((Object)folders, (String)"folders");
        RemoteFile remoteFile = RemoteFile.createRemoteFile((String)this.path, (this.cpuKind.getOsKind() == OSKind.Windows ? 1 : 0) != 0);
        Intrinsics.checkNotNullExpressionValue((Object)remoteFile, (String)"createRemoteFile(...)");
        RemoteFile remoteFile2 = remoteFile;
        for (String folder : folders) {
            Intrinsics.checkNotNullExpressionValue((Object)RemoteFile.createRemoteFile((String)remoteFile2.getPath(), (String)folder, (this.cpuKind.getOsKind() == OSKind.Windows ? 1 : 0) != 0), (String)"createRemoteFile(...)");
        }
        String string = remoteFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new PathInfo(string, this.cpuKind);
    }

    private final String transformPathToSftp() {
        if (StringsKt.startsWith$default((String)this.path, (String)"/", (boolean)false, (int)2, null)) {
            return this.path;
        }
        Object sftpPath = "/" + this.path;
        if (this.cpuKind.getOsKind() == OSKind.Windows) {
            sftpPath = StringsKt.replace$default((String)sftpPath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        PathInfoKt.access$getLogger$p().info("Path \"" + this.path + "\" transformed to SFTP \"" + (String)sftpPath + "\"");
        return sftpPath;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final CPUKind component2() {
        return this.cpuKind;
    }

    @NotNull
    public final PathInfo copy(@NotNull String path, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        return new PathInfo(path, cpuKind);
    }

    public static /* synthetic */ PathInfo copy$default(PathInfo pathInfo, String string, CPUKind cPUKind, int n, Object object) {
        if ((n & 1) != 0) {
            string = pathInfo.path;
        }
        if ((n & 2) != 0) {
            cPUKind = pathInfo.cpuKind;
        }
        return pathInfo.copy(string, cPUKind);
    }

    @NotNull
    public String toString() {
        return "PathInfo(path=" + this.path + ", cpuKind=" + this.cpuKind + ")";
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = result2 * 31 + this.cpuKind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathInfo)) {
            return false;
        }
        PathInfo pathInfo = (PathInfo)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)pathInfo.path)) {
            return false;
        }
        return this.cpuKind == pathInfo.cpuKind;
    }
}

