/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.rider.breadcrumbs.BackendBreadcrumbsInfoProvider;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/breadcrumbs/RiderBreadcrumbsSupport;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "<init>", "()V", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "language", "Lcom/intellij/lang/Language;", "intellij.rider.rdclient.dotnet"})
public final class RiderBreadcrumbsSupport
implements ProtocolLanguageFeatureProvider {
    @NotNull
    public static final RiderBreadcrumbsSupport INSTANCE = new RiderBreadcrumbsSupport();

    private RiderBreadcrumbsSupport() {
    }

    @Override
    public boolean isAvailable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return this.isAvailable(language);
    }

    public final boolean isAvailable(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        List extensionList = BreadcrumbsProvider.EP_NAME.getExtensionList();
        for (BreadcrumbsProvider breadcrumbsProvider : extensionList) {
            Language[] languageArray = breadcrumbsProvider.getLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)languageArray, (String)"getLanguages(...)");
            if (!ArraysKt.contains((Object[])languageArray, (Object)language) || !(breadcrumbsProvider instanceof BackendBreadcrumbsInfoProvider)) continue;
            return true;
        }
        return false;
    }
}

