/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.jetbrains.rd.ide.model.RdPath;
import com.jetbrains.rider.debugger.util.DebuggerPathMapper;
import com.jetbrains.rider.ijent.extensions.InteractionContextId;
import com.jetbrains.rider.model.debuggerWorker.RdDebuggerPath;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0012\u001a\u00020\u0004*\u00020\r\u001a\n\u0010\u0012\u001a\u00020\u0004*\u00020\u0010\u001a\u0016\u0010\u0012\u001a\u00020\u0004*\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006\u001a\u001a\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006\u001a$\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "toVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/model/debuggerWorker/RdDebuggerPath;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "refreshIfNeeded", "", "toFile", "Ljava/io/File;", "toFileOrNull", "toPath", "Ljava/nio/file/Path;", "toPathOrNull", "toEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "toEelPathOrNull", "toDebuggerPath", "Lcom/jetbrains/rd/ide/model/RdPath;", "expectedDescriptor", "path", "", "checkIfDescriptorsMatch", "", "realDescriptor", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDebuggerPathExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerPathExt.kt\ncom/jetbrains/rider/debugger/util/DebuggerPathExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n1#2:99\n13#3:100\n*S KotlinDebug\n*F\n+ 1 DebuggerPathExt.kt\ncom/jetbrains/rider/debugger/util/DebuggerPathExtKt\n*L\n19#1:100\n*E\n"})
public final class DebuggerPathExtKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final VirtualFile toVirtualFile(@NotNull RdDebuggerPath $this$toVirtualFile, @NotNull EelDescriptor descriptor, boolean refreshIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$toVirtualFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Path path = DebuggerPathExtKt.toPathOrNull($this$toVirtualFile, descriptor);
        if (path == null) {
            return null;
        }
        Path path2 = path;
        return VfsUtil.findFile((Path)path2, (boolean)refreshIfNeeded);
    }

    @NotNull
    public static final File toFile(@NotNull RdDebuggerPath $this$toFile, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        File file = EelNioBridgeServiceKt.asNioPath((EelPath)DebuggerPathExtKt.toEelPath($this$toFile, descriptor)).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull RdDebuggerPath $this$toFileOrNull, @NotNull EelDescriptor descriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toFileOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Object object2 = $this$toFileOrNull;
        try {
            RdDebuggerPath $this$toFileOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)DebuggerPathExtKt.toFile($this$toFileOrNull_u24lambda_u240, descriptor));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (File)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @NotNull
    public static final Path toPath(@NotNull RdDebuggerPath $this$toPath, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return EelNioBridgeServiceKt.asNioPath((EelPath)DebuggerPathExtKt.toEelPath($this$toPath, descriptor));
    }

    @Nullable
    public static final Path toPathOrNull(@NotNull RdDebuggerPath $this$toPathOrNull, @NotNull EelDescriptor descriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toPathOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Object object2 = $this$toPathOrNull;
        try {
            RdDebuggerPath $this$toPathOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)DebuggerPathExtKt.toPath($this$toPathOrNull_u24lambda_u240, descriptor));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @NotNull
    public static final EelPath toEelPath(@NotNull RdDebuggerPath $this$toEelPath, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return EelPath.Companion.parse($this$toEelPath.getPath(), descriptor);
    }

    @Nullable
    public static final EelPath toEelPathOrNull(@NotNull RdDebuggerPath $this$toEelPathOrNull, @NotNull EelDescriptor descriptor) {
        EelPath eelPath;
        Intrinsics.checkNotNullParameter((Object)$this$toEelPathOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        try {
            eelPath = DebuggerPathExtKt.toEelPath($this$toEelPathOrNull, descriptor);
        }
        catch (EelPathException eelPathException) {
            eelPath = null;
        }
        return eelPath;
    }

    @NotNull
    public static final RdPath toDebuggerPath(@NotNull RdDebuggerPath $this$toDebuggerPath, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new RdPath(InteractionContextId.INSTANCE.getId(descriptor), $this$toDebuggerPath.getPath());
    }

    @NotNull
    public static final RdDebuggerPath toDebuggerPath(@NotNull Path $this$toDebuggerPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerPath, (String)"<this>");
        return DebuggerPathExtKt.toDebuggerPath(EelNioBridgeServiceKt.asEelPath((Path)$this$toDebuggerPath));
    }

    @NotNull
    public static final RdDebuggerPath toDebuggerPath(@NotNull EelPath $this$toDebuggerPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerPath, (String)"<this>");
        return new RdDebuggerPath($this$toDebuggerPath.toString());
    }

    @NotNull
    public static final RdDebuggerPath toDebuggerPath(@NotNull VirtualFile $this$toDebuggerPath, @Nullable EelDescriptor expectedDescriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerPath, (String)"<this>");
        Object object2 = $this$toDebuggerPath;
        try {
            VirtualFile $this$toDebuggerPath_u24lambda_u240 = object2;
            boolean bl = false;
            Path path = $this$toDebuggerPath_u24lambda_u240.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            object = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)path));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        EelPath eel = (EelPath)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (eel == null) {
            LOG.warn("Failed to convert VirtualFile = " + $this$toDebuggerPath + " to EelPath, falling back to file path");
            String string = $this$toDebuggerPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return new RdDebuggerPath(string);
        }
        EelDescriptor eelDescriptor = eel.getDescriptor();
        String string = $this$toDebuggerPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        DebuggerPathExtKt.checkIfDescriptorsMatch(eelDescriptor, expectedDescriptor, string);
        return new RdDebuggerPath(eel.toString());
    }

    public static /* synthetic */ RdDebuggerPath toDebuggerPath$default(VirtualFile virtualFile, EelDescriptor eelDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            eelDescriptor = null;
        }
        return DebuggerPathExtKt.toDebuggerPath(virtualFile, eelDescriptor);
    }

    @NotNull
    public static final RdDebuggerPath toDebuggerPath(@NotNull String path, @Nullable EelDescriptor expectedDescriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            boolean bl = false;
            Path path2 = NioPathUtil.toNioPathOrNull((String)path);
            object = Result.constructor-impl((Object)(path2 != null ? EelNioBridgeServiceKt.asEelPath((Path)path2) : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        EelPath eel = (EelPath)(Result.isFailure-impl((Object)object) ? null : object);
        if (eel == null) {
            LOG.warn("Failed to convert string = " + path + " to EelPath, falling back to string");
            return new RdDebuggerPath(path);
        }
        DebuggerPathExtKt.checkIfDescriptorsMatch(eel.getDescriptor(), expectedDescriptor, path);
        return new RdDebuggerPath(eel.toString());
    }

    public static /* synthetic */ RdDebuggerPath toDebuggerPath$default(String string, EelDescriptor eelDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            eelDescriptor = null;
        }
        return DebuggerPathExtKt.toDebuggerPath(string, eelDescriptor);
    }

    private static final void checkIfDescriptorsMatch(EelDescriptor realDescriptor, EelDescriptor expectedDescriptor, String path) {
        if (expectedDescriptor != null && !Intrinsics.areEqual((Object)realDescriptor, (Object)expectedDescriptor)) {
            LOG.warn("Expected descriptor = " + expectedDescriptor + ", but got " + realDescriptor + " instead. The debugger will most likely fail to resolve the path you are passing.Path = " + path);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DebuggerPathMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

