/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.jetbrains.rd.ide.model.RdPath;
import com.jetbrains.rider.debugger.util.DebuggerPathExtKt;
import com.jetbrains.rider.model.debuggerWorker.RdDebuggerPath;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0017J\u000e\u0010\u0015\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/debugger/util/DebuggerPathMapper;", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;)V", "toVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/jetbrains/rider/model/debuggerWorker/RdDebuggerPath;", "refreshIfNeeded", "", "toFile", "Ljava/io/File;", "toFileOrNull", "toPath", "Ljava/nio/file/Path;", "toPathOrNull", "toEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "toEelPathOrNull", "toRdPath", "file", "", "Lcom/jetbrains/rd/ide/model/RdPath;", "intellij.rider.rdclient.dotnet"})
public final class DebuggerPathMapper {
    @NotNull
    private final EelDescriptor descriptor;

    public DebuggerPathMapper(@NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
    }

    @Nullable
    public final VirtualFile toVirtualFile(@NotNull RdDebuggerPath path, boolean refreshIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toVirtualFile(path, this.descriptor, refreshIfNeeded);
    }

    @NotNull
    public final File toFile(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toFile(path, this.descriptor);
    }

    @Nullable
    public final File toFileOrNull(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toFileOrNull(path, this.descriptor);
    }

    @NotNull
    public final Path toPath(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toPath(path, this.descriptor);
    }

    @Nullable
    public final Path toPathOrNull(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toPathOrNull(path, this.descriptor);
    }

    @NotNull
    public final EelPath toEelPath(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toEelPath(path, this.descriptor);
    }

    @Nullable
    public final EelPath toEelPathOrNull(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toEelPathOrNull(path, this.descriptor);
    }

    @NotNull
    public final RdDebuggerPath toRdPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DebuggerPathExtKt.toDebuggerPath(file, this.descriptor);
    }

    @NotNull
    public final RdDebuggerPath toRdPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toDebuggerPath(path, this.descriptor);
    }

    @NotNull
    public final RdPath toRdPath(@NotNull RdDebuggerPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebuggerPathExtKt.toDebuggerPath(path, this.descriptor);
    }
}

