/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.CommandDescriptor;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0002+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0018H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010)\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "policy", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "guard", "", "suppressionReqs", "", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "getCommandProcessor", "()Lcom/intellij/openapi/command/CommandProcessorEx;", "commandProcessor$delegate", "Lkotlin/Lazy;", "ignoredCommands", "", "", "bind", "", "commandProcessorModel", "Lcom/jetbrains/rd/ide/model/RdCommandProcessor;", "suppress", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "startFrontendCommand", "cmdDescriptor", "Lcom/jetbrains/rd/ide/model/CommandDescriptor;", "lt", "finishCommand", "command", "Lcom/intellij/openapi/command/CommandToken;", "commandName", "startCommand", "setCustomUndoConfirmationPolicy", "customPolicy", "Companion", "ProtocolListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendCommandsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost\n+ 2 Logger.kt\ncom/jetbrains/rdclient/util/idea/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n6#2:140\n13#3:141\n13#4:142\n67#4,4:143\n67#4,4:147\n*S KotlinDebug\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost\n*L\n34#1:140\n34#1:141\n34#1:142\n52#1:143,4\n58#1:147,4\n*E\n"})
public final class FrontendCommandsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Logger LOG;
    @NotNull
    private UndoConfirmationPolicy policy;
    private boolean guard;
    private int suppressionReqs;
    @NotNull
    private final Lazy commandProcessor$delegate;
    @NotNull
    private final Set<String> ignoredCommands;

    public FrontendCommandsHost(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        boolean $i$f$getLogger = false;
        boolean $i$f$getLogger2 = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendCommandsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.policy = UndoConfirmationPolicy.DEFAULT;
        this.commandProcessor$delegate = LazyKt.lazy(FrontendCommandsHost::commandProcessor_delegate$lambda$0);
        Object[] objectArray = new String[]{"Go to next hotspot", "Go to previous hotspot", "Hostpot.Update"};
        this.ignoredCommands = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    private final CommandProcessorEx getCommandProcessor() {
        Lazy lazy = this.commandProcessor$delegate;
        return (CommandProcessorEx)lazy.getValue();
    }

    private final void bind(RdCommandProcessor commandProcessorModel) {
        InterfacesKt.viewNotNull((IViewable)((IViewable)commandProcessorModel.getCurrentCommand()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> FrontendCommandsHost.bind$lambda$0(this, arg_0, arg_1));
    }

    public final void suppress(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ApplicationManager.getApplication().assertIsDispatchThread();
        lifetime.bracket(() -> FrontendCommandsHost.suppress$lambda$0(this), () -> FrontendCommandsHost.suppress$lambda$1(this));
    }

    private final void startFrontendCommand(CommandDescriptor cmdDescriptor, Lifetime lt) {
        CommandToken commandToken = this.startCommand(cmdDescriptor);
        if (commandToken == null) {
            return;
        }
        CommandToken command = commandToken;
        lt.onTermination(() -> FrontendCommandsHost.startFrontendCommand$lambda$0(this, command, cmdDescriptor));
    }

    private final void finishCommand(CommandToken command, String commandName) {
        if (this.getCommandProcessor().isCommandInProgress()) {
            this.getCommandProcessor().finishCommand(command, null);
        } else {
            this.LOG.error("The command '" + commandName + "' has already been interrupted by frontend.");
        }
        this.LOG.debug("<<< End command " + commandName);
    }

    private final CommandToken startCommand(CommandDescriptor cmdDescriptor) {
        String commandName = cmdDescriptor.component1();
        boolean isNavigation = cmdDescriptor.component2();
        boolean isTypingPostProcessor = cmdDescriptor.component3();
        if (this.getCommandProcessor().isCommandInProgress() && isTypingPostProcessor) {
            this.LOG.debug("isTypingPostProcessor received. Tearing apart outer command");
            TypedAction typedAction = TypedAction.getInstance();
            Intrinsics.checkNotNull((Object)typedAction, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.TypedActionImpl");
            DefaultRawTypedHandler handler = ((TypedActionImpl)typedAction).getDefaultRawTypedHandler();
            handler.beginUndoablePostProcessing();
            return null;
        }
        ClientProjectSession projectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)this.session.getProjectSessions());
        this.LOG.debug(">>> Start command " + commandName);
        ClientProjectSession clientProjectSession = projectSession;
        CommandToken command = this.getCommandProcessor().startCommand((Project)(clientProjectSession != null ? clientProjectSession.getProject() : null), commandName, null, this.policy);
        if (isNavigation) {
            if (projectSession == null) {
                this.LOG.error("There is not project session for command: " + commandName);
            } else {
                IdeDocumentHistory.getInstance((Project)projectSession.getProject()).includeCurrentCommandAsNavigation();
            }
        }
        if (command == null) {
            this.LOG.debug("<<< End command " + commandName + ": (The command is nested into " + this.getCommandProcessor().getCurrentCommandName() + ". Do nothing)");
            return null;
        }
        return command;
    }

    public final void setCustomUndoConfirmationPolicy(@NotNull Lifetime lifetime, @NotNull UndoConfirmationPolicy customPolicy) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)customPolicy, (String)"customPolicy");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.LOG.assertTrue(!this.guard);
        this.guard = true;
        UndoConfirmationPolicy oldPolicy = this.policy;
        this.policy = customPolicy;
        lifetime.onTermination(() -> FrontendCommandsHost.setCustomUndoConfirmationPolicy$lambda$0(this, oldPolicy));
    }

    private static final CommandProcessorEx commandProcessor_delegate$lambda$0() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Intrinsics.checkNotNull((Object)commandProcessor, (String)"null cannot be cast to non-null type com.intellij.openapi.command.CommandProcessorEx");
        return (CommandProcessorEx)commandProcessor;
    }

    private static final Unit bind$lambda$0(FrontendCommandsHost this$0, Lifetime lt, CommandDescriptor cmdDescriptor) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)cmdDescriptor, (String)"cmdDescriptor");
        if (this$0.suppressionReqs > 0) {
            Logger $this$trace$iv = this$0.LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Command execution is suppressed, skipping command with name " + cmdDescriptor.getName() + ".");
            }
            return Unit.INSTANCE;
        }
        if (PatchEngineRegistryKt.isPatchEngineEnabled() && this$0.ignoredCommands.contains(cmdDescriptor.getName())) {
            Logger $this$trace$iv = this$0.LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Ignore command " + cmdDescriptor.getName());
            }
            return Unit.INSTANCE;
        }
        this$0.startFrontendCommand(cmdDescriptor, lt);
        return Unit.INSTANCE;
    }

    private static final int suppress$lambda$0(FrontendCommandsHost this$0) {
        int n;
        int n2 = n = this$0.suppressionReqs >= 0 ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        n = this$0.suppressionReqs;
        this$0.suppressionReqs = n + 1;
        return n;
    }

    private static final Unit suppress$lambda$1(FrontendCommandsHost this$0) {
        int n;
        int n2 = n = this$0.suppressionReqs >= 1 ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        n = this$0.suppressionReqs;
        this$0.suppressionReqs = n + -1;
        return Unit.INSTANCE;
    }

    private static final Unit startFrontendCommand$lambda$0(FrontendCommandsHost this$0, CommandToken $command, CommandDescriptor $cmdDescriptor) {
        this$0.finishCommand($command, $cmdDescriptor.getName());
        return Unit.INSTANCE;
    }

    private static final Unit setCustomUndoConfirmationPolicy$lambda$0(FrontendCommandsHost this$0, UndoConfirmationPolicy $oldPolicy) {
        this$0.policy = $oldPolicy;
        this$0.guard = false;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/document/FrontendCommandsHost;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFrontendCommandsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,139:1\n23#2:140\n*S KotlinDebug\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost$Companion\n*L\n31#1:140\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendCommandsHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project).getAppSession());
        }

        @NotNull
        public final FrontendCommandsHost getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(FrontendCommandsHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (FrontendCommandsHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session2, @NotNull DocumentsOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            RdCommandProcessor commandProcessorModel = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)model2);
            Companion.getInstance(session2).bind(commandProcessorModel);
        }
    }
}

