/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.DocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdTextBufferDocumentModel;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.impl.RdDeferrableTextBuffer;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.daemon.TextBufferDocumentRangeShifter;
import com.jetbrains.rider.document.DocumentChangeModelConversion;
import com.jetbrains.rider.document.FrontendDocumentSuppressor;
import com.jetbrains.rider.protocol.ProtocolManagerKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\b&\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0002OPB9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010*\u001a\u00020+J\b\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u000206J\u001a\u00107\u001a\u00020+2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u000209H\u0014J\u0006\u0010<\u001a\u00020+J\u0010\u0010=\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010>\u001a\u0002042\u0006\u0010?\u001a\u000209H\u0014J\u0010\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u000209H\u0002J\u000e\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u000204J\u0010\u0010D\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\b\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020IH\u0002J\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u00020I2\u0006\u0010M\u001a\u00020NH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u0010:\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u001e\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "suppressor", "Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdTextBufferDocumentModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getSuppressor", "()Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;", "backendUpdateInProgressMarker", "", "getBackendUpdateInProgressMarker", "()Z", "setBackendUpdateInProgressMarker", "(Z)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isReceivingChange", "textBuffer", "Lcom/jetbrains/rd/rdtext/impl/RdDeferrableTextBuffer;", "getTextBuffer", "()Lcom/jetbrains/rd/rdtext/impl/RdDeferrableTextBuffer;", "autoRecoverEnabled", "hasRecoverRequest", "assertEmptyChangesQueue", "", "version", "Lcom/jetbrains/rd/ide/model/DocumentVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/DocumentVersion;", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "startTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "verifyMayUpdateDocument", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentConsistencyAssertionsEnabled", "getDocumentConsistencyAssertionsEnabled", "flushChanges", "documentChanged", "createModelChange", "change", "sendSingleDocumentChange", "ideaChange", "receiveDocumentChange", "modelChange", "beforeDocumentChange", "getPriority", "", "recover", "text", "", "accumulateRecoverRequests", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$AccumulatedRecoverRequests;", "escape", "s", "", "Companion", "AccumulatedRecoverRequests", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextBufferDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBufferDocumentSynchronizer.kt\ncom/jetbrains/rider/document/TextBufferDocumentSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n67#2,4:201\n67#2,4:205\n67#2,4:209\n67#2,4:213\n1#3:217\n*S KotlinDebug\n*F\n+ 1 TextBufferDocumentSynchronizer.kt\ncom/jetbrains/rider/document/TextBufferDocumentSynchronizer\n*L\n104#1:201,4\n114#1:205,4\n132#1:209,4\n148#1:213,4\n*E\n"})
public abstract class TextBufferDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Document document;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final RdTextBufferDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final FrontendDocumentSuppressor suppressor;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    private final boolean isReceivingChange;
    private boolean autoRecoverEnabled;
    private boolean hasRecoverRequest;
    private static int debugId;

    public TextBufferDocumentSynchronizer(@NotNull ClientAppSession session2, @NotNull Document document, @Nullable VirtualFile file, @NotNull RdTextBufferDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull FrontendDocumentSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)modelDocument, (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.session = session2;
        this.document = document;
        this.file = file;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.suppressor = suppressor;
        String fileName = com.jetbrains.rd.ide.document.DocumentExKt.createLogCategory((RdDocumentId)this.documentId);
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rdclient.document.Document#" + n + "(" + fileName + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.autoRecoverEnabled = true;
    }

    @NotNull
    public ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @NotNull
    public RdTextBufferDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @NotNull
    public final RdDocumentId getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final FrontendDocumentSuppressor getSuppressor() {
        return this.suppressor;
    }

    protected final boolean getBackendUpdateInProgressMarker() {
        return this.backendUpdateInProgressMarker;
    }

    protected final void setBackendUpdateInProgressMarker(boolean bl) {
        this.backendUpdateInProgressMarker = bl;
    }

    public boolean isReceivingChange() {
        return this.isReceivingChange;
    }

    private final RdDeferrableTextBuffer getTextBuffer() {
        return this.getModelDocument().getText();
    }

    public final void assertEmptyChangesQueue() {
        this.logger.assertTrue(this.getTextBuffer().isQueueEmpty(), (Object)"TextBuffer must be flushed before.");
    }

    @NotNull
    public DocumentVersion getVersion() {
        return new DocumentVersion(this.getTextBuffer().getBufferVersion());
    }

    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new TextBufferDocumentRangeShifter(this.getDocumentLifetime(), (RdTextBuffer)this.getTextBuffer());
    }

    @NotNull
    public final ITypingSession<RdTextChange> startTypingSession(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        RLifetimeKt.assertAlive((Lifetime)lifetime);
        ITypingSession session2 = this.getTextBuffer().startTypingSession();
        lifetime.onTermination(() -> TextBufferDocumentSynchronizer.startTypingSession$lambda$0(this));
        return session2;
    }

    protected void verifyMayUpdateDocument(@Nullable VirtualFile file, @NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    protected boolean getDocumentConsistencyAssertionsEnabled() {
        return false;
    }

    public final void flushChanges() {
        if (this.getTextBuffer().isQueueEmpty()) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            VirtualFile virtualFile = this.file;
            logger.trace("Flushing deferred '" + (virtualFile != null ? virtualFile.getName() : null) + "' document changes.");
        }
        this.getTextBuffer().flush();
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.backendUpdateInProgressMarker) {
            return;
        }
        this.verifyMayUpdateDocument(this.file, event);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            VirtualFile virtualFile = this.file;
            String string = virtualFile != null ? virtualFile.getName() : null;
            CharSequence charSequence = event.getNewFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
            String string2 = this.escape(charSequence);
            CharSequence charSequence2 = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
            logger.trace("Document '" + string + "' changed from IDEA side. New fragment: '" + string2 + "', OldFragment: '" + this.escape(charSequence2) + "'");
        }
        this.sendSingleDocumentChange(event);
    }

    @NotNull
    protected RdTextChange createModelChange(@NotNull DocumentEvent change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return DocumentChangeModelConversion.INSTANCE.createModelChange(change);
    }

    private final void sendSingleDocumentChange(DocumentEvent ideaChange) {
        Document document = ideaChange.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        RdTextChange change = this.createModelChange(ideaChange);
        boolean shouldSuppress = this.suppressor.shouldSuppressSendDocumentChanges();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(shouldSuppress ? "Queueing change " + change + "." : "Firing change " + change + ".");
        }
        if (shouldSuppress) {
            this.getTextBuffer().queue(change);
        } else {
            this.assertEmptyChangesQueue();
            this.getTextBuffer().fire(change);
        }
        if (this.getDocumentConsistencyAssertionsEnabled()) {
            RdDeferrableTextBuffer rdDeferrableTextBuffer = this.getTextBuffer();
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            rdDeferrableTextBuffer.assertState(string);
        }
    }

    public final void receiveDocumentChange(@NotNull RdTextChange modelChange) {
        Intrinsics.checkNotNullParameter((Object)modelChange, (String)"modelChange");
        ClientProjectSession clientProjectSession = ProtocolManagerKt.getProjectSessionOrNull(this.getSession());
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getProject()) == null) {
            throw new IllegalStateException(("Project did not found for " + this.getDocument()).toString());
        }
        ClientProjectSession project = clientProjectSession;
        WriteCommandAction.writeCommandAction((Project)project).run(() -> TextBufferDocumentSynchronizer.receiveDocumentChange$lambda$0(this, modelChange));
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 119;
    }

    private final void recover(String text) {
        this.hasRecoverRequest = false;
        this.logger.warn("Firing recovering text change.");
        this.getTextBuffer().reset(text);
    }

    @NotNull
    public final AccumulatedRecoverRequests accumulateRecoverRequests() {
        return new AccumulatedRecoverRequests(this);
    }

    private final String escape(CharSequence s) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)s).toString(), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
    }

    private static final Unit startTypingSession$lambda$0(TextBufferDocumentSynchronizer this$0) {
        this$0.getTextBuffer().finishTypingSession();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void receiveDocumentChange$lambda$0(TextBufferDocumentSynchronizer this$0, RdTextChange $modelChange) {
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying document change from backend '" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)this$0.documentId) + "':\n" + $modelChange + ", buffer version: " + this$0.getTextBuffer().getBufferVersion() + ".");
        }
        this$0.getDocument().startGuardedBlockChecking();
        if (!(!this$0.backendUpdateInProgressMarker)) {
            boolean bl = false;
            String string = "inconsistent currentBackendUpdate value";
            throw new IllegalArgumentException(string.toString());
        }
        this$0.backendUpdateInProgressMarker = true;
        try {
            DocumentChangeModelConversion.INSTANCE.applyModelChange($modelChange, this$0.getDocument(), this$0.getDocumentConsistencyAssertionsEnabled());
            if (this$0.getDocumentConsistencyAssertionsEnabled()) {
                RdDeferrableTextBuffer rdDeferrableTextBuffer = this$0.getTextBuffer();
                String string = this$0.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                rdDeferrableTextBuffer.assertState(string);
            }
        }
        catch (Throwable e) {
            this$0.logger.error("Exception while applying document change to idea's document", e);
            this$0.hasRecoverRequest = true;
        }
        finally {
            this$0.backendUpdateInProgressMarker = false;
            this$0.getDocument().stopGuardedBlockChecking();
        }
        if (this$0.hasRecoverRequest && this$0.autoRecoverEnabled) {
            String string = this$0.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this$0.recover(string);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$AccumulatedRecoverRequests;", "Lcom/intellij/openapi/Disposable;", "documentSynchronizer", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "<init>", "(Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;)V", "hasRequests", "", "getHasRequests", "()Z", "dispose", "", "intellij.rider.rdclient.dotnet"})
    public static final class AccumulatedRecoverRequests
    implements Disposable {
        @NotNull
        private final TextBufferDocumentSynchronizer documentSynchronizer;

        public AccumulatedRecoverRequests(@NotNull TextBufferDocumentSynchronizer documentSynchronizer) {
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
            this.documentSynchronizer = documentSynchronizer;
            if (!this.documentSynchronizer.autoRecoverEnabled) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.documentSynchronizer.autoRecoverEnabled = false;
        }

        public final boolean getHasRequests() {
            return this.documentSynchronizer.hasRecoverRequest;
        }

        public void dispose() {
            if (!(!this.documentSynchronizer.autoRecoverEnabled)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.documentSynchronizer.autoRecoverEnabled = true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer$Companion;", "", "<init>", "()V", "debugId", "", "recoverDocumentModelSynchronization", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "isBackendUpdateInProgress", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final void recoverDocumentModelSynchronization(@NotNull RdDocumentId documentId, @NotNull ClientAppSession session2) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (!(documentId instanceof RdFileDocumentId) || !com.jetbrains.rd.ide.document.DocumentExKt.isLocalFile((RdDocumentId)documentId)) {
                    return;
                }
                String filePath = ((RdFileDocumentId)documentId).getFilePath();
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)true);
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
                if (document == null) {
                    return;
                }
                Document ideaDocument = document;
                DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)ideaDocument, (ClientAppSession)session2);
                TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer : null;
                if (textBufferDocumentSynchronizer == null) break block3;
                String string = ideaDocument.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                textBufferDocumentSynchronizer.recover(string);
            }
        }

        public final boolean isBackendUpdateInProgress(@NotNull Document document, @NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (ClientAppSession)session2);
            TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer : null;
            return textBufferDocumentSynchronizer != null ? textBufferDocumentSynchronizer.getBackendUpdateInProgressMarker() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

