/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rider.editorActions.RangePair;
import com.jetbrains.rider.editorActions.RangePairKt;
import com.jetbrains.rider.editorActions.TextModificationSide;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/editorActions/TextModificationMap;", "", "<init>", "()V", "changes", "", "Lcom/jetbrains/rider/editorActions/RangePair;", "getSortedPairs", "", "initialText", "", "add", "", "change", "shiftSegments", "startIdx", "", "delta", "handleInIn", "seg1", "seg2", "handleInOut", "handleOutIn", "handleOutOut", "findStartSegment", "Lcom/jetbrains/rider/editorActions/TextModificationMap$FindResult;", "offset", "findEndSegment", "FindResult", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextModificationMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextModificationMap.kt\ncom/jetbrains/rider/editorActions/TextModificationMap\n+ 2 RangePair.kt\ncom/jetbrains/rider/editorActions/RangePairKt\n*L\n1#1,220:1\n38#2:221\n38#2:222\n38#2:223\n*S KotlinDebug\n*F\n+ 1 TextModificationMap.kt\ncom/jetbrains/rider/editorActions/TextModificationMap\n*L\n52#1:221\n67#1:222\n115#1:223\n*E\n"})
public final class TextModificationMap {
    @NotNull
    private final List<RangePair> changes = new ArrayList();

    @NotNull
    public final List<RangePair> getSortedPairs(@NotNull CharSequence initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        List result2 = new ArrayList();
        for (RangePair pair : this.changes) {
            RangePair newPair = RangePairKt.optimize(pair, initialText);
            if (newPair.isEmpty()) continue;
            result2.add(newPair);
        }
        return result2;
    }

    public final void add(@NotNull RangePair change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (this.changes.isEmpty()) {
            this.changes.add(change);
            return;
        }
        FindResult findResult = this.findStartSegment(change.getOldRange().getStartOffset());
        int startSegmentIdx = findResult.component1();
        boolean hasStartPoint = findResult.component2();
        FindResult findResult2 = this.findEndSegment(change.getOldRange().getEndOffset());
        int endSegmentIdx = findResult2.component1();
        boolean hasEndPoint = findResult2.component2();
        int insertedIdx = hasStartPoint ? (hasEndPoint ? this.handleInIn(change, startSegmentIdx, endSegmentIdx) : this.handleInOut(change, startSegmentIdx, endSegmentIdx)) : (hasEndPoint ? this.handleOutIn(change, startSegmentIdx, endSegmentIdx) : this.handleOutOut(change, startSegmentIdx, endSegmentIdx));
        RangePair $this$delta$iv = change;
        boolean $i$f$getDelta = false;
        this.shiftSegments(insertedIdx + 1, $this$delta$iv.getNewRange().getLength() - $this$delta$iv.getOldRange().getLength());
    }

    private final void shiftSegments(int startIdx, int delta) {
        for (int i = startIdx; i < this.changes.size(); ++i) {
            this.changes.set(i, RangePairKt.shiftNewRange(this.changes.get(i), delta));
        }
    }

    private final int handleInIn(RangePair change, int seg1, int seg2) {
        RangePair startSegment = this.changes.get(seg1);
        RangePair endSegment = this.changes.get(seg2);
        TextRange oldRange = new TextRange(startSegment.getOldRange().getStartOffset(), endSegment.getOldRange().getEndOffset());
        RangePair $this$delta$iv = change;
        boolean $i$f$getDelta = false;
        TextRange newRange = new TextRange(startSegment.getNewRange().getStartOffset(), endSegment.getNewRange().getEndOffset() + ($this$delta$iv.getNewRange().getLength() - $this$delta$iv.getOldRange().getLength()));
        int relativeOldStart = change.getOldRange().getStartOffset() - startSegment.getNewRange().getStartOffset();
        int relativeOldEnd = change.getOldRange().getEndOffset() - endSegment.getNewRange().getStartOffset();
        ImmutableCharSequence immutableCharSequence = startSegment.getNewText().subtext(0, relativeOldStart).concat((CharSequence)change.getNewText()).concat((CharSequence)endSegment.getNewText().subtext(relativeOldEnd, endSegment.getNewRange().getLength()));
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"concat(...)");
        ImmutableCharSequence newText = immutableCharSequence;
        for (int i = 0; i < seg2 - seg1 + 1; ++i) {
            this.changes.remove(seg1);
        }
        if (oldRange.isEmpty() && newRange.isEmpty()) {
            return seg1 - 1;
        }
        this.changes.add(seg1, new RangePair(oldRange, newRange, newText, TextModificationSide.NotSpecified));
        return seg1;
    }

    private final int handleInOut(RangePair change, int seg1, int seg2) {
        RangePair startSegment = this.changes.get(seg1);
        RangePair lastSegment = this.changes.get(seg2 - 1);
        TextRange oldRange = new TextRange(startSegment.getOldRange().getStartOffset(), lastSegment.getOldRange().getEndOffset() + change.getOldRange().getEndOffset() - lastSegment.getNewRange().getEndOffset());
        TextRange newRange = new TextRange(startSegment.getNewRange().getStartOffset(), change.getNewRange().getEndOffset());
        int relativeOldStart = change.getOldRange().getStartOffset() - startSegment.getNewRange().getStartOffset();
        ImmutableCharSequence immutableCharSequence = startSegment.getNewText().subtext(0, relativeOldStart).concat((CharSequence)change.getNewText());
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"concat(...)");
        ImmutableCharSequence newText = immutableCharSequence;
        for (int i = 0; i < seg2 - seg1; ++i) {
            this.changes.remove(seg1);
        }
        this.changes.add(seg1, new RangePair(oldRange, newRange, newText, TextModificationSide.NotSpecified));
        return seg1;
    }

    private final int handleOutIn(RangePair change, int seg1, int seg2) {
        RangePair startSegment = this.changes.get(seg1 + 1);
        RangePair endSegment = this.changes.get(seg2);
        TextRange oldRange = new TextRange(startSegment.getOldRange().getStartOffset() - startSegment.getNewRange().getStartOffset() + change.getOldRange().getStartOffset(), endSegment.getOldRange().getEndOffset());
        RangePair $this$delta$iv = change;
        boolean $i$f$getDelta = false;
        TextRange newRange = new TextRange(change.getNewRange().getStartOffset(), endSegment.getNewRange().getEndOffset() + ($this$delta$iv.getNewRange().getLength() - $this$delta$iv.getOldRange().getLength()));
        int relativeOldEnd = change.getOldRange().getEndOffset() - endSegment.getNewRange().getStartOffset();
        ImmutableCharSequence immutableCharSequence = change.getNewText().concat((CharSequence)endSegment.getNewText().subtext(relativeOldEnd, endSegment.getNewRange().getLength()));
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"concat(...)");
        ImmutableCharSequence newText = immutableCharSequence;
        for (int i = 0; i < seg2 - seg1; ++i) {
            this.changes.remove(seg1 + 1);
        }
        this.changes.add(seg1 + 1, new RangePair(oldRange, newRange, newText, TextModificationSide.NotSpecified));
        return seg1 + 1;
    }

    private final int handleOutOut(RangePair change, int seg1, int seg2) {
        if (seg1 + 1 == seg2) {
            int oldStart = seg1 >= 0 ? this.changes.get(seg1).getOldRange().getEndOffset() + change.getOldRange().getStartOffset() - this.changes.get(seg1).getNewRange().getEndOffset() : change.getOldRange().getStartOffset();
            TextRange oldRange = new TextRange(oldStart, oldStart + change.getOldRange().getLength());
            this.changes.add(seg1 + 1, new RangePair(oldRange, change.getNewRange(), change.getNewText(), change.getModificationSide()));
        } else {
            int oldStart = seg1 >= 0 ? this.changes.get(seg1).getOldRange().getEndOffset() + change.getOldRange().getStartOffset() - this.changes.get(seg1).getNewRange().getEndOffset() : change.getOldRange().getStartOffset();
            int oldEnd = seg2 < this.changes.size() ? this.changes.get(seg2).getOldRange().getStartOffset() - (this.changes.get(seg2).getNewRange().getStartOffset() - change.getOldRange().getEndOffset()) : this.changes.get(seg2 - 1).getOldRange().getEndOffset() + (change.getOldRange().getEndOffset() - this.changes.get(seg2 - 1).getNewRange().getEndOffset());
            for (int i = 0; i < seg2 - seg1 - 1; ++i) {
                this.changes.remove(seg1 + 1);
            }
            TextRange oldRange = new TextRange(oldStart, oldEnd);
            this.changes.add(seg1 + 1, new RangePair(oldRange, change.getNewRange(), change.getNewText(), change.getModificationSide()));
        }
        return seg1 + 1;
    }

    private final FindResult findStartSegment(int offset) {
        if (offset < ((RangePair)CollectionsKt.first(this.changes)).getNewRange().getStartOffset()) {
            return new FindResult(-1, false);
        }
        if (offset > ((RangePair)CollectionsKt.last(this.changes)).getNewRange().getEndOffset()) {
            return new FindResult(this.changes.size() - 1, false);
        }
        int result2 = CollectionsKt.binarySearch$default(this.changes, (int)0, (int)0, arg_0 -> TextModificationMap.findStartSegment$lambda$0(offset, arg_0), (int)3, null);
        return result2 >= 0 ? new FindResult(result2, true) : new FindResult(-result2 - 1 - 1, false);
    }

    private final FindResult findEndSegment(int offset) {
        if (offset < ((RangePair)CollectionsKt.first(this.changes)).getNewRange().getStartOffset()) {
            return new FindResult(0, false);
        }
        if (offset > ((RangePair)CollectionsKt.last(this.changes)).getNewRange().getEndOffset()) {
            return new FindResult(this.changes.size(), false);
        }
        int result2 = CollectionsKt.binarySearch$default(this.changes, (int)0, (int)0, arg_0 -> TextModificationMap.findEndSegment$lambda$0(offset, arg_0), (int)3, null);
        return result2 >= 0 ? new FindResult(result2, true) : new FindResult(-result2 - 1, false);
    }

    private static final int findStartSegment$lambda$0(int $offset, RangePair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int newStart = it.getNewRange().getStartOffset();
        int newEnd = it.getNewRange().getEndOffset();
        return $offset < newStart ? 1 : ($offset > newEnd ? -1 : 0);
    }

    private static final int findEndSegment$lambda$0(int $offset, RangePair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int newStart = it.getNewRange().getStartOffset();
        int newEnd = it.getNewRange().getEndOffset();
        return $offset < newStart ? 1 : ($offset > newEnd ? -1 : 0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/editorActions/TextModificationMap$FindResult;", "", "segmentIdx", "", "isFound", "", "<init>", "(IZ)V", "getSegmentIdx", "()I", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class FindResult {
        private final int segmentIdx;
        private final boolean isFound;

        public FindResult(int segmentIdx, boolean isFound) {
            this.segmentIdx = segmentIdx;
            this.isFound = isFound;
        }

        public final int getSegmentIdx() {
            return this.segmentIdx;
        }

        public final boolean isFound() {
            return this.isFound;
        }

        public final int component1() {
            return this.segmentIdx;
        }

        public final boolean component2() {
            return this.isFound;
        }

        @NotNull
        public final FindResult copy(int segmentIdx, boolean isFound) {
            return new FindResult(segmentIdx, isFound);
        }

        public static /* synthetic */ FindResult copy$default(FindResult findResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = findResult.segmentIdx;
            }
            if ((n2 & 2) != 0) {
                bl = findResult.isFound;
            }
            return findResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "FindResult(segmentIdx=" + this.segmentIdx + ", isFound=" + this.isFound + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.segmentIdx);
            result2 = result2 * 31 + Boolean.hashCode(this.isFound);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FindResult)) {
                return false;
            }
            FindResult findResult = (FindResult)other;
            if (this.segmentIdx != findResult.segmentIdx) {
                return false;
            }
            return this.isFound == findResult.isFound;
        }
    }
}

