/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeInsight.hint.ImplementationViewDocumentFactory;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LanguageTextField;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewElement;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.model.SandboxInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/editors/QuickDefinitionDocumentFactoryBase;", "Lcom/intellij/codeInsight/hint/ImplementationViewDocumentFactory;", "<init>", "()V", "navigationOffset", "Lcom/intellij/openapi/util/Key;", "", "defaultLanguage", "Lcom/intellij/lang/Language;", "getDefaultLanguage", "()Lcom/intellij/lang/Language;", "createDocument", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "tuneEditorAfterShow", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.rider.rdclient.dotnet"})
public abstract class QuickDefinitionDocumentFactoryBase
implements ImplementationViewDocumentFactory {
    @NotNull
    private final Key<Integer> navigationOffset;

    public QuickDefinitionDocumentFactoryBase() {
        Key key = Key.create((String)"navigationOffset");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.navigationOffset = key;
    }

    @NotNull
    protected abstract Language getDefaultLanguage();

    @Nullable
    public Document createDocument(@NotNull ImplementationViewElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof FrontendImplementationViewElement)) {
            return null;
        }
        VirtualFile virtualFile = ((FrontendImplementationViewElement)element).getContainingFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            return null;
        }
        Document doc = document;
        String string = doc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fullText = StringsKt.trimIndent((String)string);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)((FrontendImplementationViewElement)element).getProject()).getPsiFile(doc);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            psiFile = this.getDefaultLanguage();
        }
        PsiFile language = psiFile;
        RdLanguage rdLanguage = ProtocolLanguageManagerKt.toRdLanguage((Language)language);
        if (rdLanguage == null) {
            return null;
        }
        RdLanguage rdLanguage2 = rdLanguage;
        String string2 = ((FrontendImplementationViewElement)element).getText();
        Document createdDocument = new LanguageTextField.SimpleDocumentCreator().createDocument(string2 != null ? StringsKt.trimIndent((String)string2) : null, (Language)language, ((FrontendImplementationViewElement)element).getProject());
        createdDocument.setReadOnly(true);
        RdFileDocumentId rdFileDocumentId = DocumentExKt.createDocumentId((VirtualFile)vFile);
        String string3 = "/* ReSharper disable All */\n#pragma warning disable\n" + fullText;
        RdTextRange rdTextRange = RangeUtilKt.fromOffset((RdTextRange.Companion)RdTextRange.Companion, (int)(((FrontendImplementationViewElement)element).getRange().getStartOffset() + 52));
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        SandboxInfo sandboxInfo = new SandboxInfo("QuickDefinition", (RdDocumentId)rdFileDocumentId, string3, rdTextRange, true, null, list, true, list2, rdLanguage2, true, null, false, true, list3, 4096, null);
        SandboxManager sandboxManager = SandboxManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)createdDocument);
        sandboxManager.markAsSandbox(createdDocument, (AbstractSandboxInfo)sandboxInfo);
        createdDocument.putUserData(this.navigationOffset, (Object)Math.max(0, ((FrontendImplementationViewElement)element).getNavigationOffset() - ((FrontendImplementationViewElement)element).getRange().getStartOffset()));
        return createdDocument;
    }

    public void tuneEditorAfterShow(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Integer offset = (Integer)editor.getDocument().getUserData(this.navigationOffset);
        if (offset != null) {
            editor.getCaretModel().moveToOffset(offset.intValue());
            editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(offset.intValue()), ScrollType.MAKE_VISIBLE);
        }
        editor.getContentComponent().requestFocus();
    }
}

