/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editors.ILastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.StateForBackend;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "isInAfterFinishedCallback", "", "backendToGateway", "", "Lcom/jetbrains/rider/editors/StateForBackend;", "isSyncFromBackendInProgress", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAnyGatewaySyncing", "syncFromBackend", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "doAfterSyncFinished", "", "gatewayForBackend", "action", "Lkotlin/Function0;", "onSyncFromBackendFinished", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderBackendInteractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1807#2,3:126\n1915#2,2:133\n1#3:129\n39#4,3:130\n43#4:135\n13#5:136\n13#6:137\n*S KotlinDebug\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper\n*L\n44#1:126,3\n92#1:133,2\n91#1:130,3\n91#1:135\n23#1:136\n23#1:137\n*E\n"})
public final class RiderBackendInteractionHelper
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    private boolean isInAfterFinishedCallback;
    @NotNull
    private final Map<ClientAppSession, StateForBackend> backendToGateway;
    @NotNull
    private static final Logger logger;

    public RiderBackendInteractionHelper(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.backendToGateway = new LinkedHashMap();
        this.backendToGateway.put(this.session, new StateForBackend());
    }

    public final boolean isSyncFromBackendInProgress(@Nullable VirtualFile file) {
        return this.isSyncFromBackendInProgress();
    }

    public final boolean isSyncFromBackendInProgress() {
        StateForBackend stateForBackend = this.backendToGateway.get(this.session);
        Intrinsics.checkNotNull((Object)stateForBackend);
        return (Boolean)stateForBackend.getSyncFromBackendInProgress().getValue();
    }

    public final boolean isAnyGatewaySyncing() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.backendToGateway.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StateForBackend it = (StateForBackend)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.getSyncFromBackendInProgress().getValue()).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final boolean syncFromBackend(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return true;
        }
        if (!(!this.isInAfterFinishedCallback)) {
            boolean bl = false;
            String string = "Cannot use this api while executing afterFinished callback. Try to use 'callSynchronously'";
            throw new IllegalArgumentException(string.toString());
        }
        StateForBackend stateForBackend = this.backendToGateway.get(this.session);
        Intrinsics.checkNotNull((Object)stateForBackend);
        StateForBackend gateway = stateForBackend;
        if (((Boolean)gateway.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            return false;
        }
        lifetime.bracket(() -> RiderBackendInteractionHelper.syncFromBackend$lambda$1(this, lifetime, gateway), () -> RiderBackendInteractionHelper.syncFromBackend$lambda$2(gateway));
        return true;
    }

    private final void doAfterSyncFinished(StateForBackend gatewayForBackend, Lifetime lifetime, Function0<Unit> action2) {
        if (!((Boolean)gatewayForBackend.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LifetimeDefinition definition = lifetime.createNested();
        gatewayForBackend.getSyncFromBackendInProgress().advise(definition.getLifetime(), arg_0 -> RiderBackendInteractionHelper.doAfterSyncFinished$lambda$0(definition, this, action2, arg_0));
    }

    public final void onSyncFromBackendFinished(@NotNull Lifetime lifetime, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        StateForBackend gateway = this.backendToGateway.get(this.session);
        if (gateway == null) {
            action2.invoke();
            return;
        }
        if (!((Boolean)gateway.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            action2.invoke();
        } else {
            this.doAfterSyncFinished(gateway, lifetime, action2);
        }
    }

    private static final Unit syncFromBackend$lambda$1(RiderBackendInteractionHelper this$0, Lifetime $lifetime, StateForBackend $gateway) {
        logger.trace("Begin syncing from backend...");
        ClientProjectSession projectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)this$0.session.getProjectSessions());
        if (projectSession != null) {
            ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(projectSession);
            boolean success2 = editorSuppressor.forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before syncing the backend");
            if (!success2) {
                throw new IllegalStateException("Can't release editor suppression.");
            }
            editorSuppressor.vetoSuppression($lifetime, "Syncing from backend");
        }
        $gateway.getSyncFromBackendInProgress().setValue((Object)true);
        return Unit.INSTANCE;
    }

    private static final Unit syncFromBackend$lambda$2(StateForBackend $gateway) {
        $gateway.getSyncFromBackendInProgress().setValue((Object)false);
        logger.trace("Syncing from backend has finished.");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit doAfterSyncFinished$lambda$0(LifetimeDefinition $definition, RiderBackendInteractionHelper this$0, Function0 $action, boolean value) {
        if (!value) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)$definition, (boolean)false, (int)1, null);
            Lifetime.Companion this_$iv = Lifetime.Companion;
            boolean $i$f$using = false;
            LifetimeDefinition def$iv = new LifetimeDefinition();
            try {
                Lifetime lt = def$iv.getLifetime();
                boolean bl = false;
                Iterable $this$forEach$iv = this$0.session.getProjectSessions();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClientProjectSession it = (ClientProjectSession)element$iv;
                    boolean bl2 = false;
                    ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(it);
                    editorSuppressor.vetoSuppression(lt, "doAfterSyncFinished");
                }
                try {
                    this$0.isInAfterFinishedCallback = true;
                    $action.invoke();
                }
                finally {
                    this$0.isInAfterFinishedCallback = false;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderBackendInteractionHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderBackendInteractionHelper.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderBackendInteractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,125:1\n30#2,2:126\n*S KotlinDebug\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion\n*L\n26#1:126,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderBackendInteractionHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project).getAppSession());
        }

        @NotNull
        public final RiderBackendInteractionHelper getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session2;
            boolean $i$f$service = false;
            Class<RiderBackendInteractionHelper> serviceClass$iv = RiderBackendInteractionHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderBackendInteractionHelper)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

