/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.encoding;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.encoding.FileEncodingSynchronizer;
import com.jetbrains.rider.encoding.FileEncodingSynchronizerKt;
import com.jetbrains.rider.ijent.extensions.PathExtKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\u00020\u00102\u0014\u0010\u001a\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settingsModel", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "getSettingsModel", "()Lcom/jetbrains/rd/ide/model/SettingsModel;", "settingsModel$delegate", "Lkotlin/Lazy;", "toAbsolutePath", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "synchronizeEncoding", "", "file", "encoding", "Ljava/nio/charset/Charset;", "registerListeners", "encodingMgr", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;", "initialSync", "(Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "synchronizeInitialMapping", "encodings", "", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DefaultEncodingChangeListener", "EncodingChangeListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFileEncodingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileEncodingSynchronizer.kt\ncom/jetbrains/rider/encoding/FileEncodingSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n23#2:145\n*S KotlinDebug\n*F\n+ 1 FileEncodingSynchronizer.kt\ncom/jetbrains/rider/encoding/FileEncodingSynchronizer\n*L\n55#1:145\n*E\n"})
final class FileEncodingSynchronizer {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy settingsModel$delegate;

    public FileEncodingSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.settingsModel$delegate = LazyKt.lazy(() -> FileEncodingSynchronizer.settingsModel_delegate$lambda$0(this));
    }

    private final SettingsModel getSettingsModel() {
        Lazy lazy = this.settingsModel$delegate;
        return (SettingsModel)lazy.getValue();
    }

    private final String toAbsolutePath(VirtualFile $this$toAbsolutePath) {
        Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)$this$toAbsolutePath);
        return path != null ? ((Object)path.toAbsolutePath()).toString() : null;
    }

    /*
     * Unable to fully structure code
     */
    private final void synchronizeEncoding(VirtualFile file, Charset encoding) {
        v0 = VirtualFileUtil.toNioPathOrNull((VirtualFile)file);
        if (v0 == null) ** GOTO lbl-1000
        v1 = v0.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toAbsolutePath(...)");
        v0 = v1;
        if (v1 != null) {
            v2 = PathExtKt.toRd(v0);
        } else lbl-1000:
        // 2 sources

        {
            v2 = absPath = null;
        }
        if (absPath == null) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            v3 = Logger.getInstance(FileEncodingSynchronizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
            v3.debug("Got a null path for " + file.getPath());
            return;
        }
        ((Map)this.getSettingsModel().getFileEncodings()).put(absPath, FileEncodingSynchronizerKt.access$convert(encoding, file.getBOM() != null));
    }

    public final void registerListeners(@NotNull EncodingProjectManager encodingMgr) {
        Intrinsics.checkNotNullParameter((Object)encodingMgr, (String)"encodingMgr");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new EncodingChangeListener(encodingMgr)));
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect();
        Topic topic2 = EncodingManagerListener.ENCODING_MANAGER_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"ENCODING_MANAGER_CHANGES");
        messageBusConnection2.subscribe(topic2, (Object)new DefaultEncodingChangeListener(encodingMgr));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object initialSync(@NotNull EncodingProjectManager encodingMgr, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof initialSync.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FileEncodingSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.initialSync(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = encodingMgr instanceof EncodingProjectManagerImpl != false ? (EncodingProjectManagerImpl)encodingMgr : null;
                v1 = v0 != null ? v0.getAllMappings() : null;
                if (v1 == null) {
                    v1 = MapsKt.emptyMap();
                }
                encodings = v1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)encodingMgr);
                $continuation.L$1 = encodings;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, encodingMgr, null){
                    int label;
                    final /* synthetic */ FileEncodingSynchronizer this$0;
                    final /* synthetic */ EncodingProjectManager $encodingMgr;
                    {
                        this.this$0 = $receiver;
                        this.$encodingMgr = $encodingMgr;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                IOptProperty iOptProperty = FileEncodingSynchronizer.access$getSettingsModel(this.this$0).getDefaultEncoding();
                                Charset charset = this.$encodingMgr.getDefaultCharset();
                                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
                                iOptProperty.set((Object)FileEncodingSynchronizerKt.access$convert(charset, false));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                encodings = (Map)$continuation.L$1;
                encodingMgr = (EncodingProjectManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl29:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)encodingMgr);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)encodings);
                $continuation.label = 2;
                v3 = this.synchronizeInitialMapping(encodings, (Continuation<? super Unit>)$continuation);
                if (v3 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                encodings = (Map)$continuation.L$1;
                encodingMgr = (EncodingProjectManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl41:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object synchronizeInitialMapping(Map<? extends VirtualFile, ? extends Charset> encodings, Continuation<? super Unit> $completion) {
        if (!($completion instanceof synchronizeInitialMapping.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ FileEncodingSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FileEncodingSynchronizer.access$synchronizeInitialMapping(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = encodings.entrySet().iterator();
lbl13:
                // 3 sources

                while (var3_6.hasNext()) {
                    var4_7 = var3_6.next();
                    file = var4_7.getKey();
                    encoding = var4_7.getValue();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)encodings);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)file);
                    $continuation.L$3 = encoding;
                    $continuation.L$4 = null;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<VirtualFile>>, Object>(file, null){
                        int label;
                        final /* synthetic */ VirtualFile $file;
                        {
                            this.$file = $file;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return VfsUtil.collectChildrenRecursively((VirtualFile)this.$file);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<VirtualFile>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl35
                }
                break;
            }
            case 1: {
                encoding = (Charset)$continuation.L$3;
                file = (VirtualFile)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                encodings = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"withContext(...)");
                allChildren = (List)v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)encodings);
                $continuation.L$1 = var3_6;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)encoding);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)allChildren);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<VirtualFile>)allChildren, this, encoding, null){
                    int label;
                    final /* synthetic */ List<VirtualFile> $allChildren;
                    final /* synthetic */ FileEncodingSynchronizer this$0;
                    final /* synthetic */ Charset $encoding;
                    {
                        this.$allChildren = $allChildren;
                        this.this$0 = $receiver;
                        this.$encoding = $encoding;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                for (VirtualFile child : this.$allChildren) {
                                    Intrinsics.checkNotNull((Object)child);
                                    if (!VirtualFileUtil.isFile((VirtualFile)child)) continue;
                                    FileEncodingSynchronizer.access$synchronizeEncoding(this.this$0, child, this.$encoding);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 != var10_5) ** GOTO lbl13
                return var10_5;
            }
            case 2: {
                allChildren = (List)$continuation.L$4;
                encoding = (Charset)$continuation.L$3;
                file = (VirtualFile)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                encodings = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl13
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final SettingsModel settingsModel_delegate$lambda$0(FileEncodingSynchronizer this$0) {
        return SettingsModel_GeneratedKt.getSettingsModel((IProtocol)ApplicationProtocolKt.getProtocolHost(this$0.project).getProtocol());
    }

    public static final /* synthetic */ Object access$synchronizeInitialMapping(FileEncodingSynchronizer $this, Map encodings, Continuation $completion) {
        return $this.synchronizeInitialMapping(encodings, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSynchronizer$DefaultEncodingChangeListener;", "Lcom/intellij/openapi/vfs/encoding/EncodingManagerListener;", "encodingMgr", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;", "<init>", "(Lcom/jetbrains/rider/encoding/FileEncodingSynchronizer;Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;)V", "propertyChanged", "", "document", "Lcom/intellij/openapi/editor/Document;", "propertyName", "", "oldValue", "", "newValue", "intellij.rider.rdclient.dotnet"})
    private final class DefaultEncodingChangeListener
    implements EncodingManagerListener {
        @NotNull
        private final EncodingProjectManager encodingMgr;

        public DefaultEncodingChangeListener(EncodingProjectManager encodingMgr) {
            Intrinsics.checkNotNullParameter((Object)encodingMgr, (String)"encodingMgr");
            this.encodingMgr = encodingMgr;
        }

        public void propertyChanged(@Nullable Document document, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            if (Intrinsics.areEqual((Object)"defaultFilesEncoding", (Object)propertyName)) {
                IOptProperty iOptProperty = FileEncodingSynchronizer.this.getSettingsModel().getDefaultEncoding();
                Charset charset = this.encodingMgr.getDefaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
                iOptProperty.set((Object)FileEncodingSynchronizerKt.access$convert(charset, false));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSynchronizer$EncodingChangeListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "encodingMgr", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;", "<init>", "(Lcom/jetbrains/rider/encoding/FileEncodingSynchronizer;Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;)V", "removeFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "propertyChanged", "event", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "fileCopied", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "fileDeleted", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "intellij.rider.rdclient.dotnet"})
    private final class EncodingChangeListener
    implements VirtualFileListener {
        @NotNull
        private final EncodingProjectManager encodingMgr;

        public EncodingChangeListener(EncodingProjectManager encodingMgr) {
            Intrinsics.checkNotNullParameter((Object)encodingMgr, (String)"encodingMgr");
            this.encodingMgr = encodingMgr;
        }

        private final void removeFile(VirtualFile file) {
            Path path;
            block3: {
                block2: {
                    path = VirtualFileUtil.toNioPathOrNull((VirtualFile)file);
                    if (path == null) break block2;
                    Path path2 = path.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
                    path = path2;
                    if (path2 != null && (path = PathExtKt.toRd(path)) != null) break block3;
                }
                return;
            }
            Path absPath = path;
            FileEncodingSynchronizer.this.getSettingsModel().getFileEncodings().remove((Object)absPath);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)"encoding", (Object)event.getPropertyName())) {
                Object object = event.getNewValue();
                Charset charset = object instanceof Charset ? (Charset)object : null;
                if (charset == null) {
                    return;
                }
                Charset charset2 = charset;
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                FileEncodingSynchronizer.this.synchronizeEncoding(virtualFile, charset2);
            }
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            if (!VirtualFileUtil.isFile((VirtualFile)file)) {
                return;
            }
            Charset charset = this.encodingMgr.getEncoding(file, false);
            if (charset == null) {
                return;
            }
            Charset charset2 = charset;
            FileEncodingSynchronizer.this.synchronizeEncoding(file, charset2);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this.removeFile(virtualFile);
        }
    }
}

