/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environment.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.text.StringKt;
import com.jetbrains.rider.environment.NetCoreRuntime;
import com.jetbrains.rider.environment.local.NetCoreUtil;
import com.jetbrains.rider.environment.local.RiderLocalEnvironment;
import com.jetbrains.rider.infrastructure.DeprecatedDotNetSdkCmd;
import java.io.File;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\f\u0010\u000eR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/environment/local/LocalNetCoreRuntime;", "Lcom/jetbrains/rider/environment/NetCoreRuntime;", "<init>", "()V", "BACKEND_RUNTIME_PATH_PROPERTY", "", "usedRuntime", "Lcom/jetbrains/rider/environment/local/LocalNetCoreRuntime$UsedRuntime;", "getUsedRuntime", "()Lcom/jetbrains/rider/environment/local/LocalNetCoreRuntime$UsedRuntime;", "usedRuntime$delegate", "Lkotlin/Lazy;", "isUsingBundledRuntimeForBackend", "", "()Z", "isUsingBundledRuntimeForBackend$delegate", "cliPath", "Lkotlin/Lazy;", "getCliPath", "()Lkotlin/Lazy;", "getBundledDotnetCoreRuntime", "platform", "Ljava/nio/file/Path;", "UsedRuntime", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderLocalEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLocalEnvironment.kt\ncom/jetbrains/rider/environment/local/LocalNetCoreRuntime\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,721:1\n23#2:722\n*S KotlinDebug\n*F\n+ 1 RiderLocalEnvironment.kt\ncom/jetbrains/rider/environment/local/LocalNetCoreRuntime\n*L\n527#1:722\n*E\n"})
public final class LocalNetCoreRuntime
implements NetCoreRuntime {
    @NotNull
    public static final LocalNetCoreRuntime INSTANCE = new LocalNetCoreRuntime();
    @NotNull
    public static final String BACKEND_RUNTIME_PATH_PROPERTY = "rider.backend.dotnet.runtime.path";
    @NotNull
    private static final Lazy usedRuntime$delegate = LazyKt.lazy(LocalNetCoreRuntime::usedRuntime_delegate$lambda$0);
    @NotNull
    private static final Lazy isUsingBundledRuntimeForBackend$delegate = LazyKt.lazy(LocalNetCoreRuntime::isUsingBundledRuntimeForBackend_delegate$lambda$0);
    @NotNull
    private static final Lazy<String> cliPath = LazyKt.lazy(LocalNetCoreRuntime::cliPath$lambda$0);

    private LocalNetCoreRuntime() {
    }

    private final UsedRuntime getUsedRuntime() {
        Lazy lazy = usedRuntime$delegate;
        return (UsedRuntime)lazy.getValue();
    }

    public final boolean isUsingBundledRuntimeForBackend() {
        Lazy lazy = isUsingBundledRuntimeForBackend$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Lazy<String> getCliPath() {
        return cliPath;
    }

    private final UsedRuntime getBundledDotnetCoreRuntime(String platform) {
        Path explicitRuntime;
        LocalNetCoreRuntime $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LocalNetCoreRuntime.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        String string = System.getProperty(BACKEND_RUNTIME_PATH_PROPERTY);
        Path path = string != null && (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) != null ? NioPathUtil.toNioPathOrNull((String)string) : (explicitRuntime = null);
        if (explicitRuntime != null) {
            logger2.info("Loading runtime explicitly passed via rider.backend.dotnet.runtime.path: \"" + explicitRuntime + "\".");
            return new UsedRuntime(DeprecatedDotNetSdkCmd.getExecutable$default(explicitRuntime, null, 2, null), false);
        }
        String relativePath = platform + "/dotnet/" + (SystemInfo.isWindows ? "dotnet.exe" : "dotnet");
        File result2 = RiderLocalEnvironment.getBundledFileOrNull$default(RiderLocalEnvironment.INSTANCE, relativePath, false, null, 6, null);
        if (result2 != null) {
            Path path2 = result2.getCanonicalFile().toPath();
            logger2.info("Loading bundled runtime from path \"" + path2 + "\".");
            Intrinsics.checkNotNull((Object)path2);
            return new UsedRuntime(path2, true);
        }
        File bundledRuntimeScript = RiderLocalEnvironment.getBundledFileOrNull$default(RiderLocalEnvironment.INSTANCE, "dotnet-sdk.cmd", false, null, 6, null);
        if (bundledRuntimeScript != null) {
            Path path3 = bundledRuntimeScript.getCanonicalFile().toPath();
            logger2.info("Loading bundled runtime bootstrap script from path \"" + path3 + "\".");
            Intrinsics.checkNotNull((Object)path3);
            return new UsedRuntime(DeprecatedDotNetSdkCmd.getExecutable$default(path3, null, 2, null), false);
        }
        logger2.info("Bundled .NET runtime was not found, and system property rider.backend.dotnet.runtime.path is not defined. Executing fallback logic.");
        File runtimeFromPath = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)"dotnet");
        if (runtimeFromPath != null) {
            Path path4 = runtimeFromPath.getCanonicalFile().toPath();
            logger2.info("Loading runtime found in the PATH environment variable: \"" + path4 + "\".");
            Intrinsics.checkNotNull((Object)path4);
            return new UsedRuntime(path4, false);
        }
        throw new IllegalStateException("Cannot find .NET runtime to run Rider backend. Please make sure the Rider installation is not damaged, or pass the full path to the \"dotnet\" executable via rider.backend.dotnet.runtime.path system property.".toString());
    }

    @Override
    @NotNull
    public Path cliPath() {
        Path path = Path.of((String)cliPath.getValue(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    private static final UsedRuntime usedRuntime_delegate$lambda$0() {
        return INSTANCE.getBundledDotnetCoreRuntime(NetCoreUtil.INSTANCE.getPlatformId());
    }

    private static final boolean isUsingBundledRuntimeForBackend_delegate$lambda$0() {
        return INSTANCE.getUsedRuntime().isBundled();
    }

    private static final String cliPath$lambda$0() {
        return ((Object)INSTANCE.getUsedRuntime().getExecutable().toAbsolutePath()).toString();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/environment/local/LocalNetCoreRuntime$UsedRuntime;", "", "executable", "Ljava/nio/file/Path;", "isBundled", "", "<init>", "(Ljava/nio/file/Path;Z)V", "getExecutable", "()Ljava/nio/file/Path;", "()Z", "intellij.rider.rdclient.dotnet"})
    private static final class UsedRuntime {
        @NotNull
        private final Path executable;
        private final boolean isBundled;

        public UsedRuntime(@NotNull Path executable2, boolean isBundled) {
            Intrinsics.checkNotNullParameter((Object)executable2, (String)"executable");
            this.executable = executable2;
            this.isBundled = isBundled;
        }

        @NotNull
        public final Path getExecutable() {
            return this.executable;
        }

        public final boolean isBundled() {
            return this.isBundled;
        }
    }
}

