/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environment.local;

import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rider.environment.local.LocalNetCoreRuntime;
import com.jetbrains.rider.environment.local.RiderLocalEnvironment;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bJ\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u000bJ!\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00052\n\b\u0002\u0010+\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010-R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/environment/local/NetCoreUtil;", "", "<init>", "()V", "getPlatformId", "", "platform", "Lcom/intellij/platform/eel/EelPlatform;", "platformId", "()Ljava/lang/String;", "runOnNetCore", "", "executable", "Ljava/io/File;", "useManagedLauncher", "useNativeLauncher", "mapToNativeImage", "setVmOption", "", "setUseServerGc", "useServerGc", "jvmOptionName", "serverGCjvmOption", "serverGCNoAffinitizejvmOption", "serverGCHeapCountjvmOption", "GCConserveMemoryjvmOption", "useServerGC", "getUseServerGC", "()Z", "serverGCNoAffinitize", "getServerGCNoAffinitize", "serverGCHeapCount", "", "getServerGCHeapCount", "()I", "conserveMemory", "getConserveMemory", "useCompositeCrossgen", "getUseCompositeCrossgen", "runOnNetCoreOnWindows", "Lkotlin/Lazy;", "readBoolOption", "jvmOption", "default", "readIntOption", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;", "DotnetPlatform", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderLocalEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLocalEnvironment.kt\ncom/jetbrains/rider/environment/local/NetCoreUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,721:1\n23#2:722\n23#2:723\n*S KotlinDebug\n*F\n+ 1 RiderLocalEnvironment.kt\ncom/jetbrains/rider/environment/local/NetCoreUtil\n*L\n492#1:722\n473#1:723\n*E\n"})
public final class NetCoreUtil {
    @NotNull
    public static final NetCoreUtil INSTANCE;
    @NotNull
    private static final String platformId;
    @NotNull
    public static final String jvmOptionName = "rider.backend.netcore";
    @NotNull
    public static final String serverGCjvmOption = "rider.backend.gcserver";
    @NotNull
    public static final String serverGCNoAffinitizejvmOption = "rider.backend.gcserver.no.affinitize";
    @NotNull
    public static final String serverGCHeapCountjvmOption = "rider.backend.gcserver.heap.count";
    @NotNull
    public static final String GCConserveMemoryjvmOption = "rider.backend.gc.conserve.memory";
    private static final boolean useServerGC;
    private static final boolean serverGCNoAffinitize;
    private static final int serverGCHeapCount;
    private static final int conserveMemory;
    private static final boolean useCompositeCrossgen;
    @NotNull
    private static final Lazy<Boolean> runOnNetCoreOnWindows;

    private NetCoreUtil() {
    }

    @NotNull
    public final String getPlatformId(@NotNull EelPlatform platform) {
        DotnetPlatform dotnetPlatform;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (EelPlatformKt.isLinux((EelPlatform)platform) && Intrinsics.areEqual((Object)platform.getArch(), (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
            dotnetPlatform = DotnetPlatform.LINUX_ARM_64;
        } else if (EelPlatformKt.isLinux((EelPlatform)platform)) {
            dotnetPlatform = DotnetPlatform.LINUX_X64;
        } else if (EelPlatformKt.isMac((EelPlatform)platform) && Intrinsics.areEqual((Object)platform.getArch(), (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
            dotnetPlatform = DotnetPlatform.MACOS_ARM64;
        } else if (EelPlatformKt.isMac((EelPlatform)platform)) {
            dotnetPlatform = DotnetPlatform.MACOS_X64;
        } else if (EelPlatformKt.isWindows((EelPlatform)platform) && Intrinsics.areEqual((Object)platform.getArch(), (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
            dotnetPlatform = DotnetPlatform.WINDOWS_ARM64;
        } else if (EelPlatformKt.isWindows((EelPlatform)platform)) {
            dotnetPlatform = DotnetPlatform.WINDOWS_X64;
        } else {
            throw new IllegalStateException("Unknown platform".toString());
        }
        DotnetPlatform platform2 = dotnetPlatform;
        return platform2.getFolderName();
    }

    @NotNull
    public final String getPlatformId() {
        return platformId;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean runOnNetCore(@NotNull File executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        if (!this.runOnNetCore()) {
            return false;
        }
        v0 = executable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)v0, (String)".exe", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v1 = executable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)v1, (String)".dll", (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            v2 = FilesKt.getNameWithoutExtension((File)executable);
        } else {
            v2 = executable.getName();
        }
        executableNameWithoutExtension = v2;
        runtimeConfigDirectory = FileUtil.filesEqual((File)executable, (File)RiderLocalEnvironment.INSTANCE.getRiderBackendExecutable()) != false && this.useNativeLauncher() != false ? executable.getParentFile().getParentFile() : executable.getParentFile();
        Intrinsics.checkNotNull((Object)runtimeConfigDirectory);
        runtimeConfig = FilesKt.resolve((File)runtimeConfigDirectory, (String)(executableNameWithoutExtension + ".runtimeconfig.json"));
        windowsDesktopRuntimeConfig = FilesKt.resolve((File)runtimeConfigDirectory, (String)(executableNameWithoutExtension + ".windows.runtimeconfig.json"));
        netCoreRuntimeConfig = FilesKt.resolve((File)runtimeConfigDirectory, (String)(executableNameWithoutExtension + ".netcore.runtimeconfig.json"));
        return runtimeConfig.exists() != false || netCoreRuntimeConfig.exists() != false || SystemInfo.isWindows != false && windowsDesktopRuntimeConfig.exists() != false;
    }

    public final boolean useManagedLauncher() {
        return NetCoreUtil.readBoolOption$default(this, "rider.backend.launcher", false, 2, null);
    }

    public final boolean useNativeLauncher() {
        boolean defaultOption = LocalNetCoreRuntime.INSTANCE.isUsingBundledRuntimeForBackend();
        return this.readBoolOption("rider.backend.use.native.launcher", defaultOption);
    }

    @Nullable
    public final String mapToNativeImage(@NotNull String executable2) {
        String ni;
        Intrinsics.checkNotNullParameter((Object)executable2, (String)"executable");
        if (useCompositeCrossgen) {
            return executable2;
        }
        String string = FileUtilRt.getNameWithoutExtension((String)executable2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String name = string;
        if (FileUtilRt.extensionEquals((String)executable2, (String)"exe")) {
            String ni2 = name + ".ni.exe";
            if (new File(ni2).exists()) {
                return ni2;
            }
        } else if (FileUtilRt.extensionEquals((String)executable2, (String)"dll") && new File(ni = name + ".ni.dll").exists()) {
            return ni;
        }
        return null;
    }

    public final boolean runOnNetCore() {
        return !SystemInfo.isWindows || (Boolean)runOnNetCoreOnWindows.getValue() != false;
    }

    public final void setVmOption(boolean runOnNetCore) {
        VMOptions.setProperty((String)jvmOptionName, (String)String.valueOf(runOnNetCore));
    }

    public final void setUseServerGc(boolean useServerGc) {
        VMOptions.setProperty((String)serverGCjvmOption, (String)String.valueOf(useServerGc));
    }

    public final boolean getUseServerGC() {
        return useServerGC;
    }

    public final boolean getServerGCNoAffinitize() {
        return serverGCNoAffinitize;
    }

    public final int getServerGCHeapCount() {
        return serverGCHeapCount;
    }

    public final int getConserveMemory() {
        return conserveMemory;
    }

    public final boolean getUseCompositeCrossgen() {
        return useCompositeCrossgen;
    }

    public final boolean readBoolOption(@NotNull String jvmOption, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)jvmOption, (String)"jvmOption");
        String netCoreOpt = System.getProperty(jvmOption);
        CharSequence charSequence = netCoreOpt;
        if (charSequence == null || charSequence.length() == 0) {
            return bl;
        }
        return Boolean.parseBoolean(netCoreOpt) || Intrinsics.areEqual((Object)netCoreOpt, (Object)"1");
    }

    public static /* synthetic */ boolean readBoolOption$default(NetCoreUtil netCoreUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return netCoreUtil.readBoolOption(string, bl);
    }

    @Nullable
    public final Integer readIntOption(@NotNull String jvmOption, @Nullable Integer n) {
        Intrinsics.checkNotNullParameter((Object)jvmOption, (String)"jvmOption");
        String netCoreOpt = System.getProperty(jvmOption);
        Object object = netCoreOpt;
        if (object == null || object.length() == 0) {
            return n;
        }
        try {
            object = Integer.parseInt(netCoreOpt);
        }
        catch (Throwable e) {
            NetCoreUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NetCoreUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(e);
            object = n;
        }
        return object;
    }

    public static /* synthetic */ Integer readIntOption$default(NetCoreUtil netCoreUtil, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return netCoreUtil.readIntOption(string, n);
    }

    private static final boolean runOnNetCoreOnWindows$lambda$0() {
        boolean bl;
        boolean it = bl = INSTANCE.readBoolOption(jvmOptionName, true);
        boolean bl2 = false;
        NetCoreUtil $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NetCoreUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("rider.backend.netcore is " + it);
        return bl;
    }

    static {
        String string;
        INSTANCE = new NetCoreUtil();
        if (SystemInfo.isLinux && CpuArch.isArm64()) {
            string = DotnetPlatform.LINUX_ARM_64.getFolderName();
        } else if (SystemInfo.isLinux) {
            string = DotnetPlatform.LINUX_X64.getFolderName();
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            string = DotnetPlatform.MACOS_ARM64.getFolderName();
        } else if (SystemInfo.isMac) {
            string = DotnetPlatform.MACOS_X64.getFolderName();
        } else if (SystemInfo.isWindows && CpuArch.isArm64()) {
            string = DotnetPlatform.WINDOWS_ARM64.getFolderName();
        } else if (SystemInfo.isWindows) {
            string = DotnetPlatform.WINDOWS_X64.getFolderName();
        } else {
            throw new IllegalStateException("Unknown platform".toString());
        }
        platformId = string;
        useServerGC = INSTANCE.readBoolOption(serverGCjvmOption, true);
        serverGCNoAffinitize = INSTANCE.readBoolOption(serverGCNoAffinitizejvmOption, true);
        Integer n = INSTANCE.readIntOption(serverGCHeapCountjvmOption, 2);
        Intrinsics.checkNotNull((Object)n);
        serverGCHeapCount = n;
        Integer n2 = INSTANCE.readIntOption(GCConserveMemoryjvmOption, 6);
        Intrinsics.checkNotNull((Object)n2);
        conserveMemory = n2;
        runOnNetCoreOnWindows = LazyKt.lazy(NetCoreUtil::runOnNetCoreOnWindows$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/environment/local/NetCoreUtil$DotnetPlatform;", "", "folderName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getFolderName", "()Ljava/lang/String;", "LINUX_ARM_64", "LINUX_X64", "MACOS_ARM64", "MACOS_X64", "WINDOWS_ARM64", "WINDOWS_X64", "intellij.rider.rdclient.dotnet"})
    public static final class DotnetPlatform
    extends Enum<DotnetPlatform> {
        @NotNull
        private final String folderName;
        public static final /* enum */ DotnetPlatform LINUX_ARM_64 = new DotnetPlatform("linux-arm64");
        public static final /* enum */ DotnetPlatform LINUX_X64 = new DotnetPlatform("linux-x64");
        public static final /* enum */ DotnetPlatform MACOS_ARM64 = new DotnetPlatform("macos-arm64");
        public static final /* enum */ DotnetPlatform MACOS_X64 = new DotnetPlatform("macos-x64");
        public static final /* enum */ DotnetPlatform WINDOWS_ARM64 = new DotnetPlatform("windows-arm64");
        public static final /* enum */ DotnetPlatform WINDOWS_X64 = new DotnetPlatform("windows-x64");
        private static final /* synthetic */ DotnetPlatform[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DotnetPlatform(String folderName) {
            this.folderName = folderName;
        }

        @NotNull
        public final String getFolderName() {
            return this.folderName;
        }

        public static DotnetPlatform[] values() {
            return (DotnetPlatform[])$VALUES.clone();
        }

        public static DotnetPlatform valueOf(String value) {
            return Enum.valueOf(DotnetPlatform.class, value);
        }

        @NotNull
        public static EnumEntries<DotnetPlatform> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dotnetPlatformArray = new DotnetPlatform[]{DotnetPlatform.LINUX_ARM_64, DotnetPlatform.LINUX_X64, DotnetPlatform.MACOS_ARM64, DotnetPlatform.MACOS_X64, DotnetPlatform.WINDOWS_ARM64, DotnetPlatform.WINDOWS_X64};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

