/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environment.remote.deploy;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/RemoteEnvironmentUploadCache;", "", "folder", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "cacheFile", "kotlin.jvm.PlatformType", "serializer", "Lkotlinx/serialization/KSerializer;", "", "", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "getHashFor", "remotePath", "update", "", "hash", "save", "serialize", "deserialize", "PathAsStringSerializer", "intellij.rider.rdclient.dotnet"})
public final class RemoteEnvironmentUploadCache {
    private final Path cacheFile;
    @NotNull
    private final KSerializer<Map<Path, String>> serializer;
    @NotNull
    private final ConcurrentHashMap<Path, String> cache;

    public RemoteEnvironmentUploadCache(@NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.cacheFile = folder.resolve("deploy-cache.json");
        this.serializer = BuiltinSerializersKt.MapSerializer((KSerializer)PathAsStringSerializer.INSTANCE, (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));
        this.cache = new ConcurrentHashMap();
        this.cache.putAll(this.deserialize());
    }

    @Nullable
    public final String getHashFor(@NotNull Path remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return this.cache.get(remotePath);
    }

    public final void update(@NotNull Path remotePath, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        ((Map)this.cache).put(remotePath, hash);
    }

    public final void save() {
        Path path = this.cacheFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cacheFile");
        PathsKt.writeText$default((Path)path, (CharSequence)this.serialize(), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final String serialize() {
        Json json = JsonKt.Json$default(null, RemoteEnvironmentUploadCache::serialize$lambda$0, (int)1, null);
        return json.encodeToString((SerializationStrategy)this.serializer, this.cache);
    }

    private final Map<Path, String> deserialize() {
        Path path = this.cacheFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cacheFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return MapsKt.emptyMap();
        }
        Json json = JsonKt.Json$default(null, RemoteEnvironmentUploadCache::deserialize$lambda$0, (int)1, null);
        Path path3 = this.cacheFile;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"cacheFile");
        String jsonString = PathsKt.readText$default((Path)path3, null, (int)1, null);
        return (Map)json.decodeFromString((DeserializationStrategy)this.serializer, jsonString);
    }

    private static final Unit serialize$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(false);
        return Unit.INSTANCE;
    }

    private static final Unit deserialize$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/RemoteEnvironmentUploadCache$PathAsStringSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/nio/file/Path;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "intellij.rider.rdclient.dotnet"})
    @Serializer(forClass=Path.class)
    public static final class PathAsStringSerializer
    implements KSerializer<Path> {
        @NotNull
        public static final PathAsStringSerializer INSTANCE = new PathAsStringSerializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Path", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

        private PathAsStringSerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull Path value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeString(((Object)value).toString());
        }

        @NotNull
        public Path deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Path path = Paths.get(decoder.decodeString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
    }
}

