/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootHost;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.utils.threading.BackgroundProcessQueue;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;Lcom/intellij/openapi/Disposable;)V", "queue", "Lcom/jetbrains/rider/utils/threading/BackgroundProcessQueue;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Item;", "isReady", "", "()Z", "warmedFiles", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "startup", "", "enqueue", "rootFile", "isRecursive", "Companion", "Item", "VfsWarmQueueStartupActivity", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWarmQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWarmQueue.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n13#2:85\n*S KotlinDebug\n*F\n+ 1 VfsWarmQueue.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue\n*L\n23#1:85\n*E\n"})
public final class VfsWarmQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VfsWatchRootFilter filter;
    @NotNull
    private final Disposable parent;
    @NotNull
    private final BackgroundProcessQueue<Item> queue;
    @NotNull
    private final HashSet<File> warmedFiles;
    @NotNull
    private static final Logger logger;

    public VfsWarmQueue(@NotNull Project project, @NotNull VfsWatchRootFilter filter2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.filter = filter2;
        this.parent = parent;
        this.queue = new BackgroundProcessQueue(arg_0 -> VfsWarmQueue.queue$lambda$0(this, arg_0));
        this.warmedFiles = new HashSet();
    }

    public final boolean isReady() {
        return this.queue.isReady();
    }

    public final void startup() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.queue.enqueue(new Item(SolutionHostExtensionsKt.getSolutionDirectory(this.project), true));
    }

    public final void enqueue(@NotNull File rootFile, boolean isRecursive) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.filter.shouldWatch(rootFile) || !this.warmedFiles.add(rootFile)) {
            return;
        }
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            String[] stringArray = new String[]{rootFile.getPath()};
            VfsRootAccess.allowRootAccess((Disposable)this.parent, (String[])stringArray);
        }
        this.queue.enqueue(new Item(rootFile, isRecursive));
    }

    private static final Unit queue$lambda$0(VfsWarmQueue this$0, Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (ApplicationKt.getApplication().isInternal() || logger.isTraceEnabled()) {
            String suffix = item.getWarmRecursive() ? "recursive" : "flat";
            String message = "Warm '" + item.getWarmFile().getPath() + "' " + suffix;
            VfsWatchRootHost.Companion.reportEventLog(message);
            logger.trace(message);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)item.getWarmFile(), (boolean)true);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFileToWarm = virtualFile;
        if (item.getWarmRecursive()) {
            VfsIterator vfsIterator = VfsIterator.Companion.create(this$0.project);
            if (vfsIterator != null) {
                vfsIterator.visitChildrenRecursively(virtualFileToWarm);
            }
        } else {
            Unit unit;
            try {
                unit = virtualFileToWarm.getChildren();
            }
            catch (InvalidVirtualFileAccessException e) {
                unit = Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsWarmQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWarmQueue.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Item;", "", "warmFile", "Ljava/io/File;", "warmRecursive", "", "<init>", "(Ljava/io/File;Z)V", "getWarmFile", "()Ljava/io/File;", "getWarmRecursive", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class Item {
        @NotNull
        private final File warmFile;
        private final boolean warmRecursive;

        public Item(@NotNull File warmFile, boolean warmRecursive) {
            Intrinsics.checkNotNullParameter((Object)warmFile, (String)"warmFile");
            this.warmFile = warmFile;
            this.warmRecursive = warmRecursive;
        }

        @NotNull
        public final File getWarmFile() {
            return this.warmFile;
        }

        public final boolean getWarmRecursive() {
            return this.warmRecursive;
        }

        @NotNull
        public final File component1() {
            return this.warmFile;
        }

        public final boolean component2() {
            return this.warmRecursive;
        }

        @NotNull
        public final Item copy(@NotNull File warmFile, boolean warmRecursive) {
            Intrinsics.checkNotNullParameter((Object)warmFile, (String)"warmFile");
            return new Item(warmFile, warmRecursive);
        }

        public static /* synthetic */ Item copy$default(Item item, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                file = item.warmFile;
            }
            if ((n & 2) != 0) {
                bl = item.warmRecursive;
            }
            return item.copy(file, bl);
        }

        @NotNull
        public String toString() {
            return "Item(warmFile=" + this.warmFile + ", warmRecursive=" + this.warmRecursive + ")";
        }

        public int hashCode() {
            int result2 = this.warmFile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.warmRecursive);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual((Object)this.warmFile, (Object)item.warmFile)) {
                return false;
            }
            return this.warmRecursive == item.warmRecursive;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$VfsWarmQueueStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.rdclient.dotnet"})
    public static final class VfsWarmQueueStartupActivity
    implements ProjectActivity,
    DumbAware {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Object object = RdCoroutinesUtilKt.withUiContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            VfsWatchRootHost.Companion.getInstance(this.$project).startup();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion, (int)1, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

