/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ijent.paths;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.jetbrains.rd.ide.model.RdPath;
import com.jetbrains.rider.ijent.extensions.InteractionContextId;
import com.jetbrains.rider.ijent.extensions.PathExtKt;
import com.jetbrains.rider.ijent.paths.RiderBackendPathMapper;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0013*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/ijent/paths/EnvironmentAwareMapper;", "Lcom/jetbrains/rider/ijent/paths/RiderBackendPathMapper;", "<init>", "()V", "FALLBACK_DESCRIPTOR_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "toFile", "Ljava/io/File;", "path", "Lcom/jetbrains/rd/ide/model/RdPath;", "toNioPath", "Ljava/nio/file/Path;", "toVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshIfNeeded", "", "toEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "toRd", "toRdPath", "file", "toNioPathOrNull", "asEelPathOrNull", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEnvironmentAwareMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentAwareMapper.kt\ncom/jetbrains/rider/ijent/paths/EnvironmentAwareMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n1#2:90\n13#3:91\n*S KotlinDebug\n*F\n+ 1 EnvironmentAwareMapper.kt\ncom/jetbrains/rider/ijent/paths/EnvironmentAwareMapper\n*L\n21#1:91\n*E\n"})
public final class EnvironmentAwareMapper
implements RiderBackendPathMapper {
    @NotNull
    public static final EnvironmentAwareMapper INSTANCE = new EnvironmentAwareMapper();
    @NotNull
    private static final String FALLBACK_DESCRIPTOR_ID = "Local";
    @NotNull
    private static final Logger LOG;

    private EnvironmentAwareMapper() {
    }

    @Override
    @NotNull
    public File toFile(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path nioPath = this.toNioPathOrNull(path);
        Object object = nioPath;
        if (object == null || (object = object.toString()) == null) {
            object = path.getValue();
        }
        return new File((String)object);
    }

    @Override
    @NotNull
    public Path toNioPath(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return EelNioBridgeServiceKt.asNioPath((EelPath)this.toEelPath(path));
    }

    @Override
    @Nullable
    public VirtualFile toVirtualFile(@NotNull RdPath path, boolean refreshIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return VfsUtil.findFileByIoFile((File)this.toFile(path), (boolean)refreshIfNeeded);
    }

    @Override
    @NotNull
    public EelPath toEelPath(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return EelPath.Companion.parse(path.getValue(), InteractionContextId.INSTANCE.getDescriptor(path.getContextId()));
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull EelPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RdPath(InteractionContextId.INSTANCE.getId(path.getDescriptor()), path.toString());
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        EelPath eelPath = this.asEelPathOrNull(path);
        EelPath eelPath2 = eelPath;
        if (eelPath2 == null || (eelPath2 = PathExtKt.toRd(eelPath2)) == null) {
            EnvironmentAwareMapper $this$toRd_u24lambda_u240 = this;
            boolean bl = false;
            LOG.warn("Failed to convert Path '" + ((Object)path).toString() + "' to RdPath");
            eelPath2 = new RdPath(FALLBACK_DESCRIPTOR_ID, ((Object)path).toString());
        }
        return eelPath2;
    }

    @Override
    @NotNull
    public RdPath toRdPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = NioPathUtil.toNioPathOrNull((String)path);
        EelPath eelPath = path2 != null ? this.asEelPathOrNull(path2) : null;
        EelPath eelPath2 = eelPath;
        if (eelPath2 == null || (eelPath2 = PathExtKt.toRd(eelPath2)) == null) {
            EnvironmentAwareMapper $this$toRdPath_u24lambda_u240 = this;
            boolean bl = false;
            LOG.warn("Failed to convert String '" + path + "' to RdPath");
            eelPath2 = new RdPath(FALLBACK_DESCRIPTOR_ID, path);
        }
        return eelPath2;
    }

    @Override
    @NotNull
    public RdPath toRdPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.getFileSystem().getNioPath(file);
        EelPath eelPath = path != null ? this.asEelPathOrNull(path) : null;
        EelPath eelPath2 = eelPath;
        if (eelPath2 == null || (eelPath2 = PathExtKt.toRd(eelPath2)) == null) {
            EnvironmentAwareMapper $this$toRdPath_u24lambda_u241 = this;
            boolean bl = false;
            LOG.warn("Failed to convert VirtualFile '" + file.getPath() + "' to RdPath");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            eelPath2 = new RdPath(FALLBACK_DESCRIPTOR_ID, string);
        }
        return eelPath2;
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = NioPathUtil.toNioPathOrNull((String)string);
        EelPath eelPath = path != null ? this.asEelPathOrNull(path) : null;
        EelPath eelPath2 = eelPath;
        if (eelPath2 == null || (eelPath2 = PathExtKt.toRd(eelPath2)) == null) {
            EnvironmentAwareMapper $this$toRd_u24lambda_u241 = this;
            boolean bl = false;
            LOG.warn("Failed to convert File '" + file.getPath() + "' to RdPath");
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            eelPath2 = new RdPath(FALLBACK_DESCRIPTOR_ID, string2);
        }
        return eelPath2;
    }

    private final Path toNioPathOrNull(RdPath path) {
        Object object;
        Object object2 = this;
        try {
            EnvironmentAwareMapper $this$toNioPathOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$toNioPathOrNull_u24lambda_u240.toNioPath(path));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private final EelPath asEelPathOrNull(Path $this$asEelPathOrNull) {
        EelPath eelPath;
        try {
            eelPath = EelNioBridgeServiceKt.asEelPath((Path)$this$asEelPathOrNull);
        }
        catch (EelPathException eelPathException) {
            eelPath = null;
        }
        return eelPath;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EnvironmentAwareMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

