/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ijent.paths;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.jetbrains.rd.ide.model.RdPath;
import com.jetbrains.rider.ijent.extensions.PathExtKt;
import com.jetbrains.rider.ijent.paths.RiderBackendPathMapper;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/ijent/paths/EnvironmentUnawarePathMapper;", "Lcom/jetbrains/rider/ijent/paths/RiderBackendPathMapper;", "<init>", "()V", "toFile", "Ljava/io/File;", "path", "Lcom/jetbrains/rd/ide/model/RdPath;", "toNioPath", "Ljava/nio/file/Path;", "toVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshIfNeeded", "", "toEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "toRd", "toRdPath", "", "file", "intellij.rider.rdclient.dotnet"})
public final class EnvironmentUnawarePathMapper
implements RiderBackendPathMapper {
    @NotNull
    public static final EnvironmentUnawarePathMapper INSTANCE = new EnvironmentUnawarePathMapper();

    private EnvironmentUnawarePathMapper() {
    }

    @Override
    @NotNull
    public File toFile(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(path.getValue());
    }

    @Override
    @NotNull
    public Path toNioPath(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Path.of(path.getValue(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return path2;
    }

    @Override
    @Nullable
    public VirtualFile toVirtualFile(@NotNull RdPath path, boolean refreshIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return VfsUtil.findFileByIoFile((File)PathExtKt.toFile(path), (boolean)refreshIfNeeded);
    }

    @Override
    @NotNull
    public EelPath toEelPath(@NotNull RdPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return EelNioBridgeServiceKt.asEelPath((Path)this.toNioPath(path));
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull EelPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return PathExtKt.toRd(EelNioBridgeServiceKt.asNioPath((EelPath)path));
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RdPath("Local", ((Object)path).toString());
    }

    @Override
    @NotNull
    public RdPath toRdPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RdPath("Local", path);
    }

    @Override
    @NotNull
    public RdPath toRdPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new RdPath("Local", string);
    }

    @Override
    @NotNull
    public RdPath toRd(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new RdPath("Local", string);
    }
}

