/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inspections.callHierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rider.inspections.callHierarchy.RiderCallHierarchyBrowserKt;
import com.jetbrains.rider.inspections.callHierarchy.RiderCallHierarchyElement;
import com.jetbrains.rider.inspections.callHierarchy.RiderCallHierarchyNodeDescriptor;
import com.jetbrains.rider.inspections.callHierarchy.RiderCallHierarchyTreeStructure;
import com.jetbrains.rider.model.RdCallHierarchyElement;
import com.jetbrains.rider.model.RdCallHierarchySession;
import com.jetbrains.rider.model.RdCallHierarchyViewType;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001,B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J%\u0010\u0010\u001a\u00020\u00112\u001b\u0010\u0012\u001a\u0017\u0012\u000b\b\u0000\u0012\u00070\u000e\u00a2\u0006\u0002\b\u0014\u0012\u0006\b\u0000\u0012\u00020\u00150\u0013H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0005H\u0014J(\u0010\u001c\u001a\"\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001e\u0018\u00010\u001dj\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001e\u0018\u0001`\u001fH\u0014J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0017H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0002J\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/inspections/callHierarchy/RiderCallHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/CallHierarchyBrowserBase;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "sessionModel", "Lcom/jetbrains/rider/model/RdCallHierarchySession;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/jetbrains/rider/model/RdCallHierarchySession;)V", "getElementFromDescriptor", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "getContentDisplayName", "", "typeName", "createTrees", "", "trees", "", "Lorg/jetbrains/annotations/Nls;", "Ljavax/swing/JTree;", "isApplicableElement", "", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "type", "psiElement", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "Lkotlin/Comparator;", "changeView", "requestFocus", "doRefresh", "currentBuilderOnly", "mapViewTypeToViewStyle", "Lcom/jetbrains/rider/model/RdCallHierarchyViewType;", "viewType", "hasNextOccurence", "hasPreviousOccurence", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "MyOccurenceNavigatorSupport", "intellij.rider.rdclient.dotnet"})
public final class RiderCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    @NotNull
    private final RdCallHierarchySession sessionModel;

    public RiderCallHierarchyBrowser(@NotNull Project project, @NotNull PsiElement element, @NotNull RdCallHierarchySession sessionModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        super(project, element);
        this.sessionModel = sessionModel;
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return descriptor.getPsiElement();
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof RiderCallHierarchyElement) {
            Object[] objectArray = new Object[]{((RiderCallHierarchyElement)element).getText()};
            string = MessageFormat.format(typeName, objectArray);
        } else {
            string = super.getContentDisplayName(typeName, element);
        }
        return string;
    }

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        JTree jTree = this.createTree(true);
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"createTree(...)");
        JTree tree1 = jTree;
        PopupHandler.installPopupMenu((JComponent)tree1, (String)"RiderCallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        trees.put(CallHierarchyBrowserBase.getCallerType(), tree1);
        JTree jTree2 = this.createTree(true);
        Intrinsics.checkNotNullExpressionValue((Object)jTree2, (String)"createTree(...)");
        JTree tree2 = jTree2;
        PopupHandler.installPopupMenu((JComponent)tree2, (String)"RiderCallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        trees.put(CallHierarchyBrowserBase.getCalleeType(), tree2);
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof RiderCallHierarchyElement;
    }

    @NotNull
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        RiderCallHierarchyElement cfr_ignored_0 = (RiderCallHierarchyElement)psiElement;
        Icon icon = Intrinsics.areEqual((Object)type, (Object)CallHierarchyBrowserBase.getCalleeType()) ? AllIcons.Hierarchy.Subtypes : AllIcons.Hierarchy.Supertypes;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        RiderCallHierarchyElement newElem = new RiderCallHierarchyElement(project, ((RiderCallHierarchyElement)psiElement).getSessionModel(), ((RiderCallHierarchyElement)psiElement).getElementModel(), icon2);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        return new RiderCallHierarchyTreeStructure(project2, (RdCall<Integer, List<RdCallHierarchyElement>>)this.sessionModel.getGetChildren(), newElem);
    }

    @Nullable
    protected Comparator<NodeDescriptor<?>> getComparator() {
        return (Comparator)AlphaComparator.getInstance();
    }

    public void changeView(@NotNull String type, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super.changeView(type, requestFocus);
        this.sessionModel.getSetViewType().fire((Object)this.mapViewTypeToViewStyle(type));
    }

    protected void doRefresh(boolean currentBuilderOnly) {
        super.doRefresh(currentBuilderOnly);
        this.sessionModel.getRefresh().fire((Object)Unit.INSTANCE);
    }

    private final RdCallHierarchyViewType mapViewTypeToViewStyle(String viewType) {
        RdCallHierarchyViewType rdCallHierarchyViewType;
        String string = viewType;
        if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCallerType())) {
            rdCallHierarchyViewType = RdCallHierarchyViewType.Callers;
        } else if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCalleeType())) {
            rdCallHierarchyViewType = RdCallHierarchyViewType.Callees;
        } else {
            RiderCallHierarchyBrowserKt.access$getLogger$p().warn("Unexpected hierarchy tree type: " + viewType);
            rdCallHierarchyViewType = RdCallHierarchyViewType.Callers;
        }
        return rdCallHierarchyViewType;
    }

    public boolean hasNextOccurence() {
        JTree jTree = this.getCurrentTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getCurrentTree(...)");
        return new MyOccurenceNavigatorSupport(jTree).hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        JTree jTree = this.getCurrentTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getCurrentTree(...)");
        return new MyOccurenceNavigatorSupport(jTree).hasPreviousOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        JTree jTree = this.getCurrentTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getCurrentTree(...)");
        OccurenceNavigator.OccurenceInfo occurenceInfo = new MyOccurenceNavigatorSupport(jTree).goNextOccurence();
        Intrinsics.checkNotNullExpressionValue((Object)occurenceInfo, (String)"goNextOccurence(...)");
        return occurenceInfo;
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        JTree jTree = this.getCurrentTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getCurrentTree(...)");
        OccurenceNavigator.OccurenceInfo occurenceInfo = new MyOccurenceNavigatorSupport(jTree).goPreviousOccurence();
        Intrinsics.checkNotNullExpressionValue((Object)occurenceInfo, (String)"goPreviousOccurence(...)");
        return occurenceInfo;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/inspections/callHierarchy/RiderCallHierarchyBrowser$MyOccurenceNavigatorSupport;", "Lcom/intellij/ide/OccurenceNavigatorSupport;", "tree", "Ljavax/swing/JTree;", "<init>", "(Lcom/jetbrains/rider/inspections/callHierarchy/RiderCallHierarchyBrowser;Ljavax/swing/JTree;)V", "getNextOccurenceActionName", "", "getPreviousOccurenceActionName", "createDescriptorForNode", "Lcom/intellij/pom/Navigatable;", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "intellij.rider.rdclient.dotnet"})
    private final class MyOccurenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        public MyOccurenceNavigatorSupport(JTree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            super(tree);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = RiderCallHierarchyBrowser.this.getNextOccurenceActionNameImpl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getNextOccurenceActionNameImpl(...)");
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = RiderCallHierarchyBrowser.this.getPrevOccurenceActionNameImpl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getPrevOccurenceActionNameImpl(...)");
            return string;
        }

        @Nullable
        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = node.getUserObject();
            return object instanceof RiderCallHierarchyNodeDescriptor ? (RiderCallHierarchyNodeDescriptor)((Object)object) : null;
        }
    }
}

