/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.notifications;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rider.model.RiderSolutionLifecycle_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.ReSharperBackendPresenter;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/projectView/notifications/SolutionWaitNotification;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showNotification", "waitForReadyUnderTimeout", "Ljava/util/concurrent/CompletableFuture;", "Companion", "Collector", "intellij.rider.rdclient.dotnet"})
public final class SolutionWaitNotification
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long expectedTimeMs = Duration.ofSeconds(20L).toMillis();
    private static final double expectedTimeFraction = 0.8;
    private static final long stepTimeMs = 30L;

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationKt.getApplication().isUnitTestMode() || ApplicationKt.getApplication().isHeadlessEnvironment()) {
            return Unit.INSTANCE;
        }
        Object object = RdCoroutinesUtilKt.withUiContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            final /* synthetic */ SolutionWaitNotification this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SolutionWaitNotification.access$showNotification(this.this$0, this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void showNotification(Project project) {
        if (project.isDisposed()) {
            return;
        }
        if (((Boolean)RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution(project)).getSolutionLoadingStarted().getValue()).booleanValue()) {
            return;
        }
        Lifetime lifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project));
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        lifetime.onTermination(() -> SolutionWaitNotification.showNotification$lambda$0(future));
        long startTimeNs = System.nanoTime();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getProductName(), (String)"getProductName(...)");
        String title = RdClientDotnetBundle.INSTANCE.message("backend.notification.title", objectArray);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, future, this){
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ SolutionWaitNotification this$0;
            {
                this.$future = $future;
                this.this$0 = $receiver;
                super($project, $title, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String backendName = ReSharperBackendPresenter.Companion.getBackendName();
                Object[] objectArray = new Object[]{backendName};
                indicator.setText(RdClientDotnetBundle.INSTANCE.message("backend.notification.text", objectArray));
                indicator.setIndeterminate(false);
                double totalTimeMs = (double)SolutionWaitNotification.access$getExpectedTimeMs$cp() * 1.25;
                while (indicator.getFraction() < 0.8 && !this.$future.isDone()) {
                    SolutionWaitNotification.access$waitForReadyUnderTimeout(this.this$0, this.$future);
                    indicator.setFraction(indicator.getFraction() + (double)30L / totalTimeMs);
                }
                double restMs = totalTimeMs - (double)SolutionWaitNotification.access$getExpectedTimeMs$cp();
                while (!this.$future.isDone()) {
                    SolutionWaitNotification.access$waitForReadyUnderTimeout(this.this$0, this.$future);
                    double currentMs = indicator.getFraction() * totalTimeMs;
                    double q = (totalTimeMs - currentMs) / restMs;
                    indicator.setFraction(indicator.getFraction() + q / totalTimeMs);
                }
                while (indicator.getFraction() < 1.0) {
                    Thread.sleep(10L);
                    indicator.setFraction(indicator.getFraction() + 0.05);
                }
            }
        });
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution(project)).getSolutionLoadingStarted()), (Lifetime)lifetime, arg_0 -> SolutionWaitNotification.showNotification$lambda$1(future, startTimeNs, project, arg_0));
    }

    private final void waitForReadyUnderTimeout(CompletableFuture<?> $this$waitForReadyUnderTimeout) {
        try {
            $this$waitForReadyUnderTimeout.get(30L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private static final Unit showNotification$lambda$0(CompletableFuture $future) {
        $future.complete(false);
        return Unit.INSTANCE;
    }

    private static final Unit showNotification$lambda$1(CompletableFuture $future, long $startTimeNs, Project $project, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $future.complete(true);
        Duration duration = Duration.ofNanos(System.nanoTime() - $startTimeNs);
        Intrinsics.checkNotNull((Object)duration);
        Collector.INSTANCE.report($project, duration);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$showNotification(SolutionWaitNotification $this, Project project) {
        $this.showNotification(project);
    }

    public static final /* synthetic */ long access$getExpectedTimeMs$cp() {
        return expectedTimeMs;
    }

    public static final /* synthetic */ void access$waitForReadyUnderTimeout(SolutionWaitNotification $this, CompletableFuture $receiver) {
        $this.waitForReadyUnderTimeout($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/notifications/SolutionWaitNotification$Collector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "BACKEND_CONNECTION_TIME", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "BACKEND_CONNECTION_PROGRESS", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "report", "", "project", "Lcom/intellij/openapi/project/Project;", "progressDuration", "Ljava/time/Duration;", "getGroup", "intellij.rider.rdclient.dotnet"})
    public static final class Collector
    extends CounterUsagesCollector {
        @NotNull
        public static final Collector INSTANCE = new Collector();
        @NotNull
        private static final EventLogGroup GROUP = new EventLogGroup("rider.backend.connection", 1, null, 4, null);
        @NotNull
        private static final LongEventField BACKEND_CONNECTION_TIME = new LongEventField("backend_connection_time_ms");
        @NotNull
        private static final VarargEventId BACKEND_CONNECTION_PROGRESS;

        private Collector() {
        }

        public final void report(@NotNull Project project, @NotNull Duration progressDuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)progressDuration, (String)"progressDuration");
            EventPair[] eventPairArray = new EventPair[]{BACKEND_CONNECTION_TIME.with((Object)progressDuration.toMillis())};
            BACKEND_CONNECTION_PROGRESS.log(project, eventPairArray);
        }

        @NotNull
        public EventLogGroup getGroup() {
            return GROUP;
        }

        static {
            EventField[] eventFieldArray = new EventField[]{BACKEND_CONNECTION_TIME};
            BACKEND_CONNECTION_PROGRESS = GROUP.registerVarargEvent("rider.backend.connection.progress", eventFieldArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/projectView/notifications/SolutionWaitNotification$Companion;", "", "<init>", "()V", "expectedTimeMs", "", "expectedTimeFraction", "", "stepTimeMs", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

