/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.DockingLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.GutterMarkMenuLayoterKt;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterSource;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import com.jetbrains.rider.services.popups.nova.layouter.SimplePopupLayouterSource;
import com.jetbrains.rider.services.popups.nova.layouter.StaticAnchoringRect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/GutterMarkMenuLayoter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createLayouterSourceFromDocOffset", "Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouterSource;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "docOffset", "", "getAnchor", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class GutterMarkMenuLayoter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public GutterMarkMenuLayoter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final PopupLayouterSource createLayouterSourceFromDocOffset(@NotNull EditorEx editor, int docOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Function1 function1 = arg_0 -> GutterMarkMenuLayoter.createLayouterSourceFromDocOffset$lambda$0(this, docOffset, editor, arg_0);
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return new SimplePopupLayouterSource((Function1<? super Lifetime, ? extends PopupLayouter>)function1, string);
    }

    private final AnchoringRect getAnchor(int docOffset, EditorEx editor) {
        EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutterComponentEx = editorGutterComponentEx;
        VisualPosition visualPosition = editor.offsetToVisualPosition(docOffset);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition visualPosition2 = visualPosition;
        int y = editor.visualPositionToXY((VisualPosition)visualPosition2).y;
        Point point = new Point(gutterComponentEx.getIconAreaOffset(), y);
        SwingUtilities.convertPointToScreen(point, (Component)gutterComponentEx);
        Rectangle anchorRect = new Rectangle(point, new Dimension(editor.getLineHeight() + JBUI.scale((int)1), editor.getLineHeight() + JBUI.scale((int)1)));
        anchorRect = RectangleUtilsKt.smartClip(anchorRect, GutterMarkMenuLayoterKt.getScreenRectangle(point));
        return new StaticAnchoringRect(anchorRect);
    }

    private static final PopupLayouter createLayouterSourceFromDocOffset$lambda$0(GutterMarkMenuLayoter this$0, int $docOffset, EditorEx $editor, Lifetime lt) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        AnchoringRect anchor = this$0.getAnchor($docOffset, $editor);
        Object[] objectArray = new Anchoring2D[]{new Anchoring2D(Anchoring.NearInside, Anchoring.FarOutside), new Anchoring2D(Anchoring.NearInside, Anchoring.NearOutside)};
        return new DockingLayouter(lt, anchor, CollectionsKt.listOf((Object[])objectArray), this$0.project, null, 0, false, 112, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/GutterMarkMenuLayoter$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/services/popups/nova/layouter/GutterMarkMenuLayoter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nGutterMarkMenuLayoter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GutterMarkMenuLayoter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/GutterMarkMenuLayoter$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,59:1\n16#2,2:60\n*S KotlinDebug\n*F\n+ 1 GutterMarkMenuLayoter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/GutterMarkMenuLayoter$Companion\n*L\n20#1:60,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GutterMarkMenuLayoter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(GutterMarkMenuLayoter.class);
            if (object == null) {
                throw new IllegalStateException("Service " + GutterMarkMenuLayoter.class + " not found in container " + $this$getService$iv);
            }
            return (GutterMarkMenuLayoter)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

