/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.DockingLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.MousePositionLayouterSource;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.SimplePopupLayouterSource;
import com.jetbrains.rider.services.popups.nova.layouter.StaticAnchoringRect;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findCurrentWindow", "Ljava/awt/Window;", "centeredSource", "Lcom/jetbrains/rider/services/popups/nova/layouter/SimplePopupLayouterSource;", "getCenteredSource", "()Lcom/jetbrains/rider/services/popups/nova/layouter/SimplePopupLayouterSource;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nMainWindowLayouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindowLayouter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,53:1\n13#2:54\n13#3:55\n*S KotlinDebug\n*F\n+ 1 MainWindowLayouter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter\n*L\n15#1:54\n15#1:55\n*E\n"})
public final class MainWindowLayouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SimplePopupLayouterSource centeredSource;
    @NotNull
    private static final Logger LOG;

    public MainWindowLayouter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Function1 function1 = arg_0 -> MainWindowLayouter.centeredSource$lambda$0(this, arg_0);
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.centeredSource = new SimplePopupLayouterSource((Function1<? super Lifetime, ? extends PopupLayouter>)function1, string);
    }

    private final Window findCurrentWindow(Project project) {
        Component parent;
        Window window = null;
        Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(project);
        if (focusedComponent != null && (parent = UIUtil.findUltimateParent((Component)focusedComponent)) instanceof Window) {
            window = (Window)parent;
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        return window;
    }

    @NotNull
    public final SimplePopupLayouterSource getCenteredSource() {
        return this.centeredSource;
    }

    private static final PopupLayouter centeredSource$lambda$0(MainWindowLayouter this$0, Lifetime lt) {
        PopupLayouter popupLayouter;
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Window window = this$0.findCurrentWindow(this$0.project);
        if (window != null) {
            AnchoringRect anchor = StaticAnchoringRect.Companion.fromWindow(window);
            popupLayouter = new DockingLayouter(lt, anchor, CollectionsKt.listOf((Object)new Anchoring2D(Anchoring.MiddleInside, Anchoring.MiddleInside)), this$0.project, null, 0, false, 112, null);
        } else {
            LOG.error("Cannot find the current window");
            popupLayouter = new MousePositionLayouterSource(this$0.project).createLayouter(lt);
        }
        return popupLayouter;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MainWindowLayouter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nMainWindowLayouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindowLayouter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,53:1\n16#2,2:54\n*S KotlinDebug\n*F\n+ 1 MainWindowLayouter.kt\ncom/jetbrains/rider/services/popups/nova/layouter/MainWindowLayouter$Companion\n*L\n16#1:54,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MainWindowLayouter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(MainWindowLayouter.class);
            if (object == null) {
                throw new IllegalStateException("Service " + MainWindowLayouter.class + " not found in container " + $this$getService$iv);
            }
            return (MainWindowLayouter)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

