/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.GutterMarkMenuLayoterKt;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/StaticAnchoringRect;", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "rectangle", "Ljava/awt/Rectangle;", "<init>", "(Ljava/awt/Rectangle;)V", "point", "Ljava/awt/Point;", "(Ljava/awt/Point;)V", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getRectangle", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class StaticAnchoringRect
implements AnchoringRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IProperty<Rectangle> rectangle;

    public StaticAnchoringRect(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.rectangle = (IProperty)new Property((Object)rectangle);
    }

    @NotNull
    public IProperty<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public StaticAnchoringRect(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this(new Rectangle(point, new Dimension(0, 0)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/StaticAnchoringRect$Companion;", "", "<init>", "()V", "getRightComponent", "Ljavax/swing/JComponent;", "component", "Ljava/awt/Component;", "fromComponent", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "fromWindow", "window", "Ljava/awt/Window;", "fromCurrentMousePosition", "fromPoint", "point", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent getRightComponent(Component component) {
            if (component instanceof JComponent) {
                return (JComponent)component;
            }
            if (component instanceof RootPaneContainer) {
                return ((RootPaneContainer)((Object)component)).getRootPane();
            }
            return null;
        }

        @NotNull
        public final AnchoringRect fromComponent(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Rectangle visibleBounds = component.getVisibleRect();
            Point containerScreenPoint = visibleBounds.getLocation();
            SwingUtilities.convertPointToScreen(containerScreenPoint, component);
            visibleBounds.setLocation(containerScreenPoint);
            Intrinsics.checkNotNull((Object)visibleBounds);
            return new StaticAnchoringRect(visibleBounds);
        }

        @NotNull
        public final AnchoringRect fromWindow(@NotNull Window window) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            JComponent component = this.getRightComponent(window);
            Rectangle visibleBounds = component != null ? component.getVisibleRect() : new Rectangle(window.getSize());
            Point containerScreenPoint = visibleBounds.getLocation();
            JComponent jComponent = component;
            SwingUtilities.convertPointToScreen(containerScreenPoint, jComponent != null ? (Container)jComponent : (Container)window);
            visibleBounds.setLocation(containerScreenPoint);
            Intrinsics.checkNotNull((Object)visibleBounds);
            return new StaticAnchoringRect(visibleBounds);
        }

        @NotNull
        public final AnchoringRect fromCurrentMousePosition() {
            Point mousePosition = MouseInfo.getPointerInfo().getLocation();
            Rectangle anchorRect = new Rectangle(mousePosition, new Dimension(16, 16));
            Intrinsics.checkNotNull((Object)mousePosition);
            anchorRect = RectangleUtilsKt.smartClip(anchorRect, GutterMarkMenuLayoterKt.getScreenRectangle(mousePosition));
            return new StaticAnchoringRect(anchorRect);
        }

        @NotNull
        public final AnchoringRect fromPoint(@NotNull RelativePoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Point point2 = point.getScreenPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getScreenPoint(...)");
            Point screenPoint = point2;
            Rectangle anchorRect = new Rectangle(screenPoint, new Dimension(16, 16));
            anchorRect = RectangleUtilsKt.smartClip(anchorRect, GutterMarkMenuLayoterKt.getScreenRectangle(screenPoint));
            return new StaticAnchoringRect(anchorRect);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

