/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.ui.popup.list.FilterableListPopupStep;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import com.jetbrains.rd.ui.bindable.ViewModel;
import com.jetbrains.rd.ui.bindable.ViewRegistry;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.services.popups.nova.ItemExpandedEventArgs;
import com.jetbrains.rider.services.popups.nova.PopupItem;
import com.jetbrains.rider.services.popups.nova.PopupItemKt;
import com.jetbrains.rider.services.popups.nova.PopupListModel;
import com.jetbrains.rider.services.popups.nova.PopupViewModel;
import com.jetbrains.rider.services.popups.nova.impl.DefaultPopupListModel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004:\u00017B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0002H\u0016J\u000f\u0010'\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b(H\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\u001e\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0010H\u0016J\b\u0010-\u001a\u00020\u0010H\u0016J\u0012\u0010.\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u000bH\u0016J\b\u00105\u001a\u00020\u0010H\u0016J\b\u00106\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep;", "Lcom/intellij/openapi/ui/popup/util/BaseStep;", "Lcom/jetbrains/rider/services/popups/nova/PopupItem;", "Lcom/intellij/openapi/ui/popup/ListPopupStepEx;", "Lcom/intellij/ui/popup/list/FilterableListPopupStep;", "viewModel", "Lcom/jetbrains/rider/services/popups/nova/PopupViewModel;", "<init>", "(Lcom/jetbrains/rider/services/popups/nova/PopupViewModel;)V", "listeners", "", "Lcom/intellij/openapi/ui/popup/ListPopupStep$ListPopupModelListener;", "sizePreserver", "Lcom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep$PopupSizePreserver;", "synced", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getSynced", "()Lcom/jetbrains/rd/util/reactive/Property;", "getTextFor", "", "value", "getIconFor", "Ljavax/swing/Icon;", "isSelectable", "getDefaultOptionIndex", "", "setEmptyText", "", "emptyText", "Lcom/intellij/util/ui/StatusText;", "getTooltipTextFor", "getSecondaryTextFor", "", "t", "getSeparatorAbove", "Lcom/intellij/openapi/ui/popup/ListSeparator;", "hasSubstep", "selectedValue", "getTitle", "Lcom/intellij/openapi/util/NlsSafe;", "canceled", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "finalChoice", "isSpeedSearchEnabled", "updateFilter", "f", "getIndexedString", "getValues", "addListener", "listener", "removeListener", "isAutoSelectionEnabled", "fireUpdate", "PopupSizePreserver", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderPopupStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPopupStep.kt\ncom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n1807#2,3:185\n13#3:188\n13#3:189\n13#3:190\n*S KotlinDebug\n*F\n+ 1 RiderPopupStep.kt\ncom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep\n*L\n53#1:185,3\n88#1:188\n100#1:189\n93#1:190\n*E\n"})
public final class RiderPopupStep
extends BaseStep<PopupItem>
implements ListPopupStepEx<PopupItem>,
FilterableListPopupStep<PopupItem> {
    @NotNull
    private final PopupViewModel viewModel;
    @NotNull
    private final List<ListPopupStep.ListPopupModelListener> listeners;
    @NotNull
    private final PopupSizePreserver sizePreserver;
    @NotNull
    private final Property<Boolean> synced;

    public RiderPopupStep(@NotNull PopupViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
        this.listeners = new ArrayList();
        this.sizePreserver = new PopupSizePreserver(this);
        PopupListModel popupListModel = this.viewModel.getListModel();
        Intrinsics.checkNotNull((Object)popupListModel, (String)"null cannot be cast to non-null type com.jetbrains.rider.services.popups.nova.impl.DefaultPopupListModel");
        this.synced = ((DefaultPopupListModel)popupListModel).getSynced();
        this.viewModel.getListModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.fireUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.fireUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.fireUpdate();
            }
        });
    }

    @NotNull
    public final Property<Boolean> getSynced() {
        return this.synced;
    }

    @NotNull
    public String getTextFor(@NotNull PopupItem value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "<html>" + value.getDisplayName() + "</html>";
    }

    @Nullable
    public Icon getIconFor(@NotNull PopupItem value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.getIcon() != null) {
            return value.getIcon();
        }
        List list = (List)this.viewModel.getListModel().getFiltersCascade().getOutputItems().getValueOrNull();
        if (list != null) {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PopupItem it = (PopupItem)element$iv;
                        boolean bl3 = false;
                        if (!(it.getIcon() != null)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return EmptyIcon.ICON_16;
        }
        return null;
    }

    public boolean isSelectable(@NotNull PopupItem value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return PopupItemKt.isEnabled(value) || PopupItemKt.isExpandable(value);
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
        Intrinsics.checkNotNullParameter((Object)emptyText, (String)"emptyText");
    }

    @NotNull
    public String getTooltipTextFor(@NotNull PopupItem value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.getTooltipText();
    }

    @Nullable
    public Void getSecondaryTextFor(@NotNull PopupItem t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return null;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(@NotNull PopupItem value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return PopupItemKt.isWithSeparatorAbove(value) ? new ListSeparator() : (PopupItemKt.isWithGroupHeaderAbove(value) ? new ListSeparator(value.getGroupHeaderTextAbove()) : null);
    }

    public boolean hasSubstep(@NotNull PopupItem selectedValue) {
        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
        return PopupItemKt.isExpandable(selectedValue);
    }

    @Nullable
    public String getTitle() {
        ViewModel viewModel = (ViewModel)this.viewModel.getCaption().getValue();
        if (viewModel == null) {
            return null;
        }
        ViewModel caption = viewModel;
        JComponent view = ViewRegistry.Companion.getInstance().getView(caption, this.viewModel.getLifetime());
        return view instanceof SimpleColoredComponent ? ((SimpleColoredComponent)view).toString() : null;
    }

    public void canceled() {
        this.viewModel.terminateModel();
    }

    @Nullable
    public PopupStep<?> onChosen(@NotNull PopupItem selectedValue, boolean finalChoice) {
        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
        if (finalChoice && PopupItemKt.isEnabled(selectedValue) || !PopupItemKt.isExpandable(selectedValue)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RiderPopupStep.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.trace("Schedule final step for '" + selectedValue.getDisplayName() + "' item...");
            LifetimeDefinition finalStepLifetime = Lifetime.Companion.getEternal().createNested();
            this.viewModel.prolongForExecuting((Lifetime)finalStepLifetime);
            return this.doFinalStep(() -> RiderPopupStep.onChosen$lambda$0(selectedValue, this, finalStepLifetime));
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderPopupStep.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.trace("Expand '" + selectedValue.getDisplayName() + "'...");
        AsyncPromise promise = new AsyncPromise();
        SourceExKt.adviseOnce((ISource)((ISource)this.viewModel.getItemExpanded()), (Lifetime)Lifetime.Companion.getEternal(), arg_0 -> RiderPopupStep.onChosen$lambda$1(promise, arg_0));
        this.viewModel.getListModel().getFiltersCascade().getIncomingExpand().fire((Object)selectedValue);
        return (PopupStep)new AsyncPopupStep((Promise)promise);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public void updateFilter(@Nullable String f) {
        CharSequence charSequence;
        this.viewModel.getListModel().getSearchHost().isActive().setValue((Object)(!((charSequence = (CharSequence)f) == null || charSequence.length() == 0) ? 1 : 0));
        IProperty<String> iProperty = this.viewModel.getListModel().getSearchHost().getInputString();
        String string = f;
        if (string == null) {
            string = "";
        }
        iProperty.set((Object)string);
        this.sizePreserver.preserve(f);
    }

    @NotNull
    public String getIndexedString(@NotNull PopupItem value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getDisplayName().getText();
        Object object = value.getTailText();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return string + " " + (String)object;
    }

    @NotNull
    public List<PopupItem> getValues() {
        List result2 = new ArrayList();
        int n = this.viewModel.getListModel().getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.viewModel.getListModel().getElementAt(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
            result2.add(e);
        }
        return result2;
    }

    public void addListener(@NotNull ListPopupStep.ListPopupModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public void removeListener(@NotNull ListPopupStep.ListPopupModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public boolean isAutoSelectionEnabled() {
        return !PlatformUtils.isCidr();
    }

    private final void fireUpdate() {
        for (ListPopupStep.ListPopupModelListener listener2 : this.listeners) {
            listener2.onModelChanged();
        }
    }

    private static final Unit onChosen$lambda$1$0(AsyncPromise $promise, ItemExpandedEventArgs $args, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $promise.setResult((Object)new RiderPopupStep($args.getSubMenu()));
        return Unit.INSTANCE;
    }

    private static final void onChosen$lambda$0(PopupItem $selectedValue, RiderPopupStep this$0, LifetimeDefinition $finalStepLifetime) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderPopupStep.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.trace("Execute '" + $selectedValue.getDisplayName() + "' item...");
        RLifetimeKt.assertAlive((Lifetime)this$0.viewModel.getLifetime());
        this$0.viewModel.getListModel().getFiltersCascade().getIncomingExecute().fire((Object)$selectedValue);
        LifetimeDefinition.terminate$default((LifetimeDefinition)$finalStepLifetime, (boolean)false, (int)1, null);
    }

    private static final Unit onChosen$lambda$1(AsyncPromise $promise, ItemExpandedEventArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        PopupListModel popupListModel = args.getSubMenu().getListModel();
        Intrinsics.checkNotNull((Object)popupListModel, (String)"null cannot be cast to non-null type com.jetbrains.rider.services.popups.nova.impl.DefaultPopupListModel");
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)((DefaultPopupListModel)popupListModel).getSynced()), (Lifetime)args.getSubMenuLifetime(), arg_0 -> RiderPopupStep.onChosen$lambda$1$0($promise, args, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep$PopupSizePreserver;", "", "step", "Lcom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep;", "<init>", "(Lcom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep;)V", "originalSize", "Ljava/awt/Dimension;", "preserve", "", "filter", "", "tryGetPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderPopupStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPopupStep.kt\ncom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep$PopupSizePreserver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n*S KotlinDebug\n*F\n+ 1 RiderPopupStep.kt\ncom/jetbrains/rider/services/popups/nova/ui/RiderPopupStep$PopupSizePreserver\n*L\n164#1:185\n*E\n"})
    private static final class PopupSizePreserver {
        @NotNull
        private final RiderPopupStep step;
        @Nullable
        private Dimension originalSize;

        public PopupSizePreserver(@NotNull RiderPopupStep step) {
            Intrinsics.checkNotNullParameter((Object)((Object)step), (String)"step");
            this.step = step;
        }

        public final void preserve(@Nullable String filter2) {
            JBPopup popup = this.tryGetPopup();
            if (popup == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(PopupSizePreserver.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Can not get popup from " + this.step);
                return;
            }
            Dimension currentSize = popup.getSize();
            Dimension savedSize = this.originalSize;
            CharSequence charSequence = filter2;
            if (!(charSequence == null || charSequence.length() == 0) && savedSize == null) {
                this.originalSize = currentSize;
            }
            if (((charSequence = (CharSequence)filter2) == null || charSequence.length() == 0) && savedSize != null && (currentSize.width > savedSize.width || currentSize.height > savedSize.height)) {
                popup.setSize(savedSize);
            }
        }

        private final JBPopup tryGetPopup() {
            Object object = CollectionsKt.singleOrNull((List)this.step.listeners);
            return object instanceof JBPopup ? (JBPopup)object : null;
        }
    }
}

