/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.popups.ProtoViewModel;
import com.jetbrains.rd.ui.bindable.ViewRegistry;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.BeSimpleOptionsPageContent;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.settings.IRiderViewModelConfigurableKt;
import com.jetbrains.rider.settings.RiderCodeStyleContentPageConverter;
import com.jetbrains.rider.settings.RiderCodeStyleSettings;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeStyle.RiderCodeStyleTabPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J!\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\u0004\u0012\u00020\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel;", "Lcom/intellij/application/options/TabbedLanguageCodeStylePanel;", "language", "Lcom/intellij/lang/Language;", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settings", "<init>", "(Lcom/intellij/lang/Language;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "myTabsLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "myPages", "", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "dispose", "", "initTabs", "extractPages", "resetImpl", "addAutodetectButton", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleMainPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,211:1\n1#2:212\n67#3,4:213\n67#3,4:218\n13#3:226\n221#4:217\n222#4:222\n1915#5,2:223\n13#6:225\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n*L\n83#1:213,4\n117#1:218,4\n62#1:226\n86#1:217\n86#1:222\n173#1:223,2\n62#1:225\n*E\n"})
public class RiderCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LifetimeDefinition myTabsLifetime;
    @Nullable
    private Map<String, String> myPages;
    @NotNull
    private static final Logger LOG;

    public RiderCodeStyleMainPanel(@Nullable Language language, @NotNull CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentSettings, (String)"currentSettings");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(language, currentSettings, settings);
    }

    public void dispose() {
        LifetimeDefinition lifetimeDefinition = this.myTabsLifetime;
        if (lifetimeDefinition != null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        super.dispose();
    }

    protected void initTabs(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOG.trace("RiderCodeStyleMainPanel::initTabs");
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        permittedModalitiesImpl.allowPumpProtocolForComponent((Component)jComponent, (Disposable)this);
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getCurrentInstance();
        if (host != null) {
            boolean bl;
            boolean bl2 = bl = this.myTabsLifetime == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-RiderCodeStyleMainPanel$initTabs$22 = false;
                String $i$a$-assert-RiderCodeStyleMainPanel$initTabs$22 = "myTabsLifetime is not null";
                throw new AssertionError((Object)$i$a$-assert-RiderCodeStyleMainPanel$initTabs$22);
            }
            this.myTabsLifetime = host.getCurrentDialogLifetime().createNested();
            this.myPages = this.extractPages(settings);
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                Map<String, String> map = this.myPages;
                logger.trace("Preparing to initialize " + (map != null ? Integer.valueOf(map.size()) : null) + " pages for the Code Style settings page.");
            }
            Ref.BooleanRef autodetectButtonAdded = new Ref.BooleanRef();
            Map<String, String> map = this.myPages;
            Intrinsics.checkNotNull(map);
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl4 = false;
                Language language = this.getDefaultLanguage();
                FileType fileType = UnknownFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"INSTANCE");
                LifetimeDefinition lifetimeDefinition = this.myTabsLifetime;
                Intrinsics.checkNotNull((Object)lifetimeDefinition);
                RiderCodeStyleTabPanel myCodeStyleAbstractPanel = new RiderCodeStyleTabPanel(language, fileType, it.getValue(), (Lifetime)lifetimeDefinition, settings);
                host.requestFullPage(it.getKey(), (Function1<? super OptionsPageInfo, Unit>)((Function1)arg_0 -> RiderCodeStyleMainPanel.initTabs$lambda$2$0(myCodeStyleAbstractPanel, autodetectButtonAdded, this, arg_0)));
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger = $this$trace$iv2;
                    boolean bl5 = false;
                    logger.trace("Adding a tab " + myCodeStyleAbstractPanel + " (" + it.getKey() + ", " + it.getValue() + ") to " + this + ".");
                }
                this.addTab(myCodeStyleAbstractPanel);
            }
            Object[] objectArray = Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
            for (CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])objectArray) {
                if (!Intrinsics.areEqual((Object)provider.getLanguage(), (Object)this.getDefaultLanguage()) || provider.hasSettingsPage()) continue;
                this.createTab(provider);
            }
        } else if (ApplicationKt.getApplication().isHeadlessEnvironment()) {
            CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
            this.addTab(new CodeStyleAbstractPanel(codeStyleSettings){

                protected void resetImpl(CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                protected String getPreviewText() {
                    return "";
                }

                public boolean isModified(CodeStyleSettings settings) {
                    return false;
                }

                public JComponent getPanel() {
                    return new JPanel();
                }

                protected int getRightMargin() {
                    return 0;
                }

                public void apply(CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                protected FileType getFileType() {
                    Language language = this.getDefaultLanguage();
                    Object object = language != null ? language.getAssociatedFileType() : null;
                    Intrinsics.checkNotNull((Object)object);
                    return (FileType)object;
                }

                protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
                    Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                    return (EditorHighlighter)new EmptyEditorHighlighter(TextAttributes.ERASE_MARKER);
                }
            });
        }
    }

    @NotNull
    protected Map<String, String> extractPages(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings instanceof RiderCodeStyleSettings ? ((RiderCodeStyleSettings)settings).getPages() : MapsKt.emptyMap();
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getCurrentInstance();
        if (host != null && this.myPages != null) {
            Map<String, String> map = this.myPages;
            Intrinsics.checkNotNull(map);
            Iterable $this$forEach$iv = map.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                host.requestPage(it, (Function1<? super OptionsPageContentBase, Unit>)((Function1)RiderCodeStyleMainPanel::resetImpl$lambda$0$0));
            }
        }
        super.resetImpl(settings);
    }

    private final JPanel addAutodetectButton(CodeStylePageContent content) {
        JLabel descriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.label.based.on.the.existing.code.of.the.entire.solution", new Object[0]));
        descriptionLabel.setOpaque(true);
        descriptionLabel.setForeground(UIUtil.getMenuItemDisabledForeground());
        JButton runDetectionButton = new JButton(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.button.auto.detect.formatting.rules", new Object[0]));
        JPanel panelWithRunAutodetection = new JPanel();
        panelWithRunAutodetection.setBorder((Border)JBUI.Borders.empty());
        panelWithRunAutodetection.setLayout((LayoutManager)new MigLayout("insets 3 5 10 5"));
        panelWithRunAutodetection.setOpaque(true);
        panelWithRunAutodetection.add(runDetectionButton);
        panelWithRunAutodetection.add(descriptionLabel);
        panelWithRunAutodetection.setVisible(true);
        runDetectionButton.addActionListener(arg_0 -> RiderCodeStyleMainPanel.addAutodetectButton$lambda$0(descriptionLabel, content, arg_0));
        return panelWithRunAutodetection;
    }

    private static final Unit initTabs$lambda$2$0(RiderCodeStyleTabPanel $myCodeStyleAbstractPanel, Ref.BooleanRef $autodetectButtonAdded, RiderCodeStyleMainPanel this$0, OptionsPageInfo page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        OptionsPageContentBase content = page.getContent();
        $myCodeStyleAbstractPanel.setSearchableKeywords(IRiderViewModelConfigurableKt.getAllKeywords(page.getSearchableKeywords()));
        OptionsPageContentBase optionsPageContentBase = content;
        if (optionsPageContentBase instanceof CodeStylePageContent) {
            if (((CodeStylePageContent)content).getShowAutoDetectButton() && !$autodetectButtonAdded.element) {
                $autodetectButtonAdded.element = true;
                JPanel panelWithRunAutodetection = this$0.addAutodetectButton((CodeStylePageContent)content);
                JComponent jComponent = this$0.getPanel();
                Intrinsics.checkNotNull((Object)jComponent);
                jComponent.add((Component)panelWithRunAutodetection, "North");
            }
            $myCodeStyleAbstractPanel.setContent((CodeStylePageContent)content);
        } else if (optionsPageContentBase instanceof NamingPageContentBase) {
            $myCodeStyleAbstractPanel.setContent((NamingPageContentBase)content);
        } else if (optionsPageContentBase instanceof BeSimpleOptionsPageContent) {
            ViewRegistry viewRegistry = ViewRegistry.Companion.getInstance();
            ProtoViewModel protoViewModel = (ProtoViewModel)((BeSimpleOptionsPageContent)content).getAutomation();
            LifetimeDefinition lifetimeDefinition = this$0.myTabsLifetime;
            Intrinsics.checkNotNull((Object)lifetimeDefinition);
            JComponent view = viewRegistry.getView(protoViewModel, (Lifetime)lifetimeDefinition);
            $myCodeStyleAbstractPanel.setContent(view);
        } else {
            JComponent component = RiderCodeStyleContentPageConverter.Companion.createComponent(content, $myCodeStyleAbstractPanel.getLifetime());
            if (component != null) {
                $myCodeStyleAbstractPanel.setContent(component);
            } else {
                LOG.error("Unexpected page content " + content);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit resetImpl$lambda$0$0(OptionsPageContentBase optionsPageContentBase) {
        Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"optionsPageContentBase");
        InterfacesKt.fire((ISignal)optionsPageContentBase.getReset());
        return Unit.INSTANCE;
    }

    private static final void addAutodetectButton$lambda$0(JLabel $descriptionLabel, CodeStylePageContent $content, ActionEvent it) {
        block1: {
            if (!((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.title.run.detection.in.background", new Object[0]), RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.message.run.detection", new Object[0])).icon(Messages.getQuestionIcon())).ask((Component)$descriptionLabel)) break block1;
            InterfacesKt.fire((ISignal)$content.getRunAutodetection());
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost != null) {
                settingsViewModelHost.cancel();
            }
        }
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderCodeStyleMainPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

