/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.ide.model.CategoryGroup;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.ConfigureFormattingRdModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.codeStyle.ConfigureFormattingDialog;
import com.jetbrains.rider.settings.codeStyle.ConfigureFormattingDialogCustomizer;
import com.jetbrains.rider.settings.codeStyle.DialogPositionProvider;
import com.jetbrains.rider.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNodeSection;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.settings.util.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001-\u0018\u0000 42\u00020\u0001:\u000245B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016JD\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020#0\"j\b\u0012\u0004\u0012\u00020#`$H\u0002J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020&H\u0014J\u0006\u0010+\u001a\u00020)J\r\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.J\u0015\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100H\u0014\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020)H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "dialogCustomizer", "Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialogCustomizer;", "getInitialSize", "Ljava/awt/Dimension;", "fillTree", "", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeNode;", "options", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "refresher", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory$Refresher;", "filter", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "doCancelAction", "", "createTitlePane", "beforeSave", "createSaveAsCommentsAction", "com/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1", "()Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "Companion", "SaveAction", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n30#2,2:328\n1586#3:330\n1661#3,2:331\n1915#3,2:333\n1663#3:335\n1915#3:336\n1915#3,2:337\n1916#3:339\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n*L\n53#1:328,2\n129#1:330\n129#1:331,2\n139#1:333,2\n129#1:335\n79#1:336\n83#1:337,2\n79#1:339\n*E\n"})
public final class ConfigureFormattingDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigureFormattingRdModel model;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private final Editor editor;
    @NotNull
    private final ConfigureFormattingDialogCustomizer dialogCustomizer;
    @NlsSafe
    @NotNull
    private static final String CLANG_FORMAT_FILENAME = ".clang-format";
    @NlsSafe
    @NotNull
    private static final String EDITOR_CONFIG_FILENAME = ".editorconfig";

    public ConfigureFormattingDialog(@NotNull ConfigureFormattingRdModel model2, @NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false, DialogWrapper.IdeModalityType.IDE);
        this.model = model2;
        this.lifetime = lifetime;
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fill, ins 0", "[fill]", "[fill]"));
        TextControlId textControlId = this.model.getTextControl();
        this.editor = textControlId != null ? TextControlUtilsKt.tryGetEditor(textControlId, FrontendTextControlHost.Companion.getInstance(project)) : null;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ConfigureFormattingDialogCustomizer> serviceClass$iv = ConfigureFormattingDialogCustomizer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.dialogCustomizer = (ConfigureFormattingDialogCustomizer)object;
        this.dialogCustomizer.customizeDialog(this.lifetime, this.editor, this.model);
        this.myOKAction = new SaveAction();
        this.setTitle(this.model.getTitle());
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        CodeStyleTreeFactory treeFactory = new CodeStyleTreeFactory(disposable);
        CodeStyleTreeTable treeTable2 = treeFactory.createTree((Function2<? super DefaultMutableTreeNode, ? super CodeStyleTreeFactory.Refresher, Boolean>)((Function2)ConfigureFormattingDialog::_init_$lambda$0));
        treeTable2.setTableHeader(null);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setMinimumSize(new Dimension(JBUIScale.scale((int)10), JBUIScale.scale((int)100)));
        scrollPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)50), JBUIScale.scale((int)500)));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        this.mainPanel.add((Component)scrollPanel);
        this.model.getFilteredEntries().advise(this.lifetime, arg_0 -> ConfigureFormattingDialog._init_$lambda$1(this, treeTable2, arg_0));
        this.lifetime.onTermination(() -> ConfigureFormattingDialog._init_$lambda$2(this));
        RdTextRange selectedRange = this.model.getSelectedRange();
        if (this.editor != null && selectedRange != null) {
            this.setInitialLocationCallback(() -> ConfigureFormattingDialog._init_$lambda$3(this, selectedRange));
        }
        this.init();
    }

    @NotNull
    public final ConfigureFormattingRdModel getModel() {
        return this.model;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public Dimension getInitialSize() {
        int width = SwingUtilities.getRootPane(this.getWindow().getParent()).getWidth() / 5;
        int minWidth = JBUIScale.scale((int)540);
        int maxWidth = JBUIScale.scale((int)1000);
        if (width < minWidth) {
            width = minWidth;
        } else if (width > maxWidth) {
            width = maxWidth;
        }
        return new Dimension(width, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CodeStyleTreeNode> fillTree(List<? extends CodeStyleOptionBase> options, Lifetime lifetime, CodeStyleTreeFactory.Refresher refresher, HashSet<Integer> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CodeStyleTreeNode codeStyleTreeNode;
            void option;
            List<CodeStyleTreeNode> children;
            CodeStyleOptionBase codeStyleOptionBase = (CodeStyleOptionBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<CodeStyleTreeNode> list = children = option instanceof CodeStyleGroupOption ? this.fillTree(((CodeStyleGroupOption)option).getChildren(), lifetime, refresher, filter2) : CollectionsKt.emptyList();
            if (filter2.contains(option.getId()) || CollectionsKt.any((Iterable)children)) {
                CodeStyleTreeNode newNode = new CodeStyleTreeNode((CodeStyleOptionBase)option);
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CodeStyleTreeNode it = (CodeStyleTreeNode)element$iv;
                    boolean bl2 = false;
                    newNode.add(it);
                }
                codeStyleTreeNode = newNode;
            } else {
                codeStyleTreeNode = null;
            }
            collection.add(codeStyleTreeNode);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    public void doCancelAction() {
        InterfacesKt.fire((ISignal)this.model.getCancel());
        this.close(1);
    }

    @NotNull
    protected JComponent createTitlePane() {
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0", "", "[min!]"));
        if (this.model.getShouldShowEditorConfigWarning()) {
            JBLabel editorConfigNotificationPanel = new JBLabel("");
            editorConfigNotificationPanel.setBackground(Common.Resources.getHighlightedBackgroundColor());
            editorConfigNotificationPanel.setOpaque(true);
            JPanel panelWithEditorConfigNotification = new JPanel();
            panelWithEditorConfigNotification.setBorder((Border)JBUI.Borders.empty());
            panelWithEditorConfigNotification.setLayout((LayoutManager)new MigLayout("insets 3 5 3 5", "[]"));
            panelWithEditorConfigNotification.setBackground(Common.Resources.getHighlightedBackgroundColor());
            panelWithEditorConfigNotification.setOpaque(true);
            panelWithEditorConfigNotification.add((Component)editorConfigNotificationPanel, "grow");
            String saveText = this.model.getShouldShowEditorConfigSaveSuggestion() ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.to.save.them.select.saveto.editorconfig", new Object[0]) : RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.all.changes.to.them.would.be.lost", new Object[0]);
            Object[] objectArray = new Object[]{this.model.getConfigFileName()};
            editorConfigNotificationPanel.setText(new HtmlBuilder().append(HtmlChunk.text((String)RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.overrides.some.code.style.settings", objectArray))).br().append(HtmlChunk.text((String)saveText)).wrapWith(HtmlChunk.body()).style("white-space:normal").wrapWith(HtmlChunk.html()).toString());
            editorConfigNotificationPanel.setBackground(Common.Resources.getHighlightedBackgroundColor());
            panelWithEditorConfigNotification.setVisible(true);
            panel2.add((Component)panelWithEditorConfigNotification, "dock north");
        }
        if (this.model.getShowCheckBoxes()) {
            JCheckBox previewFormattingCheckBox = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.preview.formatting", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getPreviewFormatting()))));
            previewFormattingCheckBox.addChangeListener(arg_0 -> ConfigureFormattingDialog.createTitlePane$lambda$0(this, previewFormattingCheckBox, arg_0));
            panel2.add(previewFormattingCheckBox);
            JCheckBox onlyShowChangedCheckBox = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.only.show.changed.values", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getOnlyShowChanged()))));
            onlyShowChangedCheckBox.addChangeListener(arg_0 -> ConfigureFormattingDialog.createTitlePane$lambda$1(this, onlyShowChangedCheckBox, arg_0));
            panel2.add(onlyShowChangedCheckBox);
        }
        return panel2;
    }

    public final void beforeSave() {
        TableCellEditor editor;
        Container parent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            ((JFormattedTextField)focusOwner).commitEdit();
        }
        Component component = focusOwner;
        Container container = parent = component != null ? component.getParent() : null;
        if (parent instanceof JTable && (editor = ((JTable)parent).getCellEditor()) != null && !editor.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
    }

    private final createSaveAsCommentsAction.1 createSaveAsCommentsAction() {
        String string = RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.as.comments", new Object[0]);
        return new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ ConfigureFormattingDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
                this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)$receiver.getModel().getSaveEnabled())));
                $receiver.getModel().getSaveEnabled().advise($receiver.getLifetime(), arg_0 -> createSaveAsCommentsAction.1._init_$lambda$0(this, $receiver, arg_0));
            }

            protected void doAction(ActionEvent e) {
                this.this$0.beforeSave();
                InterfacesKt.fire((ISignal)this.this$0.getModel().getSaveToComments());
                this.this$0.close(1);
            }

            private static final Unit _init_$lambda$0(createSaveAsCommentsAction.1 this$0, ConfigureFormattingDialog this$1, boolean it) {
                this$0.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$1.getModel().getSaveEnabled())));
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    protected Action[] createActions() {
        if (this.model.getCanSaveAsComments() && !this.model.getPresentSaveAsCommentAsLayer()) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.createSaveAsCommentsAction(), this.getCancelAction()};
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        return actionArray;
    }

    protected void doOKAction() {
        this.beforeSave();
        InterfacesKt.fire((ISignal)this.model.getSave());
        this.close(1);
    }

    private static final boolean _init_$lambda$0(DefaultMutableTreeNode defaultMutableTreeNode, CodeStyleTreeFactory.Refresher refresher) {
        Intrinsics.checkNotNullParameter((Object)defaultMutableTreeNode, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"<unused var>");
        return false;
    }

    private static final Unit _init_$lambda$1(ConfigureFormattingDialog this$0, CodeStyleTreeTable $treeTable, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        List list = (List)this$0.model.getFilteredEntries().getValueOrNull();
        if (list == null) {
            return Unit.INSTANCE;
        }
        List filteredEntries = list;
        HashSet filter2 = CollectionsKt.toHashSet((Iterable)filteredEntries);
        CodeStyleTreeFactory.Refresher refresher = new CodeStyleTreeFactory.Refresher();
        refresher.setTreeTable($treeTable);
        Iterable $this$forEach$iv = this$0.model.getSettings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CategoryGroup group = (CategoryGroup)element$iv;
            boolean bl = false;
            List<CodeStyleTreeNode> children = this$0.fillTree(group.getOptions(), this$0.lifetime, refresher, filter2);
            if (!CollectionsKt.any((Iterable)children)) continue;
            CodeStyleTreeNodeSection newNode = new CodeStyleTreeNodeSection(group);
            Iterable $this$forEach$iv2 = children;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CodeStyleTreeNode it2 = (CodeStyleTreeNode)element$iv2;
                boolean bl2 = false;
                newNode.add(it2);
            }
            rootNode.add(newNode);
        }
        TreeTableModel treeTableModel = $treeTable.getTableModel();
        Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.treetable.ListTreeTableModel");
        ListTreeTableModel listTreeTableModel = (ListTreeTableModel)treeTableModel;
        listTreeTableModel.setRoot((TreeNode)rootNode);
        TreeUtil.INSTANCE.fitColumnWidthPercent(0, $treeTable, (int)(1.2 * (double)(100 / $treeTable.getColumnCount())), true);
        TreeTableTree treeTableTree = $treeTable.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        TreeUtil.INSTANCE.expandTree((JTree)treeTableTree);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ConfigureFormattingDialog this$0) {
        this$0.close(1);
        return Unit.INSTANCE;
    }

    private static final Point _init_$lambda$3(ConfigureFormattingDialog this$0, RdTextRange $selectedRange) {
        Editor editor = this$0.editor;
        Dimension dimension = this$0.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        int n = $selectedRange.getStartOffset();
        int n2 = $selectedRange.getEndOffset();
        JRootPane jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getParent());
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return new DialogPositionProvider(editor, dimension, document, n, n2, jRootPane).calculateLocation();
    }

    private static final void createTitlePane$lambda$0(ConfigureFormattingDialog this$0, JCheckBox $previewFormattingCheckBox, ChangeEvent it) {
        this$0.model.getPreviewFormatting().set((Object)$previewFormattingCheckBox.isSelected());
    }

    private static final void createTitlePane$lambda$1(ConfigureFormattingDialog this$0, JCheckBox $onlyShowChangedCheckBox, ChangeEvent it) {
        this$0.model.getOnlyShowChanged().set((Object)$onlyShowChangedCheckBox.isSelected());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$Companion;", "", "<init>", "()V", "CLANG_FORMAT_FILENAME", "", "EDITOR_CONFIG_FILENAME", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction;", "Ljavax/swing/AbstractAction;", "Lcom/intellij/openapi/ui/OptionAction;", "<init>", "(Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;)V", "myOptions", "", "Ljavax/swing/Action;", "[Ljavax/swing/Action;", "setEnabled", "", "value", "", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "getOptions", "()[Ljavax/swing/Action;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,327:1\n777#2:328\n873#2,2:329\n1586#2:331\n1661#2,3:332\n37#3,2:335\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n*L\n289#1:328\n289#1:329,2\n298#1:331\n298#1:332,3\n319#1:335,2\n*E\n"})
    private final class SaveAction
    extends AbstractAction
    implements OptionAction {
        @NotNull
        private final Action[] myOptions;

        /*
         * WARNING - void declaration
         */
        public SaveAction() {
            List list;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2;
            String string;
            ConfigureFormattingDialog $this$filterTo$iv$iv;
            super(ConfigureFormattingDialog.this.dialogCustomizer.okButtonName());
            this.putValue("DefaultAction", true);
            List backendLayers = ConfigureFormattingDialog.this.getModel().getSettingsLayerCollection().getLayers();
            if (OptionsUtilsHost.Companion.getLayer() != null) {
                Iterable $this$filter$iv = backendLayers;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    SettingsLayer it = (SettingsLayer)element$iv$iv;
                    boolean bl = false;
                    string = it.getDisplayName();
                    boolean bl2 = Intrinsics.areEqual((Object)string, (Object)ConfigureFormattingDialog.CLANG_FORMAT_FILENAME) ? true : Intrinsics.areEqual((Object)string, (Object)ConfigureFormattingDialog.EDITOR_CONFIG_FILENAME);
                    if (!(bl2 | Intrinsics.areEqual((Object)it, (Object)OptionsUtilsHost.Companion.getLayer()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = backendLayers;
            }
            List layers = list2;
            Iterable $i$f$filter = layers;
            $this$filterTo$iv$iv = ConfigureFormattingDialog.this;
            boolean $i$f$map = false;
            void $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                string = (SettingsLayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String displayName = Intrinsics.areEqual((Object)it, (Object)OptionsUtilsHost.Companion.getLowPriorityIdeaSettingsLayer()) ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.to.lowPriorityIdeaLayer", new Object[0]) : it.getDisplayName();
                collection.add(new AbstractAction(displayName, $this$filterTo$iv$iv, (SettingsLayer)it){
                    final /* synthetic */ ConfigureFormattingDialog this$0;
                    final /* synthetic */ SettingsLayer $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super($displayName);
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$0.beforeSave();
                        this.this$0.getModel().getSaveTo().fire((Object)this.$it);
                        this.this$0.close(1);
                    }
                });
            }
            List saveToLayerActions2 = (List)destination$iv$iv;
            if (ConfigureFormattingDialog.this.getModel().getCanSaveAsComments() && ConfigureFormattingDialog.this.getModel().getPresentSaveAsCommentAsLayer()) {
                createSaveAsCommentsAction.1 action2 = ConfigureFormattingDialog.this.createSaveAsCommentsAction();
                list = CollectionsKt.listOf((Object)((Object)action2));
            } else {
                list = CollectionsKt.emptyList();
            }
            List saveAsCommentsAction = list;
            Collection $this$toTypedArray$iv = CollectionsKt.union((Iterable)saveToLayerActions2, (Iterable)saveAsCommentsAction);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.myOptions = thisCollection$iv.toArray(new Action[0]);
            this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)ConfigureFormattingDialog.this.getModel().getSaveEnabled())));
            ConfigureFormattingDialog.this.getModel().getSaveEnabled().advise(ConfigureFormattingDialog.this.getLifetime(), arg_0 -> SaveAction._init_$lambda$2(this, ConfigureFormattingDialog.this, arg_0));
        }

        @Override
        public void setEnabled(boolean value) {
            super.setEnabled(value);
            for (Action option : this.myOptions) {
                option.setEnabled(value);
            }
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ConfigureFormattingDialog.this.doOKAction();
        }

        @NotNull
        public Action[] getOptions() {
            return ConfigureFormattingDialog.this.dialogCustomizer.hasOptionsToSave() ? this.myOptions : new Action[]{};
        }

        private static final Unit _init_$lambda$2(SaveAction this$0, ConfigureFormattingDialog this$1, boolean it) {
            this$0.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$1.getModel().getSaveEnabled())));
            return Unit.INSTANCE;
        }
    }
}

