/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.solutionAnalysis;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.SolutionAnalysisFusData;
import com.jetbrains.rider.solutionAnalysis.ValidationRule;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0014J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0014J\b\u0010!\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/solutionAnalysis/SolutionAnalysisCounterUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "RIDER_SWEA_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "SUSPEND_EVENT_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "HAS_ERRORS_EVENT_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "FILE_WITH_ERRORS_COUNT_EVENT_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "FILE_WITH_ERRORS_EXTENSIONS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringListEventField;", "SWEA_READY", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "SWEA_START", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "SWEA_PAUSED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "SWEA_ENABLED", "logSweaStart", "", "project", "Lcom/intellij/openapi/project/Project;", "logSweaReady", "data", "Lcom/jetbrains/rider/model/SolutionAnalysisFusData;", "logSweaEnabled", "isEnabled", "logSweaPaused", "isPaused", "getGroup", "intellij.rider.rdclient.dotnet"})
public final class SolutionAnalysisCounterUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final SolutionAnalysisCounterUsageCollector INSTANCE = new SolutionAnalysisCounterUsageCollector();
    @NotNull
    private static final EventLogGroup RIDER_SWEA_GROUP = new EventLogGroup("rider.swea", 5, null, 4, null);
    @NotNull
    private static final LongEventField SUSPEND_EVENT_FIELD = EventFields.Long$default((String)"suspendTimeMs", null, (int)2, null);
    @NotNull
    private static final BooleanEventField HAS_ERRORS_EVENT_FIELD = EventFields.Boolean((String)"hasErrors");
    @NotNull
    private static final IntEventField FILE_WITH_ERRORS_COUNT_EVENT_FIELD = EventFields.Int((String)"filesWithErrorsCount");
    @NotNull
    private static final StringListEventField FILE_WITH_ERRORS_EXTENSIONS_FIELD = EventFields.StringListValidatedByCustomRule$default((String)"extensionsWithErrors", ValidationRule.class, null, (int)4, null);
    @NotNull
    private static final VarargEventId SWEA_READY;
    @NotNull
    private static final EventId SWEA_START;
    @NotNull
    private static final EventId1<Boolean> SWEA_PAUSED;
    @NotNull
    private static final EventId1<Boolean> SWEA_ENABLED;

    private SolutionAnalysisCounterUsageCollector() {
    }

    public final void logSweaStart(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SWEA_START.log(project);
    }

    public final void logSweaReady(@NotNull Project project, @NotNull SolutionAnalysisFusData data2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        EventPair[] eventPairArray = new EventPair[]{SUSPEND_EVENT_FIELD.with((Object)data2.getPauseTime()), HAS_ERRORS_EVENT_FIELD.with((Object)data2.getHasErrors()), FILE_WITH_ERRORS_COUNT_EVENT_FIELD.with((Object)data2.getFilesWithErrorsCount()), FILE_WITH_ERRORS_EXTENSIONS_FIELD.with((Object)CollectionsKt.sorted((Iterable)ArraysKt.toList((Object[])data2.getExtensionsWithErrors())))};
        SWEA_READY.log(project, eventPairArray);
    }

    public final void logSweaEnabled(@NotNull Project project, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SWEA_ENABLED.log(project, (Object)isEnabled);
    }

    public final void logSweaPaused(@NotNull Project project, boolean isPaused) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SWEA_PAUSED.log(project, (Object)isPaused);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return RIDER_SWEA_GROUP;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{SUSPEND_EVENT_FIELD, HAS_ERRORS_EVENT_FIELD, FILE_WITH_ERRORS_COUNT_EVENT_FIELD, FILE_WITH_ERRORS_EXTENSIONS_FIELD};
        SWEA_READY = RIDER_SWEA_GROUP.registerVarargEvent("swea.ready", eventFieldArray);
        SWEA_START = RIDER_SWEA_GROUP.registerEvent("swea.start");
        SWEA_PAUSED = RIDER_SWEA_GROUP.registerEvent("swea.paused", (EventField)EventFields.Boolean((String)"isPaused"));
        SWEA_ENABLED = RIDER_SWEA_GROUP.registerEvent("swea.enabled", (EventField)EventFields.Boolean((String)"isEnabled"));
    }
}

