/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.targets;

import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.targets.BundledAssemblyLauncher;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/targets/DebuggerAssemblyLauncher;", "Lcom/jetbrains/rider/targets/BundledAssemblyLauncher;", "assemblyName", "", "suffix32bit", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getRuntimeConfig", "launcherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "getCustomLauncherArguments", "", "getRelativePathToExecutableFromBinDir", "binDirectory", "Lcom/jetbrains/rider/PathInfo;", "getConfiguration", "Lcom/jetbrains/rider/targets/BundledAssemblyLauncher$LauncherConfiguration;", "dotnetPath", "intellij.rider.rdclient.dotnet"})
public final class DebuggerAssemblyLauncher
extends BundledAssemblyLauncher {
    @NotNull
    private final String suffix32bit;

    public DebuggerAssemblyLauncher(@NotNull String assemblyName, @NotNull String suffix32bit) {
        Intrinsics.checkNotNullParameter((Object)assemblyName, (String)"assemblyName");
        Intrinsics.checkNotNullParameter((Object)suffix32bit, (String)"suffix32bit");
        super(assemblyName);
        this.suffix32bit = suffix32bit;
    }

    public /* synthetic */ DebuggerAssemblyLauncher(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "32";
        }
        this(string, string2);
    }

    @Override
    @NotNull
    protected String getRuntimeConfig(@NotNull BundledAssemblyLauncherInfo launcherInfo) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        String[] stringArray = StringsKt.endsWith((String)launcherInfo.getAssemblyName(), (String)".dll", (boolean)true) || StringsKt.endsWith((String)launcherInfo.getAssemblyName(), (String)".exe", (boolean)true) ? FileUtilRt.getNameWithoutExtension((String)launcherInfo.getAssemblyName()) : launcherInfo.getAssemblyName();
        Intrinsics.checkNotNull((Object)stringArray);
        String[] executableWithoutExtensions = stringArray;
        stringArray = new String[]{(String)executableWithoutExtensions + ".runtimeconfig.json"};
        return launcherInfo.getCustomInfo().getBinDirectory().appendPath(stringArray).getPath();
    }

    @Override
    @Nullable
    protected List<String> getCustomLauncherArguments(@NotNull BundledAssemblyLauncherInfo launcherInfo) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        return null;
    }

    @Override
    @NotNull
    protected String getRelativePathToExecutableFromBinDir(@NotNull PathInfo binDirectory) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        return switch (WhenMappings.$EnumSwitchMapping$0[binDirectory.getCpuKind().ordinal()]) {
            case 1 -> this.getAssemblyName() + this.suffix32bit + ".exe";
            case 2, 3 -> binDirectory.getCpuKind().getDirectoryName() + binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator + this.getAssemblyName() + ".exe";
            case 4, 5, 6, 7 -> binDirectory.getCpuKind().getDirectoryName() + binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator + this.getAssemblyName();
            case 8, 9, 10, 11, 12 -> this.getAssemblyName() + ".exe";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    protected BundledAssemblyLauncher.LauncherConfiguration getConfiguration(@NotNull PathInfo binDirectory, @NotNull String dotnetPath) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        Intrinsics.checkNotNullParameter((Object)dotnetPath, (String)"dotnetPath");
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[binDirectory.getCpuKind().ordinal()]) {
            case 1 -> TuplesKt.to((Object)false, (Object)true);
            case 2, 3 -> TuplesKt.to((Object)true, (Object)true);
            case 4, 5, 6, 7 -> TuplesKt.to((Object)true, (Object)true);
            case 8, 9, 10, 11, 12 -> TuplesKt.to((Object)true, (Object)false);
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean runOnNetCore = (Boolean)pair.component1();
        boolean useNativeLauncher = (Boolean)pair.component2();
        return new BundledAssemblyLauncher.LauncherConfiguration(runOnNetCore, useNativeLauncher);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CPUKind.values().length];
            try {
                nArray[CPUKind.Win32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Win64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.WinArm64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOs64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOsArm.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm32.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm64.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMusl64.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

