/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.targets;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.environment.RiderEnvironment;
import com.jetbrains.rider.targets.BundledAssemblyLauncher;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/targets/DefaultBundledAssemblyLauncher;", "Lcom/jetbrains/rider/targets/BundledAssemblyLauncher;", "assembly", "Ljava/nio/file/Path;", "runOnNetCore", "", "useNativeLauncher", "<init>", "(Ljava/nio/file/Path;ZZ)V", "configuration", "Lcom/jetbrains/rider/targets/BundledAssemblyLauncher$LauncherConfiguration;", "getRuntimeConfig", "", "launcherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "canBeLaunchedInEnvironment", "environment", "Lcom/jetbrains/rider/environment/RiderEnvironment;", "getCustomLauncherArguments", "", "getRelativePathToExecutableFromBinDir", "binDirectory", "Lcom/jetbrains/rider/PathInfo;", "getBinDirForEnvironment", "(Lcom/jetbrains/rider/environment/RiderEnvironment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfiguration", "dotnetPath", "Companion", "intellij.rider.rdclient.dotnet"})
public final class DefaultBundledAssemblyLauncher
extends BundledAssemblyLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path assembly;
    @NotNull
    private final BundledAssemblyLauncher.LauncherConfiguration configuration;

    public DefaultBundledAssemblyLauncher(@NotNull Path assembly, boolean runOnNetCore, boolean useNativeLauncher) {
        Intrinsics.checkNotNullParameter((Object)assembly, (String)"assembly");
        super(PathsKt.getName((Path)assembly));
        this.assembly = assembly;
        this.configuration = new BundledAssemblyLauncher.LauncherConfiguration(runOnNetCore, useNativeLauncher);
    }

    @Override
    @Nullable
    protected String getRuntimeConfig(@NotNull BundledAssemblyLauncherInfo launcherInfo) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        RiderEnvironment riderEnvironment = launcherInfo.getCustomInfo().getEnvironment();
        if (riderEnvironment == null) {
            return null;
        }
        RiderEnvironment riderEnvironment2 = riderEnvironment;
        Path assemblyPath = Path.of(launcherInfo.getAssemblyAbsolutePath(), new String[0]);
        Intrinsics.checkNotNull((Object)assemblyPath);
        Path path = assemblyPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return Companion.getRuntimeConfig(assemblyPath, path, false, riderEnvironment2.getDescriptor());
    }

    @Override
    protected boolean canBeLaunchedInEnvironment(@NotNull RiderEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return Intrinsics.areEqual((Object)environment.getDescriptor(), (Object)EelProviderUtil.getEelDescriptor((Path)this.assembly));
    }

    @Override
    @Nullable
    protected List<String> getCustomLauncherArguments(@NotNull BundledAssemblyLauncherInfo launcherInfo) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        return null;
    }

    @Override
    @NotNull
    protected String getRelativePathToExecutableFromBinDir(@NotNull PathInfo binDirectory) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        return this.getAssemblyName();
    }

    @Override
    @Nullable
    protected Object getBinDirForEnvironment(@NotNull RiderEnvironment environment, @NotNull Continuation<? super Path> $completion) {
        Path path = this.assembly.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return path;
    }

    @Override
    @NotNull
    protected BundledAssemblyLauncher.LauncherConfiguration getConfiguration(@NotNull PathInfo binDirectory, @NotNull String dotnetPath) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        Intrinsics.checkNotNullParameter((Object)dotnetPath, (String)"dotnetPath");
        return this.configuration;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/targets/DefaultBundledAssemblyLauncher$Companion;", "", "<init>", "()V", "getRuntimeConfig", "", "assemblyFile", "Ljava/nio/file/Path;", "runtimeConfigDirectory", "useManagedLauncher", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getRuntimeConfig(@NotNull Path assemblyFile, @NotNull Path runtimeConfigDirectory, boolean useManagedLauncher, @NotNull EelDescriptor descriptor) {
            String name;
            Intrinsics.checkNotNullParameter((Object)assemblyFile, (String)"assemblyFile");
            Intrinsics.checkNotNullParameter((Object)runtimeConfigDirectory, (String)"runtimeConfigDirectory");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            String runtimeConfigJson = ".runtimeconfig.json";
            String string = name = StringsKt.endsWith$default((String)PathsKt.getName((Path)assemblyFile), (String)".exe", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)PathsKt.getName((Path)assemblyFile), (String)".dll", (boolean)false, (int)2, null) ? PathsKt.getNameWithoutExtension((Path)assemblyFile) : PathsKt.getName((Path)assemblyFile);
            String middle = EelPlatformKt.isWindows((EelOsFamily)descriptor.getOsFamily()) ? ".windows" + (useManagedLauncher ? ".launcher" : "") : ".netcore";
            Path configFile = runtimeConfigDirectory.resolve(name + middle + runtimeConfigJson);
            Intrinsics.checkNotNull((Object)configFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? ((Object)configFile).toString() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

