/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.environment.local.NetCoreUtil;
import com.jetbrains.rider.environment.local.RiderLocalEnvironment;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.projectView.SolutionLifecycleHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.utils.PerfWatcherRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0017\u0010\u0018\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J1\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\"H\u0002J.\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020\"012\u0006\u00102\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/utils/BackendPerformanceWatcher;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "alarm", "Lcom/intellij/util/Alarm;", "retrySampling", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastRequest", "Lcom/jetbrains/rider/utils/PerfWatcherRequest;", "startBackendPerformanceWatcher", "", "project", "Lcom/intellij/openapi/project/Project;", "customMaxAllowedTimeMs", "", "activityDescription", "", "activityId", "startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "isPerformanceWatcherDisabled", "getCustomMaxAllowedTimeMs", "(Ljava/lang/Integer;)I", "getSamplingIntervalMs", "getDelayTimeMs", "finishBackendPerformanceWatcher", "", "finishBackendPerformanceWatcher$intellij_rider_rdclient_dotnet", "prepareFreezeReport", "request", "spentTimeMs", "", "findFilesByStartTime", "", "Ljava/io/File;", "children", "expectedStartTime", "expectedNumbersOfFiles", "([Ljava/io/File;Ljava/lang/String;I)[Ljava/io/File;", "formatTime", "timeMs", "dumpBackendThreads", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "info", "pids", "", "samplingInterval", "dispose", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nBackendPerformanceWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,288:1\n13#2:289\n13#3:290\n14060#4,2:291\n*S KotlinDebug\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher\n*L\n75#1:289\n75#1:290\n211#1:291,2\n*E\n"})
public final class BackendPerformanceWatcher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final AtomicBoolean retrySampling;
    @Nullable
    private PerfWatcherRequest lastRequest;
    @NotNull
    private static final String descriptionFileName = "description.txt";
    @NotNull
    private static final String threadDumpExtensionWithDot = ".tdump";
    @NotNull
    private static final String isEnabledKey = "rider.backend.performance.watcher.isEnabled";
    @NotNull
    private static final String maxAllowedTimeMsKey = "rider.backend.performance.watcher.maxAllowedTimeMs";
    private static final int maxAllowedTimeMsDefault = 500;
    @NotNull
    private static final String delayTimeMsKey = "rider.backend.performance.watcher.delayTimeMs";
    private static final int delayTimeMsDefault = 500;
    @NotNull
    private static final String samplingIntervalMsKey = "rider.backend.performance.watcher.samplingIntervalMs";
    private static final int samplingIntervalMsDefault = 500;
    @NotNull
    private static final String openThreadDumpFolderKey = "rider.backend.performance.watcher.openFolder";

    public BackendPerformanceWatcher() {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendPerformanceWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.retrySampling = new AtomicBoolean(false);
        ApplicationKt.getApplication().executeOnPooledThread(BackendPerformanceWatcher::_init_$lambda$0);
    }

    public final boolean startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet(@NotNull Project project, @Nullable Integer customMaxAllowedTimeMs, @NotNull String activityDescription, @NotNull String activityId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activityDescription, (String)"activityDescription");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.isPerformanceWatcherDisabled()) {
            return false;
        }
        this.logger.info("Start backend performance monitor");
        Object object = project.getUserData(ProtocolKeys.Companion.getProtocolHostKey());
        IProtocolHostWithBackend iProtocolHostWithBackend = object instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)object : null;
        if (iProtocolHostWithBackend == null) {
            BackendPerformanceWatcher $this$startBackendPerformanceWatcher_u24lambda_u240 = this;
            boolean bl = false;
            $this$startBackendPerformanceWatcher_u24lambda_u240.logger.info("Current backend is not supported.");
            return false;
        }
        IProtocolHostWithBackend protocolHost = iProtocolHostWithBackend;
        SolutionLifecycleHost solutionLifecycle = SolutionLifecycleHost.Companion.getInstance(project);
        if (!((Boolean)solutionLifecycle.isBackendLoaded().getValue()).booleanValue()) {
            this.logger.info("Backend isn't loaded.");
            return false;
        }
        Object object2 = protocolHost.getResharperProcess();
        if (object2 == null || (object2 = ((ReSharperProcessBase)object2).getResharperProcessHandler()) == null || (object2 = object2.getProcess()) == null) {
            BackendPerformanceWatcher $this$startBackendPerformanceWatcher_u24lambda_u241 = this;
            boolean bl = false;
            $this$startBackendPerformanceWatcher_u24lambda_u241.logger.error("resharperProcess == null");
            return false;
        }
        Object process = object2;
        Lifetime lifetime = protocolHost.getLifetime();
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime)) {
            this.logger.warn("Backend is already terminated.");
            return false;
        }
        long pid = ((Process)process).pid();
        if (this.lastRequest != null) {
            this.logger.error("The previous request is still processing (skip activity=" + activityDescription + ").");
            return false;
        }
        int delayMs = this.getDelayTimeMs();
        int samplingInterval = this.getSamplingIntervalMs();
        int maxAllowedTime = this.getCustomMaxAllowedTimeMs(customMaxAllowedTimeMs);
        long startTimeNano = System.nanoTime();
        this.lastRequest = new PerfWatcherRequest(startTimeNano, activityDescription, activityId, maxAllowedTime, delayMs, System.currentTimeMillis());
        this.alarm.addRequest(() -> BackendPerformanceWatcher.startBackendPerformanceWatcher$lambda$2(this, lifetime, activityId, activityDescription, pid, samplingInterval), delayMs);
        this.retrySampling.set(true);
        return true;
    }

    public static /* synthetic */ boolean startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet$default(BackendPerformanceWatcher backendPerformanceWatcher, Project project, Integer n, String string, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return backendPerformanceWatcher.startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet(project, n, string, string2);
    }

    private final boolean isPerformanceWatcherDisabled() {
        return NetCoreUtil.INSTANCE.runOnNetCore() || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode() || ApplicationKt.getApplication().isUnitTestMode() || !Registry.Companion.is(isEnabledKey) && !ApplicationInfoEx.getInstanceEx().isEAP();
    }

    private final int getCustomMaxAllowedTimeMs(Integer customMaxAllowedTimeMs) {
        int maxAllowedTime;
        Integer n = customMaxAllowedTimeMs;
        int n2 = maxAllowedTime = n != null ? n.intValue() : Registry.Companion.intValue(maxAllowedTimeMsKey);
        if (maxAllowedTime <= 0) {
            this.logger.warn("Flag `maxAllowedTimeMs` must be more then zero. Using default value...");
            maxAllowedTime = 500;
        }
        return maxAllowedTime;
    }

    private final int getSamplingIntervalMs() {
        int samplingInterval = Registry.Companion.intValue(samplingIntervalMsKey);
        if (samplingInterval <= 0) {
            this.logger.warn("Flag `samplingIntervalMs` must be greater than zero. Using default value...");
            samplingInterval = 500;
        }
        return samplingInterval;
    }

    private final int getDelayTimeMs() {
        int delayMs = Registry.Companion.intValue(delayTimeMsKey);
        if (delayMs <= 0) {
            this.logger.warn("Flag `delayTimeMs` must be greater than zero. Using default value...");
            delayMs = 500;
        }
        return delayMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishBackendPerformanceWatcher$intellij_rider_rdclient_dotnet() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.isPerformanceWatcherDisabled()) {
            return;
        }
        PerfWatcherRequest perfWatcherRequest = this.lastRequest;
        if (perfWatcherRequest == null) {
            return;
        }
        PerfWatcherRequest request = perfWatcherRequest;
        try {
            long endTime = System.nanoTime();
            long spentTimeMs = (endTime - request.getStartTimeNano()) / (long)1000000;
            if (spentTimeMs >= (long)request.getMaxAllowedTimeMs()) {
                this.alarm.addRequest(() -> BackendPerformanceWatcher.finishBackendPerformanceWatcher$lambda$0(this, request, spentTimeMs), 0);
            } else {
                this.alarm.cancelAllRequests();
            }
            this.logger.info("Finish backend performance monitor.");
        }
        finally {
            this.lastRequest = null;
            this.retrySampling.set(false);
        }
    }

    private final void prepareFreezeReport(PerfWatcherRequest request, long spentTimeMs) {
        String formattedStartTime = this.formatTime(request.getStartTimeMs());
        String expectedStartTime = formattedStartTime + threadDumpExtensionWithDot;
        int expectedNumbersOfFiles = (int)((float)spentTimeMs / (float)this.getSamplingIntervalMs() + 0.5f);
        File[] fileArray = RiderLocalEnvironment.INSTANCE.getBackendThreadDumpDir().listFiles(BackendPerformanceWatcher::prepareFreezeReport$lambda$0);
        if (fileArray == null) {
            BackendPerformanceWatcher $this$prepareFreezeReport_u24lambda_u241 = this;
            boolean bl = false;
            $this$prepareFreezeReport_u24lambda_u241.logger.warn("Can't enumerate thread dumps into " + RiderLocalEnvironment.INSTANCE.getBackendThreadDumpDir() + " folder.");
            return;
        }
        File[] children = fileArray;
        File[] filesToMove = this.findFilesByStartTime(children, expectedStartTime, expectedNumbersOfFiles);
        if (!(filesToMove.length == 0)) {
            File folder = FilesKt.resolve((File)RiderLocalEnvironment.INSTANCE.getBackendThreadDumpDir(), (String)(request.getActivityId() + "_" + formattedStartTime));
            folder.mkdir();
            this.logger.trace("Moving files to " + folder);
            File[] $this$forEach$iv = filesToMove;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.renameTo(new File(folder, it.getName()));
                it.delete();
            }
            String startThreadsDumpTime = new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(request.getStartTimeMs() + (long)request.getDelayMs()));
            StringBuilder stringBuilder = new StringBuilder().append("activityDescription:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            StringBuilder stringBuilder3 = stringBuilder2.append(request.getActivityDescription()).append('\n').append("elapsed time:").append(spentTimeMs);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append("ms").append('\n').append("start threads dump time:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            stringBuilder4 = stringBuilder4.append(startThreadsDumpTime).append('\n');
            StringBuilder stringBuilder5 = stringBuilder4.append("Run parameters:").append('\n').append("  maxAllowedTimeMs:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            int n2 = request.getMaxAllowedTimeMs();
            StringBuilder stringBuilder6 = stringBuilder5.append(n2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            StringBuilder stringBuilder7 = stringBuilder6.append('\n').append("  startDelayMs:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            int n3 = request.getDelayMs();
            StringBuilder stringBuilder8 = stringBuilder7.append(n3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            String string = stringBuilder8.append('\n').toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String descriptionText = string;
            FilesKt.writeText$default((File)new File(folder, descriptionFileName), (String)descriptionText, null, (int)2, null);
            this.logger.warn("Backend `" + request.getActivityDescription() + "` activity took more than " + request.getMaxAllowedTimeMs() + " ms. Please report a bug (see " + folder + " for details).");
            if (Registry.Companion.is(openThreadDumpFolderKey)) {
                RevealFileAction.openDirectory((File)folder);
            }
        } else {
            this.logger.error("ThreadDumps are not found.");
        }
    }

    private final File[] findFilesByStartTime(File[] children, String expectedStartTime, int expectedNumbersOfFiles) {
        Arrays.sort(children);
        int idx = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])children), (int)0, (int)0, arg_0 -> BackendPerformanceWatcher.findFilesByStartTime$lambda$0(expectedStartTime, arg_0), (int)3, null);
        int fstIdx = idx < 0 ? -idx - 1 : idx;
        IntRange fileRange = RangesKt.until((int)Math.min(fstIdx, children.length), (int)Math.min(fstIdx + expectedNumbersOfFiles, children.length));
        return (File[])ArraysKt.sliceArray((Object[])children, (IntRange)fileRange);
    }

    private final String formatTime(long timeMs) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS").format(new Date(timeMs));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final void dumpBackendThreads(Lifetime lifetime, String info, List<Long> pids, int samplingInterval) {
        RdCoroutinesUtilKt.launchBackground$default((Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(info, pids, null){
            int label;
            final /* synthetic */ String $info;
            final /* synthetic */ List<Long> $pids;
            {
                this.$info = $info;
                this.$pids = $pids;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        long[] lArray = CollectionsKt.toLongArray((Collection)this.$pids);
                        this.label = 1;
                        Object object2 = ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcesses$default(CollectThreadDumpRequest.Companion.automaticDiagnostics(this.$info), Arrays.copyOf(lArray, lArray.length), null, (Continuation)this, 4, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.retrySampling.get()) {
            this.alarm.addRequest(() -> BackendPerformanceWatcher.dumpBackendThreads$lambda$0(this, lifetime, info, pids, samplingInterval), samplingInterval);
        }
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0() {
        BackendPerformanceWatcher.Companion.cleanOldFiles(RiderLocalEnvironment.INSTANCE.getBackendThreadDumpDir());
    }

    private static final void startBackendPerformanceWatcher$lambda$2(BackendPerformanceWatcher this$0, Lifetime $lifetime, String $activityId, String $activityDescription, long $pid, int $samplingInterval) {
        this$0.dumpBackendThreads($lifetime, $activityId + ": " + $activityDescription, CollectionsKt.listOf((Object)$pid), $samplingInterval);
    }

    private static final void finishBackendPerformanceWatcher$lambda$0(BackendPerformanceWatcher this$0, PerfWatcherRequest $request, long $spentTimeMs) {
        this$0.prepareFreezeReport($request, $spentTimeMs);
    }

    private static final boolean prepareFreezeReport$lambda$0(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)threadDumpExtensionWithDot, (boolean)false, (int)2, null);
    }

    private static final int findFilesByStartTime$lambda$0(String $expectedStartTime, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FilesKt.getNameWithoutExtension((File)file).compareTo($expectedStartTime);
    }

    private static final void dumpBackendThreads$lambda$0(BackendPerformanceWatcher this$0, Lifetime $lifetime, String $info, List $pids, int $samplingInterval) {
        this$0.dumpBackendThreads($lifetime, $info, $pids, $samplingInterval);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion;", "", "<init>", "()V", "descriptionFileName", "", "threadDumpExtensionWithDot", "isEnabledKey", "maxAllowedTimeMsKey", "maxAllowedTimeMsDefault", "", "delayTimeMsKey", "delayTimeMsDefault", "samplingIntervalMsKey", "samplingIntervalMsDefault", "openThreadDumpFolderKey", "getInstance", "Lcom/jetbrains/rider/utils/BackendPerformanceWatcher;", "cleanOldFiles", "", "dir", "Ljava/io/File;", "ageInDays", "", "file", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nBackendPerformanceWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,288:1\n16#2,2:289\n*S KotlinDebug\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion\n*L\n57#1:289,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendPerformanceWatcher getInstance() {
            ComponentManager $this$getService$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(BackendPerformanceWatcher.class);
            if (object == null) {
                throw new IllegalStateException("Service " + BackendPerformanceWatcher.class + " not found in container " + $this$getService$iv);
            }
            return (BackendPerformanceWatcher)object;
        }

        private final void cleanOldFiles(File dir) {
            Object[] objectArray = dir.listFiles();
            if (objectArray == null) {
                return;
            }
            Object[] children = objectArray;
            Arrays.sort(children);
            int n = children.length;
            for (int i = 0; i < n; ++i) {
                Object child = children[i];
                if (i >= children.length - 100) {
                    Intrinsics.checkNotNull((Object)child);
                    if (this.ageInDays((File)child) <= 10L) continue;
                }
                FileUtil.delete((File)child);
            }
        }

        private final long ageInDays(File file) {
            return TimeUnit.DAYS.convert(System.currentTimeMillis() - file.lastModified(), TimeUnit.MILLISECONDS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

